package software.amazon.awscdk.services.cognito.identitypool;

/**
 * (experimental) Defines an Identity Pool Role Attachment.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cognito.identitypool.*;
 * import software.amazon.awscdk.services.iam.*;
 * IdentityPool identityPool;
 * IdentityPoolProviderUrl identityPoolProviderUrl;
 * Role role;
 * IdentityPoolRoleAttachment identityPoolRoleAttachment = IdentityPoolRoleAttachment.Builder.create(this, "MyIdentityPoolRoleAttachment")
 *         .identityPool(identityPool)
 *         // the properties below are optional
 *         .authenticatedRole(role)
 *         .roleMappings(List.of(IdentityPoolRoleMapping.builder()
 *                 .providerUrl(identityPoolProviderUrl)
 *                 // the properties below are optional
 *                 .resolveAmbiguousRoles(false)
 *                 .rules(List.of(RoleMappingRule.builder()
 *                         .claim("claim")
 *                         .claimValue("claimValue")
 *                         .mappedRole(role)
 *                         // the properties below are optional
 *                         .matchType(RoleMappingMatchType.EQUALS)
 *                         .build()))
 *                 .useToken(false)
 *                 .build()))
 *         .unauthenticatedRole(role)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:58.029Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_cognito_identitypool.IdentityPoolRoleAttachment")
public class IdentityPoolRoleAttachment extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.cognito.identitypool.IIdentityPoolRoleAttachment {

    protected IdentityPoolRoleAttachment(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected IdentityPoolRoleAttachment(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public IdentityPoolRoleAttachment(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.identitypool.IdentityPoolRoleAttachmentProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Id of the underlying identity pool.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getIdentityPoolId() {
        return software.amazon.jsii.Kernel.get(this, "identityPoolId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.cognito.identitypool.IdentityPoolRoleAttachment}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cognito.identitypool.IdentityPoolRoleAttachment> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.cognito.identitypool.IdentityPoolRoleAttachmentProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.cognito.identitypool.IdentityPoolRoleAttachmentProps.Builder();
        }

        /**
         * (experimental) Id of the Attachments Underlying Identity Pool.
         * <p>
         * @return {@code this}
         * @param identityPool Id of the Attachments Underlying Identity Pool. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder identityPool(final software.amazon.awscdk.services.cognito.identitypool.IIdentityPool identityPool) {
            this.props.identityPool(identityPool);
            return this;
        }

        /**
         * (experimental) Default Authenticated (User) Role.
         * <p>
         * Default: - No default authenticated role will be added
         * <p>
         * @return {@code this}
         * @param authenticatedRole Default Authenticated (User) Role. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder authenticatedRole(final software.amazon.awscdk.services.iam.IRole authenticatedRole) {
            this.props.authenticatedRole(authenticatedRole);
            return this;
        }

        /**
         * (experimental) Rules for mapping roles to users.
         * <p>
         * Default: - no Role Mappings
         * <p>
         * @return {@code this}
         * @param roleMappings Rules for mapping roles to users. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder roleMappings(final java.util.List<? extends software.amazon.awscdk.services.cognito.identitypool.IdentityPoolRoleMapping> roleMappings) {
            this.props.roleMappings(roleMappings);
            return this;
        }

        /**
         * (experimental) Default Unauthenticated (Guest) Role.
         * <p>
         * Default: - No default unauthenticated role will be added
         * <p>
         * @return {@code this}
         * @param unauthenticatedRole Default Unauthenticated (Guest) Role. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder unauthenticatedRole(final software.amazon.awscdk.services.iam.IRole unauthenticatedRole) {
            this.props.unauthenticatedRole(unauthenticatedRole);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.cognito.identitypool.IdentityPoolRoleAttachment}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.cognito.identitypool.IdentityPoolRoleAttachment build() {
            return new software.amazon.awscdk.services.cognito.identitypool.IdentityPoolRoleAttachment(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
