package software.amazon.awscdk.services.cognito.identitypool;

/**
 * (experimental) Types of matches allowed for Role Mapping.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderUrl;
 * import software.amazon.awscdk.services.cognito.identitypool.RoleMappingMatchType;
 * Role adminRole;
 * Role nonAdminRole;
 * IdentityPool.Builder.create(this, "myidentitypool")
 *         .identityPoolName("myidentitypool")
 *         // Assign specific roles to users based on whether or not the custom admin claim is passed from the identity provider
 *         .roleMappings(List.of(IdentityPoolRoleMapping.builder()
 *                 .providerUrl(IdentityPoolProviderUrl.AMAZON)
 *                 .rules(List.of(RoleMappingRule.builder()
 *                         .claim("custom:admin")
 *                         .claimValue("admin")
 *                         .mappedRole(adminRole)
 *                         .build(), RoleMappingRule.builder()
 *                         .claim("custom:admin")
 *                         .claimValue("admin")
 *                         .matchType(RoleMappingMatchType.NOTEQUAL)
 *                         .mappedRole(nonAdminRole)
 *                         .build()))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:58.034Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_cognito_identitypool.RoleMappingMatchType")
public enum RoleMappingMatchType {
    /**
     * (experimental) The Claim from the token must equal the given value in order for a match.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    EQUALS,
    /**
     * (experimental) The Claim from the token must contain the given value in order for a match.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    CONTAINS,
    /**
     * (experimental) The Claim from the token must start with the given value in order for a match.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    STARTS_WITH,
    /**
     * (experimental) The Claim from the token must not equal the given value in order for a match.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    NOTEQUAL,
}
