package software.amazon.awscdk.services.config;

/**
 * A CloudFormation `AWS::Config::DeliveryChannel`.
 * <p>
 * Specifies a delivery channel object to deliver configuration information to an Amazon S3 bucket and Amazon SNS topic.
 * <p>
 * Before you can create a delivery channel, you must create a configuration recorder. You can use this action to change the Amazon S3 bucket or an Amazon SNS topic of the existing delivery channel. To change the Amazon S3 bucket or an Amazon SNS topic, call this action and specify the changed values for the S3 bucket and the SNS topic. If you specify a different value for either the S3 bucket or the SNS topic, this action will keep the existing value for the parameter that is not changed.
 * <p>
 * <blockquote>
 * <p>
 * In the China (Beijing) Region, when you call this action, the Amazon S3 bucket must also be in the China (Beijing) Region. In all the other regions, AWS Config supports cross-region and cross-account delivery channels.
 * <p>
 * </blockquote>
 * <p>
 * You can have only one delivery channel per region per AWS account, and the delivery channel is required to use AWS Config .
 * <p>
 * <blockquote>
 * <p>
 * AWS Config does not support the delivery channel to an Amazon S3 bucket bucket where object lock is enabled. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-lock-overview.html">How S3 Object Lock works</a> .
 * <p>
 * </blockquote>
 * <p>
 * When you create the delivery channel, you can specify; how often AWS Config delivers configuration snapshots to your Amazon S3 bucket (for example, 24 hours), the S3 bucket to which AWS Config sends configuration snapshots and configuration history files, and the Amazon SNS topic to which AWS Config sends notifications about configuration changes, such as updated resources, AWS Config rule evaluations, and when AWS Config delivers the configuration snapshot to your S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/how-does-config-work.html#delivery-channel">Deliver Configuration Items</a> in the AWS Config Developer Guide.
 * <p>
 * <blockquote>
 * <p>
 * To enable AWS Config , you must create a configuration recorder and a delivery channel. If you want to create the resources separately, you must create a configuration recorder before you can create a delivery channel. AWS Config uses the configuration recorder to capture configuration changes to your resources. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationrecorder.html">AWS::Config::ConfigurationRecorder</a> .
 * <p>
 * </blockquote>
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/manage-delivery-channel.html">Managing the Delivery Channel</a> in the AWS Config Developer Guide.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.config.*;
 * CfnDeliveryChannel cfnDeliveryChannel = CfnDeliveryChannel.Builder.create(this, "MyCfnDeliveryChannel")
 *         .s3BucketName("s3BucketName")
 *         // the properties below are optional
 *         .configSnapshotDeliveryProperties(ConfigSnapshotDeliveryPropertiesProperty.builder()
 *                 .deliveryFrequency("deliveryFrequency")
 *                 .build())
 *         .name("name")
 *         .s3KeyPrefix("s3KeyPrefix")
 *         .s3KmsKeyArn("s3KmsKeyArn")
 *         .snsTopicArn("snsTopicArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:58.099Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_config.CfnDeliveryChannel")
public class CfnDeliveryChannel extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnDeliveryChannel(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDeliveryChannel(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.CfnDeliveryChannel.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::Config::DeliveryChannel`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDeliveryChannel(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.config.CfnDeliveryChannelProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The name of the Amazon S3 bucket to which AWS Config delivers configuration snapshots and configuration history files.
     * <p>
     * If you specify a bucket that belongs to another AWS account , that bucket must have policies that grant access permissions to AWS Config . For more information, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-policy.html">Permissions for the Amazon S3 Bucket</a> in the <em>AWS Config Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getS3BucketName() {
        return software.amazon.jsii.Kernel.get(this, "s3BucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the Amazon S3 bucket to which AWS Config delivers configuration snapshots and configuration history files.
     * <p>
     * If you specify a bucket that belongs to another AWS account , that bucket must have policies that grant access permissions to AWS Config . For more information, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-policy.html">Permissions for the Amazon S3 Bucket</a> in the <em>AWS Config Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setS3BucketName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "s3BucketName", java.util.Objects.requireNonNull(value, "s3BucketName is required"));
    }

    /**
     * The options for how often AWS Config delivers configuration snapshots to the Amazon S3 bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getConfigSnapshotDeliveryProperties() {
        return software.amazon.jsii.Kernel.get(this, "configSnapshotDeliveryProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The options for how often AWS Config delivers configuration snapshots to the Amazon S3 bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfigSnapshotDeliveryProperties(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.config.CfnDeliveryChannel.ConfigSnapshotDeliveryPropertiesProperty value) {
        software.amazon.jsii.Kernel.set(this, "configSnapshotDeliveryProperties", value);
    }

    /**
     * The options for how often AWS Config delivers configuration snapshots to the Amazon S3 bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfigSnapshotDeliveryProperties(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "configSnapshotDeliveryProperties", value);
    }

    /**
     * A name for the delivery channel.
     * <p>
     * If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the delivery channel name. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name Type</a> .
     * <p>
     * Updates are not supported. To change the name, you must run two separate updates. In the first update, delete this resource, and then recreate it with a new name in the second update.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A name for the delivery channel.
     * <p>
     * If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the delivery channel name. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name Type</a> .
     * <p>
     * Updates are not supported. To change the name, you must run two separate updates. In the first update, delete this resource, and then recreate it with a new name in the second update.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * The prefix for the specified Amazon S3 bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getS3KeyPrefix() {
        return software.amazon.jsii.Kernel.get(this, "s3KeyPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The prefix for the specified Amazon S3 bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setS3KeyPrefix(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "s3KeyPrefix", value);
    }

    /**
     * The Amazon Resource Name (ARN) of the AWS Key Management Service ( AWS KMS ) AWS KMS key (KMS key) used to encrypt objects delivered by AWS Config .
     * <p>
     * Must belong to the same Region as the destination S3 bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getS3KmsKeyArn() {
        return software.amazon.jsii.Kernel.get(this, "s3KmsKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the AWS Key Management Service ( AWS KMS ) AWS KMS key (KMS key) used to encrypt objects delivered by AWS Config .
     * <p>
     * Must belong to the same Region as the destination S3 bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setS3KmsKeyArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "s3KmsKeyArn", value);
    }

    /**
     * The Amazon Resource Name (ARN) of the Amazon SNS topic to which AWS Config sends notifications about configuration changes.
     * <p>
     * If you choose a topic from another account, the topic must have policies that grant access permissions to AWS Config . For more information, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/sns-topic-policy.html">Permissions for the Amazon SNS Topic</a> in the <em>AWS Config Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSnsTopicArn() {
        return software.amazon.jsii.Kernel.get(this, "snsTopicArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the Amazon SNS topic to which AWS Config sends notifications about configuration changes.
     * <p>
     * If you choose a topic from another account, the topic must have policies that grant access permissions to AWS Config . For more information, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/sns-topic-policy.html">Permissions for the Amazon SNS Topic</a> in the <em>AWS Config Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSnsTopicArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "snsTopicArn", value);
    }
    /**
     * Provides options for how often AWS Config delivers configuration snapshots to the Amazon S3 bucket in your delivery channel.
     * <p>
     * <blockquote>
     * <p>
     * If you want to create a rule that triggers evaluations for your resources when AWS Config delivers the configuration snapshot, see the following:
     * <p>
     * </blockquote>
     * <p>
     * The frequency for a rule that triggers evaluations for your resources when AWS Config delivers the configuration snapshot is set by one of two values, depending on which is less frequent:
     * <p>
     * <ul>
     * <li>The value for the <code>deliveryFrequency</code> parameter within the delivery channel configuration, which sets how often AWS Config delivers configuration snapshots. This value also sets how often AWS Config invokes evaluations for AWS Config rules.</li>
     * <li>The value for the <code>MaximumExecutionFrequency</code> parameter, which sets the maximum frequency with which AWS Config invokes evaluations for the rule. For more information, see <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_ConfigRule.html">ConfigRule</a> .</li>
     * </ul>
     * <p>
     * If the <code>deliveryFrequency</code> value is less frequent than the <code>MaximumExecutionFrequency</code> value for a rule, AWS Config invokes the rule only as often as the <code>deliveryFrequency</code> value.
     * <p>
     * <ul>
     * <li>For example, you want your rule to run evaluations when AWS Config delivers the configuration snapshot.</li>
     * <li>You specify the <code>MaximumExecutionFrequency</code> value for <code>Six_Hours</code> .</li>
     * <li>You then specify the delivery channel <code>deliveryFrequency</code> value for <code>TwentyFour_Hours</code> .</li>
     * <li>Because the value for <code>deliveryFrequency</code> is less frequent than <code>MaximumExecutionFrequency</code> , AWS Config invokes evaluations for the rule every 24 hours.</li>
     * </ul>
     * <p>
     * You should set the <code>MaximumExecutionFrequency</code> value to be at least as frequent as the <code>deliveryFrequency</code> value. You can view the <code>deliveryFrequency</code> value by using the <code>DescribeDeliveryChannnels</code> action.
     * <p>
     * To update the <code>deliveryFrequency</code> with which AWS Config delivers your configuration snapshots, use the <code>PutDeliveryChannel</code> action.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.config.*;
     * ConfigSnapshotDeliveryPropertiesProperty configSnapshotDeliveryPropertiesProperty = ConfigSnapshotDeliveryPropertiesProperty.builder()
     *         .deliveryFrequency("deliveryFrequency")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_config.CfnDeliveryChannel.ConfigSnapshotDeliveryPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(ConfigSnapshotDeliveryPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConfigSnapshotDeliveryPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The frequency with which AWS Config delivers configuration snapshots.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDeliveryFrequency() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConfigSnapshotDeliveryPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConfigSnapshotDeliveryPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConfigSnapshotDeliveryPropertiesProperty> {
            java.lang.String deliveryFrequency;

            /**
             * Sets the value of {@link ConfigSnapshotDeliveryPropertiesProperty#getDeliveryFrequency}
             * @param deliveryFrequency The frequency with which AWS Config delivers configuration snapshots.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deliveryFrequency(java.lang.String deliveryFrequency) {
                this.deliveryFrequency = deliveryFrequency;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConfigSnapshotDeliveryPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConfigSnapshotDeliveryPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConfigSnapshotDeliveryPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConfigSnapshotDeliveryPropertiesProperty {
            private final java.lang.String deliveryFrequency;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.deliveryFrequency = software.amazon.jsii.Kernel.get(this, "deliveryFrequency", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.deliveryFrequency = builder.deliveryFrequency;
            }

            @Override
            public final java.lang.String getDeliveryFrequency() {
                return this.deliveryFrequency;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDeliveryFrequency() != null) {
                    data.set("deliveryFrequency", om.valueToTree(this.getDeliveryFrequency()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_config.CfnDeliveryChannel.ConfigSnapshotDeliveryPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConfigSnapshotDeliveryPropertiesProperty.Jsii$Proxy that = (ConfigSnapshotDeliveryPropertiesProperty.Jsii$Proxy) o;

                return this.deliveryFrequency != null ? this.deliveryFrequency.equals(that.deliveryFrequency) : that.deliveryFrequency == null;
            }

            @Override
            public final int hashCode() {
                int result = this.deliveryFrequency != null ? this.deliveryFrequency.hashCode() : 0;
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.config.CfnDeliveryChannel}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.config.CfnDeliveryChannel> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.config.CfnDeliveryChannelProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.config.CfnDeliveryChannelProps.Builder();
        }

        /**
         * The name of the Amazon S3 bucket to which AWS Config delivers configuration snapshots and configuration history files.
         * <p>
         * If you specify a bucket that belongs to another AWS account , that bucket must have policies that grant access permissions to AWS Config . For more information, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-policy.html">Permissions for the Amazon S3 Bucket</a> in the <em>AWS Config Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @param s3BucketName The name of the Amazon S3 bucket to which AWS Config delivers configuration snapshots and configuration history files. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3BucketName(final java.lang.String s3BucketName) {
            this.props.s3BucketName(s3BucketName);
            return this;
        }

        /**
         * The options for how often AWS Config delivers configuration snapshots to the Amazon S3 bucket.
         * <p>
         * @return {@code this}
         * @param configSnapshotDeliveryProperties The options for how often AWS Config delivers configuration snapshots to the Amazon S3 bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configSnapshotDeliveryProperties(final software.amazon.awscdk.services.config.CfnDeliveryChannel.ConfigSnapshotDeliveryPropertiesProperty configSnapshotDeliveryProperties) {
            this.props.configSnapshotDeliveryProperties(configSnapshotDeliveryProperties);
            return this;
        }
        /**
         * The options for how often AWS Config delivers configuration snapshots to the Amazon S3 bucket.
         * <p>
         * @return {@code this}
         * @param configSnapshotDeliveryProperties The options for how often AWS Config delivers configuration snapshots to the Amazon S3 bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configSnapshotDeliveryProperties(final software.amazon.awscdk.core.IResolvable configSnapshotDeliveryProperties) {
            this.props.configSnapshotDeliveryProperties(configSnapshotDeliveryProperties);
            return this;
        }

        /**
         * A name for the delivery channel.
         * <p>
         * If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the delivery channel name. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name Type</a> .
         * <p>
         * Updates are not supported. To change the name, you must run two separate updates. In the first update, delete this resource, and then recreate it with a new name in the second update.
         * <p>
         * @return {@code this}
         * @param name A name for the delivery channel. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The prefix for the specified Amazon S3 bucket.
         * <p>
         * @return {@code this}
         * @param s3KeyPrefix The prefix for the specified Amazon S3 bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3KeyPrefix(final java.lang.String s3KeyPrefix) {
            this.props.s3KeyPrefix(s3KeyPrefix);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the AWS Key Management Service ( AWS KMS ) AWS KMS key (KMS key) used to encrypt objects delivered by AWS Config .
         * <p>
         * Must belong to the same Region as the destination S3 bucket.
         * <p>
         * @return {@code this}
         * @param s3KmsKeyArn The Amazon Resource Name (ARN) of the AWS Key Management Service ( AWS KMS ) AWS KMS key (KMS key) used to encrypt objects delivered by AWS Config . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3KmsKeyArn(final java.lang.String s3KmsKeyArn) {
            this.props.s3KmsKeyArn(s3KmsKeyArn);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the Amazon SNS topic to which AWS Config sends notifications about configuration changes.
         * <p>
         * If you choose a topic from another account, the topic must have policies that grant access permissions to AWS Config . For more information, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/sns-topic-policy.html">Permissions for the Amazon SNS Topic</a> in the <em>AWS Config Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @param snsTopicArn The Amazon Resource Name (ARN) of the Amazon SNS topic to which AWS Config sends notifications about configuration changes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snsTopicArn(final java.lang.String snsTopicArn) {
            this.props.snsTopicArn(snsTopicArn);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.config.CfnDeliveryChannel}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.config.CfnDeliveryChannel build() {
            return new software.amazon.awscdk.services.config.CfnDeliveryChannel(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
