package software.amazon.awscdk.services.config;

/**
 * (experimental) Managed rules that are supported by AWS Config.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // https://docs.aws.amazon.com/config/latest/developerguide/access-keys-rotated.html
 * // https://docs.aws.amazon.com/config/latest/developerguide/access-keys-rotated.html
 * ManagedRule.Builder.create(this, "AccessKeysRotated")
 *         .identifier(ManagedRuleIdentifiers.ACCESS_KEYS_ROTATED)
 *         .inputParameters(Map.of(
 *                 "maxAccessKeyAge", 60))
 *         // default is 24 hours
 *         .maximumExecutionFrequency(MaximumExecutionFrequency.TWELVE_HOURS)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/managed-rules-by-aws-config.html">https://docs.aws.amazon.com/config/latest/developerguide/managed-rules-by-aws-config.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:58.139Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_config.ManagedRuleIdentifiers")
public class ManagedRuleIdentifiers extends software.amazon.jsii.JsiiObject {

    protected ManagedRuleIdentifiers(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ManagedRuleIdentifiers(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        ACCESS_KEYS_ROTATED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "ACCESS_KEYS_ROTATED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        ACCOUNT_PART_OF_ORGANIZATIONS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "ACCOUNT_PART_OF_ORGANIZATIONS", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        ACM_CERTIFICATE_EXPIRATION_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "ACM_CERTIFICATE_EXPIRATION_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        ALB_HTTP_DROP_INVALID_HEADER_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "ALB_HTTP_DROP_INVALID_HEADER_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        ALB_HTTP_TO_HTTPS_REDIRECTION_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "ALB_HTTP_TO_HTTPS_REDIRECTION_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        ALB_WAF_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "ALB_WAF_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        API_GW_CACHE_ENABLED_AND_ENCRYPTED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "API_GW_CACHE_ENABLED_AND_ENCRYPTED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        API_GW_ENDPOINT_TYPE_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "API_GW_ENDPOINT_TYPE_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        API_GW_EXECUTION_LOGGING_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "API_GW_EXECUTION_LOGGING_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        APPROVED_AMIS_BY_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "APPROVED_AMIS_BY_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        APPROVED_AMIS_BY_TAG = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "APPROVED_AMIS_BY_TAG", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        AUTOSCALING_GROUP_ELB_HEALTHCHECK_REQUIRED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "AUTOSCALING_GROUP_ELB_HEALTHCHECK_REQUIRED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        CLOUD_TRAIL_CLOUD_WATCH_LOGS_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "CLOUD_TRAIL_CLOUD_WATCH_LOGS_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        CLOUD_TRAIL_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "CLOUD_TRAIL_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        CLOUD_TRAIL_ENCRYPTION_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "CLOUD_TRAIL_ENCRYPTION_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        CLOUD_TRAIL_LOG_FILE_VALIDATION_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "CLOUD_TRAIL_LOG_FILE_VALIDATION_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        CLOUDFORMATION_STACK_DRIFT_DETECTION_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "CLOUDFORMATION_STACK_DRIFT_DETECTION_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        CLOUDFORMATION_STACK_NOTIFICATION_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "CLOUDFORMATION_STACK_NOTIFICATION_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        CLOUDFRONT_DEFAULT_ROOT_OBJECT_CONFIGURED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "CLOUDFRONT_DEFAULT_ROOT_OBJECT_CONFIGURED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        CLOUDFRONT_ORIGIN_ACCESS_IDENTITY_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "CLOUDFRONT_ORIGIN_ACCESS_IDENTITY_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        CLOUDFRONT_ORIGIN_FAILOVER_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "CLOUDFRONT_ORIGIN_FAILOVER_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        CLOUDFRONT_SNI_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "CLOUDFRONT_SNI_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        CLOUDFRONT_VIEWER_POLICY_HTTPS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "CLOUDFRONT_VIEWER_POLICY_HTTPS", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        CLOUDTRAIL_MULTI_REGION_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "CLOUDTRAIL_MULTI_REGION_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        CLOUDTRAIL_S3_DATAEVENTS_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "CLOUDTRAIL_S3_DATAEVENTS_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        CLOUDTRAIL_SECURITY_TRAIL_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "CLOUDTRAIL_SECURITY_TRAIL_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        CLOUDWATCH_ALARM_ACTION_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "CLOUDWATCH_ALARM_ACTION_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        CLOUDWATCH_ALARM_RESOURCE_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "CLOUDWATCH_ALARM_RESOURCE_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        CLOUDWATCH_ALARM_SETTINGS_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "CLOUDWATCH_ALARM_SETTINGS_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        CLOUDWATCH_LOG_GROUP_ENCRYPTED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "CLOUDWATCH_LOG_GROUP_ENCRYPTED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        CMK_BACKING_KEY_ROTATION_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "CMK_BACKING_KEY_ROTATION_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        CODEBUILD_PROJECT_ENVVAR_AWSCRED_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "CODEBUILD_PROJECT_ENVVAR_AWSCRED_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        CODEBUILD_PROJECT_SOURCE_REPO_URL_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "CODEBUILD_PROJECT_SOURCE_REPO_URL_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        CODEPIPELINE_DEPLOYMENT_COUNT_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "CODEPIPELINE_DEPLOYMENT_COUNT_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        CODEPIPELINE_REGION_FANOUT_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "CODEPIPELINE_REGION_FANOUT_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        CW_LOGGROUP_RETENTION_PERIOD_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "CW_LOGGROUP_RETENTION_PERIOD_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        DAX_ENCRYPTION_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "DAX_ENCRYPTION_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        DMS_REPLICATION_NOT_PUBLIC = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "DMS_REPLICATION_NOT_PUBLIC", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        DYNAMODB_AUTOSCALING_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "DYNAMODB_AUTOSCALING_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        DYNAMODB_IN_BACKUP_PLAN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "DYNAMODB_IN_BACKUP_PLAN", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        DYNAMODB_PITR_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "DYNAMODB_PITR_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        DYNAMODB_TABLE_ENCRYPTED_KMS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "DYNAMODB_TABLE_ENCRYPTED_KMS", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        DYNAMODB_TABLE_ENCRYPTION_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "DYNAMODB_TABLE_ENCRYPTION_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        DYNAMODB_THROUGHPUT_LIMIT_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "DYNAMODB_THROUGHPUT_LIMIT_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EBS_ENCRYPTED_VOLUMES = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EBS_ENCRYPTED_VOLUMES", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EBS_IN_BACKUP_PLAN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EBS_IN_BACKUP_PLAN", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EBS_OPTIMIZED_INSTANCE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EBS_OPTIMIZED_INSTANCE", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EBS_SNAPSHOT_PUBLIC_RESTORABLE_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EBS_SNAPSHOT_PUBLIC_RESTORABLE_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EC2_DESIRED_INSTANCE_TENANCY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EC2_DESIRED_INSTANCE_TENANCY", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EC2_DESIRED_INSTANCE_TYPE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EC2_DESIRED_INSTANCE_TYPE", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EC2_EBS_ENCRYPTION_BY_DEFAULT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EC2_EBS_ENCRYPTION_BY_DEFAULT", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EC2_IMDSV2_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EC2_IMDSV2_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EC2_INSTANCE_DETAILED_MONITORING_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EC2_INSTANCE_DETAILED_MONITORING_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EC2_INSTANCE_MANAGED_BY_SSM = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EC2_INSTANCE_MANAGED_BY_SSM", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EC2_INSTANCE_NO_PUBLIC_IP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EC2_INSTANCE_NO_PUBLIC_IP", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EC2_INSTANCE_PROFILE_ATTACHED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EC2_INSTANCE_PROFILE_ATTACHED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EC2_INSTANCES_IN_VPC = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EC2_INSTANCES_IN_VPC", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EC2_MANAGED_INSTANCE_APPLICATIONS_BLOCKED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EC2_MANAGED_INSTANCE_APPLICATIONS_BLOCKED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EC2_MANAGED_INSTANCE_APPLICATIONS_REQUIRED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EC2_MANAGED_INSTANCE_APPLICATIONS_REQUIRED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EC2_MANAGED_INSTANCE_ASSOCIATION_COMPLIANCE_STATUS_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EC2_MANAGED_INSTANCE_ASSOCIATION_COMPLIANCE_STATUS_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EC2_MANAGED_INSTANCE_INVENTORY_BLOCKED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EC2_MANAGED_INSTANCE_INVENTORY_BLOCKED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EC2_MANAGED_INSTANCE_PATCH_COMPLIANCE_STATUS_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EC2_MANAGED_INSTANCE_PATCH_COMPLIANCE_STATUS_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EC2_MANAGED_INSTANCE_PLATFORM_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EC2_MANAGED_INSTANCE_PLATFORM_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EC2_SECURITY_GROUP_ATTACHED_TO_ENI = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EC2_SECURITY_GROUP_ATTACHED_TO_ENI", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EC2_SECURITY_GROUPS_INCOMING_SSH_DISABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EC2_SECURITY_GROUPS_INCOMING_SSH_DISABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EC2_SECURITY_GROUPS_RESTRICTED_INCOMING_TRAFFIC = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EC2_SECURITY_GROUPS_RESTRICTED_INCOMING_TRAFFIC", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EC2_STOPPED_INSTANCE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EC2_STOPPED_INSTANCE", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EC2_VOLUME_INUSE_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EC2_VOLUME_INUSE_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EFS_ENCRYPTED_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EFS_ENCRYPTED_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EFS_IN_BACKUP_PLAN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EFS_IN_BACKUP_PLAN", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EIP_ATTACHED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EIP_ATTACHED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EKS_ENDPOINT_NO_PUBLIC_ACCESS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EKS_ENDPOINT_NO_PUBLIC_ACCESS", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EKS_SECRETS_ENCRYPTED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EKS_SECRETS_ENCRYPTED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        ELASTICACHE_REDIS_CLUSTER_AUTOMATIC_BACKUP_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "ELASTICACHE_REDIS_CLUSTER_AUTOMATIC_BACKUP_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        ELASTICSEARCH_ENCRYPTED_AT_REST = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "ELASTICSEARCH_ENCRYPTED_AT_REST", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        ELASTICSEARCH_IN_VPC_ONLY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "ELASTICSEARCH_IN_VPC_ONLY", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        ELASTICSEARCH_NODE_TO_NODE_ENCRYPTION_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "ELASTICSEARCH_NODE_TO_NODE_ENCRYPTION_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        ELB_ACM_CERTIFICATE_REQUIRED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "ELB_ACM_CERTIFICATE_REQUIRED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        ELB_CROSS_ZONE_LOAD_BALANCING_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "ELB_CROSS_ZONE_LOAD_BALANCING_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        ELB_CUSTOM_SECURITY_POLICY_SSL_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "ELB_CUSTOM_SECURITY_POLICY_SSL_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        ELB_DELETION_PROTECTION_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "ELB_DELETION_PROTECTION_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        ELB_LOGGING_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "ELB_LOGGING_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        ELB_PREDEFINED_SECURITY_POLICY_SSL_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "ELB_PREDEFINED_SECURITY_POLICY_SSL_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        ELB_TLS_HTTPS_LISTENERS_ONLY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "ELB_TLS_HTTPS_LISTENERS_ONLY", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EMR_KERBEROS_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EMR_KERBEROS_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        EMR_MASTER_NO_PUBLIC_IP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "EMR_MASTER_NO_PUBLIC_IP", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        FMS_SECURITY_GROUP_AUDIT_POLICY_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "FMS_SECURITY_GROUP_AUDIT_POLICY_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        FMS_SECURITY_GROUP_CONTENT_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "FMS_SECURITY_GROUP_CONTENT_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        FMS_SECURITY_GROUP_RESOURCE_ASSOCIATION_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "FMS_SECURITY_GROUP_RESOURCE_ASSOCIATION_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        FMS_SHIELD_RESOURCE_POLICY_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "FMS_SHIELD_RESOURCE_POLICY_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        FMS_WEBACL_RESOURCE_POLICY_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "FMS_WEBACL_RESOURCE_POLICY_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        FMS_WEBACL_RULEGROUP_ASSOCIATION_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "FMS_WEBACL_RULEGROUP_ASSOCIATION_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        GUARDDUTY_ENABLED_CENTRALIZED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "GUARDDUTY_ENABLED_CENTRALIZED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        GUARDDUTY_NON_ARCHIVED_FINDINGS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "GUARDDUTY_NON_ARCHIVED_FINDINGS", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        IAM_CUSTOMER_POLICY_BLOCKED_KMS_ACTIONS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "IAM_CUSTOMER_POLICY_BLOCKED_KMS_ACTIONS", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        IAM_GROUP_HAS_USERS_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "IAM_GROUP_HAS_USERS_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        IAM_INLINE_POLICY_BLOCKED_KMS_ACTIONS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "IAM_INLINE_POLICY_BLOCKED_KMS_ACTIONS", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        IAM_NO_INLINE_POLICY_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "IAM_NO_INLINE_POLICY_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        IAM_PASSWORD_POLICY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "IAM_PASSWORD_POLICY", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        IAM_POLICY_BLOCKED_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "IAM_POLICY_BLOCKED_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        IAM_POLICY_IN_USE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "IAM_POLICY_IN_USE", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        IAM_POLICY_NO_STATEMENTS_WITH_ADMIN_ACCESS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "IAM_POLICY_NO_STATEMENTS_WITH_ADMIN_ACCESS", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        IAM_ROLE_MANAGED_POLICY_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "IAM_ROLE_MANAGED_POLICY_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        IAM_ROOT_ACCESS_KEY_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "IAM_ROOT_ACCESS_KEY_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        IAM_USER_GROUP_MEMBERSHIP_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "IAM_USER_GROUP_MEMBERSHIP_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        IAM_USER_MFA_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "IAM_USER_MFA_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        IAM_USER_NO_POLICIES_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "IAM_USER_NO_POLICIES_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        IAM_USER_UNUSED_CREDENTIALS_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "IAM_USER_UNUSED_CREDENTIALS_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        INTERNET_GATEWAY_AUTHORIZED_VPC_ONLY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "INTERNET_GATEWAY_AUTHORIZED_VPC_ONLY", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        KMS_CMK_NOT_SCHEDULED_FOR_DELETION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "KMS_CMK_NOT_SCHEDULED_FOR_DELETION", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        LAMBDA_CONCURRENCY_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "LAMBDA_CONCURRENCY_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        LAMBDA_DLQ_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "LAMBDA_DLQ_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        LAMBDA_FUNCTION_PUBLIC_ACCESS_PROHIBITED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "LAMBDA_FUNCTION_PUBLIC_ACCESS_PROHIBITED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        LAMBDA_FUNCTION_SETTINGS_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "LAMBDA_FUNCTION_SETTINGS_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        LAMBDA_INSIDE_VPC = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "LAMBDA_INSIDE_VPC", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        MFA_ENABLED_FOR_IAM_CONSOLE_ACCESS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "MFA_ENABLED_FOR_IAM_CONSOLE_ACCESS", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        RDS_CLUSTER_DELETION_PROTECTION_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "RDS_CLUSTER_DELETION_PROTECTION_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        RDS_DB_INSTANCE_BACKUP_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "RDS_DB_INSTANCE_BACKUP_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        RDS_ENHANCED_MONITORING_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "RDS_ENHANCED_MONITORING_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        RDS_IN_BACKUP_PLAN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "RDS_IN_BACKUP_PLAN", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        RDS_INSTANCE_DELETION_PROTECTION_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "RDS_INSTANCE_DELETION_PROTECTION_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        RDS_INSTANCE_IAM_AUTHENTICATION_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "RDS_INSTANCE_IAM_AUTHENTICATION_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        RDS_INSTANCE_PUBLIC_ACCESS_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "RDS_INSTANCE_PUBLIC_ACCESS_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        RDS_LOGGING_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "RDS_LOGGING_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        RDS_MULTI_AZ_SUPPORT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "RDS_MULTI_AZ_SUPPORT", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        RDS_SNAPSHOT_ENCRYPTED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "RDS_SNAPSHOT_ENCRYPTED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        RDS_SNAPSHOTS_PUBLIC_PROHIBITED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "RDS_SNAPSHOTS_PUBLIC_PROHIBITED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        RDS_STORAGE_ENCRYPTED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "RDS_STORAGE_ENCRYPTED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        REDSHIFT_BACKUP_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "REDSHIFT_BACKUP_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        REDSHIFT_CLUSTER_CONFIGURATION_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "REDSHIFT_CLUSTER_CONFIGURATION_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        REDSHIFT_CLUSTER_MAINTENANCE_SETTINGS_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "REDSHIFT_CLUSTER_MAINTENANCE_SETTINGS_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        REDSHIFT_CLUSTER_PUBLIC_ACCESS_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "REDSHIFT_CLUSTER_PUBLIC_ACCESS_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        REDSHIFT_REQUIRE_TLS_SSL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "REDSHIFT_REQUIRE_TLS_SSL", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        REQUIRED_TAGS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "REQUIRED_TAGS", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        ROOT_ACCOUNT_HARDWARE_MFA_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "ROOT_ACCOUNT_HARDWARE_MFA_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        ROOT_ACCOUNT_MFA_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "ROOT_ACCOUNT_MFA_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        S3_ACCOUNT_LEVEL_PUBLIC_ACCESS_BLOCKS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "S3_ACCOUNT_LEVEL_PUBLIC_ACCESS_BLOCKS", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        S3_BUCKET_BLOCKED_ACTIONS_PROHIBITED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "S3_BUCKET_BLOCKED_ACTIONS_PROHIBITED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        S3_BUCKET_DEFAULT_LOCK_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "S3_BUCKET_DEFAULT_LOCK_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        S3_BUCKET_LEVEL_PUBLIC_ACCESS_PROHIBITED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "S3_BUCKET_LEVEL_PUBLIC_ACCESS_PROHIBITED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        S3_BUCKET_LOGGING_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "S3_BUCKET_LOGGING_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        S3_BUCKET_POLICY_GRANTEE_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "S3_BUCKET_POLICY_GRANTEE_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        S3_BUCKET_POLICY_NOT_MORE_PERMISSIVE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "S3_BUCKET_POLICY_NOT_MORE_PERMISSIVE", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        S3_BUCKET_PUBLIC_READ_PROHIBITED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "S3_BUCKET_PUBLIC_READ_PROHIBITED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        S3_BUCKET_PUBLIC_WRITE_PROHIBITED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "S3_BUCKET_PUBLIC_WRITE_PROHIBITED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        S3_BUCKET_REPLICATION_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "S3_BUCKET_REPLICATION_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        S3_BUCKET_SERVER_SIDE_ENCRYPTION_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "S3_BUCKET_SERVER_SIDE_ENCRYPTION_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        S3_BUCKET_SSL_REQUESTS_ONLY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "S3_BUCKET_SSL_REQUESTS_ONLY", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        S3_BUCKET_VERSIONING_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "S3_BUCKET_VERSIONING_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        S3_DEFAULT_ENCRYPTION_KMS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "S3_DEFAULT_ENCRYPTION_KMS", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        SAGEMAKER_ENDPOINT_CONFIGURATION_KMS_KEY_CONFIGURED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "SAGEMAKER_ENDPOINT_CONFIGURATION_KMS_KEY_CONFIGURED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        SAGEMAKER_NOTEBOOK_INSTANCE_KMS_KEY_CONFIGURED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "SAGEMAKER_NOTEBOOK_INSTANCE_KMS_KEY_CONFIGURED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        SAGEMAKER_NOTEBOOK_NO_DIRECT_INTERNET_ACCESS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "SAGEMAKER_NOTEBOOK_NO_DIRECT_INTERNET_ACCESS", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        SECRETSMANAGER_ROTATION_ENABLED_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "SECRETSMANAGER_ROTATION_ENABLED_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        SECRETSMANAGER_SCHEDULED_ROTATION_SUCCESS_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "SECRETSMANAGER_SCHEDULED_ROTATION_SUCCESS_CHECK", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        SECURITYHUB_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "SECURITYHUB_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        SERVICE_VPC_ENDPOINT_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "SERVICE_VPC_ENDPOINT_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        SHIELD_ADVANCED_ENABLED_AUTO_RENEW = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "SHIELD_ADVANCED_ENABLED_AUTO_RENEW", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        SHIELD_DRT_ACCESS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "SHIELD_DRT_ACCESS", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        SNS_ENCRYPTED_KMS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "SNS_ENCRYPTED_KMS", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        VPC_DEFAULT_SECURITY_GROUP_CLOSED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "VPC_DEFAULT_SECURITY_GROUP_CLOSED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        VPC_FLOW_LOGS_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "VPC_FLOW_LOGS_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        VPC_SG_OPEN_ONLY_TO_AUTHORIZED_PORTS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "VPC_SG_OPEN_ONLY_TO_AUTHORIZED_PORTS", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        VPC_VPN_2_TUNNELS_UP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "VPC_VPN_2_TUNNELS_UP", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        WAF_CLASSIC_LOGGING_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "WAF_CLASSIC_LOGGING_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        WAFV2_LOGGING_ENABLED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ManagedRuleIdentifiers.class, "WAFV2_LOGGING_ENABLED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) Checks whether the active access keys are rotated within the number of days specified in maxAccessKeyAge.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/access-keys-rotated.html">https://docs.aws.amazon.com/config/latest/developerguide/access-keys-rotated.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String ACCESS_KEYS_ROTATED;

    /**
     * (experimental) Checks whether AWS account is part of AWS Organizations.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/account-part-of-organizations.html">https://docs.aws.amazon.com/config/latest/developerguide/account-part-of-organizations.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String ACCOUNT_PART_OF_ORGANIZATIONS;

    /**
     * (experimental) Checks whether ACM Certificates in your account are marked for expiration within the specified number of days.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/acm-certificate-expiration-check.html">https://docs.aws.amazon.com/config/latest/developerguide/acm-certificate-expiration-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String ACM_CERTIFICATE_EXPIRATION_CHECK;

    /**
     * (experimental) Checks if rule evaluates Application Load Balancers (ALBs) to ensure they are configured to drop http headers.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/alb-http-drop-invalid-header-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/alb-http-drop-invalid-header-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String ALB_HTTP_DROP_INVALID_HEADER_ENABLED;

    /**
     * (experimental) Checks whether HTTP to HTTPS redirection is configured on all HTTP listeners of Application Load Balancer.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/alb-http-to-https-redirection-check.html">https://docs.aws.amazon.com/config/latest/developerguide/alb-http-to-https-redirection-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String ALB_HTTP_TO_HTTPS_REDIRECTION_CHECK;

    /**
     * (experimental) Checks if Web Application Firewall (WAF) is enabled on Application Load Balancers (ALBs).
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/alb-waf-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/alb-waf-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String ALB_WAF_ENABLED;

    /**
     * (experimental) Checks that all methods in Amazon API Gateway stages have caching enabled and encrypted.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/api-gw-cache-enabled-and-encrypted.html">https://docs.aws.amazon.com/config/latest/developerguide/api-gw-cache-enabled-and-encrypted.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String API_GW_CACHE_ENABLED_AND_ENCRYPTED;

    /**
     * (experimental) Checks that Amazon API Gateway APIs are of the type specified in the rule parameter endpointConfigurationType.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/api-gw-endpoint-type-check.html">https://docs.aws.amazon.com/config/latest/developerguide/api-gw-endpoint-type-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String API_GW_ENDPOINT_TYPE_CHECK;

    /**
     * (experimental) Checks that all methods in Amazon API Gateway stage has logging enabled.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/api-gw-execution-logging-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/api-gw-execution-logging-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String API_GW_EXECUTION_LOGGING_ENABLED;

    /**
     * (experimental) Checks whether running instances are using specified AMIs.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/approved-amis-by-id.html">https://docs.aws.amazon.com/config/latest/developerguide/approved-amis-by-id.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String APPROVED_AMIS_BY_ID;

    /**
     * (experimental) Checks whether running instances are using specified AMIs.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/approved-amis-by-tag.html">https://docs.aws.amazon.com/config/latest/developerguide/approved-amis-by-tag.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String APPROVED_AMIS_BY_TAG;

    /**
     * (experimental) Checks whether your Auto Scaling groups that are associated with a load balancer are using Elastic Load Balancing health checks.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/autoscaling-group-elb-healthcheck-required.html">https://docs.aws.amazon.com/config/latest/developerguide/autoscaling-group-elb-healthcheck-required.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String AUTOSCALING_GROUP_ELB_HEALTHCHECK_REQUIRED;

    /**
     * (experimental) Checks whether AWS CloudTrail trails are configured to send logs to Amazon CloudWatch Logs.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/cloud-trail-cloud-watch-logs-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/cloud-trail-cloud-watch-logs-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String CLOUD_TRAIL_CLOUD_WATCH_LOGS_ENABLED;

    /**
     * (experimental) Checks whether AWS CloudTrail is enabled in your AWS account.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/cloudtrail-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/cloudtrail-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String CLOUD_TRAIL_ENABLED;

    /**
     * (experimental) Checks whether AWS CloudTrail is configured to use the server side encryption (SSE) AWS Key Management Service (AWS KMS) customer master key (CMK) encryption.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/cloud-trail-encryption-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/cloud-trail-encryption-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String CLOUD_TRAIL_ENCRYPTION_ENABLED;

    /**
     * (experimental) Checks whether AWS CloudTrail creates a signed digest file with logs.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/cloud-trail-log-file-validation-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/cloud-trail-log-file-validation-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String CLOUD_TRAIL_LOG_FILE_VALIDATION_ENABLED;

    /**
     * (experimental) Checks whether an AWS CloudFormation stack's actual configuration differs, or has drifted, from it's expected configuration.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/cloudformation-stack-drift-detection-check.html">https://docs.aws.amazon.com/config/latest/developerguide/cloudformation-stack-drift-detection-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String CLOUDFORMATION_STACK_DRIFT_DETECTION_CHECK;

    /**
     * (experimental) Checks whether your CloudFormation stacks are sending event notifications to an SNS topic.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/cloudformation-stack-notification-check.html">https://docs.aws.amazon.com/config/latest/developerguide/cloudformation-stack-notification-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String CLOUDFORMATION_STACK_NOTIFICATION_CHECK;

    /**
     * (experimental) Checks if an Amazon CloudFront distribution is configured to return a specific object that is the default root object.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/cloudfront-default-root-object-configured.html">https://docs.aws.amazon.com/config/latest/developerguide/cloudfront-default-root-object-configured.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String CLOUDFRONT_DEFAULT_ROOT_OBJECT_CONFIGURED;

    /**
     * (experimental) Checks that Amazon CloudFront distribution with Amazon S3 Origin type has Origin Access Identity (OAI) configured.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/cloudfront-origin-access-identity-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/cloudfront-origin-access-identity-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String CLOUDFRONT_ORIGIN_ACCESS_IDENTITY_ENABLED;

    /**
     * (experimental) Checks whether an origin group is configured for the distribution of at least 2 origins in the origin group for Amazon CloudFront.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/cloudfront-origin-failover-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/cloudfront-origin-failover-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String CLOUDFRONT_ORIGIN_FAILOVER_ENABLED;

    /**
     * (experimental) Checks if Amazon CloudFront distributions are using a custom SSL certificate and are configured to use SNI to serve HTTPS requests.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/cloudfront-sni-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/cloudfront-sni-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String CLOUDFRONT_SNI_ENABLED;

    /**
     * (experimental) Checks whether your Amazon CloudFront distributions use HTTPS (directly or via a redirection).
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/cloudfront-viewer-policy-https.html">https://docs.aws.amazon.com/config/latest/developerguide/cloudfront-viewer-policy-https.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String CLOUDFRONT_VIEWER_POLICY_HTTPS;

    /**
     * (experimental) Checks that there is at least one multi-region AWS CloudTrail.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/multi-region-cloudtrail-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/multi-region-cloudtrail-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String CLOUDTRAIL_MULTI_REGION_ENABLED;

    /**
     * (experimental) Checks whether at least one AWS CloudTrail trail is logging Amazon S3 data events for all S3 buckets.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/cloudtrail-s3-dataevents-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/cloudtrail-s3-dataevents-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String CLOUDTRAIL_S3_DATAEVENTS_ENABLED;

    /**
     * (experimental) Checks that there is at least one AWS CloudTrail trail defined with security best practices.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/cloudtrail-security-trail-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/cloudtrail-security-trail-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String CLOUDTRAIL_SECURITY_TRAIL_ENABLED;

    /**
     * (experimental) Checks whether CloudWatch alarms have at least one alarm action, one INSUFFICIENT_DATA action, or one OK action enabled.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/cloudwatch-alarm-action-check.html">https://docs.aws.amazon.com/config/latest/developerguide/cloudwatch-alarm-action-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String CLOUDWATCH_ALARM_ACTION_CHECK;

    /**
     * (experimental) Checks whether the specified resource type has a CloudWatch alarm for the specified metric.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/cloudwatch-alarm-resource-check.html">https://docs.aws.amazon.com/config/latest/developerguide/cloudwatch-alarm-resource-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String CLOUDWATCH_ALARM_RESOURCE_CHECK;

    /**
     * (experimental) Checks whether CloudWatch alarms with the given metric name have the specified settings.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/cloudwatch-alarm-settings-check.html">https://docs.aws.amazon.com/config/latest/developerguide/cloudwatch-alarm-settings-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String CLOUDWATCH_ALARM_SETTINGS_CHECK;

    /**
     * (experimental) Checks whether a log group in Amazon CloudWatch Logs is encrypted with a AWS Key Management Service (KMS) managed Customer Master Keys (CMK).
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/cloudwatch-log-group-encrypted.html">https://docs.aws.amazon.com/config/latest/developerguide/cloudwatch-log-group-encrypted.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String CLOUDWATCH_LOG_GROUP_ENCRYPTED;

    /**
     * (experimental) Checks that key rotation is enabled for each key and matches to the key ID of the customer created customer master key (CMK).
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/cmk-backing-key-rotation-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/cmk-backing-key-rotation-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String CMK_BACKING_KEY_ROTATION_ENABLED;

    /**
     * (experimental) Checks whether the project contains environment variables AWS_ACCESS_KEY_ID and AWS_SECRET_ACCESS_KEY.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/codebuild-project-envvar-awscred-check.html">https://docs.aws.amazon.com/config/latest/developerguide/codebuild-project-envvar-awscred-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String CODEBUILD_PROJECT_ENVVAR_AWSCRED_CHECK;

    /**
     * (experimental) Checks whether the GitHub or Bitbucket source repository URL contains either personal access tokens or user name and password.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/codebuild-project-source-repo-url-check.html">https://docs.aws.amazon.com/config/latest/developerguide/codebuild-project-source-repo-url-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String CODEBUILD_PROJECT_SOURCE_REPO_URL_CHECK;

    /**
     * (experimental) Checks whether the first deployment stage of the AWS CodePipeline performs more than one deployment.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/codepipeline-deployment-count-check.html">https://docs.aws.amazon.com/config/latest/developerguide/codepipeline-deployment-count-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String CODEPIPELINE_DEPLOYMENT_COUNT_CHECK;

    /**
     * (experimental) Checks whether each stage in the AWS CodePipeline deploys to more than N times the number of the regions the AWS CodePipeline has deployed in all the previous combined stages, where N is the region fanout number.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/codepipeline-region-fanout-check.html">https://docs.aws.amazon.com/config/latest/developerguide/codepipeline-region-fanout-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String CODEPIPELINE_REGION_FANOUT_CHECK;

    /**
     * (experimental) Checks whether Amazon CloudWatch LogGroup retention period is set to specific number of days.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/cw-loggroup-retention-period-check.html">https://docs.aws.amazon.com/config/latest/developerguide/cw-loggroup-retention-period-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String CW_LOGGROUP_RETENTION_PERIOD_CHECK;

    /**
     * (experimental) Checks that DynamoDB Accelerator (DAX) clusters are encrypted.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/dax-encryption-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/dax-encryption-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String DAX_ENCRYPTION_ENABLED;

    /**
     * (experimental) Checks whether AWS Database Migration Service replication instances are public.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/dms-replication-not-public.html">https://docs.aws.amazon.com/config/latest/developerguide/dms-replication-not-public.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String DMS_REPLICATION_NOT_PUBLIC;

    /**
     * (experimental) Checks whether Auto Scaling or On-Demand is enabled on your DynamoDB tables and/or global secondary indexes.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/dynamodb-autoscaling-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/dynamodb-autoscaling-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String DYNAMODB_AUTOSCALING_ENABLED;

    /**
     * (experimental) Checks whether Amazon DynamoDB table is present in AWS Backup plans.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/dynamodb-in-backup-plan.html">https://docs.aws.amazon.com/config/latest/developerguide/dynamodb-in-backup-plan.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String DYNAMODB_IN_BACKUP_PLAN;

    /**
     * (experimental) Checks that point in time recovery (PITR) is enabled for Amazon DynamoDB tables.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/dynamodb-pitr-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/dynamodb-pitr-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String DYNAMODB_PITR_ENABLED;

    /**
     * (experimental) Checks whether Amazon DynamoDB table is encrypted with AWS Key Management Service (KMS).
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/dynamodb-table-encrypted-kms.html">https://docs.aws.amazon.com/config/latest/developerguide/dynamodb-table-encrypted-kms.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String DYNAMODB_TABLE_ENCRYPTED_KMS;

    /**
     * (experimental) Checks whether the Amazon DynamoDB tables are encrypted and checks their status.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/dynamodb-table-encryption-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/dynamodb-table-encryption-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String DYNAMODB_TABLE_ENCRYPTION_ENABLED;

    /**
     * (experimental) Checks whether provisioned DynamoDB throughput is approaching the maximum limit for your account.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/dynamodb-throughput-limit-check.html">https://docs.aws.amazon.com/config/latest/developerguide/dynamodb-throughput-limit-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String DYNAMODB_THROUGHPUT_LIMIT_CHECK;

    /**
     * (experimental) Checks whether the EBS volumes that are in an attached state are encrypted.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/encrypted-volumes.html">https://docs.aws.amazon.com/config/latest/developerguide/encrypted-volumes.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String EBS_ENCRYPTED_VOLUMES;

    /**
     * (experimental) Checks if Amazon Elastic Block Store (Amazon EBS) volumes are added in backup plans of AWS Backup.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/ebs-in-backup-plan.html">https://docs.aws.amazon.com/config/latest/developerguide/ebs-in-backup-plan.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String EBS_IN_BACKUP_PLAN;

    /**
     * (experimental) Checks whether EBS optimization is enabled for your EC2 instances that can be EBS-optimized.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/ebs-optimized-instance.html">https://docs.aws.amazon.com/config/latest/developerguide/ebs-optimized-instance.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String EBS_OPTIMIZED_INSTANCE;

    /**
     * (experimental) Checks whether Amazon Elastic Block Store snapshots are not publicly restorable.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/ebs-snapshot-public-restorable-check.html">https://docs.aws.amazon.com/config/latest/developerguide/ebs-snapshot-public-restorable-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String EBS_SNAPSHOT_PUBLIC_RESTORABLE_CHECK;

    /**
     * (experimental) Checks instances for specified tenancy.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/desired-instance-tenancy.html">https://docs.aws.amazon.com/config/latest/developerguide/desired-instance-tenancy.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String EC2_DESIRED_INSTANCE_TENANCY;

    /**
     * (experimental) Checks whether your EC2 instances are of the specified instance types.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/desired-instance-type.html">https://docs.aws.amazon.com/config/latest/developerguide/desired-instance-type.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String EC2_DESIRED_INSTANCE_TYPE;

    /**
     * (experimental) Check that Amazon Elastic Block Store (EBS) encryption is enabled by default.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/ec2-ebs-encryption-by-default.html">https://docs.aws.amazon.com/config/latest/developerguide/ec2-ebs-encryption-by-default.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String EC2_EBS_ENCRYPTION_BY_DEFAULT;

    /**
     * (experimental) Checks whether your Amazon Elastic Compute Cloud (Amazon EC2) instance metadata version is configured with Instance Metadata Service Version 2 (IMDSv2).
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/ec2-imdsv2-check.html">https://docs.aws.amazon.com/config/latest/developerguide/ec2-imdsv2-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String EC2_IMDSV2_CHECK;

    /**
     * (experimental) Checks whether detailed monitoring is enabled for EC2 instances.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/ec2-instance-detailed-monitoring-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/ec2-instance-detailed-monitoring-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String EC2_INSTANCE_DETAILED_MONITORING_ENABLED;

    /**
     * (experimental) Checks whether the Amazon EC2 instances in your account are managed by AWS Systems Manager.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/ec2-instance-managed-by-systems-manager.html">https://docs.aws.amazon.com/config/latest/developerguide/ec2-instance-managed-by-systems-manager.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String EC2_INSTANCE_MANAGED_BY_SSM;

    /**
     * (experimental) Checks whether Amazon Elastic Compute Cloud (Amazon EC2) instances have a public IP association.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/ec2-instance-no-public-ip.html">https://docs.aws.amazon.com/config/latest/developerguide/ec2-instance-no-public-ip.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String EC2_INSTANCE_NO_PUBLIC_IP;

    /**
     * (experimental) Checks if an Amazon Elastic Compute Cloud (Amazon EC2) instance has an Identity and Access Management (IAM) profile attached to it.
     * <p>
     * This rule is NON_COMPLIANT if no IAM profile is
     * attached to the Amazon EC2 instance.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/ec2-instance-profile-attached.html">https://docs.aws.amazon.com/config/latest/developerguide/ec2-instance-profile-attached.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String EC2_INSTANCE_PROFILE_ATTACHED;

    /**
     * (experimental) Checks whether your EC2 instances belong to a virtual private cloud (VPC).
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/ec2-instances-in-vpc.html">https://docs.aws.amazon.com/config/latest/developerguide/ec2-instances-in-vpc.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String EC2_INSTANCES_IN_VPC;

    /**
     * (experimental) Checks that none of the specified applications are installed on the instance.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/ec2-managedinstance-applications-blacklisted.html">https://docs.aws.amazon.com/config/latest/developerguide/ec2-managedinstance-applications-blacklisted.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String EC2_MANAGED_INSTANCE_APPLICATIONS_BLOCKED;

    /**
     * (experimental) Checks whether all of the specified applications are installed on the instance.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/ec2-managedinstance-applications-required.html">https://docs.aws.amazon.com/config/latest/developerguide/ec2-managedinstance-applications-required.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String EC2_MANAGED_INSTANCE_APPLICATIONS_REQUIRED;

    /**
     * (experimental) Checks whether the compliance status of AWS Systems Manager association compliance is COMPLIANT or NON_COMPLIANT after the association execution on the instance.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/ec2-managedinstance-association-compliance-status-check.html">https://docs.aws.amazon.com/config/latest/developerguide/ec2-managedinstance-association-compliance-status-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String EC2_MANAGED_INSTANCE_ASSOCIATION_COMPLIANCE_STATUS_CHECK;

    /**
     * (experimental) Checks whether instances managed by AWS Systems Manager are configured to collect blocked inventory types.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/ec2-managedinstance-inventory-blacklisted.html">https://docs.aws.amazon.com/config/latest/developerguide/ec2-managedinstance-inventory-blacklisted.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String EC2_MANAGED_INSTANCE_INVENTORY_BLOCKED;

    /**
     * (experimental) Checks whether the compliance status of the Amazon EC2 Systems Manager patch compliance is COMPLIANT or NON_COMPLIANT after the patch installation on the instance.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/ec2-managedinstance-patch-compliance-status-check.html">https://docs.aws.amazon.com/config/latest/developerguide/ec2-managedinstance-patch-compliance-status-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String EC2_MANAGED_INSTANCE_PATCH_COMPLIANCE_STATUS_CHECK;

    /**
     * (experimental) Checks whether EC2 managed instances have the desired configurations.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/ec2-managedinstance-platform-check.html">https://docs.aws.amazon.com/config/latest/developerguide/ec2-managedinstance-platform-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String EC2_MANAGED_INSTANCE_PLATFORM_CHECK;

    /**
     * (experimental) Checks that security groups are attached to Amazon Elastic Compute Cloud (Amazon EC2) instances or to an elastic network interface.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/ec2-security-group-attached-to-eni.html">https://docs.aws.amazon.com/config/latest/developerguide/ec2-security-group-attached-to-eni.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String EC2_SECURITY_GROUP_ATTACHED_TO_ENI;

    /**
     * (experimental) Checks whether the incoming SSH traffic for the security groups is accessible.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/restricted-ssh.html">https://docs.aws.amazon.com/config/latest/developerguide/restricted-ssh.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String EC2_SECURITY_GROUPS_INCOMING_SSH_DISABLED;

    /**
     * (experimental) Checks whether the security groups in use do not allow unrestricted incoming TCP traffic to the specified ports.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/restricted-common-ports.html">https://docs.aws.amazon.com/config/latest/developerguide/restricted-common-ports.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String EC2_SECURITY_GROUPS_RESTRICTED_INCOMING_TRAFFIC;

    /**
     * (experimental) Checks whether there are instances stopped for more than the allowed number of days.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/ec2-stopped-instance.html">https://docs.aws.amazon.com/config/latest/developerguide/ec2-stopped-instance.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String EC2_STOPPED_INSTANCE;

    /**
     * (experimental) Checks whether EBS volumes are attached to EC2 instances.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/ec2-volume-inuse-check.html">https://docs.aws.amazon.com/config/latest/developerguide/ec2-volume-inuse-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String EC2_VOLUME_INUSE_CHECK;

    /**
     * (experimental) hecks whether Amazon Elastic File System (Amazon EFS) is configured to encrypt the file data using AWS Key Management Service (AWS KMS).
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/efs-encrypted-check.html">https://docs.aws.amazon.com/config/latest/developerguide/efs-encrypted-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String EFS_ENCRYPTED_CHECK;

    /**
     * (experimental) Checks whether Amazon Elastic File System (Amazon EFS) file systems are added in the backup plans of AWS Backup.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/efs-in-backup-plan.html">https://docs.aws.amazon.com/config/latest/developerguide/efs-in-backup-plan.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String EFS_IN_BACKUP_PLAN;

    /**
     * (experimental) Checks whether all Elastic IP addresses that are allocated to a VPC are attached to EC2 instances or in-use elastic network interfaces (ENIs).
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/eip-attached.html">https://docs.aws.amazon.com/config/latest/developerguide/eip-attached.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String EIP_ATTACHED;

    /**
     * (experimental) Checks whether Amazon Elastic Kubernetes Service (Amazon EKS) endpoint is not publicly accessible.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/eks-endpoint-no-public-access.html">https://docs.aws.amazon.com/config/latest/developerguide/eks-endpoint-no-public-access.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String EKS_ENDPOINT_NO_PUBLIC_ACCESS;

    /**
     * (experimental) Checks whether Amazon Elastic Kubernetes Service clusters are configured to have Kubernetes secrets encrypted using AWS Key Management Service (KMS) keys.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/eks-secrets-encrypted.html">https://docs.aws.amazon.com/config/latest/developerguide/eks-secrets-encrypted.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String EKS_SECRETS_ENCRYPTED;

    /**
     * (experimental) Check if the Amazon ElastiCache Redis clusters have automatic backup turned on.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/elasticache-redis-cluster-automatic-backup-check.html">https://docs.aws.amazon.com/config/latest/developerguide/elasticache-redis-cluster-automatic-backup-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String ELASTICACHE_REDIS_CLUSTER_AUTOMATIC_BACKUP_CHECK;

    /**
     * (experimental) Checks whether Amazon Elasticsearch Service (Amazon ES) domains have encryption at rest configuration enabled.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/elasticsearch-encrypted-at-rest.html">https://docs.aws.amazon.com/config/latest/developerguide/elasticsearch-encrypted-at-rest.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String ELASTICSEARCH_ENCRYPTED_AT_REST;

    /**
     * (experimental) Checks whether Amazon Elasticsearch Service (Amazon ES) domains are in Amazon Virtual Private Cloud (Amazon VPC).
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/elasticsearch-in-vpc-only.html">https://docs.aws.amazon.com/config/latest/developerguide/elasticsearch-in-vpc-only.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String ELASTICSEARCH_IN_VPC_ONLY;

    /**
     * (experimental) Check that Amazon ElasticSearch Service nodes are encrypted end to end.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/elasticsearch-node-to-node-encryption-check.html">https://docs.aws.amazon.com/config/latest/developerguide/elasticsearch-node-to-node-encryption-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String ELASTICSEARCH_NODE_TO_NODE_ENCRYPTION_CHECK;

    /**
     * (experimental) Checks whether the Classic Load Balancers use SSL certificates provided by AWS Certificate Manager.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/elb-acm-certificate-required.html">https://docs.aws.amazon.com/config/latest/developerguide/elb-acm-certificate-required.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String ELB_ACM_CERTIFICATE_REQUIRED;

    /**
     * (experimental) Checks if cross-zone load balancing is enabled for the Classic Load Balancers (CLBs).
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/elb-cross-zone-load-balancing-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/elb-cross-zone-load-balancing-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String ELB_CROSS_ZONE_LOAD_BALANCING_ENABLED;

    /**
     * (experimental) Checks whether your Classic Load Balancer SSL listeners are using a custom policy.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/elb-custom-security-policy-ssl-check.html">https://docs.aws.amazon.com/config/latest/developerguide/elb-custom-security-policy-ssl-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String ELB_CUSTOM_SECURITY_POLICY_SSL_CHECK;

    /**
     * (experimental) Checks whether Elastic Load Balancing has deletion protection enabled.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/elb-deletion-protection-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/elb-deletion-protection-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String ELB_DELETION_PROTECTION_ENABLED;

    /**
     * (experimental) Checks whether the Application Load Balancer and the Classic Load Balancer have logging enabled.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/elb-logging-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/elb-logging-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String ELB_LOGGING_ENABLED;

    /**
     * (experimental) Checks whether your Classic Load Balancer SSL listeners are using a predefined policy.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/elb-predefined-security-policy-ssl-check.html">https://docs.aws.amazon.com/config/latest/developerguide/elb-predefined-security-policy-ssl-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String ELB_PREDEFINED_SECURITY_POLICY_SSL_CHECK;

    /**
     * (experimental) Checks whether your Classic Load Balancer is configured with SSL or HTTPS listeners.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/elb-tls-https-listeners-only.html">https://docs.aws.amazon.com/config/latest/developerguide/elb-tls-https-listeners-only.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String ELB_TLS_HTTPS_LISTENERS_ONLY;

    /**
     * (experimental) Checks that Amazon EMR clusters have Kerberos enabled.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/emr-kerberos-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/emr-kerberos-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String EMR_KERBEROS_ENABLED;

    /**
     * (experimental) Checks whether Amazon Elastic MapReduce (EMR) clusters' master nodes have public IPs.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/emr-master-no-public-ip.html">https://docs.aws.amazon.com/config/latest/developerguide/emr-master-no-public-ip.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String EMR_MASTER_NO_PUBLIC_IP;

    /**
     * (experimental) Checks whether the security groups associated inScope resources are compliant with the master security groups at each rule level based on allowSecurityGroup and denySecurityGroup flag.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/fms-security-group-audit-policy-check.html">https://docs.aws.amazon.com/config/latest/developerguide/fms-security-group-audit-policy-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String FMS_SECURITY_GROUP_AUDIT_POLICY_CHECK;

    /**
     * (experimental) Checks whether AWS Firewall Manager created security groups content is the same as the master security groups.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/fms-security-group-content-check.html">https://docs.aws.amazon.com/config/latest/developerguide/fms-security-group-content-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String FMS_SECURITY_GROUP_CONTENT_CHECK;

    /**
     * (experimental) Checks whether Amazon EC2 or an elastic network interface is associated with AWS Firewall Manager security groups.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/fms-security-group-resource-association-check.html">https://docs.aws.amazon.com/config/latest/developerguide/fms-security-group-resource-association-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String FMS_SECURITY_GROUP_RESOURCE_ASSOCIATION_CHECK;

    /**
     * (experimental) Checks whether an Application Load Balancer, Amazon CloudFront distributions, Elastic Load Balancer or Elastic IP has AWS Shield protection.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/fms-shield-resource-policy-check.html">https://docs.aws.amazon.com/config/latest/developerguide/fms-shield-resource-policy-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String FMS_SHIELD_RESOURCE_POLICY_CHECK;

    /**
     * (experimental) Checks whether the web ACL is associated with an Application Load Balancer, API Gateway stage, or Amazon CloudFront distributions.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/fms-webacl-resource-policy-check.html">https://docs.aws.amazon.com/config/latest/developerguide/fms-webacl-resource-policy-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String FMS_WEBACL_RESOURCE_POLICY_CHECK;

    /**
     * (experimental) Checks that the rule groups associate with the web ACL at the correct priority.
     * <p>
     * The correct priority is decided by the rank of the rule groups in the ruleGroups parameter.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/fms-webacl-rulegroup-association-check.html">https://docs.aws.amazon.com/config/latest/developerguide/fms-webacl-rulegroup-association-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String FMS_WEBACL_RULEGROUP_ASSOCIATION_CHECK;

    /**
     * (experimental) Checks whether Amazon GuardDuty is enabled in your AWS account and region.
     * <p>
     * If you provide an AWS account for centralization,
     * the rule evaluates the Amazon GuardDuty results in the centralized account.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/guardduty-enabled-centralized.html">https://docs.aws.amazon.com/config/latest/developerguide/guardduty-enabled-centralized.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String GUARDDUTY_ENABLED_CENTRALIZED;

    /**
     * (experimental) Checks whether the Amazon GuardDuty has findings that are non archived.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/guardduty-non-archived-findings.html">https://docs.aws.amazon.com/config/latest/developerguide/guardduty-non-archived-findings.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String GUARDDUTY_NON_ARCHIVED_FINDINGS;

    /**
     * (experimental) Checks that the managed AWS Identity and Access Management policies that you create do not allow blocked actions on all AWS AWS KMS keys.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/iam-customer-policy-blocked-kms-actions.html">https://docs.aws.amazon.com/config/latest/developerguide/iam-customer-policy-blocked-kms-actions.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String IAM_CUSTOMER_POLICY_BLOCKED_KMS_ACTIONS;

    /**
     * (experimental) Checks whether IAM groups have at least one IAM user.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/iam-group-has-users-check.html">https://docs.aws.amazon.com/config/latest/developerguide/iam-group-has-users-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String IAM_GROUP_HAS_USERS_CHECK;

    /**
     * (experimental) Checks that the inline policies attached to your AWS Identity and Access Management users, roles, and groups do not allow blocked actions on all AWS Key Management Service keys.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/iam-inline-policy-blocked-kms-actions.html">https://docs.aws.amazon.com/config/latest/developerguide/iam-inline-policy-blocked-kms-actions.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String IAM_INLINE_POLICY_BLOCKED_KMS_ACTIONS;

    /**
     * (experimental) Checks that inline policy feature is not in use.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/iam-no-inline-policy-check.html">https://docs.aws.amazon.com/config/latest/developerguide/iam-no-inline-policy-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String IAM_NO_INLINE_POLICY_CHECK;

    /**
     * (experimental) Checks whether the account password policy for IAM users meets the specified requirements indicated in the parameters.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/iam-password-policy.html">https://docs.aws.amazon.com/config/latest/developerguide/iam-password-policy.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String IAM_PASSWORD_POLICY;

    /**
     * (experimental) Checks whether for each IAM resource, a policy ARN in the input parameter is attached to the IAM resource.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/iam-policy-blacklisted-check.html">https://docs.aws.amazon.com/config/latest/developerguide/iam-policy-blacklisted-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String IAM_POLICY_BLOCKED_CHECK;

    /**
     * (experimental) Checks whether the IAM policy ARN is attached to an IAM user, or an IAM group with one or more IAM users, or an IAM role with one or more trusted entity.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/iam-policy-in-use.html">https://docs.aws.amazon.com/config/latest/developerguide/iam-policy-in-use.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String IAM_POLICY_IN_USE;

    /**
     * (experimental) Checks the IAM policies that you create for Allow statements that grant permissions to all actions on all resources.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/iam-policy-no-statements-with-admin-access.html">https://docs.aws.amazon.com/config/latest/developerguide/iam-policy-no-statements-with-admin-access.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String IAM_POLICY_NO_STATEMENTS_WITH_ADMIN_ACCESS;

    /**
     * (experimental) Checks that AWS Identity and Access Management (IAM) policies in a list of policies are attached to all AWS roles.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/iam-role-managed-policy-check.html">https://docs.aws.amazon.com/config/latest/developerguide/iam-role-managed-policy-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String IAM_ROLE_MANAGED_POLICY_CHECK;

    /**
     * (experimental) Checks whether the root user access key is available.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/iam-root-access-key-check.html">https://docs.aws.amazon.com/config/latest/developerguide/iam-root-access-key-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String IAM_ROOT_ACCESS_KEY_CHECK;

    /**
     * (experimental) Checks whether IAM users are members of at least one IAM group.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/iam-user-group-membership-check.html">https://docs.aws.amazon.com/config/latest/developerguide/iam-user-group-membership-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String IAM_USER_GROUP_MEMBERSHIP_CHECK;

    /**
     * (experimental) Checks whether the AWS Identity and Access Management users have multi-factor authentication (MFA) enabled.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/iam-user-mfa-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/iam-user-mfa-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String IAM_USER_MFA_ENABLED;

    /**
     * (experimental) Checks that none of your IAM users have policies attached.
     * <p>
     * IAM users must inherit permissions from IAM groups or roles.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/iam-user-no-policies-check.html">https://docs.aws.amazon.com/config/latest/developerguide/iam-user-no-policies-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String IAM_USER_NO_POLICIES_CHECK;

    /**
     * (experimental) Checks whether your AWS Identity and Access Management (IAM) users have passwords or active access keys that have not been used within the specified number of days you provided.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/iam-user-unused-credentials-check.html">https://docs.aws.amazon.com/config/latest/developerguide/iam-user-unused-credentials-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String IAM_USER_UNUSED_CREDENTIALS_CHECK;

    /**
     * (experimental) Checks that Internet gateways (IGWs) are only attached to an authorized Amazon Virtual Private Cloud (VPCs).
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/internet-gateway-authorized-vpc-only.html">https://docs.aws.amazon.com/config/latest/developerguide/internet-gateway-authorized-vpc-only.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String INTERNET_GATEWAY_AUTHORIZED_VPC_ONLY;

    /**
     * (experimental) Checks whether customer master keys (CMKs) are not scheduled for deletion in AWS Key Management Service (KMS).
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/kms-cmk-not-scheduled-for-deletion.html">https://docs.aws.amazon.com/config/latest/developerguide/kms-cmk-not-scheduled-for-deletion.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String KMS_CMK_NOT_SCHEDULED_FOR_DELETION;

    /**
     * (experimental) Checks whether the AWS Lambda function is configured with function-level concurrent execution limit.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/lambda-concurrency-check.html">https://docs.aws.amazon.com/config/latest/developerguide/lambda-concurrency-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String LAMBDA_CONCURRENCY_CHECK;

    /**
     * (experimental) Checks whether an AWS Lambda function is configured with a dead-letter queue.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/lambda-dlq-check.html">https://docs.aws.amazon.com/config/latest/developerguide/lambda-dlq-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String LAMBDA_DLQ_CHECK;

    /**
     * (experimental) Checks whether the AWS Lambda function policy attached to the Lambda resource prohibits public access.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/lambda-function-public-access-prohibited.html">https://docs.aws.amazon.com/config/latest/developerguide/lambda-function-public-access-prohibited.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String LAMBDA_FUNCTION_PUBLIC_ACCESS_PROHIBITED;

    /**
     * (experimental) Checks that the lambda function settings for runtime, role, timeout, and memory size match the expected values.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/lambda-function-settings-check.html">https://docs.aws.amazon.com/config/latest/developerguide/lambda-function-settings-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String LAMBDA_FUNCTION_SETTINGS_CHECK;

    /**
     * (experimental) Checks whether an AWS Lambda function is in an Amazon Virtual Private Cloud.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/lambda-inside-vpc.html">https://docs.aws.amazon.com/config/latest/developerguide/lambda-inside-vpc.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String LAMBDA_INSIDE_VPC;

    /**
     * (experimental) Checks whether AWS Multi-Factor Authentication (MFA) is enabled for all IAM users that use a console password.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/mfa-enabled-for-iam-console-access.html">https://docs.aws.amazon.com/config/latest/developerguide/mfa-enabled-for-iam-console-access.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String MFA_ENABLED_FOR_IAM_CONSOLE_ACCESS;

    /**
     * (experimental) Checks if an Amazon Relational Database Service (Amazon RDS) cluster has deletion protection enabled.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/rds-cluster-deletion-protection-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/rds-cluster-deletion-protection-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String RDS_CLUSTER_DELETION_PROTECTION_ENABLED;

    /**
     * (experimental) Checks whether RDS DB instances have backups enabled.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/db-instance-backup-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/db-instance-backup-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String RDS_DB_INSTANCE_BACKUP_ENABLED;

    /**
     * (experimental) Checks whether enhanced monitoring is enabled for Amazon Relational Database Service (Amazon RDS) instances.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/rds-enhanced-monitoring-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/rds-enhanced-monitoring-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String RDS_ENHANCED_MONITORING_ENABLED;

    /**
     * (experimental) Checks whether Amazon RDS database is present in back plans of AWS Backup.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/rds-in-backup-plan.html">https://docs.aws.amazon.com/config/latest/developerguide/rds-in-backup-plan.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String RDS_IN_BACKUP_PLAN;

    /**
     * (experimental) Checks if an Amazon Relational Database Service (Amazon RDS) instance has deletion protection enabled.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/rds-instance-deletion-protection-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/rds-instance-deletion-protection-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String RDS_INSTANCE_DELETION_PROTECTION_ENABLED;

    /**
     * (experimental) Checks if an Amazon RDS instance has AWS Identity and Access Management (IAM) authentication enabled.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/rds-instance-iam-authentication-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/rds-instance-iam-authentication-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String RDS_INSTANCE_IAM_AUTHENTICATION_ENABLED;

    /**
     * (experimental) Check whether the Amazon Relational Database Service instances are not publicly accessible.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/rds-instance-public-access-check.html">https://docs.aws.amazon.com/config/latest/developerguide/rds-instance-public-access-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String RDS_INSTANCE_PUBLIC_ACCESS_CHECK;

    /**
     * (experimental) Checks that respective logs of Amazon Relational Database Service (Amazon RDS) are enabled.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/rds-logging-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/rds-logging-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String RDS_LOGGING_ENABLED;

    /**
     * (experimental) Checks whether high availability is enabled for your RDS DB instances.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/rds-multi-az-support.html">https://docs.aws.amazon.com/config/latest/developerguide/rds-multi-az-support.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String RDS_MULTI_AZ_SUPPORT;

    /**
     * (experimental) Checks whether Amazon Relational Database Service (Amazon RDS) DB snapshots are encrypted.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/rds-snapshot-encrypted.html">https://docs.aws.amazon.com/config/latest/developerguide/rds-snapshot-encrypted.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String RDS_SNAPSHOT_ENCRYPTED;

    /**
     * (experimental) Checks if Amazon Relational Database Service (Amazon RDS) snapshots are public.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/rds-snapshots-public-prohibited.html">https://docs.aws.amazon.com/config/latest/developerguide/rds-snapshots-public-prohibited.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String RDS_SNAPSHOTS_PUBLIC_PROHIBITED;

    /**
     * (experimental) Checks whether storage encryption is enabled for your RDS DB instances.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/rds-storage-encrypted.html">https://docs.aws.amazon.com/config/latest/developerguide/rds-storage-encrypted.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String RDS_STORAGE_ENCRYPTED;

    /**
     * (experimental) Checks that Amazon Redshift automated snapshots are enabled for clusters.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/redshift-backup-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/redshift-backup-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String REDSHIFT_BACKUP_ENABLED;

    /**
     * (experimental) Checks whether Amazon Redshift clusters have the specified settings.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/redshift-cluster-configuration-check.html">https://docs.aws.amazon.com/config/latest/developerguide/redshift-cluster-configuration-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String REDSHIFT_CLUSTER_CONFIGURATION_CHECK;

    /**
     * (experimental) Checks whether Amazon Redshift clusters have the specified maintenance settings.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/redshift-cluster-maintenancesettings-check.html">https://docs.aws.amazon.com/config/latest/developerguide/redshift-cluster-maintenancesettings-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String REDSHIFT_CLUSTER_MAINTENANCE_SETTINGS_CHECK;

    /**
     * (experimental) Checks whether Amazon Redshift clusters are not publicly accessible.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/redshift-cluster-public-access-check.html">https://docs.aws.amazon.com/config/latest/developerguide/redshift-cluster-public-access-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String REDSHIFT_CLUSTER_PUBLIC_ACCESS_CHECK;

    /**
     * (experimental) Checks whether Amazon Redshift clusters require TLS/SSL encryption to connect to SQL clients.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/redshift-require-tls-ssl.html">https://docs.aws.amazon.com/config/latest/developerguide/redshift-require-tls-ssl.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String REDSHIFT_REQUIRE_TLS_SSL;

    /**
     * (experimental) Checks whether your resources have the tags that you specify.
     * <p>
     * For example, you can check whether your Amazon EC2 instances have the CostCenter tag.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/required-tags.html">https://docs.aws.amazon.com/config/latest/developerguide/required-tags.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String REQUIRED_TAGS;

    /**
     * (experimental) Checks whether your AWS account is enabled to use multi-factor authentication (MFA) hardware device to sign in with root credentials.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/root-account-hardware-mfa-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/root-account-hardware-mfa-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String ROOT_ACCOUNT_HARDWARE_MFA_ENABLED;

    /**
     * (experimental) Checks whether users of your AWS account require a multi-factor authentication (MFA) device to sign in with root credentials.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/root-account-mfa-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/root-account-mfa-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String ROOT_ACCOUNT_MFA_ENABLED;

    /**
     * (experimental) Checks whether the required public access block settings are configured from account level.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/s3-account-level-public-access-blocks.html">https://docs.aws.amazon.com/config/latest/developerguide/s3-account-level-public-access-blocks.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String S3_ACCOUNT_LEVEL_PUBLIC_ACCESS_BLOCKS;

    /**
     * (experimental) Checks that the Amazon Simple Storage Service bucket policy does not allow blocked bucket-level and object-level actions on resources in the bucket for principals from other AWS accounts.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-blacklisted-actions-prohibited.html">https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-blacklisted-actions-prohibited.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String S3_BUCKET_BLOCKED_ACTIONS_PROHIBITED;

    /**
     * (experimental) Checks whether Amazon Simple Storage Service (Amazon S3) bucket has lock enabled, by default.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-default-lock-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-default-lock-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String S3_BUCKET_DEFAULT_LOCK_ENABLED;

    /**
     * (experimental) Checks if Amazon Simple Storage Service (Amazon S3) buckets are publicly accessible.
     * <p>
     * This rule is
     * NON_COMPLIANT if an Amazon S3 bucket is not listed in the excludedPublicBuckets parameter and bucket level
     * settings are public.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-level-public-access-prohibited.html">https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-level-public-access-prohibited.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String S3_BUCKET_LEVEL_PUBLIC_ACCESS_PROHIBITED;

    /**
     * (experimental) Checks whether logging is enabled for your S3 buckets.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-logging-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-logging-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String S3_BUCKET_LOGGING_ENABLED;

    /**
     * (experimental) Checks that the access granted by the Amazon S3 bucket is restricted by any of the AWS principals, federated users, service principals, IP addresses, or VPCs that you provide.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-policy-grantee-check.html">https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-policy-grantee-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String S3_BUCKET_POLICY_GRANTEE_CHECK;

    /**
     * (experimental) Verifies that your Amazon Simple Storage Service bucket policies do not allow other inter-account permissions than the control Amazon S3 bucket policy provided.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-policy-not-more-permissive.html">https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-policy-not-more-permissive.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String S3_BUCKET_POLICY_NOT_MORE_PERMISSIVE;

    /**
     * (experimental) Checks that your Amazon S3 buckets do not allow public read access.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-public-read-prohibited.html">https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-public-read-prohibited.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String S3_BUCKET_PUBLIC_READ_PROHIBITED;

    /**
     * (experimental) Checks that your Amazon S3 buckets do not allow public write access.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-public-write-prohibited.html">https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-public-write-prohibited.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String S3_BUCKET_PUBLIC_WRITE_PROHIBITED;

    /**
     * (experimental) Checks whether S3 buckets have cross-region replication enabled.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-replication-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-replication-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String S3_BUCKET_REPLICATION_ENABLED;

    /**
     * (experimental) Checks that your Amazon S3 bucket either has Amazon S3 default encryption enabled or that the S3 bucket policy explicitly denies put-object requests without server side encryption that uses AES-256 or AWS Key Management Service.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-server-side-encryption-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-server-side-encryption-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String S3_BUCKET_SERVER_SIDE_ENCRYPTION_ENABLED;

    /**
     * (experimental) Checks whether S3 buckets have policies that require requests to use Secure Socket Layer (SSL).
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-ssl-requests-only.html">https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-ssl-requests-only.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String S3_BUCKET_SSL_REQUESTS_ONLY;

    /**
     * (experimental) Checks whether versioning is enabled for your S3 buckets.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-versioning-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-versioning-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String S3_BUCKET_VERSIONING_ENABLED;

    /**
     * (experimental) Checks whether the Amazon Simple Storage Service (Amazon S3) buckets are encrypted with AWS Key Management Service (AWS KMS).
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/s3-default-encryption-kms.html">https://docs.aws.amazon.com/config/latest/developerguide/s3-default-encryption-kms.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String S3_DEFAULT_ENCRYPTION_KMS;

    /**
     * (experimental) Checks whether AWS Key Management Service (KMS) key is configured for an Amazon SageMaker endpoint configuration.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/sagemaker-endpoint-configuration-kms-key-configured.html">https://docs.aws.amazon.com/config/latest/developerguide/sagemaker-endpoint-configuration-kms-key-configured.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String SAGEMAKER_ENDPOINT_CONFIGURATION_KMS_KEY_CONFIGURED;

    /**
     * (experimental) Check whether an AWS Key Management Service (KMS) key is configured for SageMaker notebook instance.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/sagemaker-notebook-instance-kms-key-configured.html">https://docs.aws.amazon.com/config/latest/developerguide/sagemaker-notebook-instance-kms-key-configured.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String SAGEMAKER_NOTEBOOK_INSTANCE_KMS_KEY_CONFIGURED;

    /**
     * (experimental) Checks whether direct internet access is disabled for an Amazon SageMaker notebook instance.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/sagemaker-notebook-no-direct-internet-access.html">https://docs.aws.amazon.com/config/latest/developerguide/sagemaker-notebook-no-direct-internet-access.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String SAGEMAKER_NOTEBOOK_NO_DIRECT_INTERNET_ACCESS;

    /**
     * (experimental) Checks whether AWS Secrets Manager secret has rotation enabled.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/secretsmanager-rotation-enabled-check.html">https://docs.aws.amazon.com/config/latest/developerguide/secretsmanager-rotation-enabled-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String SECRETSMANAGER_ROTATION_ENABLED_CHECK;

    /**
     * (experimental) Checks whether AWS Secrets Manager secret rotation has rotated successfully as per the rotation schedule.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/secretsmanager-scheduled-rotation-success-check.html">https://docs.aws.amazon.com/config/latest/developerguide/secretsmanager-scheduled-rotation-success-check.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String SECRETSMANAGER_SCHEDULED_ROTATION_SUCCESS_CHECK;

    /**
     * (experimental) Checks that AWS Security Hub is enabled for an AWS account.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/securityhub-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/securityhub-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String SECURITYHUB_ENABLED;

    /**
     * (experimental) Checks whether Service Endpoint for the service provided in rule parameter is created for each Amazon VPC.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/service-vpc-endpoint-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/service-vpc-endpoint-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String SERVICE_VPC_ENDPOINT_ENABLED;

    /**
     * (experimental) Checks whether EBS volumes are attached to EC2 instances.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/shield-advanced-enabled-autorenew.html">https://docs.aws.amazon.com/config/latest/developerguide/shield-advanced-enabled-autorenew.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String SHIELD_ADVANCED_ENABLED_AUTO_RENEW;

    /**
     * (experimental) Verify that DDoS response team (DRT) can access AWS account.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/shield-drt-access.html">https://docs.aws.amazon.com/config/latest/developerguide/shield-drt-access.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String SHIELD_DRT_ACCESS;

    /**
     * (experimental) Checks whether Amazon SNS topic is encrypted with AWS Key Management Service (AWS KMS).
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/sns-encrypted-kms.html">https://docs.aws.amazon.com/config/latest/developerguide/sns-encrypted-kms.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String SNS_ENCRYPTED_KMS;

    /**
     * (experimental) Checks that the default security group of any Amazon Virtual Private Cloud (VPC) does not allow inbound or outbound traffic.
     * <p>
     * The rule returns NOT_APPLICABLE if the security group
     * is not default.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/vpc-default-security-group-closed.html">https://docs.aws.amazon.com/config/latest/developerguide/vpc-default-security-group-closed.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String VPC_DEFAULT_SECURITY_GROUP_CLOSED;

    /**
     * (experimental) Checks whether Amazon Virtual Private Cloud flow logs are found and enabled for Amazon VPC.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/vpc-flow-logs-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/vpc-flow-logs-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String VPC_FLOW_LOGS_ENABLED;

    /**
     * (experimental) Checks whether the security group with 0.0.0.0/0 of any Amazon Virtual Private Cloud (Amazon VPC) allows only specific inbound TCP or UDP traffic.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/vpc-sg-open-only-to-authorized-ports.html">https://docs.aws.amazon.com/config/latest/developerguide/vpc-sg-open-only-to-authorized-ports.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String VPC_SG_OPEN_ONLY_TO_AUTHORIZED_PORTS;

    /**
     * (experimental) Checks that both AWS Virtual Private Network tunnels provided by AWS Site-to-Site VPN are in UP status.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/vpc-vpn-2-tunnels-up.html">https://docs.aws.amazon.com/config/latest/developerguide/vpc-vpn-2-tunnels-up.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String VPC_VPN_2_TUNNELS_UP;

    /**
     * (experimental) Checks if logging is enabled on AWS Web Application Firewall (WAF) classic global web ACLs.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/waf-classic-logging-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/waf-classic-logging-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String WAF_CLASSIC_LOGGING_ENABLED;

    /**
     * (experimental) Checks whether logging is enabled on AWS Web Application Firewall (WAFV2) regional and global web access control list (ACLs).
     * <p>
     * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/wafv2-logging-enabled.html">https://docs.aws.amazon.com/config/latest/developerguide/wafv2-logging-enabled.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String WAFV2_LOGGING_ENABLED;
}
