package software.amazon.awscdk.services.cur;

/**
 * A CloudFormation `AWS::CUR::ReportDefinition`.
 * <p>
 * The definition of AWS Cost and Usage Report. You can specify the report name, time unit, report format, compression format, S3 bucket, additional artifacts, and schema elements in the definition.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cur.*;
 * CfnReportDefinition cfnReportDefinition = CfnReportDefinition.Builder.create(this, "MyCfnReportDefinition")
 *         .compression("compression")
 *         .format("format")
 *         .refreshClosedReports(false)
 *         .reportName("reportName")
 *         .reportVersioning("reportVersioning")
 *         .s3Bucket("s3Bucket")
 *         .s3Prefix("s3Prefix")
 *         .s3Region("s3Region")
 *         .timeUnit("timeUnit")
 *         // the properties below are optional
 *         .additionalArtifacts(List.of("additionalArtifacts"))
 *         .additionalSchemaElements(List.of("additionalSchemaElements"))
 *         .billingViewArn("billingViewArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:58.262Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_cur.CfnReportDefinition")
public class CfnReportDefinition extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnReportDefinition(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnReportDefinition(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cur.CfnReportDefinition.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::CUR::ReportDefinition`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnReportDefinition(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cur.CfnReportDefinitionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The compression format that Amazon Web Services uses for the report.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getCompression() {
        return software.amazon.jsii.Kernel.get(this, "compression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The compression format that Amazon Web Services uses for the report.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCompression(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "compression", java.util.Objects.requireNonNull(value, "compression is required"));
    }

    /**
     * The format that Amazon Web Services saves the report in.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getFormat() {
        return software.amazon.jsii.Kernel.get(this, "format", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The format that Amazon Web Services saves the report in.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFormat(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "format", java.util.Objects.requireNonNull(value, "format is required"));
    }

    /**
     * Whether you want AWS to update your reports after they have been finalized if AWS detects charges related to previous months.
     * <p>
     * These charges can include refunds, credits, or support fees.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getRefreshClosedReports() {
        return software.amazon.jsii.Kernel.get(this, "refreshClosedReports", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Whether you want AWS to update your reports after they have been finalized if AWS detects charges related to previous months.
     * <p>
     * These charges can include refunds, credits, or support fees.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRefreshClosedReports(final @org.jetbrains.annotations.NotNull java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "refreshClosedReports", java.util.Objects.requireNonNull(value, "refreshClosedReports is required"));
    }

    /**
     * Whether you want AWS to update your reports after they have been finalized if AWS detects charges related to previous months.
     * <p>
     * These charges can include refunds, credits, or support fees.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRefreshClosedReports(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "refreshClosedReports", java.util.Objects.requireNonNull(value, "refreshClosedReports is required"));
    }

    /**
     * The name of the report that you want to create.
     * <p>
     * The name must be unique, is case sensitive, and can't include spaces.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getReportName() {
        return software.amazon.jsii.Kernel.get(this, "reportName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the report that you want to create.
     * <p>
     * The name must be unique, is case sensitive, and can't include spaces.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReportName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "reportName", java.util.Objects.requireNonNull(value, "reportName is required"));
    }

    /**
     * Whether you want AWS to overwrite the previous version of each report or to deliver the report in addition to the previous versions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getReportVersioning() {
        return software.amazon.jsii.Kernel.get(this, "reportVersioning", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Whether you want AWS to overwrite the previous version of each report or to deliver the report in addition to the previous versions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReportVersioning(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "reportVersioning", java.util.Objects.requireNonNull(value, "reportVersioning is required"));
    }

    /**
     * The S3 bucket where Amazon Web Services delivers the report.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getS3Bucket() {
        return software.amazon.jsii.Kernel.get(this, "s3Bucket", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The S3 bucket where Amazon Web Services delivers the report.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setS3Bucket(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "s3Bucket", java.util.Objects.requireNonNull(value, "s3Bucket is required"));
    }

    /**
     * The prefix that Amazon Web Services adds to the report name when Amazon Web Services delivers the report.
     * <p>
     * Your prefix can't include spaces.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getS3Prefix() {
        return software.amazon.jsii.Kernel.get(this, "s3Prefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The prefix that Amazon Web Services adds to the report name when Amazon Web Services delivers the report.
     * <p>
     * Your prefix can't include spaces.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setS3Prefix(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "s3Prefix", java.util.Objects.requireNonNull(value, "s3Prefix is required"));
    }

    /**
     * The Region of the S3 bucket that Amazon Web Services delivers the report into.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getS3Region() {
        return software.amazon.jsii.Kernel.get(this, "s3Region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Region of the S3 bucket that Amazon Web Services delivers the report into.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setS3Region(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "s3Region", java.util.Objects.requireNonNull(value, "s3Region is required"));
    }

    /**
     * The granularity of the line items in the report.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getTimeUnit() {
        return software.amazon.jsii.Kernel.get(this, "timeUnit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The granularity of the line items in the report.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTimeUnit(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "timeUnit", java.util.Objects.requireNonNull(value, "timeUnit is required"));
    }

    /**
     * A list of manifests that you want AWS to create for this report.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAdditionalArtifacts() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "additionalArtifacts", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A list of manifests that you want AWS to create for this report.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAdditionalArtifacts(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "additionalArtifacts", value);
    }

    /**
     * A list of strings that indicate additional content that AWS includes in the report, such as individual resource IDs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAdditionalSchemaElements() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "additionalSchemaElements", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A list of strings that indicate additional content that AWS includes in the report, such as individual resource IDs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAdditionalSchemaElements(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "additionalSchemaElements", value);
    }

    /**
     * The Amazon Resource Name (ARN) of the billing view.
     * <p>
     * You can get this value by using the billing view service public APIs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getBillingViewArn() {
        return software.amazon.jsii.Kernel.get(this, "billingViewArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the billing view.
     * <p>
     * You can get this value by using the billing view service public APIs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBillingViewArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "billingViewArn", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cur.CfnReportDefinition}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cur.CfnReportDefinition> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.cur.CfnReportDefinitionProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.cur.CfnReportDefinitionProps.Builder();
        }

        /**
         * The compression format that Amazon Web Services uses for the report.
         * <p>
         * @return {@code this}
         * @param compression The compression format that Amazon Web Services uses for the report. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder compression(final java.lang.String compression) {
            this.props.compression(compression);
            return this;
        }

        /**
         * The format that Amazon Web Services saves the report in.
         * <p>
         * @return {@code this}
         * @param format The format that Amazon Web Services saves the report in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder format(final java.lang.String format) {
            this.props.format(format);
            return this;
        }

        /**
         * Whether you want AWS to update your reports after they have been finalized if AWS detects charges related to previous months.
         * <p>
         * These charges can include refunds, credits, or support fees.
         * <p>
         * @return {@code this}
         * @param refreshClosedReports Whether you want AWS to update your reports after they have been finalized if AWS detects charges related to previous months. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder refreshClosedReports(final java.lang.Boolean refreshClosedReports) {
            this.props.refreshClosedReports(refreshClosedReports);
            return this;
        }
        /**
         * Whether you want AWS to update your reports after they have been finalized if AWS detects charges related to previous months.
         * <p>
         * These charges can include refunds, credits, or support fees.
         * <p>
         * @return {@code this}
         * @param refreshClosedReports Whether you want AWS to update your reports after they have been finalized if AWS detects charges related to previous months. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder refreshClosedReports(final software.amazon.awscdk.core.IResolvable refreshClosedReports) {
            this.props.refreshClosedReports(refreshClosedReports);
            return this;
        }

        /**
         * The name of the report that you want to create.
         * <p>
         * The name must be unique, is case sensitive, and can't include spaces.
         * <p>
         * @return {@code this}
         * @param reportName The name of the report that you want to create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reportName(final java.lang.String reportName) {
            this.props.reportName(reportName);
            return this;
        }

        /**
         * Whether you want AWS to overwrite the previous version of each report or to deliver the report in addition to the previous versions.
         * <p>
         * @return {@code this}
         * @param reportVersioning Whether you want AWS to overwrite the previous version of each report or to deliver the report in addition to the previous versions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reportVersioning(final java.lang.String reportVersioning) {
            this.props.reportVersioning(reportVersioning);
            return this;
        }

        /**
         * The S3 bucket where Amazon Web Services delivers the report.
         * <p>
         * @return {@code this}
         * @param s3Bucket The S3 bucket where Amazon Web Services delivers the report. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3Bucket(final java.lang.String s3Bucket) {
            this.props.s3Bucket(s3Bucket);
            return this;
        }

        /**
         * The prefix that Amazon Web Services adds to the report name when Amazon Web Services delivers the report.
         * <p>
         * Your prefix can't include spaces.
         * <p>
         * @return {@code this}
         * @param s3Prefix The prefix that Amazon Web Services adds to the report name when Amazon Web Services delivers the report. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3Prefix(final java.lang.String s3Prefix) {
            this.props.s3Prefix(s3Prefix);
            return this;
        }

        /**
         * The Region of the S3 bucket that Amazon Web Services delivers the report into.
         * <p>
         * @return {@code this}
         * @param s3Region The Region of the S3 bucket that Amazon Web Services delivers the report into. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3Region(final java.lang.String s3Region) {
            this.props.s3Region(s3Region);
            return this;
        }

        /**
         * The granularity of the line items in the report.
         * <p>
         * @return {@code this}
         * @param timeUnit The granularity of the line items in the report. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeUnit(final java.lang.String timeUnit) {
            this.props.timeUnit(timeUnit);
            return this;
        }

        /**
         * A list of manifests that you want AWS to create for this report.
         * <p>
         * @return {@code this}
         * @param additionalArtifacts A list of manifests that you want AWS to create for this report. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder additionalArtifacts(final java.util.List<java.lang.String> additionalArtifacts) {
            this.props.additionalArtifacts(additionalArtifacts);
            return this;
        }

        /**
         * A list of strings that indicate additional content that AWS includes in the report, such as individual resource IDs.
         * <p>
         * @return {@code this}
         * @param additionalSchemaElements A list of strings that indicate additional content that AWS includes in the report, such as individual resource IDs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder additionalSchemaElements(final java.util.List<java.lang.String> additionalSchemaElements) {
            this.props.additionalSchemaElements(additionalSchemaElements);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the billing view.
         * <p>
         * You can get this value by using the billing view service public APIs.
         * <p>
         * @return {@code this}
         * @param billingViewArn The Amazon Resource Name (ARN) of the billing view. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder billingViewArn(final java.lang.String billingViewArn) {
            this.props.billingViewArn(billingViewArn);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.cur.CfnReportDefinition}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cur.CfnReportDefinition build() {
            return new software.amazon.awscdk.services.cur.CfnReportDefinition(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
