package software.amazon.awscdk.services.datasync;

/**
 * Properties for defining a `CfnLocationFSxWindows`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.datasync.*;
 * CfnLocationFSxWindowsProps cfnLocationFSxWindowsProps = CfnLocationFSxWindowsProps.builder()
 *         .fsxFilesystemArn("fsxFilesystemArn")
 *         .password("password")
 *         .securityGroupArns(List.of("securityGroupArns"))
 *         .user("user")
 *         // the properties below are optional
 *         .domain("domain")
 *         .subdirectory("subdirectory")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:58.478Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_datasync.CfnLocationFSxWindowsProps")
@software.amazon.jsii.Jsii.Proxy(CfnLocationFSxWindowsProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnLocationFSxWindowsProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specifies the Amazon Resource Name (ARN) for the FSx for Windows File Server file system.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFsxFilesystemArn();

    /**
     * Specifies the password of the user who has the permissions to access files and folders in the file system.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPassword();

    /**
     * The Amazon Resource Names (ARNs) of the security groups that are used to configure the FSx for Windows File Server file system.
     * <p>
     * <em>Pattern</em> : <code>^arn:(aws|aws-cn|aws-us-gov|aws-iso|aws-iso-b):ec2:[a-z\-0-9]*:[0-9]{12}:security-group/.*$</code>
     * <p>
     * <em>Length constraints</em> : Maximum length of 128.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSecurityGroupArns();

    /**
     * The user who has the permissions to access files and folders in the FSx for Windows File Server file system.
     * <p>
     * For information about choosing a user name that ensures sufficient permissions to files, folders, and metadata, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-fsx-location.html#FSxWuser">user</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getUser();

    /**
     * Specifies the name of the Windows domain that the FSx for Windows File Server belongs to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDomain() {
        return null;
    }

    /**
     * Specifies a mount path for your file system using forward slashes.
     * <p>
     * This is where DataSync reads or writes data (depending on if this is a source or destination location).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSubdirectory() {
        return null;
    }

    /**
     * Specifies labels that help you categorize, filter, and search for your AWS resources.
     * <p>
     * We recommend creating at least a name tag for your location.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnLocationFSxWindowsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnLocationFSxWindowsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnLocationFSxWindowsProps> {
        java.lang.String fsxFilesystemArn;
        java.lang.String password;
        java.util.List<java.lang.String> securityGroupArns;
        java.lang.String user;
        java.lang.String domain;
        java.lang.String subdirectory;
        java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Sets the value of {@link CfnLocationFSxWindowsProps#getFsxFilesystemArn}
         * @param fsxFilesystemArn Specifies the Amazon Resource Name (ARN) for the FSx for Windows File Server file system. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fsxFilesystemArn(java.lang.String fsxFilesystemArn) {
            this.fsxFilesystemArn = fsxFilesystemArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocationFSxWindowsProps#getPassword}
         * @param password Specifies the password of the user who has the permissions to access files and folders in the file system. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder password(java.lang.String password) {
            this.password = password;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocationFSxWindowsProps#getSecurityGroupArns}
         * @param securityGroupArns The Amazon Resource Names (ARNs) of the security groups that are used to configure the FSx for Windows File Server file system. This parameter is required.
         *                          <em>Pattern</em> : <code>^arn:(aws|aws-cn|aws-us-gov|aws-iso|aws-iso-b):ec2:[a-z\-0-9]*:[0-9]{12}:security-group/.*$</code>
         *                          <p>
         *                          <em>Length constraints</em> : Maximum length of 128.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroupArns(java.util.List<java.lang.String> securityGroupArns) {
            this.securityGroupArns = securityGroupArns;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocationFSxWindowsProps#getUser}
         * @param user The user who has the permissions to access files and folders in the FSx for Windows File Server file system. This parameter is required.
         *             For information about choosing a user name that ensures sufficient permissions to files, folders, and metadata, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-fsx-location.html#FSxWuser">user</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder user(java.lang.String user) {
            this.user = user;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocationFSxWindowsProps#getDomain}
         * @param domain Specifies the name of the Windows domain that the FSx for Windows File Server belongs to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domain(java.lang.String domain) {
            this.domain = domain;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocationFSxWindowsProps#getSubdirectory}
         * @param subdirectory Specifies a mount path for your file system using forward slashes.
         *                     This is where DataSync reads or writes data (depending on if this is a source or destination location).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subdirectory(java.lang.String subdirectory) {
            this.subdirectory = subdirectory;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocationFSxWindowsProps#getTags}
         * @param tags Specifies labels that help you categorize, filter, and search for your AWS resources.
         *             We recommend creating at least a name tag for your location.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnLocationFSxWindowsProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnLocationFSxWindowsProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnLocationFSxWindowsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnLocationFSxWindowsProps {
        private final java.lang.String fsxFilesystemArn;
        private final java.lang.String password;
        private final java.util.List<java.lang.String> securityGroupArns;
        private final java.lang.String user;
        private final java.lang.String domain;
        private final java.lang.String subdirectory;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.fsxFilesystemArn = software.amazon.jsii.Kernel.get(this, "fsxFilesystemArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.password = software.amazon.jsii.Kernel.get(this, "password", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.securityGroupArns = software.amazon.jsii.Kernel.get(this, "securityGroupArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.user = software.amazon.jsii.Kernel.get(this, "user", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.domain = software.amazon.jsii.Kernel.get(this, "domain", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.subdirectory = software.amazon.jsii.Kernel.get(this, "subdirectory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.fsxFilesystemArn = java.util.Objects.requireNonNull(builder.fsxFilesystemArn, "fsxFilesystemArn is required");
            this.password = java.util.Objects.requireNonNull(builder.password, "password is required");
            this.securityGroupArns = java.util.Objects.requireNonNull(builder.securityGroupArns, "securityGroupArns is required");
            this.user = java.util.Objects.requireNonNull(builder.user, "user is required");
            this.domain = builder.domain;
            this.subdirectory = builder.subdirectory;
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getFsxFilesystemArn() {
            return this.fsxFilesystemArn;
        }

        @Override
        public final java.lang.String getPassword() {
            return this.password;
        }

        @Override
        public final java.util.List<java.lang.String> getSecurityGroupArns() {
            return this.securityGroupArns;
        }

        @Override
        public final java.lang.String getUser() {
            return this.user;
        }

        @Override
        public final java.lang.String getDomain() {
            return this.domain;
        }

        @Override
        public final java.lang.String getSubdirectory() {
            return this.subdirectory;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("fsxFilesystemArn", om.valueToTree(this.getFsxFilesystemArn()));
            data.set("password", om.valueToTree(this.getPassword()));
            data.set("securityGroupArns", om.valueToTree(this.getSecurityGroupArns()));
            data.set("user", om.valueToTree(this.getUser()));
            if (this.getDomain() != null) {
                data.set("domain", om.valueToTree(this.getDomain()));
            }
            if (this.getSubdirectory() != null) {
                data.set("subdirectory", om.valueToTree(this.getSubdirectory()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_datasync.CfnLocationFSxWindowsProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnLocationFSxWindowsProps.Jsii$Proxy that = (CfnLocationFSxWindowsProps.Jsii$Proxy) o;

            if (!fsxFilesystemArn.equals(that.fsxFilesystemArn)) return false;
            if (!password.equals(that.password)) return false;
            if (!securityGroupArns.equals(that.securityGroupArns)) return false;
            if (!user.equals(that.user)) return false;
            if (this.domain != null ? !this.domain.equals(that.domain) : that.domain != null) return false;
            if (this.subdirectory != null ? !this.subdirectory.equals(that.subdirectory) : that.subdirectory != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.fsxFilesystemArn.hashCode();
            result = 31 * result + (this.password.hashCode());
            result = 31 * result + (this.securityGroupArns.hashCode());
            result = 31 * result + (this.user.hashCode());
            result = 31 * result + (this.domain != null ? this.domain.hashCode() : 0);
            result = 31 * result + (this.subdirectory != null ? this.subdirectory.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
