package software.amazon.awscdk.services.datasync;

/**
 * Properties for defining a `CfnLocationS3`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.datasync.*;
 * CfnLocationS3Props cfnLocationS3Props = CfnLocationS3Props.builder()
 *         .s3BucketArn("s3BucketArn")
 *         .s3Config(S3ConfigProperty.builder()
 *                 .bucketAccessRoleArn("bucketAccessRoleArn")
 *                 .build())
 *         // the properties below are optional
 *         .s3StorageClass("s3StorageClass")
 *         .subdirectory("subdirectory")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:58.498Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_datasync.CfnLocationS3Props")
@software.amazon.jsii.Jsii.Proxy(CfnLocationS3Props.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnLocationS3Props extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the Amazon S3 bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getS3BucketArn();

    /**
     * The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that is used to access an Amazon S3 bucket.
     * <p>
     * For detailed information about using such a role, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/working-with-locations.html#create-s3-location">Creating a Location for Amazon S3</a> in the <em>AWS DataSync User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getS3Config();

    /**
     * The Amazon S3 storage class that you want to store your files in when this location is used as a task destination.
     * <p>
     * For buckets in AWS Regions , the storage class defaults to S3 Standard.
     * <p>
     * For more information about S3 storage classes, see <a href="https://docs.aws.amazon.com/s3/storage-classes/">Amazon S3 Storage Classes</a> . Some storage classes have behaviors that can affect your S3 storage costs. For detailed information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes">Considerations When Working with Amazon S3 Storage Classes in DataSync</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getS3StorageClass() {
        return null;
    }

    /**
     * A subdirectory in the Amazon S3 bucket.
     * <p>
     * This subdirectory in Amazon S3 is used to read data from the S3 source location or write data to the S3 destination.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSubdirectory() {
        return null;
    }

    /**
     * The key-value pair that represents the tag that you want to add to the location.
     * <p>
     * The value can be an empty string. We recommend using tags to name your resources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnLocationS3Props}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnLocationS3Props}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnLocationS3Props> {
        java.lang.String s3BucketArn;
        java.lang.Object s3Config;
        java.lang.String s3StorageClass;
        java.lang.String subdirectory;
        java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Sets the value of {@link CfnLocationS3Props#getS3BucketArn}
         * @param s3BucketArn The ARN of the Amazon S3 bucket. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3BucketArn(java.lang.String s3BucketArn) {
            this.s3BucketArn = s3BucketArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocationS3Props#getS3Config}
         * @param s3Config The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that is used to access an Amazon S3 bucket. This parameter is required.
         *                 For detailed information about using such a role, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/working-with-locations.html#create-s3-location">Creating a Location for Amazon S3</a> in the <em>AWS DataSync User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3Config(software.amazon.awscdk.services.datasync.CfnLocationS3.S3ConfigProperty s3Config) {
            this.s3Config = s3Config;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocationS3Props#getS3Config}
         * @param s3Config The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that is used to access an Amazon S3 bucket. This parameter is required.
         *                 For detailed information about using such a role, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/working-with-locations.html#create-s3-location">Creating a Location for Amazon S3</a> in the <em>AWS DataSync User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3Config(software.amazon.awscdk.core.IResolvable s3Config) {
            this.s3Config = s3Config;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocationS3Props#getS3StorageClass}
         * @param s3StorageClass The Amazon S3 storage class that you want to store your files in when this location is used as a task destination.
         *                       For buckets in AWS Regions , the storage class defaults to S3 Standard.
         *                       <p>
         *                       For more information about S3 storage classes, see <a href="https://docs.aws.amazon.com/s3/storage-classes/">Amazon S3 Storage Classes</a> . Some storage classes have behaviors that can affect your S3 storage costs. For detailed information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes">Considerations When Working with Amazon S3 Storage Classes in DataSync</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3StorageClass(java.lang.String s3StorageClass) {
            this.s3StorageClass = s3StorageClass;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocationS3Props#getSubdirectory}
         * @param subdirectory A subdirectory in the Amazon S3 bucket.
         *                     This subdirectory in Amazon S3 is used to read data from the S3 source location or write data to the S3 destination.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subdirectory(java.lang.String subdirectory) {
            this.subdirectory = subdirectory;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocationS3Props#getTags}
         * @param tags The key-value pair that represents the tag that you want to add to the location.
         *             The value can be an empty string. We recommend using tags to name your resources.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnLocationS3Props}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnLocationS3Props build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnLocationS3Props}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnLocationS3Props {
        private final java.lang.String s3BucketArn;
        private final java.lang.Object s3Config;
        private final java.lang.String s3StorageClass;
        private final java.lang.String subdirectory;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.s3BucketArn = software.amazon.jsii.Kernel.get(this, "s3BucketArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.s3Config = software.amazon.jsii.Kernel.get(this, "s3Config", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.s3StorageClass = software.amazon.jsii.Kernel.get(this, "s3StorageClass", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.subdirectory = software.amazon.jsii.Kernel.get(this, "subdirectory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.s3BucketArn = java.util.Objects.requireNonNull(builder.s3BucketArn, "s3BucketArn is required");
            this.s3Config = java.util.Objects.requireNonNull(builder.s3Config, "s3Config is required");
            this.s3StorageClass = builder.s3StorageClass;
            this.subdirectory = builder.subdirectory;
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getS3BucketArn() {
            return this.s3BucketArn;
        }

        @Override
        public final java.lang.Object getS3Config() {
            return this.s3Config;
        }

        @Override
        public final java.lang.String getS3StorageClass() {
            return this.s3StorageClass;
        }

        @Override
        public final java.lang.String getSubdirectory() {
            return this.subdirectory;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("s3BucketArn", om.valueToTree(this.getS3BucketArn()));
            data.set("s3Config", om.valueToTree(this.getS3Config()));
            if (this.getS3StorageClass() != null) {
                data.set("s3StorageClass", om.valueToTree(this.getS3StorageClass()));
            }
            if (this.getSubdirectory() != null) {
                data.set("subdirectory", om.valueToTree(this.getSubdirectory()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_datasync.CfnLocationS3Props"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnLocationS3Props.Jsii$Proxy that = (CfnLocationS3Props.Jsii$Proxy) o;

            if (!s3BucketArn.equals(that.s3BucketArn)) return false;
            if (!s3Config.equals(that.s3Config)) return false;
            if (this.s3StorageClass != null ? !this.s3StorageClass.equals(that.s3StorageClass) : that.s3StorageClass != null) return false;
            if (this.subdirectory != null ? !this.subdirectory.equals(that.subdirectory) : that.subdirectory != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.s3BucketArn.hashCode();
            result = 31 * result + (this.s3Config.hashCode());
            result = 31 * result + (this.s3StorageClass != null ? this.s3StorageClass.hashCode() : 0);
            result = 31 * result + (this.subdirectory != null ? this.subdirectory.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
