package software.amazon.awscdk.services.docdbelastic;

/**
 * Properties for defining a `CfnCluster`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.docdbelastic.*;
 * CfnClusterProps cfnClusterProps = CfnClusterProps.builder()
 *         .adminUserName("adminUserName")
 *         .authType("authType")
 *         .clusterName("clusterName")
 *         .shardCapacity(123)
 *         .shardCount(123)
 *         // the properties below are optional
 *         .adminUserPassword("adminUserPassword")
 *         .kmsKeyId("kmsKeyId")
 *         .preferredMaintenanceWindow("preferredMaintenanceWindow")
 *         .subnetIds(List.of("subnetIds"))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .vpcSecurityGroupIds(List.of("vpcSecurityGroupIds"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:58.778Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_docdbelastic.CfnClusterProps")
@software.amazon.jsii.Jsii.Proxy(CfnClusterProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnClusterProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the Elastic DocumentDB cluster administrator.
     * <p>
     * <em>Constraints</em> :
     * <p>
     * <ul>
     * <li>Must be from 1 to 63 letters or numbers.</li>
     * <li>The first character must be a letter.</li>
     * <li>Cannot be a reserved word.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAdminUserName();

    /**
     * The authentication type for the Elastic DocumentDB cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAuthType();

    /**
     * The name of the new Elastic DocumentDB cluster. This parameter is stored as a lowercase string.
     * <p>
     * <em>Constraints</em> :
     * <p>
     * <ul>
     * <li>Must contain from 1 to 63 letters, numbers, or hyphens.</li>
     * <li>The first character must be a letter.</li>
     * <li>Cannot end with a hyphen or contain two consecutive hyphens.</li>
     * </ul>
     * <p>
     * <em>Example</em> : <code>my-cluster</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getClusterName();

    /**
     * The capacity of each shard in the new Elastic DocumentDB cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getShardCapacity();

    /**
     * The number of shards to create in the new Elastic DocumentDB cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getShardCount();

    /**
     * The password for the Elastic DocumentDB cluster administrator and can contain any printable ASCII characters.
     * <p>
     * <em>Constraints</em> :
     * <p>
     * <ul>
     * <li>Must contain from 8 to 100 characters.</li>
     * <li>Cannot contain a forward slash (/), double quote ("), or the "at" symbol (&#64;).</li>
     * <li>A valid <code>AdminUserName</code> entry is also required.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAdminUserPassword() {
        return null;
    }

    /**
     * The KMS key identifier to use to encrypt the new Elastic DocumentDB cluster.
     * <p>
     * The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are creating a cluster using the same Amazon account that owns this KMS encryption key, you can use the KMS key alias instead of the ARN as the KMS encryption key.
     * <p>
     * If an encryption key is not specified, Elastic DocumentDB uses the default encryption key that KMS creates for your account. Your account has a different default encryption key for each Amazon Region.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return null;
    }

    /**
     * The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
     * <p>
     * <em>Format</em> : <code>ddd:hh24:mi-ddd:hh24:mi</code>
     * <p>
     * <em>Default</em> : a 30-minute window selected at random from an 8-hour block of time for each AWS Region , occurring on a random day of the week.
     * <p>
     * <em>Valid days</em> : Mon, Tue, Wed, Thu, Fri, Sat, Sun
     * <p>
     * <em>Constraints</em> : Minimum 30-minute window.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPreferredMaintenanceWindow() {
        return null;
    }

    /**
     * The Amazon EC2 subnet IDs for the new Elastic DocumentDB cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSubnetIds() {
        return null;
    }

    /**
     * The tags to be assigned to the new Elastic DocumentDB cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
        return null;
    }

    /**
     * A list of EC2 VPC security groups to associate with the new Elastic DocumentDB cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getVpcSecurityGroupIds() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnClusterProps> {
        java.lang.String adminUserName;
        java.lang.String authType;
        java.lang.String clusterName;
        java.lang.Number shardCapacity;
        java.lang.Number shardCount;
        java.lang.String adminUserPassword;
        java.lang.String kmsKeyId;
        java.lang.String preferredMaintenanceWindow;
        java.util.List<java.lang.String> subnetIds;
        java.util.List<software.amazon.awscdk.core.CfnTag> tags;
        java.util.List<java.lang.String> vpcSecurityGroupIds;

        /**
         * Sets the value of {@link CfnClusterProps#getAdminUserName}
         * @param adminUserName The name of the Elastic DocumentDB cluster administrator. This parameter is required.
         *                      <em>Constraints</em> :
         *                      <p>
         *                      <ul>
         *                      <li>Must be from 1 to 63 letters or numbers.</li>
         *                      <li>The first character must be a letter.</li>
         *                      <li>Cannot be a reserved word.</li>
         *                      </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder adminUserName(java.lang.String adminUserName) {
            this.adminUserName = adminUserName;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getAuthType}
         * @param authType The authentication type for the Elastic DocumentDB cluster. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authType(java.lang.String authType) {
            this.authType = authType;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getClusterName}
         * @param clusterName The name of the new Elastic DocumentDB cluster. This parameter is stored as a lowercase string. This parameter is required.
         *                    <em>Constraints</em> :
         *                    <p>
         *                    <ul>
         *                    <li>Must contain from 1 to 63 letters, numbers, or hyphens.</li>
         *                    <li>The first character must be a letter.</li>
         *                    <li>Cannot end with a hyphen or contain two consecutive hyphens.</li>
         *                    </ul>
         *                    <p>
         *                    <em>Example</em> : <code>my-cluster</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterName(java.lang.String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getShardCapacity}
         * @param shardCapacity The capacity of each shard in the new Elastic DocumentDB cluster. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder shardCapacity(java.lang.Number shardCapacity) {
            this.shardCapacity = shardCapacity;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getShardCount}
         * @param shardCount The number of shards to create in the new Elastic DocumentDB cluster. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder shardCount(java.lang.Number shardCount) {
            this.shardCount = shardCount;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getAdminUserPassword}
         * @param adminUserPassword The password for the Elastic DocumentDB cluster administrator and can contain any printable ASCII characters.
         *                          <em>Constraints</em> :
         *                          <p>
         *                          <ul>
         *                          <li>Must contain from 8 to 100 characters.</li>
         *                          <li>Cannot contain a forward slash (/), double quote ("), or the "at" symbol (&#64;).</li>
         *                          <li>A valid <code>AdminUserName</code> entry is also required.</li>
         *                          </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder adminUserPassword(java.lang.String adminUserPassword) {
            this.adminUserPassword = adminUserPassword;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getKmsKeyId}
         * @param kmsKeyId The KMS key identifier to use to encrypt the new Elastic DocumentDB cluster.
         *                 The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are creating a cluster using the same Amazon account that owns this KMS encryption key, you can use the KMS key alias instead of the ARN as the KMS encryption key.
         *                 <p>
         *                 If an encryption key is not specified, Elastic DocumentDB uses the default encryption key that KMS creates for your account. Your account has a different default encryption key for each Amazon Region.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(java.lang.String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getPreferredMaintenanceWindow}
         * @param preferredMaintenanceWindow The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
         *                                   <em>Format</em> : <code>ddd:hh24:mi-ddd:hh24:mi</code>
         *                                   <p>
         *                                   <em>Default</em> : a 30-minute window selected at random from an 8-hour block of time for each AWS Region , occurring on a random day of the week.
         *                                   <p>
         *                                   <em>Valid days</em> : Mon, Tue, Wed, Thu, Fri, Sat, Sun
         *                                   <p>
         *                                   <em>Constraints</em> : Minimum 30-minute window.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preferredMaintenanceWindow(java.lang.String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getSubnetIds}
         * @param subnetIds The Amazon EC2 subnet IDs for the new Elastic DocumentDB cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetIds(java.util.List<java.lang.String> subnetIds) {
            this.subnetIds = subnetIds;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getTags}
         * @param tags The tags to be assigned to the new Elastic DocumentDB cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getVpcSecurityGroupIds}
         * @param vpcSecurityGroupIds A list of EC2 VPC security groups to associate with the new Elastic DocumentDB cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSecurityGroupIds(java.util.List<java.lang.String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = vpcSecurityGroupIds;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnClusterProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnClusterProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnClusterProps {
        private final java.lang.String adminUserName;
        private final java.lang.String authType;
        private final java.lang.String clusterName;
        private final java.lang.Number shardCapacity;
        private final java.lang.Number shardCount;
        private final java.lang.String adminUserPassword;
        private final java.lang.String kmsKeyId;
        private final java.lang.String preferredMaintenanceWindow;
        private final java.util.List<java.lang.String> subnetIds;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;
        private final java.util.List<java.lang.String> vpcSecurityGroupIds;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.adminUserName = software.amazon.jsii.Kernel.get(this, "adminUserName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.authType = software.amazon.jsii.Kernel.get(this, "authType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.clusterName = software.amazon.jsii.Kernel.get(this, "clusterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.shardCapacity = software.amazon.jsii.Kernel.get(this, "shardCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.shardCount = software.amazon.jsii.Kernel.get(this, "shardCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.adminUserPassword = software.amazon.jsii.Kernel.get(this, "adminUserPassword", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.preferredMaintenanceWindow = software.amazon.jsii.Kernel.get(this, "preferredMaintenanceWindow", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.subnetIds = software.amazon.jsii.Kernel.get(this, "subnetIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
            this.vpcSecurityGroupIds = software.amazon.jsii.Kernel.get(this, "vpcSecurityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.adminUserName = java.util.Objects.requireNonNull(builder.adminUserName, "adminUserName is required");
            this.authType = java.util.Objects.requireNonNull(builder.authType, "authType is required");
            this.clusterName = java.util.Objects.requireNonNull(builder.clusterName, "clusterName is required");
            this.shardCapacity = java.util.Objects.requireNonNull(builder.shardCapacity, "shardCapacity is required");
            this.shardCount = java.util.Objects.requireNonNull(builder.shardCount, "shardCount is required");
            this.adminUserPassword = builder.adminUserPassword;
            this.kmsKeyId = builder.kmsKeyId;
            this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
            this.subnetIds = builder.subnetIds;
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)builder.tags;
            this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
        }

        @Override
        public final java.lang.String getAdminUserName() {
            return this.adminUserName;
        }

        @Override
        public final java.lang.String getAuthType() {
            return this.authType;
        }

        @Override
        public final java.lang.String getClusterName() {
            return this.clusterName;
        }

        @Override
        public final java.lang.Number getShardCapacity() {
            return this.shardCapacity;
        }

        @Override
        public final java.lang.Number getShardCount() {
            return this.shardCount;
        }

        @Override
        public final java.lang.String getAdminUserPassword() {
            return this.adminUserPassword;
        }

        @Override
        public final java.lang.String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final java.lang.String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        @Override
        public final java.util.List<java.lang.String> getSubnetIds() {
            return this.subnetIds;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.util.List<java.lang.String> getVpcSecurityGroupIds() {
            return this.vpcSecurityGroupIds;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("adminUserName", om.valueToTree(this.getAdminUserName()));
            data.set("authType", om.valueToTree(this.getAuthType()));
            data.set("clusterName", om.valueToTree(this.getClusterName()));
            data.set("shardCapacity", om.valueToTree(this.getShardCapacity()));
            data.set("shardCount", om.valueToTree(this.getShardCount()));
            if (this.getAdminUserPassword() != null) {
                data.set("adminUserPassword", om.valueToTree(this.getAdminUserPassword()));
            }
            if (this.getKmsKeyId() != null) {
                data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
            }
            if (this.getPreferredMaintenanceWindow() != null) {
                data.set("preferredMaintenanceWindow", om.valueToTree(this.getPreferredMaintenanceWindow()));
            }
            if (this.getSubnetIds() != null) {
                data.set("subnetIds", om.valueToTree(this.getSubnetIds()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getVpcSecurityGroupIds() != null) {
                data.set("vpcSecurityGroupIds", om.valueToTree(this.getVpcSecurityGroupIds()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_docdbelastic.CfnClusterProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnClusterProps.Jsii$Proxy that = (CfnClusterProps.Jsii$Proxy) o;

            if (!adminUserName.equals(that.adminUserName)) return false;
            if (!authType.equals(that.authType)) return false;
            if (!clusterName.equals(that.clusterName)) return false;
            if (!shardCapacity.equals(that.shardCapacity)) return false;
            if (!shardCount.equals(that.shardCount)) return false;
            if (this.adminUserPassword != null ? !this.adminUserPassword.equals(that.adminUserPassword) : that.adminUserPassword != null) return false;
            if (this.kmsKeyId != null ? !this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId != null) return false;
            if (this.preferredMaintenanceWindow != null ? !this.preferredMaintenanceWindow.equals(that.preferredMaintenanceWindow) : that.preferredMaintenanceWindow != null) return false;
            if (this.subnetIds != null ? !this.subnetIds.equals(that.subnetIds) : that.subnetIds != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.vpcSecurityGroupIds != null ? this.vpcSecurityGroupIds.equals(that.vpcSecurityGroupIds) : that.vpcSecurityGroupIds == null;
        }

        @Override
        public final int hashCode() {
            int result = this.adminUserName.hashCode();
            result = 31 * result + (this.authType.hashCode());
            result = 31 * result + (this.clusterName.hashCode());
            result = 31 * result + (this.shardCapacity.hashCode());
            result = 31 * result + (this.shardCount.hashCode());
            result = 31 * result + (this.adminUserPassword != null ? this.adminUserPassword.hashCode() : 0);
            result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
            result = 31 * result + (this.preferredMaintenanceWindow != null ? this.preferredMaintenanceWindow.hashCode() : 0);
            result = 31 * result + (this.subnetIds != null ? this.subnetIds.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.vpcSecurityGroupIds != null ? this.vpcSecurityGroupIds.hashCode() : 0);
            return result;
        }
    }
}
