package software.amazon.awscdk.services.dynamodb;

/**
 * (experimental) Data types for attributes within a table.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Table globalTable = Table.Builder.create(this, "Table")
 *         .partitionKey(Attribute.builder().name("id").type(AttributeType.STRING).build())
 *         .replicationRegions(List.of("us-east-1", "us-east-2", "us-west-2"))
 *         .billingMode(BillingMode.PROVISIONED)
 *         .build();
 * globalTable.autoScaleWriteCapacity(EnableScalingProps.builder()
 *         .minCapacity(1)
 *         .maxCapacity(10)
 *         .build()).scaleOnUtilization(UtilizationScalingProps.builder().targetUtilizationPercent(75).build());
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes">https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:58.805Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_dynamodb.AttributeType")
public enum AttributeType {
    /**
     * (experimental) Up to 400KiB of binary data (which must be encoded as base64 before sending to DynamoDB).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    BINARY,
    /**
     * (experimental) Numeric values made of up to 38 digits (positive, negative or zero).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    NUMBER,
    /**
     * (experimental) Up to 400KiB of UTF-8 encoded text.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    STRING,
}
