package software.amazon.awscdk.services.ec2;

/**
 * (experimental) Selects the latest version of Amazon Linux.
 * <p>
 * This Machine Image automatically updates to the latest version on every
 * deployment. Be aware this will cause your instances to be replaced when a
 * new version of the image becomes available. Do not store stateful information
 * on the instance if you are using this image.
 * <p>
 * The AMI ID is selected using the values published to the SSM parameter store.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Pick a Windows edition to use
 * WindowsImage windows = new WindowsImage(WindowsVersion.WINDOWS_SERVER_2019_ENGLISH_FULL_BASE);
 * // Pick the right Amazon Linux edition. All arguments shown are optional
 * // and will default to these values when omitted.
 * AmazonLinuxImage amznLinux = AmazonLinuxImage.Builder.create()
 *         .generation(AmazonLinuxGeneration.AMAZON_LINUX)
 *         .edition(AmazonLinuxEdition.STANDARD)
 *         .virtualization(AmazonLinuxVirt.HVM)
 *         .storage(AmazonLinuxStorage.GENERAL_PURPOSE)
 *         .build();
 * // For other custom (Linux) images, instantiate a `GenericLinuxImage` with
 * // a map giving the AMI to in for each region:
 * GenericLinuxImage linux = new GenericLinuxImage(Map.of(
 *         "us-east-1", "ami-97785bed",
 *         "eu-west-1", "ami-12345678"));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:58.998Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_ec2.AmazonLinuxImage")
public class AmazonLinuxImage extends software.amazon.awscdk.services.ec2.GenericSSMParameterImage {

    protected AmazonLinuxImage(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AmazonLinuxImage(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public AmazonLinuxImage(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.AmazonLinuxImageProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { props });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public AmazonLinuxImage() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * (experimental) Return the SSM parameter name that will contain the Amazon Linux image with the given attributes.
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull java.lang.String ssmParameterName(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.AmazonLinuxImageProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.AmazonLinuxImage.class, "ssmParameterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { props });
    }

    /**
     * (experimental) Return the SSM parameter name that will contain the Amazon Linux image with the given attributes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull java.lang.String ssmParameterName() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.AmazonLinuxImage.class, "ssmParameterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) Return the image to use in the given context.
     * <p>
     * @param scope This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.MachineImageConfig getImage(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope) {
        return software.amazon.jsii.Kernel.call(this, "getImage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.MachineImageConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required") });
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.ec2.AmazonLinuxImage}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ec2.AmazonLinuxImage> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create() {
            return new Builder();
        }

        private software.amazon.awscdk.services.ec2.AmazonLinuxImageProps.Builder props;

        private Builder() {
        }

        /**
         * (experimental) Whether the AMI ID is cached to be stable between deployments.
         * <p>
         * By default, the newest image is used on each deployment. This will cause
         * instances to be replaced whenever a new version is released, and may cause
         * downtime if there aren't enough running instances in the AutoScalingGroup
         * to reschedule the tasks on.
         * <p>
         * If set to true, the AMI ID will be cached in <code>cdk.context.json</code> and the
         * same value will be used on future runs. Your instances will not be replaced
         * but your AMI version will grow old over time. To refresh the AMI lookup,
         * you will have to evict the value from the cache using the <code>cdk context</code>
         * command. See https://docs.aws.amazon.com/cdk/latest/guide/context.html for
         * more information.
         * <p>
         * Can not be set to <code>true</code> in environment-agnostic stacks.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param cachedInContext Whether the AMI ID is cached to be stable between deployments. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cachedInContext(final java.lang.Boolean cachedInContext) {
            this.props().cachedInContext(cachedInContext);
            return this;
        }

        /**
         * (experimental) CPU Type.
         * <p>
         * Default: X86_64
         * <p>
         * @return {@code this}
         * @param cpuType CPU Type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cpuType(final software.amazon.awscdk.services.ec2.AmazonLinuxCpuType cpuType) {
            this.props().cpuType(cpuType);
            return this;
        }

        /**
         * (experimental) What edition of Amazon Linux to use.
         * <p>
         * Default: Standard
         * <p>
         * @return {@code this}
         * @param edition What edition of Amazon Linux to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder edition(final software.amazon.awscdk.services.ec2.AmazonLinuxEdition edition) {
            this.props().edition(edition);
            return this;
        }

        /**
         * (experimental) What generation of Amazon Linux to use.
         * <p>
         * Default: AmazonLinux
         * <p>
         * @return {@code this}
         * @param generation What generation of Amazon Linux to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder generation(final software.amazon.awscdk.services.ec2.AmazonLinuxGeneration generation) {
            this.props().generation(generation);
            return this;
        }

        /**
         * (experimental) What kernel version of Amazon Linux to use.
         * <p>
         * Default: -
         * <p>
         * @return {@code this}
         * @param kernel What kernel version of Amazon Linux to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder kernel(final software.amazon.awscdk.services.ec2.AmazonLinuxKernel kernel) {
            this.props().kernel(kernel);
            return this;
        }

        /**
         * (experimental) What storage backed image to use.
         * <p>
         * Default: GeneralPurpose
         * <p>
         * @return {@code this}
         * @param storage What storage backed image to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder storage(final software.amazon.awscdk.services.ec2.AmazonLinuxStorage storage) {
            this.props().storage(storage);
            return this;
        }

        /**
         * (experimental) Initial user data.
         * <p>
         * Default: - Empty UserData for Linux machines
         * <p>
         * @return {@code this}
         * @param userData Initial user data. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder userData(final software.amazon.awscdk.services.ec2.UserData userData) {
            this.props().userData(userData);
            return this;
        }

        /**
         * (experimental) Virtualization type.
         * <p>
         * Default: HVM
         * <p>
         * @return {@code this}
         * @param virtualization Virtualization type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder virtualization(final software.amazon.awscdk.services.ec2.AmazonLinuxVirt virtualization) {
            this.props().virtualization(virtualization);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ec2.AmazonLinuxImage}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.ec2.AmazonLinuxImage build() {
            return new software.amazon.awscdk.services.ec2.AmazonLinuxImage(
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.ec2.AmazonLinuxImageProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.ec2.AmazonLinuxImageProps.Builder();
            }
            return this.props;
        }
    }
}
