package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `CfnSecurityGroupEgress`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnSecurityGroupEgressProps cfnSecurityGroupEgressProps = CfnSecurityGroupEgressProps.builder()
 *         .groupId("groupId")
 *         .ipProtocol("ipProtocol")
 *         // the properties below are optional
 *         .cidrIp("cidrIp")
 *         .cidrIpv6("cidrIpv6")
 *         .description("description")
 *         .destinationPrefixListId("destinationPrefixListId")
 *         .destinationSecurityGroupId("destinationSecurityGroupId")
 *         .fromPort(123)
 *         .toPort(123)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:59.421Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_ec2.CfnSecurityGroupEgressProps")
@software.amazon.jsii.Jsii.Proxy(CfnSecurityGroupEgressProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnSecurityGroupEgressProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ID of the security group.
     * <p>
     * You must specify either the security group ID or the security group name in the request. For security groups in a nondefault VPC, you must specify the security group ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getGroupId();

    /**
     * The IP protocol name ( `tcp` , `udp` , `icmp` , `icmpv6` ) or number (see [Protocol Numbers](https://docs.aws.amazon.com/http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml) ).
     * <p>
     * [VPC only] Use <code>-1</code> to specify all protocols. When authorizing security group rules, specifying <code>-1</code> or a protocol number other than <code>tcp</code> , <code>udp</code> , <code>icmp</code> , or <code>icmpv6</code> allows traffic on all ports, regardless of any port range you specify. For <code>tcp</code> , <code>udp</code> , and <code>icmp</code> , you must specify a port range. For <code>icmpv6</code> , the port range is optional; if you omit the port range, traffic for all types and codes is allowed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIpProtocol();

    /**
     * The IPv4 address range, in CIDR format.
     * <p>
     * You must specify a destination security group ( <code>DestinationPrefixListId</code> or <code>DestinationSecurityGroupId</code> ) or a CIDR range ( <code>CidrIp</code> or <code>CidrIpv6</code> ).
     * <p>
     * For examples of rules that you can add to security groups for specific access scenarios, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/security-group-rules-reference.html">Security group rules for different use cases</a> in the <em>Amazon EC2 User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCidrIp() {
        return null;
    }

    /**
     * The IPv6 address range, in CIDR format.
     * <p>
     * You must specify a destination security group ( <code>DestinationPrefixListId</code> or <code>DestinationSecurityGroupId</code> ) or a CIDR range ( <code>CidrIp</code> or <code>CidrIpv6</code> ).
     * <p>
     * For examples of rules that you can add to security groups for specific access scenarios, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/security-group-rules-reference.html">Security group rules for different use cases</a> in the <em>Amazon EC2 User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCidrIpv6() {
        return null;
    }

    /**
     * The description of an egress (outbound) security group rule.
     * <p>
     * Constraints: Up to 255 characters in length. Allowed characters are a-z, A-Z, 0-9, spaces, and ._-:/()#,&#64;[]+=;{}!$*
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * [EC2-VPC only] The prefix list IDs for an AWS service.
     * <p>
     * This is the AWS service that you want to access through a VPC endpoint from instances associated with the security group.
     * <p>
     * You must specify a destination security group ( <code>DestinationPrefixListId</code> or <code>DestinationSecurityGroupId</code> ) or a CIDR range ( <code>CidrIp</code> or <code>CidrIpv6</code> ).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDestinationPrefixListId() {
        return null;
    }

    /**
     * The ID of the security group.
     * <p>
     * You must specify a destination security group ( <code>DestinationPrefixListId</code> or <code>DestinationSecurityGroupId</code> ) or a CIDR range ( <code>CidrIp</code> or <code>CidrIpv6</code> ).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDestinationSecurityGroupId() {
        return null;
    }

    /**
     * If the protocol is TCP or UDP, this is the start of the port range.
     * <p>
     * If the protocol is ICMP or ICMPv6, this is the type number. A value of -1 indicates all ICMP/ICMPv6 types. If you specify all ICMP/ICMPv6 types, you must specify all ICMP/ICMPv6 codes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getFromPort() {
        return null;
    }

    /**
     * If the protocol is TCP or UDP, this is the end of the port range.
     * <p>
     * If the protocol is ICMP or ICMPv6, this is the code. A value of -1 indicates all ICMP/ICMPv6 codes. If you specify all ICMP/ICMPv6 types, you must specify all ICMP/ICMPv6 codes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getToPort() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnSecurityGroupEgressProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnSecurityGroupEgressProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnSecurityGroupEgressProps> {
        java.lang.String groupId;
        java.lang.String ipProtocol;
        java.lang.String cidrIp;
        java.lang.String cidrIpv6;
        java.lang.String description;
        java.lang.String destinationPrefixListId;
        java.lang.String destinationSecurityGroupId;
        java.lang.Number fromPort;
        java.lang.Number toPort;

        /**
         * Sets the value of {@link CfnSecurityGroupEgressProps#getGroupId}
         * @param groupId The ID of the security group. This parameter is required.
         *                You must specify either the security group ID or the security group name in the request. For security groups in a nondefault VPC, you must specify the security group ID.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder groupId(java.lang.String groupId) {
            this.groupId = groupId;
            return this;
        }

        /**
         * Sets the value of {@link CfnSecurityGroupEgressProps#getIpProtocol}
         * @param ipProtocol The IP protocol name ( `tcp` , `udp` , `icmp` , `icmpv6` ) or number (see [Protocol Numbers](https://docs.aws.amazon.com/http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml) ). This parameter is required.
         *                   [VPC only] Use <code>-1</code> to specify all protocols. When authorizing security group rules, specifying <code>-1</code> or a protocol number other than <code>tcp</code> , <code>udp</code> , <code>icmp</code> , or <code>icmpv6</code> allows traffic on all ports, regardless of any port range you specify. For <code>tcp</code> , <code>udp</code> , and <code>icmp</code> , you must specify a port range. For <code>icmpv6</code> , the port range is optional; if you omit the port range, traffic for all types and codes is allowed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipProtocol(java.lang.String ipProtocol) {
            this.ipProtocol = ipProtocol;
            return this;
        }

        /**
         * Sets the value of {@link CfnSecurityGroupEgressProps#getCidrIp}
         * @param cidrIp The IPv4 address range, in CIDR format.
         *               You must specify a destination security group ( <code>DestinationPrefixListId</code> or <code>DestinationSecurityGroupId</code> ) or a CIDR range ( <code>CidrIp</code> or <code>CidrIpv6</code> ).
         *               <p>
         *               For examples of rules that you can add to security groups for specific access scenarios, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/security-group-rules-reference.html">Security group rules for different use cases</a> in the <em>Amazon EC2 User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cidrIp(java.lang.String cidrIp) {
            this.cidrIp = cidrIp;
            return this;
        }

        /**
         * Sets the value of {@link CfnSecurityGroupEgressProps#getCidrIpv6}
         * @param cidrIpv6 The IPv6 address range, in CIDR format.
         *                 You must specify a destination security group ( <code>DestinationPrefixListId</code> or <code>DestinationSecurityGroupId</code> ) or a CIDR range ( <code>CidrIp</code> or <code>CidrIpv6</code> ).
         *                 <p>
         *                 For examples of rules that you can add to security groups for specific access scenarios, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/security-group-rules-reference.html">Security group rules for different use cases</a> in the <em>Amazon EC2 User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cidrIpv6(java.lang.String cidrIpv6) {
            this.cidrIpv6 = cidrIpv6;
            return this;
        }

        /**
         * Sets the value of {@link CfnSecurityGroupEgressProps#getDescription}
         * @param description The description of an egress (outbound) security group rule.
         *                    Constraints: Up to 255 characters in length. Allowed characters are a-z, A-Z, 0-9, spaces, and ._-:/()#,&#64;[]+=;{}!$*
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnSecurityGroupEgressProps#getDestinationPrefixListId}
         * @param destinationPrefixListId [EC2-VPC only] The prefix list IDs for an AWS service.
         *                                This is the AWS service that you want to access through a VPC endpoint from instances associated with the security group.
         *                                <p>
         *                                You must specify a destination security group ( <code>DestinationPrefixListId</code> or <code>DestinationSecurityGroupId</code> ) or a CIDR range ( <code>CidrIp</code> or <code>CidrIpv6</code> ).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationPrefixListId(java.lang.String destinationPrefixListId) {
            this.destinationPrefixListId = destinationPrefixListId;
            return this;
        }

        /**
         * Sets the value of {@link CfnSecurityGroupEgressProps#getDestinationSecurityGroupId}
         * @param destinationSecurityGroupId The ID of the security group.
         *                                   You must specify a destination security group ( <code>DestinationPrefixListId</code> or <code>DestinationSecurityGroupId</code> ) or a CIDR range ( <code>CidrIp</code> or <code>CidrIpv6</code> ).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationSecurityGroupId(java.lang.String destinationSecurityGroupId) {
            this.destinationSecurityGroupId = destinationSecurityGroupId;
            return this;
        }

        /**
         * Sets the value of {@link CfnSecurityGroupEgressProps#getFromPort}
         * @param fromPort If the protocol is TCP or UDP, this is the start of the port range.
         *                 If the protocol is ICMP or ICMPv6, this is the type number. A value of -1 indicates all ICMP/ICMPv6 types. If you specify all ICMP/ICMPv6 types, you must specify all ICMP/ICMPv6 codes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fromPort(java.lang.Number fromPort) {
            this.fromPort = fromPort;
            return this;
        }

        /**
         * Sets the value of {@link CfnSecurityGroupEgressProps#getToPort}
         * @param toPort If the protocol is TCP or UDP, this is the end of the port range.
         *               If the protocol is ICMP or ICMPv6, this is the code. A value of -1 indicates all ICMP/ICMPv6 codes. If you specify all ICMP/ICMPv6 types, you must specify all ICMP/ICMPv6 codes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder toPort(java.lang.Number toPort) {
            this.toPort = toPort;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnSecurityGroupEgressProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnSecurityGroupEgressProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnSecurityGroupEgressProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnSecurityGroupEgressProps {
        private final java.lang.String groupId;
        private final java.lang.String ipProtocol;
        private final java.lang.String cidrIp;
        private final java.lang.String cidrIpv6;
        private final java.lang.String description;
        private final java.lang.String destinationPrefixListId;
        private final java.lang.String destinationSecurityGroupId;
        private final java.lang.Number fromPort;
        private final java.lang.Number toPort;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.groupId = software.amazon.jsii.Kernel.get(this, "groupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ipProtocol = software.amazon.jsii.Kernel.get(this, "ipProtocol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.cidrIp = software.amazon.jsii.Kernel.get(this, "cidrIp", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.cidrIpv6 = software.amazon.jsii.Kernel.get(this, "cidrIpv6", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.destinationPrefixListId = software.amazon.jsii.Kernel.get(this, "destinationPrefixListId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.destinationSecurityGroupId = software.amazon.jsii.Kernel.get(this, "destinationSecurityGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.fromPort = software.amazon.jsii.Kernel.get(this, "fromPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.toPort = software.amazon.jsii.Kernel.get(this, "toPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.groupId = java.util.Objects.requireNonNull(builder.groupId, "groupId is required");
            this.ipProtocol = java.util.Objects.requireNonNull(builder.ipProtocol, "ipProtocol is required");
            this.cidrIp = builder.cidrIp;
            this.cidrIpv6 = builder.cidrIpv6;
            this.description = builder.description;
            this.destinationPrefixListId = builder.destinationPrefixListId;
            this.destinationSecurityGroupId = builder.destinationSecurityGroupId;
            this.fromPort = builder.fromPort;
            this.toPort = builder.toPort;
        }

        @Override
        public final java.lang.String getGroupId() {
            return this.groupId;
        }

        @Override
        public final java.lang.String getIpProtocol() {
            return this.ipProtocol;
        }

        @Override
        public final java.lang.String getCidrIp() {
            return this.cidrIp;
        }

        @Override
        public final java.lang.String getCidrIpv6() {
            return this.cidrIpv6;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getDestinationPrefixListId() {
            return this.destinationPrefixListId;
        }

        @Override
        public final java.lang.String getDestinationSecurityGroupId() {
            return this.destinationSecurityGroupId;
        }

        @Override
        public final java.lang.Number getFromPort() {
            return this.fromPort;
        }

        @Override
        public final java.lang.Number getToPort() {
            return this.toPort;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("groupId", om.valueToTree(this.getGroupId()));
            data.set("ipProtocol", om.valueToTree(this.getIpProtocol()));
            if (this.getCidrIp() != null) {
                data.set("cidrIp", om.valueToTree(this.getCidrIp()));
            }
            if (this.getCidrIpv6() != null) {
                data.set("cidrIpv6", om.valueToTree(this.getCidrIpv6()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getDestinationPrefixListId() != null) {
                data.set("destinationPrefixListId", om.valueToTree(this.getDestinationPrefixListId()));
            }
            if (this.getDestinationSecurityGroupId() != null) {
                data.set("destinationSecurityGroupId", om.valueToTree(this.getDestinationSecurityGroupId()));
            }
            if (this.getFromPort() != null) {
                data.set("fromPort", om.valueToTree(this.getFromPort()));
            }
            if (this.getToPort() != null) {
                data.set("toPort", om.valueToTree(this.getToPort()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_ec2.CfnSecurityGroupEgressProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnSecurityGroupEgressProps.Jsii$Proxy that = (CfnSecurityGroupEgressProps.Jsii$Proxy) o;

            if (!groupId.equals(that.groupId)) return false;
            if (!ipProtocol.equals(that.ipProtocol)) return false;
            if (this.cidrIp != null ? !this.cidrIp.equals(that.cidrIp) : that.cidrIp != null) return false;
            if (this.cidrIpv6 != null ? !this.cidrIpv6.equals(that.cidrIpv6) : that.cidrIpv6 != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.destinationPrefixListId != null ? !this.destinationPrefixListId.equals(that.destinationPrefixListId) : that.destinationPrefixListId != null) return false;
            if (this.destinationSecurityGroupId != null ? !this.destinationSecurityGroupId.equals(that.destinationSecurityGroupId) : that.destinationSecurityGroupId != null) return false;
            if (this.fromPort != null ? !this.fromPort.equals(that.fromPort) : that.fromPort != null) return false;
            return this.toPort != null ? this.toPort.equals(that.toPort) : that.toPort == null;
        }

        @Override
        public final int hashCode() {
            int result = this.groupId.hashCode();
            result = 31 * result + (this.ipProtocol.hashCode());
            result = 31 * result + (this.cidrIp != null ? this.cidrIp.hashCode() : 0);
            result = 31 * result + (this.cidrIpv6 != null ? this.cidrIpv6.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.destinationPrefixListId != null ? this.destinationPrefixListId.hashCode() : 0);
            result = 31 * result + (this.destinationSecurityGroupId != null ? this.destinationSecurityGroupId.hashCode() : 0);
            result = 31 * result + (this.fromPort != null ? this.fromPort.hashCode() : 0);
            result = 31 * result + (this.toPort != null ? this.toPort.hashCode() : 0);
            return result;
        }
    }
}
