package software.amazon.awscdk.services.ec2;

/**
 * (experimental) What class and generation of instance to use.
 * <p>
 * We have both symbolic and concrete enums for every type.
 * <p>
 * The first are for people that want to specify by purpose,
 * the second one are for people who already know exactly what
 * 'R4' means.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * DatabaseInstance sourceInstance;
 * DatabaseInstanceFromSnapshot.Builder.create(this, "Instance")
 *         .snapshotIdentifier("my-snapshot")
 *         .engine(DatabaseInstanceEngine.postgres(PostgresInstanceEngineProps.builder().version(PostgresEngineVersion.VER_12_3).build()))
 *         // optional, defaults to m5.large
 *         .instanceType(InstanceType.of(InstanceClass.BURSTABLE2, InstanceSize.LARGE))
 *         .vpc(vpc)
 *         .build();
 * DatabaseInstanceReadReplica.Builder.create(this, "ReadReplica")
 *         .sourceDatabaseInstance(sourceInstance)
 *         .instanceType(InstanceType.of(InstanceClass.BURSTABLE2, InstanceSize.LARGE))
 *         .vpc(vpc)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:59.778Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_ec2.InstanceClass")
public enum InstanceClass {
    /**
     * (experimental) Standard instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    STANDARD3,
    /**
     * (experimental) Standard instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    M3,
    /**
     * (experimental) Standard instances, 4th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    STANDARD4,
    /**
     * (experimental) Standard instances, 4th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    M4,
    /**
     * (experimental) Standard instances, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    STANDARD5,
    /**
     * (experimental) Standard instances, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    M5,
    /**
     * (experimental) Standard instances with local NVME drive, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    STANDARD5_NVME_DRIVE,
    /**
     * (experimental) Standard instances with local NVME drive, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    M5D,
    /**
     * (experimental) Standard instances based on AMD EPYC, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    STANDARD5_AMD,
    /**
     * (experimental) Standard instances based on AMD EPYC, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    M5A,
    /**
     * (experimental) Standard instances based on AMD EPYC with local NVME drive, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    STANDARD5_AMD_NVME_DRIVE,
    /**
     * (experimental) Standard instances based on AMD EPYC with local NVME drive, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    M5AD,
    /**
     * (experimental) Standard instances for high performance computing, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    STANDARD5_HIGH_PERFORMANCE,
    /**
     * (experimental) Standard instances for high performance computing, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    M5N,
    /**
     * (experimental) Standard instances with local NVME drive for high performance computing, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    STANDARD5_NVME_DRIVE_HIGH_PERFORMANCE,
    /**
     * (experimental) Standard instances with local NVME drive for high performance computing, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    M5DN,
    /**
     * (experimental) Standard instances with high memory and compute capacity based on Intel Xeon Scalable (Cascade Lake) processors, 5nd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    STANDARD5_HIGH_COMPUTE,
    /**
     * (experimental) Standard instances with high memory and compute capacity based on Intel Xeon Scalable (Cascade Lake) processors, 5nd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    M5ZN,
    /**
     * (experimental) Memory optimized instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    MEMORY3,
    /**
     * (experimental) Memory optimized instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    R3,
    /**
     * (experimental) Memory optimized instances, 4th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    MEMORY4,
    /**
     * (experimental) Memory optimized instances, 4th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    R4,
    /**
     * (experimental) Memory optimized instances, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    MEMORY5,
    /**
     * (experimental) Memory optimized instances, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    R5,
    /**
     * (experimental) Memory optimized instances, 6th generation with Intel Xeon Scalable processors (3rd generation processors code named Ice Lake).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    MEMORY6_INTEL,
    /**
     * (experimental) Memory optimized instances, 6th generation with Intel Xeon Scalable processors (3rd generation processors code named Ice Lake).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    R6I,
    /**
     * (experimental) Memory optimized instances for high performance computing, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    MEMORY5_HIGH_PERFORMANCE,
    /**
     * (experimental) Memory optimized instances for high performance computing, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    R5N,
    /**
     * (experimental) Memory optimized instances with local NVME drive, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    MEMORY5_NVME_DRIVE,
    /**
     * (experimental) Memory optimized instances with local NVME drive, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    R5D,
    /**
     * (experimental) Memory optimized instances with local NVME drive for high performance computing, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    MEMORY5_NVME_DRIVE_HIGH_PERFORMANCE,
    /**
     * (experimental) Memory optimized instances with local NVME drive for high performance computing, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    R5DN,
    /**
     * (experimental) Memory optimized instances based on AMD EPYC, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    MEMORY5_AMD,
    /**
     * (experimental) Memory optimized instances based on AMD EPYC, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    R5A,
    /**
     * (experimental) Memory optimized instances based on AMD EPYC with local NVME drive, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    MEMORY5_AMD_NVME_DRIVE,
    /**
     * (experimental) High memory instances (6TB) based on Intel Xeon Platinum 8176M (Skylake) processors, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    HIGH_MEMORY_6TB_1,
    /**
     * (experimental) High memory instances (6TB) based on Intel Xeon Platinum 8176M (Skylake) processors, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    U_6TB1,
    /**
     * (experimental) High memory instances (9TB) based on Intel Xeon Platinum 8176M (Skylake) processors, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    HIGH_MEMORY_9TB_1,
    /**
     * (experimental) High memory instances (9TB) based on Intel Xeon Platinum 8176M (Skylake) processors, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    U_9TB1,
    /**
     * (experimental) High memory instances (12TB) based on Intel Xeon Platinum 8176M (Skylake) processors, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    HIGH_MEMORY_12TB_1,
    /**
     * (experimental) High memory instances (12TB) based on Intel Xeon Platinum 8176M (Skylake) processors, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    U_12TB1,
    /**
     * (experimental) High memory instances (18TB) based on Intel Xeon Scalable (Cascade Lake) processors, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    HIGH_MEMORY_18TB_1,
    /**
     * (experimental) High memory instances (18TB) based on Intel Xeon Scalable (Cascade Lake) processors, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    U_18TB1,
    /**
     * (experimental) High memory instances (24TB) based on Intel Xeon Scalable (Cascade Lake) processors, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    HIGH_MEMORY_24TB_1,
    /**
     * (experimental) High memory instances (24TB) based on Intel Xeon Scalable (Cascade Lake) processors, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    U_24TB1,
    /**
     * (experimental) Memory optimized instances based on AMD EPYC with local NVME drive, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    R5AD,
    /**
     * (experimental) Memory optimized instances that are also EBS-optimized, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    MEMORY5_EBS_OPTIMIZED,
    /**
     * (experimental) Memory optimized instances that are also EBS-optimized, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    R5B,
    /**
     * (experimental) Memory optimized instances, 6th generation with Graviton2 processors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    MEMORY6_GRAVITON,
    /**
     * (experimental) Memory optimized instances, 6th generation with Graviton2 processors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    R6G,
    /**
     * (experimental) Memory optimized instances, 6th generation with Graviton2 processors and local NVME drive.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    MEMORY6_GRAVITON2_NVME_DRIVE,
    /**
     * (experimental) Memory optimized instances, 6th generation with Graviton2 processors and local NVME drive.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    R6GD,
    /**
     * (experimental) Compute optimized instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    COMPUTE3,
    /**
     * (experimental) Compute optimized instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    C3,
    /**
     * (experimental) Compute optimized instances, 4th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    COMPUTE4,
    /**
     * (experimental) Compute optimized instances, 4th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    C4,
    /**
     * (experimental) Compute optimized instances, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    COMPUTE5,
    /**
     * (experimental) Compute optimized instances, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    C5,
    /**
     * (experimental) Compute optimized instances with local NVME drive, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    COMPUTE5_NVME_DRIVE,
    /**
     * (experimental) Compute optimized instances with local NVME drive, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    C5D,
    /**
     * (experimental) Compute optimized instances based on AMD EPYC, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    COMPUTE5_AMD,
    /**
     * (experimental) Compute optimized instances based on AMD EPYC, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    C5A,
    /**
     * (experimental) Compute optimized instances with local NVME drive based on AMD EPYC, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    COMPUTE5_AMD_NVME_DRIVE,
    /**
     * (experimental) Compute optimized instances with local NVME drive based on AMD EPYC, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    C5AD,
    /**
     * (experimental) Compute optimized instances for high performance computing, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    COMPUTE5_HIGH_PERFORMANCE,
    /**
     * (experimental) Compute optimized instances for high performance computing, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    C5N,
    /**
     * (experimental) Compute optimized instances, 6th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    COMPUTE6_INTEL,
    /**
     * (experimental) Compute optimized instances, 6th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    C6I,
    /**
     * (experimental) Compute optimized instances based on AMD EPYC (codename Milan), 6th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    COMPUTE6_AMD,
    /**
     * (experimental) Compute optimized instances based on AMD EPYC (codename Milan), 6th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    C6A,
    /**
     * (experimental) Compute optimized instances for high performance computing, 6th generation with Graviton2 processors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    COMPUTE6_GRAVITON2,
    /**
     * (experimental) Compute optimized instances for high performance computing, 6th generation with Graviton2 processors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    C6G,
    /**
     * (experimental) Compute optimized instances for high performance computing, 6th generation with Graviton2 processors and local NVME drive.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    COMPUTE6_GRAVITON2_NVME_DRIVE,
    /**
     * (experimental) Compute optimized instances for high performance computing, 6th generation with Graviton2 processors and local NVME drive.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    C6GD,
    /**
     * (experimental) Compute optimized instances for high performance computing, 6th generation with Graviton2 processors and high network bandwidth capabilities.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    COMPUTE6_GRAVITON2_HIGH_NETWORK_BANDWITH,
    /**
     * (experimental) Compute optimized instances for high performance computing, 6th generation with Graviton2 processors and high network bandwidth capabilities.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    COMPUTE6_GRAVITON2_HIGH_NETWORK_BANDWIDTH,
    /**
     * (experimental) Compute optimized instances for high performance computing, 6th generation with Graviton2 processors and high network bandwidth capabilities.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    C6GN,
    /**
     * (experimental) Storage-optimized instances, 2nd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    STORAGE2,
    /**
     * (experimental) Storage-optimized instances, 2nd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    D2,
    /**
     * (experimental) Storage-optimized instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    STORAGE3,
    /**
     * (experimental) Storage-optimized instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    D3,
    /**
     * (experimental) Storage-optimized instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    STORAGE3_ENHANCED_NETWORK,
    /**
     * (experimental) Storage-optimized instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    D3EN,
    /**
     * (experimental) Storage/compute balanced instances, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    STORAGE_COMPUTE_1,
    /**
     * (experimental) Storage/compute balanced instances, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    H1,
    /**
     * (experimental) I/O-optimized instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    IO3,
    /**
     * (experimental) I/O-optimized instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    I3,
    /**
     * (experimental) I/O-optimized instances with local NVME drive, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    IO3_DENSE_NVME_DRIVE,
    /**
     * (experimental) I/O-optimized instances with local NVME drive, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    I3EN,
    /**
     * (experimental) I/O-optimized instances with local NVME drive powered by Intel Xeon Scalable processors (code named Ice Lake), 4th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    IO4_INTEL,
    /**
     * (experimental) I/O-optimized instances with local NVME drive powered by Intel Xeon Scalable processors (code named Ice Lake), 4th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    I4I,
    /**
     * (experimental) Storage optimized instances powered by Graviton2 processor, 4th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    STORAGE4_GRAVITON_NETWORK_OPTIMIZED,
    /**
     * (experimental) Storage optimized instances powered by Graviton2 processor, 4th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    IM4GN,
    /**
     * (experimental) Storage optimized instances powered by Graviton2 processor, 4th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    STORAGE4_GRAVITON_NETWORK_STORAGE_OPTIMIZED,
    /**
     * (experimental) Storage optimized instances powered by Graviton2 processor, 4th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    IS4GEN,
    /**
     * (experimental) Burstable instances, 2nd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    BURSTABLE2,
    /**
     * (experimental) Burstable instances, 2nd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    T2,
    /**
     * (experimental) Burstable instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    BURSTABLE3,
    /**
     * (experimental) Burstable instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    T3,
    /**
     * (experimental) Burstable instances based on AMD EPYC, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    BURSTABLE3_AMD,
    /**
     * (experimental) Burstable instances based on AMD EPYC, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    T3A,
    /**
     * (experimental) Burstable instances, 4th generation with Graviton2 processors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    BURSTABLE4_GRAVITON,
    /**
     * (experimental) Burstable instances, 4th generation with Graviton2 processors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    T4G,
    /**
     * (experimental) Memory-intensive instances, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    MEMORY_INTENSIVE_1,
    /**
     * (experimental) Memory-intensive instances, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    X1,
    /**
     * (experimental) Memory-intensive instances, extended, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    MEMORY_INTENSIVE_1_EXTENDED,
    /**
     * (experimental) Memory-intensive instances, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    X1E,
    /**
     * (experimental) Memory-intensive instances, 2nd generation with Graviton2 processors.
     * <p>
     * This instance type can be used only in RDS. It is not supported in EC2.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    MEMORY_INTENSIVE_2_GRAVITON2,
    /**
     * (experimental) Memory-intensive instances, 2nd generation with Graviton2 processors.
     * <p>
     * This instance type can be used only in RDS. It is not supported in EC2.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    X2G,
    /**
     * (experimental) Memory-intensive instances, 2nd generation with Graviton2 processors and local NVME drive.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    MEMORY_INTENSIVE_2_GRAVITON2_NVME_DRIVE,
    /**
     * (experimental) Memory-intensive instances, 2nd generation with Graviton2 processors and local NVME drive.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    X2GD,
    /**
     * (experimental) Memory-intensive instances with higher network bandwith, local NVME drive, and extended memory.
     * <p>
     * Intel Xeon Scalable (Ice Lake) processors
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    MEMORY_INTENSIVE_2_XT_INTEL,
    /**
     * (experimental) Memory-intensive instances with higher network bandwith, local NVME drive, and extended memory.
     * <p>
     * Intel Xeon Scalable (Ice Lake) processors
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    X2IEDN,
    /**
     * (experimental) Memory-intensive instances with higher network bandwith and local NVME drive, Intel Xeon Scalable (Ice Lake) processors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    MEMORY_INTENSIVE_2_INTEL,
    /**
     * (experimental) Memory-intensive instances with higher network bandwith and local NVME drive, Intel Xeon Scalable (Ice Lake) processors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    X2IDN,
    /**
     * (experimental) Memory-intensive instances with higher network bandwith and single-threaded performance, Intel Xeon Scalable (Cascade Lake) processors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    MEMORY_INTENSIVE_2_XTZ_INTEL,
    /**
     * (experimental) Memory-intensive instances with higher network bandwith and single-threaded performance, Intel Xeon Scalable (Cascade Lake) processors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    X2IEZN,
    /**
     * (experimental) Instances with customizable hardware acceleration, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    FPGA1,
    /**
     * (experimental) Instances with customizable hardware acceleration, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    F1,
    /**
     * (experimental) Graphics-optimized instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    GRAPHICS3,
    /**
     * (experimental) Graphics-optimized instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    G3,
    /**
     * (experimental) Graphics-optimized instances with NVME drive for high performance computing, 4th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    GRAPHICS4_NVME_DRIVE_HIGH_PERFORMANCE,
    /**
     * (experimental) Graphics-optimized instances with NVME drive for high performance computing, 4th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    G4DN,
    /**
     * (experimental) Graphics-optimized instances based on AMD EPYC And Radeon Pro GPU (NAVI) with local NVME drive, 4th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    GRAPHICS4_AMD_NVME_DRIVE,
    /**
     * (experimental) Graphics-optimized instances based on AMD EPYC And Radeon Pro GPU (NAVI) with local NVME drive, 4th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    G4AD,
    /**
     * (experimental) Graphics-optimized instances, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    GRAPHICS5,
    /**
     * (experimental) Graphics-optimized instances, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    G5,
    /**
     * (experimental) Graphics-optimized instances powered by AWS Graviton2 Processors and NVIDIA T4G Tensor Core GPUs, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    GRAPHICS5_GRAVITON2,
    /**
     * (experimental) Graphics-optimized instances powered by AWS Graviton2 Processors and NVIDIA T4G Tensor Core GPUs, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    G5G,
    /**
     * (experimental) Parallel-processing optimized instances, 2nd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    PARALLEL2,
    /**
     * (experimental) Parallel-processing optimized instances, 2nd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    P2,
    /**
     * (experimental) Parallel-processing optimized instances, 3nd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    PARALLEL3,
    /**
     * (experimental) Parallel-processing optimized instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    P3,
    /**
     * (experimental) Parallel-processing optimized instances, 4th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    PARALLEL4,
    /**
     * (experimental) Parallel-processing optimized instances, 4th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    P4D,
    /**
     * (experimental) Arm processor based instances, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    ARM1,
    /**
     * (experimental) Arm processor based instances, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    A1,
    /**
     * (experimental) Arm processor based instances, 2nd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    STANDARD6_GRAVITON,
    /**
     * (experimental) Arm processor based instances, 2nd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    M6G,
    /**
     * (experimental) Standard instances based on Intel (Ice Lake), 6th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    STANDARD6_INTEL,
    /**
     * (experimental) Standard instances based on Intel (Ice Lake), 6th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    M6I,
    /**
     * (experimental) Standard instances based on 3rd Gen AMD EPYC processors, 6th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    STANDARD6_AMD,
    /**
     * (experimental) Standard instances based on 3rd Gen AMD EPYC processors, 6th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    M6A,
    /**
     * (experimental) Standard instances, 6th generation with Graviton2 processors and local NVME drive.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    STANDARD6_GRAVITON2_NVME_DRIVE,
    /**
     * (experimental) Standard instances, 6th generation with Graviton2 processors and local NVME drive.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    M6GD,
    /**
     * (experimental) High memory and compute capacity instances, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    HIGH_COMPUTE_MEMORY1,
    /**
     * (experimental) High memory and compute capacity instances, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    Z1D,
    /**
     * (experimental) Inferentia Chips based instances for machine learning inference applications, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    INFERENCE1,
    /**
     * (experimental) Inferentia Chips based instances for machine learning inference applications, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    INF1,
    /**
     * (experimental) Macintosh instances built on Apple Mac mini computers, 1st generation with Intel procesors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    MACINTOSH1_INTEL,
    /**
     * (experimental) Macintosh instances built on Apple Mac mini computers, 1st generation with Intel procesors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    MAC1,
    /**
     * (experimental) Multi-stream video transcoding instances for resolutions up to 4K UHD, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    VIDEO_TRANSCODING1,
    /**
     * (experimental) Multi-stream video transcoding instances for resolutions up to 4K UHD, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    VT1,
    /**
     * (experimental) High performance computing based on AMD EPYC, 6th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    HIGH_PERFORMANCE_COMPUTING6_AMD,
    /**
     * (experimental) High performance computing based on AMD EPYC, 6th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    HPC6A,
}
