package software.amazon.awscdk.services.ec2;

/**
 * (experimental) Direction of traffic to allow all by default.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * InstanceType instanceType;
 * NatInstanceProvider provider = NatProvider.instance(NatInstanceProps.builder()
 *         .instanceType(instanceType)
 *         .defaultAllowedTraffic(NatTrafficDirection.OUTBOUND_ONLY)
 *         .build());
 * Vpc.Builder.create(this, "TheVPC")
 *         .natGatewayProvider(provider)
 *         .build();
 * provider.connections.allowFrom(Peer.ipv4("1.2.3.4/8"), Port.tcp(80));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:59.847Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_ec2.NatTrafficDirection")
public enum NatTrafficDirection {
    /**
     * (experimental) Allow all outbound traffic and disallow all inbound traffic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    OUTBOUND_ONLY,
    /**
     * (experimental) Allow all outbound and inbound traffic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    INBOUND_AND_OUTBOUND,
    /**
     * (experimental) Disallow all outbound and inbound traffic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    NONE,
}
