package software.amazon.awscdk.services.ec2;

/**
 * (experimental) Type of router used in route.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc = Vpc.Builder.create(this, "VPC")
 *         .subnetConfiguration(List.of(SubnetConfiguration.builder()
 *                 .subnetType(SubnetType.PUBLIC)
 *                 .name("Public")
 *                 .build(), SubnetConfiguration.builder()
 *                 .subnetType(SubnetType.PRIVATE_ISOLATED)
 *                 .name("Isolated")
 *                 .build()))
 *         .build();
 * ((Subnet)vpc.isolatedSubnets[0]).addRoute("StaticRoute", AddRouteOptions.builder()
 *         .routerId(vpc.getInternetGatewayId())
 *         .routerType(RouterType.GATEWAY)
 *         .destinationCidrBlock("8.8.8.8/32")
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:59.865Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_ec2.RouterType")
public enum RouterType {
    /**
     * (experimental) Carrier gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    CARRIER_GATEWAY,
    /**
     * (experimental) Egress-only Internet Gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    EGRESS_ONLY_INTERNET_GATEWAY,
    /**
     * (experimental) Internet Gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    GATEWAY,
    /**
     * (experimental) Instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    INSTANCE,
    /**
     * (experimental) Local Gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    LOCAL_GATEWAY,
    /**
     * (experimental) NAT Gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    NAT_GATEWAY,
    /**
     * (experimental) Network Interface.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    NETWORK_INTERFACE,
    /**
     * (experimental) Transit Gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    TRANSIT_GATEWAY,
    /**
     * (experimental) VPC peering connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    VPC_PEERING_CONNECTION,
    /**
     * (experimental) VPC Endpoint for gateway load balancers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    VPC_ENDPOINT,
}
