package software.amazon.awscdk.services.ecr.assets;

/**
 * (experimental) An asset that represents a Docker image.
 * <p>
 * The image will be created in build time and uploaded to an ECR repository.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.ecr.assets.DockerImageAsset;
 * import software.amazon.awscdk.services.ecr.assets.NetworkMode;
 * DockerImageAsset asset = DockerImageAsset.Builder.create(this, "MyBuildImage")
 *         .directory(join(__dirname, "my-image"))
 *         .networkMode(NetworkMode.HOST)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:00.004Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_ecr_assets.DockerImageAsset")
public class DockerImageAsset extends software.amazon.awscdk.core.Construct implements software.amazon.awscdk.assets.IAsset {

    protected DockerImageAsset(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DockerImageAsset(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public DockerImageAsset(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecr.assets.DockerImageAssetProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Adds CloudFormation template metadata to the specified resource with information that indicates which resource property is mapped to this local asset.
     * <p>
     * This can be used by tools such as SAM CLI to provide local
     * experience such as local invocation and debugging of Lambda functions.
     * <p>
     * Asset metadata will only be included if the stack is synthesized with the
     * "aws:cdk:enable-asset-metadata" context key defined, which is the default
     * behavior when synthesizing via the CDK Toolkit.
     * <p>
     * @see <a href="https://github.com/aws/aws-cdk/issues/1432">https://github.com/aws/aws-cdk/issues/1432</a>
     * @param resource The CloudFormation resource which is using this asset [disable-awslint:ref-via-interface]. This parameter is required.
     * @param resourceProperty The property name where this asset is referenced. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addResourceMetadata(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.CfnResource resource, final @org.jetbrains.annotations.NotNull java.lang.String resourceProperty) {
        software.amazon.jsii.Kernel.call(this, "addResourceMetadata", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(resource, "resource is required"), java.util.Objects.requireNonNull(resourceProperty, "resourceProperty is required") });
    }

    /**
     * (experimental) A hash of this asset, which is available at construction time.
     * <p>
     * As this is a plain string, it
     * can be used in construct IDs in order to enforce creation of a new resource when the content
     * hash has changed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getAssetHash() {
        return software.amazon.jsii.Kernel.get(this, "assetHash", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (deprecated) A hash of the source of this asset, which is available at construction time.
     * <p>
     * As this is a plain
     * string, it can be used in construct IDs in order to enforce creation of a new resource when
     * the content hash has changed.
     * <p>
     * @deprecated use assetHash
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull java.lang.String getSourceHash() {
        return software.amazon.jsii.Kernel.get(this, "sourceHash", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The full URI of the image (including a tag).
     * <p>
     * Use this reference to pull
     * the asset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getImageUri() {
        return software.amazon.jsii.Kernel.get(this, "imageUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The full URI of the image (including a tag).
     * <p>
     * Use this reference to pull
     * the asset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void setImageUri(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "imageUri", java.util.Objects.requireNonNull(value, "imageUri is required"));
    }

    /**
     * (experimental) Repository where the image is stored.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecr.IRepository getRepository() {
        return software.amazon.jsii.Kernel.get(this, "repository", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecr.IRepository.class));
    }

    /**
     * (experimental) Repository where the image is stored.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void setRepository(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecr.IRepository value) {
        software.amazon.jsii.Kernel.set(this, "repository", java.util.Objects.requireNonNull(value, "repository is required"));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.ecr.assets.DockerImageAsset}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ecr.assets.DockerImageAsset> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ecr.assets.DockerImageAssetProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ecr.assets.DockerImageAssetProps.Builder();
        }

        /**
         * (experimental) Glob patterns to exclude from the copy.
         * <p>
         * Default: - nothing is excluded
         * <p>
         * @return {@code this}
         * @param exclude Glob patterns to exclude from the copy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder exclude(final java.util.List<java.lang.String> exclude) {
            this.props.exclude(exclude);
            return this;
        }

        /**
         * (deprecated) A strategy for how to handle symlinks.
         * <p>
         * Default: Never
         * <p>
         * @return {@code this}
         * @deprecated use `followSymlinks` instead
         * @param follow A strategy for how to handle symlinks. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder follow(final software.amazon.awscdk.assets.FollowMode follow) {
            this.props.follow(follow);
            return this;
        }

        /**
         * (experimental) The ignore behavior to use for exclude patterns.
         * <p>
         * Default: IgnoreMode.GLOB
         * <p>
         * @return {@code this}
         * @param ignoreMode The ignore behavior to use for exclude patterns. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder ignoreMode(final software.amazon.awscdk.core.IgnoreMode ignoreMode) {
            this.props.ignoreMode(ignoreMode);
            return this;
        }

        /**
         * (experimental) Extra information to encode into the fingerprint (e.g. build instructions and other inputs).
         * <p>
         * Default: - hash is only based on source content
         * <p>
         * @return {@code this}
         * @param extraHash Extra information to encode into the fingerprint (e.g. build instructions and other inputs). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder extraHash(final java.lang.String extraHash) {
            this.props.extraHash(extraHash);
            return this;
        }

        /**
         * (experimental) A strategy for how to handle symlinks.
         * <p>
         * Default: SymlinkFollowMode.NEVER
         * <p>
         * @return {@code this}
         * @param followSymlinks A strategy for how to handle symlinks. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder followSymlinks(final software.amazon.awscdk.core.SymlinkFollowMode followSymlinks) {
            this.props.followSymlinks(followSymlinks);
            return this;
        }

        /**
         * (experimental) Build args to pass to the `docker build` command.
         * <p>
         * Since Docker build arguments are resolved before deployment, keys and
         * values cannot refer to unresolved tokens (such as <code>lambda.functionArn</code> or
         * <code>queue.queueUrl</code>).
         * <p>
         * Default: - no build args are passed
         * <p>
         * @return {@code this}
         * @param buildArgs Build args to pass to the `docker build` command. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder buildArgs(final java.util.Map<java.lang.String, java.lang.String> buildArgs) {
            this.props.buildArgs(buildArgs);
            return this;
        }

        /**
         * (experimental) Path to the Dockerfile (relative to the directory).
         * <p>
         * Default: 'Dockerfile'
         * <p>
         * @return {@code this}
         * @param file Path to the Dockerfile (relative to the directory). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder file(final java.lang.String file) {
            this.props.file(file);
            return this;
        }

        /**
         * (experimental) Options to control which parameters are used to invalidate the asset hash.
         * <p>
         * Default: - hash all parameters
         * <p>
         * @return {@code this}
         * @param invalidation Options to control which parameters are used to invalidate the asset hash. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder invalidation(final software.amazon.awscdk.services.ecr.assets.DockerImageAssetInvalidationOptions invalidation) {
            this.props.invalidation(invalidation);
            return this;
        }

        /**
         * (experimental) Networking mode for the RUN commands during build.
         * <p>
         * Support docker API 1.25+.
         * <p>
         * Default: - no networking mode specified (the default networking mode `NetworkMode.DEFAULT` will be used)
         * <p>
         * @return {@code this}
         * @param networkMode Networking mode for the RUN commands during build. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder networkMode(final software.amazon.awscdk.services.ecr.assets.NetworkMode networkMode) {
            this.props.networkMode(networkMode);
            return this;
        }

        /**
         * (experimental) Platform to build for.
         * <p>
         * <em>Requires Docker Buildx</em>.
         * <p>
         * Default: - no platform specified (the current machine architecture will be used)
         * <p>
         * @return {@code this}
         * @param platform Platform to build for. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder platform(final software.amazon.awscdk.services.ecr.assets.Platform platform) {
            this.props.platform(platform);
            return this;
        }

        /**
         * (deprecated) ECR repository name.
         * <p>
         * Specify this property if you need to statically address the image, e.g.
         * from a Kubernetes Pod. Note, this is only the repository name, without the
         * registry and the tag parts.
         * <p>
         * Default: - the default ECR repository for CDK assets
         * <p>
         * @return {@code this}
         * @deprecated to control the location of docker image assets, please override
         * `Stack.addDockerImageAsset`. this feature will be removed in future
         * releases.
         * @param repositoryName ECR repository name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder repositoryName(final java.lang.String repositoryName) {
            this.props.repositoryName(repositoryName);
            return this;
        }

        /**
         * (experimental) Docker target to build to.
         * <p>
         * Default: - no target
         * <p>
         * @return {@code this}
         * @param target Docker target to build to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder target(final java.lang.String target) {
            this.props.target(target);
            return this;
        }

        /**
         * (experimental) The directory where the Dockerfile is stored.
         * <p>
         * Any directory inside with a name that matches the CDK output folder (cdk.out by default) will be excluded from the asset
         * <p>
         * @return {@code this}
         * @param directory The directory where the Dockerfile is stored. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder directory(final java.lang.String directory) {
            this.props.directory(directory);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ecr.assets.DockerImageAsset}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.ecr.assets.DockerImageAsset build() {
            return new software.amazon.awscdk.services.ecr.assets.DockerImageAsset(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
