package software.amazon.awscdk.services.ecs;

/**
 * (experimental) The task launch type compatibility requirement.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * IVpc vpc = Vpc.fromLookup(this, "Vpc", VpcLookupOptions.builder()
 *         .isDefault(true)
 *         .build());
 * Cluster cluster = Cluster.Builder.create(this, "Ec2Cluster").vpc(vpc).build();
 * cluster.addCapacity("DefaultAutoScalingGroup", AddCapacityOptions.builder()
 *         .instanceType(new InstanceType("t2.micro"))
 *         .vpcSubnets(SubnetSelection.builder().subnetType(SubnetType.PUBLIC).build())
 *         .build());
 * TaskDefinition taskDefinition = TaskDefinition.Builder.create(this, "TD")
 *         .compatibility(Compatibility.EC2)
 *         .build();
 * taskDefinition.addContainer("TheContainer", ContainerDefinitionOptions.builder()
 *         .image(ContainerImage.fromRegistry("foo/bar"))
 *         .memoryLimitMiB(256)
 *         .build());
 * EcsRunTask runTask = EcsRunTask.Builder.create(this, "Run")
 *         .integrationPattern(IntegrationPattern.RUN_JOB)
 *         .cluster(cluster)
 *         .taskDefinition(taskDefinition)
 *         .launchTarget(EcsEc2LaunchTarget.Builder.create()
 *                 .placementStrategies(List.of(PlacementStrategy.spreadAcrossInstances(), PlacementStrategy.packedByCpu(), PlacementStrategy.randomly()))
 *                 .placementConstraints(List.of(PlacementConstraint.memberOf("blieptuut")))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:00.324Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_ecs.Compatibility")
public enum Compatibility {
    /**
     * (experimental) The task should specify the EC2 launch type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    EC2,
    /**
     * (experimental) The task should specify the Fargate launch type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    FARGATE,
    /**
     * (experimental) The task can specify either the EC2 or Fargate launch types.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    EC2_AND_FARGATE,
    /**
     * (experimental) The task should specify the External launch type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    EXTERNAL,
}
