package software.amazon.awscdk.services.ecs;

/**
 * (experimental) The details of a task definition run on an EC2 cluster.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Create a Task Definition for the container to start
 * Ec2TaskDefinition taskDefinition = new Ec2TaskDefinition(this, "TaskDef");
 * taskDefinition.addContainer("TheContainer", ContainerDefinitionOptions.builder()
 *         .image(ContainerImage.fromRegistry("example-image"))
 *         .memoryLimitMiB(256)
 *         .logging(LogDrivers.splunk(SplunkLogDriverProps.builder()
 *                 .token(SecretValue.secretsManager("my-splunk-token"))
 *                 .url("my-splunk-url")
 *                 .build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:00.350Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_ecs.Ec2TaskDefinition")
public class Ec2TaskDefinition extends software.amazon.awscdk.services.ecs.TaskDefinition implements software.amazon.awscdk.services.ecs.IEc2TaskDefinition {

    protected Ec2TaskDefinition(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Ec2TaskDefinition(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * (experimental) Constructs a new instance of the Ec2TaskDefinition class.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public Ec2TaskDefinition(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.Ec2TaskDefinitionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * (experimental) Constructs a new instance of the Ec2TaskDefinition class.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public Ec2TaskDefinition(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * (experimental) Imports a task definition from the specified task definition ARN.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param ec2TaskDefinitionArn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.IEc2TaskDefinition fromEc2TaskDefinitionArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String ec2TaskDefinitionArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.Ec2TaskDefinition.class, "fromEc2TaskDefinitionArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.IEc2TaskDefinition.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(ec2TaskDefinitionArn, "ec2TaskDefinitionArn is required") });
    }

    /**
     * (experimental) Imports an existing Ec2 task definition from its attributes.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.IEc2TaskDefinition fromEc2TaskDefinitionAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.Ec2TaskDefinitionAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.Ec2TaskDefinition.class, "fromEc2TaskDefinitionAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.IEc2TaskDefinition.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.ecs.Ec2TaskDefinition}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ecs.Ec2TaskDefinition> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.ecs.Ec2TaskDefinitionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * (experimental) The name of the IAM task execution role that grants the ECS agent permission to call AWS APIs on your behalf.
         * <p>
         * The role will be used to retrieve container images from ECR and create CloudWatch log groups.
         * <p>
         * Default: - An execution role will be automatically created if you use ECR images in your task definition.
         * <p>
         * @return {@code this}
         * @param executionRole The name of the IAM task execution role that grants the ECS agent permission to call AWS APIs on your behalf. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder executionRole(final software.amazon.awscdk.services.iam.IRole executionRole) {
            this.props().executionRole(executionRole);
            return this;
        }

        /**
         * (experimental) The name of a family that this task definition is registered to.
         * <p>
         * A family groups multiple versions of a task definition.
         * <p>
         * Default: - Automatically generated name.
         * <p>
         * @return {@code this}
         * @param family The name of a family that this task definition is registered to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder family(final java.lang.String family) {
            this.props().family(family);
            return this;
        }

        /**
         * (experimental) The configuration details for the App Mesh proxy.
         * <p>
         * Default: - No proxy configuration.
         * <p>
         * @return {@code this}
         * @param proxyConfiguration The configuration details for the App Mesh proxy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder proxyConfiguration(final software.amazon.awscdk.services.ecs.ProxyConfiguration proxyConfiguration) {
            this.props().proxyConfiguration(proxyConfiguration);
            return this;
        }

        /**
         * (experimental) The name of the IAM role that grants containers in the task permission to call AWS APIs on your behalf.
         * <p>
         * Default: - A task role is automatically created for you.
         * <p>
         * @return {@code this}
         * @param taskRole The name of the IAM role that grants containers in the task permission to call AWS APIs on your behalf. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder taskRole(final software.amazon.awscdk.services.iam.IRole taskRole) {
            this.props().taskRole(taskRole);
            return this;
        }

        /**
         * (experimental) The list of volume definitions for the task.
         * <p>
         * For more information, see
         * <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide//task_definition_parameters.html#volumes">Task Definition Parameter Volumes</a>.
         * <p>
         * Default: - No volumes are passed to the Docker daemon on a container instance.
         * <p>
         * @return {@code this}
         * @param volumes The list of volume definitions for the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder volumes(final java.util.List<? extends software.amazon.awscdk.services.ecs.Volume> volumes) {
            this.props().volumes(volumes);
            return this;
        }

        /**
         * (experimental) The inference accelerators to use for the containers in the task.
         * <p>
         * Not supported in Fargate.
         * <p>
         * Default: - No inference accelerators.
         * <p>
         * @return {@code this}
         * @param inferenceAccelerators The inference accelerators to use for the containers in the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder inferenceAccelerators(final java.util.List<? extends software.amazon.awscdk.services.ecs.InferenceAccelerator> inferenceAccelerators) {
            this.props().inferenceAccelerators(inferenceAccelerators);
            return this;
        }

        /**
         * (experimental) The IPC resource namespace to use for the containers in the task.
         * <p>
         * Not supported in Fargate and Windows containers.
         * <p>
         * Default: - IpcMode used by the task is not specified
         * <p>
         * @return {@code this}
         * @param ipcMode The IPC resource namespace to use for the containers in the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder ipcMode(final software.amazon.awscdk.services.ecs.IpcMode ipcMode) {
            this.props().ipcMode(ipcMode);
            return this;
        }

        /**
         * (experimental) The Docker networking mode to use for the containers in the task.
         * <p>
         * The valid values are NONE, BRIDGE, AWS_VPC, and HOST.
         * <p>
         * Default: - NetworkMode.BRIDGE for EC2 tasks, AWS_VPC for Fargate tasks.
         * <p>
         * @return {@code this}
         * @param networkMode The Docker networking mode to use for the containers in the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder networkMode(final software.amazon.awscdk.services.ecs.NetworkMode networkMode) {
            this.props().networkMode(networkMode);
            return this;
        }

        /**
         * (experimental) The process namespace to use for the containers in the task.
         * <p>
         * Not supported in Fargate and Windows containers.
         * <p>
         * Default: - PidMode used by the task is not specified
         * <p>
         * @return {@code this}
         * @param pidMode The process namespace to use for the containers in the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder pidMode(final software.amazon.awscdk.services.ecs.PidMode pidMode) {
            this.props().pidMode(pidMode);
            return this;
        }

        /**
         * (experimental) An array of placement constraint objects to use for the task.
         * <p>
         * You can
         * specify a maximum of 10 constraints per task (this limit includes
         * constraints in the task definition and those specified at run time).
         * <p>
         * Default: - No placement constraints.
         * <p>
         * @return {@code this}
         * @param placementConstraints An array of placement constraint objects to use for the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder placementConstraints(final java.util.List<? extends software.amazon.awscdk.services.ecs.PlacementConstraint> placementConstraints) {
            this.props().placementConstraints(placementConstraints);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ecs.Ec2TaskDefinition}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.ecs.Ec2TaskDefinition build() {
            return new software.amazon.awscdk.services.ecs.Ec2TaskDefinition(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.ecs.Ec2TaskDefinitionProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.ecs.Ec2TaskDefinitionProps.Builder();
            }
            return this.props;
        }
    }
}
