package software.amazon.awscdk.services.ecs;

/**
 * (experimental) Specifies the fluentd log driver configuration options.
 * <p>
 * <a href="https://docs.docker.com/config/containers/logging/fluentd/">Source</a>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.services.ecs.*;
 * Duration duration;
 * FluentdLogDriverProps fluentdLogDriverProps = FluentdLogDriverProps.builder()
 *         .address("address")
 *         .asyncConnect(false)
 *         .bufferLimit(123)
 *         .env(List.of("env"))
 *         .envRegex("envRegex")
 *         .labels(List.of("labels"))
 *         .maxRetries(123)
 *         .retryWait(duration)
 *         .subSecondPrecision(false)
 *         .tag("tag")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:00.420Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_ecs.FluentdLogDriverProps")
@software.amazon.jsii.Jsii.Proxy(FluentdLogDriverProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface FluentdLogDriverProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.ecs.BaseLogDriverProps {

    /**
     * (experimental) By default, the logging driver connects to localhost:24224.
     * <p>
     * Supply the
     * address option to connect to a different address. tcp(default) and unix
     * sockets are supported.
     * <p>
     * Default: - address not set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getAddress() {
        return null;
    }

    /**
     * (experimental) Docker connects to Fluentd in the background.
     * <p>
     * Messages are buffered until
     * the connection is established.
     * <p>
     * Default: - false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAsyncConnect() {
        return null;
    }

    /**
     * (experimental) The amount of data to buffer before flushing to disk.
     * <p>
     * Default: - The amount of RAM available to the container.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getBufferLimit() {
        return null;
    }

    /**
     * (experimental) The maximum number of retries.
     * <p>
     * Default: - 4294967295 (2**32 - 1).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxRetries() {
        return null;
    }

    /**
     * (experimental) How long to wait between retries.
     * <p>
     * Default: - 1 second
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getRetryWait() {
        return null;
    }

    /**
     * (experimental) Generates event logs in nanosecond resolution.
     * <p>
     * Default: - false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getSubSecondPrecision() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link FluentdLogDriverProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FluentdLogDriverProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<FluentdLogDriverProps> {
        java.lang.String address;
        java.lang.Boolean asyncConnect;
        java.lang.Number bufferLimit;
        java.lang.Number maxRetries;
        software.amazon.awscdk.core.Duration retryWait;
        java.lang.Boolean subSecondPrecision;
        java.util.List<java.lang.String> env;
        java.lang.String envRegex;
        java.util.List<java.lang.String> labels;
        java.lang.String tag;

        /**
         * Sets the value of {@link FluentdLogDriverProps#getAddress}
         * @param address By default, the logging driver connects to localhost:24224.
         *                Supply the
         *                address option to connect to a different address. tcp(default) and unix
         *                sockets are supported.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder address(java.lang.String address) {
            this.address = address;
            return this;
        }

        /**
         * Sets the value of {@link FluentdLogDriverProps#getAsyncConnect}
         * @param asyncConnect Docker connects to Fluentd in the background.
         *                     Messages are buffered until
         *                     the connection is established.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder asyncConnect(java.lang.Boolean asyncConnect) {
            this.asyncConnect = asyncConnect;
            return this;
        }

        /**
         * Sets the value of {@link FluentdLogDriverProps#getBufferLimit}
         * @param bufferLimit The amount of data to buffer before flushing to disk.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder bufferLimit(java.lang.Number bufferLimit) {
            this.bufferLimit = bufferLimit;
            return this;
        }

        /**
         * Sets the value of {@link FluentdLogDriverProps#getMaxRetries}
         * @param maxRetries The maximum number of retries.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder maxRetries(java.lang.Number maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        /**
         * Sets the value of {@link FluentdLogDriverProps#getRetryWait}
         * @param retryWait How long to wait between retries.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder retryWait(software.amazon.awscdk.core.Duration retryWait) {
            this.retryWait = retryWait;
            return this;
        }

        /**
         * Sets the value of {@link FluentdLogDriverProps#getSubSecondPrecision}
         * @param subSecondPrecision Generates event logs in nanosecond resolution.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder subSecondPrecision(java.lang.Boolean subSecondPrecision) {
            this.subSecondPrecision = subSecondPrecision;
            return this;
        }

        /**
         * Sets the value of {@link FluentdLogDriverProps#getEnv}
         * @param env The env option takes an array of keys.
         *            If there is collision between
         *            label and env keys, the value of the env takes precedence. Adds additional fields
         *            to the extra attributes of a logging message.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder env(java.util.List<java.lang.String> env) {
            this.env = env;
            return this;
        }

        /**
         * Sets the value of {@link FluentdLogDriverProps#getEnvRegex}
         * @param envRegex The env-regex option is similar to and compatible with env.
         *                 Its value is a regular
         *                 expression to match logging-related environment variables. It is used for advanced
         *                 log tag options.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder envRegex(java.lang.String envRegex) {
            this.envRegex = envRegex;
            return this;
        }

        /**
         * Sets the value of {@link FluentdLogDriverProps#getLabels}
         * @param labels The labels option takes an array of keys.
         *               If there is collision
         *               between label and env keys, the value of the env takes precedence. Adds additional
         *               fields to the extra attributes of a logging message.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder labels(java.util.List<java.lang.String> labels) {
            this.labels = labels;
            return this;
        }

        /**
         * Sets the value of {@link FluentdLogDriverProps#getTag}
         * @param tag By default, Docker uses the first 12 characters of the container ID to tag log messages.
         *            Refer to the log tag option documentation for customizing the
         *            log tag format.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder tag(java.lang.String tag) {
            this.tag = tag;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FluentdLogDriverProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public FluentdLogDriverProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link FluentdLogDriverProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FluentdLogDriverProps {
        private final java.lang.String address;
        private final java.lang.Boolean asyncConnect;
        private final java.lang.Number bufferLimit;
        private final java.lang.Number maxRetries;
        private final software.amazon.awscdk.core.Duration retryWait;
        private final java.lang.Boolean subSecondPrecision;
        private final java.util.List<java.lang.String> env;
        private final java.lang.String envRegex;
        private final java.util.List<java.lang.String> labels;
        private final java.lang.String tag;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.address = software.amazon.jsii.Kernel.get(this, "address", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.asyncConnect = software.amazon.jsii.Kernel.get(this, "asyncConnect", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.bufferLimit = software.amazon.jsii.Kernel.get(this, "bufferLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.maxRetries = software.amazon.jsii.Kernel.get(this, "maxRetries", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.retryWait = software.amazon.jsii.Kernel.get(this, "retryWait", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
            this.subSecondPrecision = software.amazon.jsii.Kernel.get(this, "subSecondPrecision", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.env = software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.envRegex = software.amazon.jsii.Kernel.get(this, "envRegex", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.labels = software.amazon.jsii.Kernel.get(this, "labels", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.tag = software.amazon.jsii.Kernel.get(this, "tag", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.address = builder.address;
            this.asyncConnect = builder.asyncConnect;
            this.bufferLimit = builder.bufferLimit;
            this.maxRetries = builder.maxRetries;
            this.retryWait = builder.retryWait;
            this.subSecondPrecision = builder.subSecondPrecision;
            this.env = builder.env;
            this.envRegex = builder.envRegex;
            this.labels = builder.labels;
            this.tag = builder.tag;
        }

        @Override
        public final java.lang.String getAddress() {
            return this.address;
        }

        @Override
        public final java.lang.Boolean getAsyncConnect() {
            return this.asyncConnect;
        }

        @Override
        public final java.lang.Number getBufferLimit() {
            return this.bufferLimit;
        }

        @Override
        public final java.lang.Number getMaxRetries() {
            return this.maxRetries;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getRetryWait() {
            return this.retryWait;
        }

        @Override
        public final java.lang.Boolean getSubSecondPrecision() {
            return this.subSecondPrecision;
        }

        @Override
        public final java.util.List<java.lang.String> getEnv() {
            return this.env;
        }

        @Override
        public final java.lang.String getEnvRegex() {
            return this.envRegex;
        }

        @Override
        public final java.util.List<java.lang.String> getLabels() {
            return this.labels;
        }

        @Override
        public final java.lang.String getTag() {
            return this.tag;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAddress() != null) {
                data.set("address", om.valueToTree(this.getAddress()));
            }
            if (this.getAsyncConnect() != null) {
                data.set("asyncConnect", om.valueToTree(this.getAsyncConnect()));
            }
            if (this.getBufferLimit() != null) {
                data.set("bufferLimit", om.valueToTree(this.getBufferLimit()));
            }
            if (this.getMaxRetries() != null) {
                data.set("maxRetries", om.valueToTree(this.getMaxRetries()));
            }
            if (this.getRetryWait() != null) {
                data.set("retryWait", om.valueToTree(this.getRetryWait()));
            }
            if (this.getSubSecondPrecision() != null) {
                data.set("subSecondPrecision", om.valueToTree(this.getSubSecondPrecision()));
            }
            if (this.getEnv() != null) {
                data.set("env", om.valueToTree(this.getEnv()));
            }
            if (this.getEnvRegex() != null) {
                data.set("envRegex", om.valueToTree(this.getEnvRegex()));
            }
            if (this.getLabels() != null) {
                data.set("labels", om.valueToTree(this.getLabels()));
            }
            if (this.getTag() != null) {
                data.set("tag", om.valueToTree(this.getTag()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_ecs.FluentdLogDriverProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FluentdLogDriverProps.Jsii$Proxy that = (FluentdLogDriverProps.Jsii$Proxy) o;

            if (this.address != null ? !this.address.equals(that.address) : that.address != null) return false;
            if (this.asyncConnect != null ? !this.asyncConnect.equals(that.asyncConnect) : that.asyncConnect != null) return false;
            if (this.bufferLimit != null ? !this.bufferLimit.equals(that.bufferLimit) : that.bufferLimit != null) return false;
            if (this.maxRetries != null ? !this.maxRetries.equals(that.maxRetries) : that.maxRetries != null) return false;
            if (this.retryWait != null ? !this.retryWait.equals(that.retryWait) : that.retryWait != null) return false;
            if (this.subSecondPrecision != null ? !this.subSecondPrecision.equals(that.subSecondPrecision) : that.subSecondPrecision != null) return false;
            if (this.env != null ? !this.env.equals(that.env) : that.env != null) return false;
            if (this.envRegex != null ? !this.envRegex.equals(that.envRegex) : that.envRegex != null) return false;
            if (this.labels != null ? !this.labels.equals(that.labels) : that.labels != null) return false;
            return this.tag != null ? this.tag.equals(that.tag) : that.tag == null;
        }

        @Override
        public final int hashCode() {
            int result = this.address != null ? this.address.hashCode() : 0;
            result = 31 * result + (this.asyncConnect != null ? this.asyncConnect.hashCode() : 0);
            result = 31 * result + (this.bufferLimit != null ? this.bufferLimit.hashCode() : 0);
            result = 31 * result + (this.maxRetries != null ? this.maxRetries.hashCode() : 0);
            result = 31 * result + (this.retryWait != null ? this.retryWait.hashCode() : 0);
            result = 31 * result + (this.subSecondPrecision != null ? this.subSecondPrecision.hashCode() : 0);
            result = 31 * result + (this.env != null ? this.env.hashCode() : 0);
            result = 31 * result + (this.envRegex != null ? this.envRegex.hashCode() : 0);
            result = 31 * result + (this.labels != null ? this.labels.hashCode() : 0);
            result = 31 * result + (this.tag != null ? this.tag.hashCode() : 0);
            return result;
        }
    }
}
