package software.amazon.awscdk.services.ecs;

/**
 * (experimental) The details of data volume mount points for a container.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ecs.*;
 * MountPoint mountPoint = MountPoint.builder()
 *         .containerPath("containerPath")
 *         .readOnly(false)
 *         .sourceVolume("sourceVolume")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:00.467Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_ecs.MountPoint")
@software.amazon.jsii.Jsii.Proxy(MountPoint.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface MountPoint extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The path on the container to mount the host volume at.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getContainerPath();

    /**
     * (experimental) Specifies whether to give the container read-only access to the volume.
     * <p>
     * If this value is true, the container has read-only access to the volume.
     * If this value is false, then the container can write to the volume.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.Boolean getReadOnly();

    /**
     * (experimental) The name of the volume to mount.
     * <p>
     * Must be a volume name referenced in the name parameter of task definition volume.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getSourceVolume();

    /**
     * @return a {@link Builder} of {@link MountPoint}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link MountPoint}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<MountPoint> {
        java.lang.String containerPath;
        java.lang.Boolean readOnly;
        java.lang.String sourceVolume;

        /**
         * Sets the value of {@link MountPoint#getContainerPath}
         * @param containerPath The path on the container to mount the host volume at. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder containerPath(java.lang.String containerPath) {
            this.containerPath = containerPath;
            return this;
        }

        /**
         * Sets the value of {@link MountPoint#getReadOnly}
         * @param readOnly Specifies whether to give the container read-only access to the volume. This parameter is required.
         *                 If this value is true, the container has read-only access to the volume.
         *                 If this value is false, then the container can write to the volume.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder readOnly(java.lang.Boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        /**
         * Sets the value of {@link MountPoint#getSourceVolume}
         * @param sourceVolume The name of the volume to mount. This parameter is required.
         *                     Must be a volume name referenced in the name parameter of task definition volume.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder sourceVolume(java.lang.String sourceVolume) {
            this.sourceVolume = sourceVolume;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link MountPoint}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public MountPoint build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link MountPoint}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MountPoint {
        private final java.lang.String containerPath;
        private final java.lang.Boolean readOnly;
        private final java.lang.String sourceVolume;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.containerPath = software.amazon.jsii.Kernel.get(this, "containerPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.readOnly = software.amazon.jsii.Kernel.get(this, "readOnly", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.sourceVolume = software.amazon.jsii.Kernel.get(this, "sourceVolume", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.containerPath = java.util.Objects.requireNonNull(builder.containerPath, "containerPath is required");
            this.readOnly = java.util.Objects.requireNonNull(builder.readOnly, "readOnly is required");
            this.sourceVolume = java.util.Objects.requireNonNull(builder.sourceVolume, "sourceVolume is required");
        }

        @Override
        public final java.lang.String getContainerPath() {
            return this.containerPath;
        }

        @Override
        public final java.lang.Boolean getReadOnly() {
            return this.readOnly;
        }

        @Override
        public final java.lang.String getSourceVolume() {
            return this.sourceVolume;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("containerPath", om.valueToTree(this.getContainerPath()));
            data.set("readOnly", om.valueToTree(this.getReadOnly()));
            data.set("sourceVolume", om.valueToTree(this.getSourceVolume()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_ecs.MountPoint"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            MountPoint.Jsii$Proxy that = (MountPoint.Jsii$Proxy) o;

            if (!containerPath.equals(that.containerPath)) return false;
            if (!readOnly.equals(that.readOnly)) return false;
            return this.sourceVolume.equals(that.sourceVolume);
        }

        @Override
        public final int hashCode() {
            int result = this.containerPath.hashCode();
            result = 31 * result + (this.readOnly.hashCode());
            result = 31 * result + (this.sourceVolume.hashCode());
            return result;
        }
    }
}
