package software.amazon.awscdk.services.ecs;

/**
 * (experimental) The placement strategies to use for tasks in the service. For more information, see [Amazon ECS Task Placement Strategies](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-strategies.html).
 * <p>
 * Tasks will preferentially be placed on instances that match these rules.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * IVpc vpc = Vpc.fromLookup(this, "Vpc", VpcLookupOptions.builder()
 *         .isDefault(true)
 *         .build());
 * Cluster cluster = Cluster.Builder.create(this, "Ec2Cluster").vpc(vpc).build();
 * cluster.addCapacity("DefaultAutoScalingGroup", AddCapacityOptions.builder()
 *         .instanceType(new InstanceType("t2.micro"))
 *         .vpcSubnets(SubnetSelection.builder().subnetType(SubnetType.PUBLIC).build())
 *         .build());
 * TaskDefinition taskDefinition = TaskDefinition.Builder.create(this, "TD")
 *         .compatibility(Compatibility.EC2)
 *         .build();
 * taskDefinition.addContainer("TheContainer", ContainerDefinitionOptions.builder()
 *         .image(ContainerImage.fromRegistry("foo/bar"))
 *         .memoryLimitMiB(256)
 *         .build());
 * EcsRunTask runTask = EcsRunTask.Builder.create(this, "Run")
 *         .integrationPattern(IntegrationPattern.RUN_JOB)
 *         .cluster(cluster)
 *         .taskDefinition(taskDefinition)
 *         .launchTarget(EcsEc2LaunchTarget.Builder.create()
 *                 .placementStrategies(List.of(PlacementStrategy.spreadAcrossInstances(), PlacementStrategy.packedByCpu(), PlacementStrategy.randomly()))
 *                 .placementConstraints(List.of(PlacementConstraint.memberOf("blieptuut")))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:00.472Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_ecs.PlacementStrategy")
public class PlacementStrategy extends software.amazon.jsii.JsiiObject {

    protected PlacementStrategy(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected PlacementStrategy(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * (experimental) Places tasks on the container instances with the least available capacity of the specified resource.
     * <p>
     * @param resource This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.PlacementStrategy packedBy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.BinPackResource resource) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.PlacementStrategy.class, "packedBy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.PlacementStrategy.class), new Object[] { java.util.Objects.requireNonNull(resource, "resource is required") });
    }

    /**
     * (experimental) Places tasks on container instances with the least available amount of CPU capacity.
     * <p>
     * This minimizes the number of instances in use.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.PlacementStrategy packedByCpu() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.PlacementStrategy.class, "packedByCpu", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.PlacementStrategy.class));
    }

    /**
     * (experimental) Places tasks on container instances with the least available amount of memory capacity.
     * <p>
     * This minimizes the number of instances in use.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.PlacementStrategy packedByMemory() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.PlacementStrategy.class, "packedByMemory", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.PlacementStrategy.class));
    }

    /**
     * (experimental) Places tasks randomly.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.PlacementStrategy randomly() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.PlacementStrategy.class, "randomly", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.PlacementStrategy.class));
    }

    /**
     * (experimental) Places tasks evenly based on the specified value.
     * <p>
     * You can use one of the built-in attributes found on <code>BuiltInAttributes</code>
     * or supply your own custom instance attributes. If more than one attribute
     * is supplied, spreading is done in order.
     * <p>
     * Default: attributes instanceId
     * <p>
     * @param fields This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.PlacementStrategy spreadAcross(final @org.jetbrains.annotations.NotNull java.lang.String... fields) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.PlacementStrategy.class, "spreadAcross", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.PlacementStrategy.class), java.util.Arrays.<Object>stream(fields).toArray(Object[]::new));
    }

    /**
     * (experimental) Places tasks evenly across all container instances in the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.PlacementStrategy spreadAcrossInstances() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.PlacementStrategy.class, "spreadAcrossInstances", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.PlacementStrategy.class));
    }

    /**
     * (experimental) Return the placement JSON.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.ecs.CfnService.PlacementStrategyProperty> toJson() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "toJson", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.CfnService.PlacementStrategyProperty.class))));
    }
}
