package software.amazon.awscdk.services.ecs;

/**
 * (experimental) An image hosted in a public or private repository.
 * <p>
 * For images hosted in Amazon ECR, see
 * <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/images.html">EcrImage</a>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ecr.assets.*;
 * import software.amazon.awscdk.services.ecs.*;
 * DockerImageAsset dockerImageAsset;
 * ContainerImage repositoryImage = RepositoryImage.fromDockerImageAsset(dockerImageAsset);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:00.476Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_ecs.RepositoryImage")
public class RepositoryImage extends software.amazon.awscdk.services.ecs.ContainerImage {

    protected RepositoryImage(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected RepositoryImage(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * (experimental) Constructs a new instance of the RepositoryImage class.
     * <p>
     * @param imageName This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public RepositoryImage(final @org.jetbrains.annotations.NotNull java.lang.String imageName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.RepositoryImageProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(imageName, "imageName is required"), props });
    }

    /**
     * (experimental) Constructs a new instance of the RepositoryImage class.
     * <p>
     * @param imageName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public RepositoryImage(final @org.jetbrains.annotations.NotNull java.lang.String imageName) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(imageName, "imageName is required") });
    }

    /**
     * (experimental) Called when the image is used by a ContainerDefinition.
     * <p>
     * @param scope This parameter is required.
     * @param containerDefinition This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ContainerImageConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ContainerDefinition containerDefinition) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ContainerImageConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(containerDefinition, "containerDefinition is required") });
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.ecs.RepositoryImage}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ecs.RepositoryImage> {
        /**
         * @return a new instance of {@link Builder}.
         * @param imageName This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final java.lang.String imageName) {
            return new Builder(imageName);
        }

        private final java.lang.String imageName;
        private software.amazon.awscdk.services.ecs.RepositoryImageProps.Builder props;

        private Builder(final java.lang.String imageName) {
            this.imageName = imageName;
        }

        /**
         * (experimental) The secret to expose to the container that contains the credentials for the image repository.
         * <p>
         * The supported value is the full ARN of an AWS Secrets Manager secret.
         * <p>
         * @return {@code this}
         * @param credentials The secret to expose to the container that contains the credentials for the image repository. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder credentials(final software.amazon.awscdk.services.secretsmanager.ISecret credentials) {
            this.props().credentials(credentials);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ecs.RepositoryImage}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.ecs.RepositoryImage build() {
            return new software.amazon.awscdk.services.ecs.RepositoryImage(
                this.imageName,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.ecs.RepositoryImageProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.ecs.RepositoryImageProps.Builder();
            }
            return this.props;
        }
    }
}
