package software.amazon.awscdk.services.efs;

/**
 * Properties for defining a `CfnFileSystem`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.efs.*;
 * Object fileSystemPolicy;
 * CfnFileSystemProps cfnFileSystemProps = CfnFileSystemProps.builder()
 *         .availabilityZoneName("availabilityZoneName")
 *         .backupPolicy(BackupPolicyProperty.builder()
 *                 .status("status")
 *                 .build())
 *         .bypassPolicyLockoutSafetyCheck(false)
 *         .encrypted(false)
 *         .fileSystemPolicy(fileSystemPolicy)
 *         .fileSystemTags(List.of(ElasticFileSystemTagProperty.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .kmsKeyId("kmsKeyId")
 *         .lifecyclePolicies(List.of(LifecyclePolicyProperty.builder()
 *                 .transitionToIa("transitionToIa")
 *                 .transitionToPrimaryStorageClass("transitionToPrimaryStorageClass")
 *                 .build()))
 *         .performanceMode("performanceMode")
 *         .provisionedThroughputInMibps(123)
 *         .throughputMode("throughputMode")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:00.713Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_efs.CfnFileSystemProps")
@software.amazon.jsii.Jsii.Proxy(CfnFileSystemProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnFileSystemProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Used to create a file system that uses One Zone storage classes.
     * <p>
     * It specifies the AWS Availability Zone in which to create the file system. Use the format <code>us-east-1a</code> to specify the Availability Zone. For more information about One Zone storage classes, see <a href="https://docs.aws.amazon.com/efs/latest/ug/storage-classes.html">Using EFS storage classes</a> in the <em>Amazon EFS User Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * One Zone storage classes are not available in all Availability Zones in AWS Regions where Amazon EFS is available.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZoneName() {
        return null;
    }

    /**
     * Use the `BackupPolicy` to turn automatic backups on or off for the file system.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getBackupPolicy() {
        return null;
    }

    /**
     * (Optional) A boolean that specifies whether or not to bypass the `FileSystemPolicy` lockout safety check.
     * <p>
     * The lockout safety check determines whether the policy in the request will lock out, or prevent, the IAM principal that is making the request from making future <code>PutFileSystemPolicy</code> requests on this file system. Set <code>BypassPolicyLockoutSafetyCheck</code> to <code>True</code> only when you intend to prevent the IAM principal that is making the request from making subsequent <code>PutFileSystemPolicy</code> requests on this file system. The default value is <code>False</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getBypassPolicyLockoutSafetyCheck() {
        return null;
    }

    /**
     * A Boolean value that, if true, creates an encrypted file system.
     * <p>
     * When creating an encrypted file system, you have the option of specifying a KmsKeyId for an existing AWS KMS key . If you don't specify a KMS key , then the default KMS key for Amazon EFS , <code>/aws/elasticfilesystem</code> , is used to protect the encrypted file system.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEncrypted() {
        return null;
    }

    /**
     * The `FileSystemPolicy` for the EFS file system.
     * <p>
     * A file system policy is an IAM resource policy used to control NFS access to an EFS file system. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/iam-access-control-nfs-efs.html">Using IAM to control NFS access to Amazon EFS</a> in the <em>Amazon EFS User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getFileSystemPolicy() {
        return null;
    }

    /**
     * Use to create one or more tags associated with the file system.
     * <p>
     * Each tag is a user-defined key-value pair. Name your file system on creation by including a <code>"Key":"Name","Value":"{value}"</code> key-value pair. Each key must be unique. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS resources</a> in the <em>AWS General Reference Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.efs.CfnFileSystem.ElasticFileSystemTagProperty> getFileSystemTags() {
        return null;
    }

    /**
     * The ID of the AWS KMS key to be used to protect the encrypted file system.
     * <p>
     * This parameter is only required if you want to use a nondefault KMS key . If this parameter is not specified, the default KMS key for Amazon EFS is used. This ID can be in one of the following formats:
     * <p>
     * <ul>
     * <li>Key ID - A unique identifier of the key, for example <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> .</li>
     * <li>ARN - An Amazon Resource Name (ARN) for the key, for example <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> .</li>
     * <li>Key alias - A previously created display name for a key, for example <code>alias/projectKey1</code> .</li>
     * <li>Key alias ARN - An ARN for a key alias, for example <code>arn:aws:kms:us-west-2:444455556666:alias/projectKey1</code> .</li>
     * </ul>
     * <p>
     * If <code>KmsKeyId</code> is specified, the <code>Encrypted</code> parameter must be set to true.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return null;
    }

    /**
     * An array of `LifecyclePolicy` objects that define the file system's `LifecycleConfiguration` object.
     * <p>
     * A <code>LifecycleConfiguration</code> object informs EFS lifecycle management and intelligent tiering of the following:
     * <p>
     * <ul>
     * <li>When to move files in the file system from primary storage to the IA storage class.</li>
     * <li>When to move files that are in IA storage to primary storage.</li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * Amazon EFS requires that each <code>LifecyclePolicy</code> object have only a single transition. This means that in a request body, <code>LifecyclePolicies</code> needs to be structured as an array of <code>LifecyclePolicy</code> objects, one object for each transition, <code>TransitionToIA</code> , <code>TransitionToPrimaryStorageClass</code> . See the example requests in the following section for more information.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLifecyclePolicies() {
        return null;
    }

    /**
     * The performance mode of the file system.
     * <p>
     * We recommend <code>generalPurpose</code> performance mode for most file systems. File systems using the <code>maxIO</code> performance mode can scale to higher levels of aggregate throughput and operations per second with a tradeoff of slightly higher latencies for most file operations. The performance mode can't be changed after the file system has been created.
     * <p>
     * <blockquote>
     * <p>
     * The <code>maxIO</code> mode is not supported on file systems using One Zone storage classes.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPerformanceMode() {
        return null;
    }

    /**
     * The throughput, measured in MiB/s, that you want to provision for a file system that you're creating.
     * <p>
     * Valid values are 1-1024. Required if <code>ThroughputMode</code> is set to <code>provisioned</code> . The upper limit for throughput is 1024 MiB/s. To increase this limit, contact AWS Support . For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/limits.html#soft-limits">Amazon EFS quotas that you can increase</a> in the <em>Amazon EFS User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getProvisionedThroughputInMibps() {
        return null;
    }

    /**
     * Specifies the throughput mode for the file system.
     * <p>
     * The mode can be <code>bursting</code> , <code>provisioned</code> , or <code>elastic</code> . If you set <code>ThroughputMode</code> to <code>provisioned</code> , you must also set a value for <code>ProvisionedThroughputInMibps</code> . After you create the file system, you can decrease your file system's throughput in Provisioned Throughput mode or change between the throughput modes, with certain time restrictions. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/performance.html#provisioned-throughput">Specifying throughput with provisioned mode</a> in the <em>Amazon EFS User Guide</em> .
     * <p>
     * Default is <code>bursting</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getThroughputMode() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnFileSystemProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnFileSystemProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnFileSystemProps> {
        java.lang.String availabilityZoneName;
        java.lang.Object backupPolicy;
        java.lang.Object bypassPolicyLockoutSafetyCheck;
        java.lang.Object encrypted;
        java.lang.Object fileSystemPolicy;
        java.util.List<software.amazon.awscdk.services.efs.CfnFileSystem.ElasticFileSystemTagProperty> fileSystemTags;
        java.lang.String kmsKeyId;
        java.lang.Object lifecyclePolicies;
        java.lang.String performanceMode;
        java.lang.Number provisionedThroughputInMibps;
        java.lang.String throughputMode;

        /**
         * Sets the value of {@link CfnFileSystemProps#getAvailabilityZoneName}
         * @param availabilityZoneName Used to create a file system that uses One Zone storage classes.
         *                             It specifies the AWS Availability Zone in which to create the file system. Use the format <code>us-east-1a</code> to specify the Availability Zone. For more information about One Zone storage classes, see <a href="https://docs.aws.amazon.com/efs/latest/ug/storage-classes.html">Using EFS storage classes</a> in the <em>Amazon EFS User Guide</em> .
         *                             <p>
         *                             <blockquote>
         *                             <p>
         *                             One Zone storage classes are not available in all Availability Zones in AWS Regions where Amazon EFS is available.
         *                             <p>
         *                             </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZoneName(java.lang.String availabilityZoneName) {
            this.availabilityZoneName = availabilityZoneName;
            return this;
        }

        /**
         * Sets the value of {@link CfnFileSystemProps#getBackupPolicy}
         * @param backupPolicy Use the `BackupPolicy` to turn automatic backups on or off for the file system.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backupPolicy(software.amazon.awscdk.services.efs.CfnFileSystem.BackupPolicyProperty backupPolicy) {
            this.backupPolicy = backupPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnFileSystemProps#getBackupPolicy}
         * @param backupPolicy Use the `BackupPolicy` to turn automatic backups on or off for the file system.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backupPolicy(software.amazon.awscdk.core.IResolvable backupPolicy) {
            this.backupPolicy = backupPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnFileSystemProps#getBypassPolicyLockoutSafetyCheck}
         * @param bypassPolicyLockoutSafetyCheck (Optional) A boolean that specifies whether or not to bypass the `FileSystemPolicy` lockout safety check.
         *                                       The lockout safety check determines whether the policy in the request will lock out, or prevent, the IAM principal that is making the request from making future <code>PutFileSystemPolicy</code> requests on this file system. Set <code>BypassPolicyLockoutSafetyCheck</code> to <code>True</code> only when you intend to prevent the IAM principal that is making the request from making subsequent <code>PutFileSystemPolicy</code> requests on this file system. The default value is <code>False</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bypassPolicyLockoutSafetyCheck(java.lang.Boolean bypassPolicyLockoutSafetyCheck) {
            this.bypassPolicyLockoutSafetyCheck = bypassPolicyLockoutSafetyCheck;
            return this;
        }

        /**
         * Sets the value of {@link CfnFileSystemProps#getBypassPolicyLockoutSafetyCheck}
         * @param bypassPolicyLockoutSafetyCheck (Optional) A boolean that specifies whether or not to bypass the `FileSystemPolicy` lockout safety check.
         *                                       The lockout safety check determines whether the policy in the request will lock out, or prevent, the IAM principal that is making the request from making future <code>PutFileSystemPolicy</code> requests on this file system. Set <code>BypassPolicyLockoutSafetyCheck</code> to <code>True</code> only when you intend to prevent the IAM principal that is making the request from making subsequent <code>PutFileSystemPolicy</code> requests on this file system. The default value is <code>False</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bypassPolicyLockoutSafetyCheck(software.amazon.awscdk.core.IResolvable bypassPolicyLockoutSafetyCheck) {
            this.bypassPolicyLockoutSafetyCheck = bypassPolicyLockoutSafetyCheck;
            return this;
        }

        /**
         * Sets the value of {@link CfnFileSystemProps#getEncrypted}
         * @param encrypted A Boolean value that, if true, creates an encrypted file system.
         *                  When creating an encrypted file system, you have the option of specifying a KmsKeyId for an existing AWS KMS key . If you don't specify a KMS key , then the default KMS key for Amazon EFS , <code>/aws/elasticfilesystem</code> , is used to protect the encrypted file system.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encrypted(java.lang.Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        /**
         * Sets the value of {@link CfnFileSystemProps#getEncrypted}
         * @param encrypted A Boolean value that, if true, creates an encrypted file system.
         *                  When creating an encrypted file system, you have the option of specifying a KmsKeyId for an existing AWS KMS key . If you don't specify a KMS key , then the default KMS key for Amazon EFS , <code>/aws/elasticfilesystem</code> , is used to protect the encrypted file system.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encrypted(software.amazon.awscdk.core.IResolvable encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        /**
         * Sets the value of {@link CfnFileSystemProps#getFileSystemPolicy}
         * @param fileSystemPolicy The `FileSystemPolicy` for the EFS file system.
         *                         A file system policy is an IAM resource policy used to control NFS access to an EFS file system. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/iam-access-control-nfs-efs.html">Using IAM to control NFS access to Amazon EFS</a> in the <em>Amazon EFS User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileSystemPolicy(java.lang.Object fileSystemPolicy) {
            this.fileSystemPolicy = fileSystemPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnFileSystemProps#getFileSystemTags}
         * @param fileSystemTags Use to create one or more tags associated with the file system.
         *                       Each tag is a user-defined key-value pair. Name your file system on creation by including a <code>"Key":"Name","Value":"{value}"</code> key-value pair. Each key must be unique. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS resources</a> in the <em>AWS General Reference Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder fileSystemTags(java.util.List<? extends software.amazon.awscdk.services.efs.CfnFileSystem.ElasticFileSystemTagProperty> fileSystemTags) {
            this.fileSystemTags = (java.util.List<software.amazon.awscdk.services.efs.CfnFileSystem.ElasticFileSystemTagProperty>)fileSystemTags;
            return this;
        }

        /**
         * Sets the value of {@link CfnFileSystemProps#getKmsKeyId}
         * @param kmsKeyId The ID of the AWS KMS key to be used to protect the encrypted file system.
         *                 This parameter is only required if you want to use a nondefault KMS key . If this parameter is not specified, the default KMS key for Amazon EFS is used. This ID can be in one of the following formats:
         *                 <p>
         *                 <ul>
         *                 <li>Key ID - A unique identifier of the key, for example <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> .</li>
         *                 <li>ARN - An Amazon Resource Name (ARN) for the key, for example <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> .</li>
         *                 <li>Key alias - A previously created display name for a key, for example <code>alias/projectKey1</code> .</li>
         *                 <li>Key alias ARN - An ARN for a key alias, for example <code>arn:aws:kms:us-west-2:444455556666:alias/projectKey1</code> .</li>
         *                 </ul>
         *                 <p>
         *                 If <code>KmsKeyId</code> is specified, the <code>Encrypted</code> parameter must be set to true.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(java.lang.String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        /**
         * Sets the value of {@link CfnFileSystemProps#getLifecyclePolicies}
         * @param lifecyclePolicies An array of `LifecyclePolicy` objects that define the file system's `LifecycleConfiguration` object.
         *                          A <code>LifecycleConfiguration</code> object informs EFS lifecycle management and intelligent tiering of the following:
         *                          <p>
         *                          <ul>
         *                          <li>When to move files in the file system from primary storage to the IA storage class.</li>
         *                          <li>When to move files that are in IA storage to primary storage.</li>
         *                          </ul>
         *                          <p>
         *                          <blockquote>
         *                          <p>
         *                          Amazon EFS requires that each <code>LifecyclePolicy</code> object have only a single transition. This means that in a request body, <code>LifecyclePolicies</code> needs to be structured as an array of <code>LifecyclePolicy</code> objects, one object for each transition, <code>TransitionToIA</code> , <code>TransitionToPrimaryStorageClass</code> . See the example requests in the following section for more information.
         *                          <p>
         *                          </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lifecyclePolicies(software.amazon.awscdk.core.IResolvable lifecyclePolicies) {
            this.lifecyclePolicies = lifecyclePolicies;
            return this;
        }

        /**
         * Sets the value of {@link CfnFileSystemProps#getLifecyclePolicies}
         * @param lifecyclePolicies An array of `LifecyclePolicy` objects that define the file system's `LifecycleConfiguration` object.
         *                          A <code>LifecycleConfiguration</code> object informs EFS lifecycle management and intelligent tiering of the following:
         *                          <p>
         *                          <ul>
         *                          <li>When to move files in the file system from primary storage to the IA storage class.</li>
         *                          <li>When to move files that are in IA storage to primary storage.</li>
         *                          </ul>
         *                          <p>
         *                          <blockquote>
         *                          <p>
         *                          Amazon EFS requires that each <code>LifecyclePolicy</code> object have only a single transition. This means that in a request body, <code>LifecyclePolicies</code> needs to be structured as an array of <code>LifecyclePolicy</code> objects, one object for each transition, <code>TransitionToIA</code> , <code>TransitionToPrimaryStorageClass</code> . See the example requests in the following section for more information.
         *                          <p>
         *                          </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lifecyclePolicies(java.util.List<? extends java.lang.Object> lifecyclePolicies) {
            this.lifecyclePolicies = lifecyclePolicies;
            return this;
        }

        /**
         * Sets the value of {@link CfnFileSystemProps#getPerformanceMode}
         * @param performanceMode The performance mode of the file system.
         *                        We recommend <code>generalPurpose</code> performance mode for most file systems. File systems using the <code>maxIO</code> performance mode can scale to higher levels of aggregate throughput and operations per second with a tradeoff of slightly higher latencies for most file operations. The performance mode can't be changed after the file system has been created.
         *                        <p>
         *                        <blockquote>
         *                        <p>
         *                        The <code>maxIO</code> mode is not supported on file systems using One Zone storage classes.
         *                        <p>
         *                        </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder performanceMode(java.lang.String performanceMode) {
            this.performanceMode = performanceMode;
            return this;
        }

        /**
         * Sets the value of {@link CfnFileSystemProps#getProvisionedThroughputInMibps}
         * @param provisionedThroughputInMibps The throughput, measured in MiB/s, that you want to provision for a file system that you're creating.
         *                                     Valid values are 1-1024. Required if <code>ThroughputMode</code> is set to <code>provisioned</code> . The upper limit for throughput is 1024 MiB/s. To increase this limit, contact AWS Support . For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/limits.html#soft-limits">Amazon EFS quotas that you can increase</a> in the <em>Amazon EFS User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provisionedThroughputInMibps(java.lang.Number provisionedThroughputInMibps) {
            this.provisionedThroughputInMibps = provisionedThroughputInMibps;
            return this;
        }

        /**
         * Sets the value of {@link CfnFileSystemProps#getThroughputMode}
         * @param throughputMode Specifies the throughput mode for the file system.
         *                       The mode can be <code>bursting</code> , <code>provisioned</code> , or <code>elastic</code> . If you set <code>ThroughputMode</code> to <code>provisioned</code> , you must also set a value for <code>ProvisionedThroughputInMibps</code> . After you create the file system, you can decrease your file system's throughput in Provisioned Throughput mode or change between the throughput modes, with certain time restrictions. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/performance.html#provisioned-throughput">Specifying throughput with provisioned mode</a> in the <em>Amazon EFS User Guide</em> .
         *                       <p>
         *                       Default is <code>bursting</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder throughputMode(java.lang.String throughputMode) {
            this.throughputMode = throughputMode;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnFileSystemProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnFileSystemProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnFileSystemProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnFileSystemProps {
        private final java.lang.String availabilityZoneName;
        private final java.lang.Object backupPolicy;
        private final java.lang.Object bypassPolicyLockoutSafetyCheck;
        private final java.lang.Object encrypted;
        private final java.lang.Object fileSystemPolicy;
        private final java.util.List<software.amazon.awscdk.services.efs.CfnFileSystem.ElasticFileSystemTagProperty> fileSystemTags;
        private final java.lang.String kmsKeyId;
        private final java.lang.Object lifecyclePolicies;
        private final java.lang.String performanceMode;
        private final java.lang.Number provisionedThroughputInMibps;
        private final java.lang.String throughputMode;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.availabilityZoneName = software.amazon.jsii.Kernel.get(this, "availabilityZoneName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.backupPolicy = software.amazon.jsii.Kernel.get(this, "backupPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.bypassPolicyLockoutSafetyCheck = software.amazon.jsii.Kernel.get(this, "bypassPolicyLockoutSafetyCheck", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.encrypted = software.amazon.jsii.Kernel.get(this, "encrypted", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.fileSystemPolicy = software.amazon.jsii.Kernel.get(this, "fileSystemPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.fileSystemTags = software.amazon.jsii.Kernel.get(this, "fileSystemTags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.efs.CfnFileSystem.ElasticFileSystemTagProperty.class)));
            this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.lifecyclePolicies = software.amazon.jsii.Kernel.get(this, "lifecyclePolicies", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.performanceMode = software.amazon.jsii.Kernel.get(this, "performanceMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.provisionedThroughputInMibps = software.amazon.jsii.Kernel.get(this, "provisionedThroughputInMibps", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.throughputMode = software.amazon.jsii.Kernel.get(this, "throughputMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.availabilityZoneName = builder.availabilityZoneName;
            this.backupPolicy = builder.backupPolicy;
            this.bypassPolicyLockoutSafetyCheck = builder.bypassPolicyLockoutSafetyCheck;
            this.encrypted = builder.encrypted;
            this.fileSystemPolicy = builder.fileSystemPolicy;
            this.fileSystemTags = (java.util.List<software.amazon.awscdk.services.efs.CfnFileSystem.ElasticFileSystemTagProperty>)builder.fileSystemTags;
            this.kmsKeyId = builder.kmsKeyId;
            this.lifecyclePolicies = builder.lifecyclePolicies;
            this.performanceMode = builder.performanceMode;
            this.provisionedThroughputInMibps = builder.provisionedThroughputInMibps;
            this.throughputMode = builder.throughputMode;
        }

        @Override
        public final java.lang.String getAvailabilityZoneName() {
            return this.availabilityZoneName;
        }

        @Override
        public final java.lang.Object getBackupPolicy() {
            return this.backupPolicy;
        }

        @Override
        public final java.lang.Object getBypassPolicyLockoutSafetyCheck() {
            return this.bypassPolicyLockoutSafetyCheck;
        }

        @Override
        public final java.lang.Object getEncrypted() {
            return this.encrypted;
        }

        @Override
        public final java.lang.Object getFileSystemPolicy() {
            return this.fileSystemPolicy;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.efs.CfnFileSystem.ElasticFileSystemTagProperty> getFileSystemTags() {
            return this.fileSystemTags;
        }

        @Override
        public final java.lang.String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final java.lang.Object getLifecyclePolicies() {
            return this.lifecyclePolicies;
        }

        @Override
        public final java.lang.String getPerformanceMode() {
            return this.performanceMode;
        }

        @Override
        public final java.lang.Number getProvisionedThroughputInMibps() {
            return this.provisionedThroughputInMibps;
        }

        @Override
        public final java.lang.String getThroughputMode() {
            return this.throughputMode;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAvailabilityZoneName() != null) {
                data.set("availabilityZoneName", om.valueToTree(this.getAvailabilityZoneName()));
            }
            if (this.getBackupPolicy() != null) {
                data.set("backupPolicy", om.valueToTree(this.getBackupPolicy()));
            }
            if (this.getBypassPolicyLockoutSafetyCheck() != null) {
                data.set("bypassPolicyLockoutSafetyCheck", om.valueToTree(this.getBypassPolicyLockoutSafetyCheck()));
            }
            if (this.getEncrypted() != null) {
                data.set("encrypted", om.valueToTree(this.getEncrypted()));
            }
            if (this.getFileSystemPolicy() != null) {
                data.set("fileSystemPolicy", om.valueToTree(this.getFileSystemPolicy()));
            }
            if (this.getFileSystemTags() != null) {
                data.set("fileSystemTags", om.valueToTree(this.getFileSystemTags()));
            }
            if (this.getKmsKeyId() != null) {
                data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
            }
            if (this.getLifecyclePolicies() != null) {
                data.set("lifecyclePolicies", om.valueToTree(this.getLifecyclePolicies()));
            }
            if (this.getPerformanceMode() != null) {
                data.set("performanceMode", om.valueToTree(this.getPerformanceMode()));
            }
            if (this.getProvisionedThroughputInMibps() != null) {
                data.set("provisionedThroughputInMibps", om.valueToTree(this.getProvisionedThroughputInMibps()));
            }
            if (this.getThroughputMode() != null) {
                data.set("throughputMode", om.valueToTree(this.getThroughputMode()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_efs.CfnFileSystemProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnFileSystemProps.Jsii$Proxy that = (CfnFileSystemProps.Jsii$Proxy) o;

            if (this.availabilityZoneName != null ? !this.availabilityZoneName.equals(that.availabilityZoneName) : that.availabilityZoneName != null) return false;
            if (this.backupPolicy != null ? !this.backupPolicy.equals(that.backupPolicy) : that.backupPolicy != null) return false;
            if (this.bypassPolicyLockoutSafetyCheck != null ? !this.bypassPolicyLockoutSafetyCheck.equals(that.bypassPolicyLockoutSafetyCheck) : that.bypassPolicyLockoutSafetyCheck != null) return false;
            if (this.encrypted != null ? !this.encrypted.equals(that.encrypted) : that.encrypted != null) return false;
            if (this.fileSystemPolicy != null ? !this.fileSystemPolicy.equals(that.fileSystemPolicy) : that.fileSystemPolicy != null) return false;
            if (this.fileSystemTags != null ? !this.fileSystemTags.equals(that.fileSystemTags) : that.fileSystemTags != null) return false;
            if (this.kmsKeyId != null ? !this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId != null) return false;
            if (this.lifecyclePolicies != null ? !this.lifecyclePolicies.equals(that.lifecyclePolicies) : that.lifecyclePolicies != null) return false;
            if (this.performanceMode != null ? !this.performanceMode.equals(that.performanceMode) : that.performanceMode != null) return false;
            if (this.provisionedThroughputInMibps != null ? !this.provisionedThroughputInMibps.equals(that.provisionedThroughputInMibps) : that.provisionedThroughputInMibps != null) return false;
            return this.throughputMode != null ? this.throughputMode.equals(that.throughputMode) : that.throughputMode == null;
        }

        @Override
        public final int hashCode() {
            int result = this.availabilityZoneName != null ? this.availabilityZoneName.hashCode() : 0;
            result = 31 * result + (this.backupPolicy != null ? this.backupPolicy.hashCode() : 0);
            result = 31 * result + (this.bypassPolicyLockoutSafetyCheck != null ? this.bypassPolicyLockoutSafetyCheck.hashCode() : 0);
            result = 31 * result + (this.encrypted != null ? this.encrypted.hashCode() : 0);
            result = 31 * result + (this.fileSystemPolicy != null ? this.fileSystemPolicy.hashCode() : 0);
            result = 31 * result + (this.fileSystemTags != null ? this.fileSystemTags.hashCode() : 0);
            result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
            result = 31 * result + (this.lifecyclePolicies != null ? this.lifecyclePolicies.hashCode() : 0);
            result = 31 * result + (this.performanceMode != null ? this.performanceMode.hashCode() : 0);
            result = 31 * result + (this.provisionedThroughputInMibps != null ? this.provisionedThroughputInMibps.hashCode() : 0);
            result = 31 * result + (this.throughputMode != null ? this.throughputMode.hashCode() : 0);
            return result;
        }
    }
}
