package software.amazon.awscdk.services.efs;

/**
 * (experimental) EFS Performance mode.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * FileSystem fileSystem = FileSystem.Builder.create(this, "MyEfsFileSystem")
 *         .vpc(new Vpc(this, "VPC"))
 *         .lifecyclePolicy(LifecyclePolicy.AFTER_14_DAYS) // files are not transitioned to infrequent access (IA) storage by default
 *         .performanceMode(PerformanceMode.GENERAL_PURPOSE) // default
 *         .outOfInfrequentAccessPolicy(OutOfInfrequentAccessPolicy.AFTER_1_ACCESS)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/efs/latest/ug/performance.html#performancemodes">https://docs.aws.amazon.com/efs/latest/ug/performance.html#performancemodes</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:00.742Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_efs.PerformanceMode")
public enum PerformanceMode {
    /**
     * (experimental) General Purpose is ideal for latency-sensitive use cases, like web serving environments, content management systems, home directories, and general file serving.
     * <p>
     * Recommended for the majority of Amazon EFS file systems.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    GENERAL_PURPOSE,
    /**
     * (experimental) File systems in the Max I/O mode can scale to higher levels of aggregate throughput and operations per second.
     * <p>
     * This scaling is done with a tradeoff
     * of slightly higher latencies for file metadata operations.
     * Highly parallelized applications and workloads, such as big data analysis,
     * media processing, and genomics analysis, can benefit from this mode.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    MAX_IO,
}
