package software.amazon.awscdk.services.eks;

/**
 * (experimental) An EKS cluster.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:00.922Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_eks.ICluster")
@software.amazon.jsii.Jsii.Proxy(ICluster.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface ICluster extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.core.IResource, software.amazon.awscdk.services.ec2.IConnectable {

    /**
     * (experimental) The unique ARN assigned to the service by AWS in the form of arn:aws:eks:.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getClusterArn();

    /**
     * (experimental) The certificate-authority-data for your cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getClusterCertificateAuthorityData();

    /**
     * (experimental) Amazon Resource Name (ARN) or alias of the customer master key (CMK).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getClusterEncryptionConfigKeyArn();

    /**
     * (experimental) The API Server endpoint URL.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getClusterEndpoint();

    /**
     * (experimental) The physical name of the Cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getClusterName();

    /**
     * (experimental) The cluster security group that was created by Amazon EKS for the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.ISecurityGroup getClusterSecurityGroup();

    /**
     * (experimental) The id of the cluster security group that was created by Amazon EKS for the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getClusterSecurityGroupId();

    /**
     * (experimental) The Open ID Connect Provider of the cluster used to configure Service Accounts.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IOpenIdConnectProvider getOpenIdConnectProvider();

    /**
     * (experimental) Indicates whether Kubernetes resources can be automatically pruned.
     * <p>
     * When
     * this is enabled (default), prune labels will be allocated and injected to
     * each resource. These labels will then be used when issuing the <code>kubectl apply</code> operation with the <code>--prune</code> switch.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.Boolean getPrune();

    /**
     * (experimental) The VPC in which this Cluster was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IVpc getVpc();

    /**
     * (experimental) A security group to associate with the Cluster Handler's Lambdas.
     * <p>
     * The Cluster Handler's Lambdas are responsible for calling AWS's EKS API.
     * <p>
     * Requires <code>placeClusterHandlerInVpc</code> to be set to true.
     * <p>
     * Default: - No security group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.ISecurityGroup getClusterHandlerSecurityGroup() {
        return null;
    }

    /**
     * (experimental) Custom environment variables when running `kubectl` against this cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getKubectlEnvironment() {
        return null;
    }

    /**
     * (experimental) An IAM role that can perform kubectl operations against this cluster.
     * <p>
     * The role should be mapped to the <code>system:masters</code> Kubernetes RBAC role.
     * <p>
     * This role is directly passed to the lambda handler that sends Kube Ctl commands to the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getKubectlLambdaRole() {
        return null;
    }

    /**
     * (experimental) An AWS Lambda layer that includes `kubectl`, `helm` and the `aws` CLI.
     * <p>
     * If not defined, a default layer will be used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.ILayerVersion getKubectlLayer() {
        return null;
    }

    /**
     * (experimental) Amount of memory to allocate to the provider's lambda function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Size getKubectlMemory() {
        return null;
    }

    /**
     * (experimental) Subnets to host the `kubectl` compute resources.
     * <p>
     * If this is undefined, the k8s endpoint is expected to be accessible
     * publicly.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.ISubnet> getKubectlPrivateSubnets() {
        return null;
    }

    /**
     * (experimental) Kubectl Provider for issuing kubectl commands against it.
     * <p>
     * If not defined, a default provider will be used
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.eks.IKubectlProvider getKubectlProvider() {
        return null;
    }

    /**
     * (experimental) An IAM role that can perform kubectl operations against this cluster.
     * <p>
     * The role should be mapped to the <code>system:masters</code> Kubernetes RBAC role.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getKubectlRole() {
        return null;
    }

    /**
     * (experimental) A security group to use for `kubectl` execution.
     * <p>
     * If this is undefined, the k8s endpoint is expected to be accessible
     * publicly.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.ISecurityGroup getKubectlSecurityGroup() {
        return null;
    }

    /**
     * (experimental) An AWS Lambda layer that includes the NPM dependency `proxy-agent`.
     * <p>
     * If not defined, a default layer will be used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.ILayerVersion getOnEventLayer() {
        return null;
    }

    /**
     * (experimental) Defines a CDK8s chart in this cluster.
     * <p>
     * @return a `KubernetesManifest` construct representing the chart.
     * @param id logical id of this chart. This parameter is required.
     * @param chart the cdk8s chart. This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.KubernetesManifest addCdk8sChart(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.constructs.Construct chart, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.eks.KubernetesManifestOptions options);

    /**
     * (experimental) Defines a CDK8s chart in this cluster.
     * <p>
     * @return a `KubernetesManifest` construct representing the chart.
     * @param id logical id of this chart. This parameter is required.
     * @param chart the cdk8s chart. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.KubernetesManifest addCdk8sChart(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.constructs.Construct chart);

    /**
     * (experimental) Defines a Helm chart in this cluster.
     * <p>
     * @return a `HelmChart` construct
     * @param id logical id of this chart. This parameter is required.
     * @param options options of this chart. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.HelmChart addHelmChart(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.HelmChartOptions options);

    /**
     * (experimental) Defines a Kubernetes resource in this cluster.
     * <p>
     * The manifest will be applied/deleted using kubectl as needed.
     * <p>
     * @return a `KubernetesManifest` object.
     * @param id logical id of this manifest. This parameter is required.
     * @param manifest a list of Kubernetes resource specifications. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.KubernetesManifest addManifest(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object>... manifest);

    /**
     * (experimental) Creates a new service account with corresponding IAM Role (IRSA).
     * <p>
     * @param id logical id of service account. This parameter is required.
     * @param options service account options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.ServiceAccount addServiceAccount(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.eks.ServiceAccountOptions options);

    /**
     * (experimental) Creates a new service account with corresponding IAM Role (IRSA).
     * <p>
     * @param id logical id of service account. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.ServiceAccount addServiceAccount(final @org.jetbrains.annotations.NotNull java.lang.String id);

    /**
     * (experimental) Connect capacity in the form of an existing AutoScalingGroup to the EKS cluster.
     * <p>
     * The AutoScalingGroup must be running an EKS-optimized AMI containing the
     * /etc/eks/bootstrap.sh script. This method will configure Security Groups,
     * add the right policies to the instance role, apply the right tags, and add
     * the required user data to the instance's launch configuration.
     * <p>
     * Spot instances will be labeled <code>lifecycle=Ec2Spot</code> and tainted with <code>PreferNoSchedule</code>.
     * If kubectl is enabled, the
     * <a href="https://github.com/awslabs/ec2-spot-labs/tree/master/ec2-spot-eks-solution/spot-termination-handler">spot interrupt handler</a>
     * daemon will be installed on all spot instances to handle
     * <a href="https://aws.amazon.com/blogs/aws/new-ec2-spot-instance-termination-notices/">EC2 Spot Instance Termination Notices</a>.
     * <p>
     * Prefer to use <code>addAutoScalingGroupCapacity</code> if possible.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/eks/latest/userguide/launch-workers.html">https://docs.aws.amazon.com/eks/latest/userguide/launch-workers.html</a>
     * @param autoScalingGroup [disable-awslint:ref-via-interface]. This parameter is required.
     * @param options options for adding auto scaling groups, like customizing the bootstrap script. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    void connectAutoScalingGroupCapacity(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.AutoScalingGroup autoScalingGroup, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.AutoScalingGroupOptions options);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.eks.ICluster.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * (experimental) The construct tree node for this construct.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ConstructNode getNode() {
            return software.amazon.jsii.Kernel.get(this, "node", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.ConstructNode.class));
        }

        /**
         * (experimental) The environment this resource belongs to.
         * <p>
         * For resources that are created and managed by the CDK
         * (generally, those created by creating new class instances like Role, Bucket, etc.),
         * this is always the same as the environment of the stack they belong to;
         * however, for imported resources
         * (those obtained from static methods like fromRoleArn, fromBucketName, etc.),
         * that might be different than the stack they were imported into.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ResourceEnvironment getEnv() {
            return software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.ResourceEnvironment.class));
        }

        /**
         * (experimental) The stack in which this resource is defined.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Stack getStack() {
            return software.amazon.jsii.Kernel.get(this, "stack", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Stack.class));
        }

        /**
         * (experimental) The network connections associated with this resource.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Connections getConnections() {
            return software.amazon.jsii.Kernel.get(this, "connections", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Connections.class));
        }

        /**
         * (experimental) The unique ARN assigned to the service by AWS in the form of arn:aws:eks:.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public final @org.jetbrains.annotations.NotNull java.lang.String getClusterArn() {
            return software.amazon.jsii.Kernel.get(this, "clusterArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * (experimental) The certificate-authority-data for your cluster.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public final @org.jetbrains.annotations.NotNull java.lang.String getClusterCertificateAuthorityData() {
            return software.amazon.jsii.Kernel.get(this, "clusterCertificateAuthorityData", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * (experimental) Amazon Resource Name (ARN) or alias of the customer master key (CMK).
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public final @org.jetbrains.annotations.NotNull java.lang.String getClusterEncryptionConfigKeyArn() {
            return software.amazon.jsii.Kernel.get(this, "clusterEncryptionConfigKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * (experimental) The API Server endpoint URL.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public final @org.jetbrains.annotations.NotNull java.lang.String getClusterEndpoint() {
            return software.amazon.jsii.Kernel.get(this, "clusterEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * (experimental) The physical name of the Cluster.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public final @org.jetbrains.annotations.NotNull java.lang.String getClusterName() {
            return software.amazon.jsii.Kernel.get(this, "clusterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * (experimental) The cluster security group that was created by Amazon EKS for the cluster.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.ISecurityGroup getClusterSecurityGroup() {
            return software.amazon.jsii.Kernel.get(this, "clusterSecurityGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class));
        }

        /**
         * (experimental) The id of the cluster security group that was created by Amazon EKS for the cluster.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public final @org.jetbrains.annotations.NotNull java.lang.String getClusterSecurityGroupId() {
            return software.amazon.jsii.Kernel.get(this, "clusterSecurityGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * (experimental) The Open ID Connect Provider of the cluster used to configure Service Accounts.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IOpenIdConnectProvider getOpenIdConnectProvider() {
            return software.amazon.jsii.Kernel.get(this, "openIdConnectProvider", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IOpenIdConnectProvider.class));
        }

        /**
         * (experimental) Indicates whether Kubernetes resources can be automatically pruned.
         * <p>
         * When
         * this is enabled (default), prune labels will be allocated and injected to
         * each resource. These labels will then be used when issuing the <code>kubectl apply</code> operation with the <code>--prune</code> switch.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public final @org.jetbrains.annotations.NotNull java.lang.Boolean getPrune() {
            return software.amazon.jsii.Kernel.get(this, "prune", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * (experimental) The VPC in which this Cluster was created.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
        }

        /**
         * (experimental) A security group to associate with the Cluster Handler's Lambdas.
         * <p>
         * The Cluster Handler's Lambdas are responsible for calling AWS's EKS API.
         * <p>
         * Requires <code>placeClusterHandlerInVpc</code> to be set to true.
         * <p>
         * Default: - No security group.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.ISecurityGroup getClusterHandlerSecurityGroup() {
            return software.amazon.jsii.Kernel.get(this, "clusterHandlerSecurityGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class));
        }

        /**
         * (experimental) Custom environment variables when running `kubectl` against this cluster.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getKubectlEnvironment() {
            return java.util.Optional.ofNullable((java.util.Map<java.lang.String, java.lang.String>)(software.amazon.jsii.Kernel.get(this, "kubectlEnvironment", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableMap).orElse(null);
        }

        /**
         * (experimental) An IAM role that can perform kubectl operations against this cluster.
         * <p>
         * The role should be mapped to the <code>system:masters</code> Kubernetes RBAC role.
         * <p>
         * This role is directly passed to the lambda handler that sends Kube Ctl commands to the cluster.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getKubectlLambdaRole() {
            return software.amazon.jsii.Kernel.get(this, "kubectlLambdaRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
        }

        /**
         * (experimental) An AWS Lambda layer that includes `kubectl`, `helm` and the `aws` CLI.
         * <p>
         * If not defined, a default layer will be used.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.ILayerVersion getKubectlLayer() {
            return software.amazon.jsii.Kernel.get(this, "kubectlLayer", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.ILayerVersion.class));
        }

        /**
         * (experimental) Amount of memory to allocate to the provider's lambda function.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Size getKubectlMemory() {
            return software.amazon.jsii.Kernel.get(this, "kubectlMemory", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Size.class));
        }

        /**
         * (experimental) Subnets to host the `kubectl` compute resources.
         * <p>
         * If this is undefined, the k8s endpoint is expected to be accessible
         * publicly.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.ISubnet> getKubectlPrivateSubnets() {
            return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.services.ec2.ISubnet>)(software.amazon.jsii.Kernel.get(this, "kubectlPrivateSubnets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISubnet.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
        }

        /**
         * (experimental) Kubectl Provider for issuing kubectl commands against it.
         * <p>
         * If not defined, a default provider will be used
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.eks.IKubectlProvider getKubectlProvider() {
            return software.amazon.jsii.Kernel.get(this, "kubectlProvider", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.IKubectlProvider.class));
        }

        /**
         * (experimental) An IAM role that can perform kubectl operations against this cluster.
         * <p>
         * The role should be mapped to the <code>system:masters</code> Kubernetes RBAC role.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getKubectlRole() {
            return software.amazon.jsii.Kernel.get(this, "kubectlRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
        }

        /**
         * (experimental) A security group to use for `kubectl` execution.
         * <p>
         * If this is undefined, the k8s endpoint is expected to be accessible
         * publicly.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.ISecurityGroup getKubectlSecurityGroup() {
            return software.amazon.jsii.Kernel.get(this, "kubectlSecurityGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class));
        }

        /**
         * (experimental) An AWS Lambda layer that includes the NPM dependency `proxy-agent`.
         * <p>
         * If not defined, a default layer will be used.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.ILayerVersion getOnEventLayer() {
            return software.amazon.jsii.Kernel.get(this, "onEventLayer", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.ILayerVersion.class));
        }

        /**
         * (experimental) Apply the given removal policy to this resource.
         * <p>
         * The Removal Policy controls what happens to this resource when it stops
         * being managed by CloudFormation, either because you've removed it from the
         * CDK application or because you've made a change that requires the resource
         * to be replaced.
         * <p>
         * The resource can be deleted (<code>RemovalPolicy.DESTROY</code>), or left in your AWS
         * account for data recovery and cleanup later (<code>RemovalPolicy.RETAIN</code>).
         * <p>
         * @param policy This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final void applyRemovalPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.RemovalPolicy policy) {
            software.amazon.jsii.Kernel.call(this, "applyRemovalPolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(policy, "policy is required") });
        }

        /**
         * (experimental) Defines a CDK8s chart in this cluster.
         * <p>
         * @return a `KubernetesManifest` construct representing the chart.
         * @param id logical id of this chart. This parameter is required.
         * @param chart the cdk8s chart. This parameter is required.
         * @param options
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.KubernetesManifest addCdk8sChart(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.constructs.Construct chart, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.eks.KubernetesManifestOptions options) {
            return software.amazon.jsii.Kernel.call(this, "addCdk8sChart", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.KubernetesManifest.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(chart, "chart is required"), options });
        }

        /**
         * (experimental) Defines a CDK8s chart in this cluster.
         * <p>
         * @return a `KubernetesManifest` construct representing the chart.
         * @param id logical id of this chart. This parameter is required.
         * @param chart the cdk8s chart. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.KubernetesManifest addCdk8sChart(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.constructs.Construct chart) {
            return software.amazon.jsii.Kernel.call(this, "addCdk8sChart", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.KubernetesManifest.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(chart, "chart is required") });
        }

        /**
         * (experimental) Defines a Helm chart in this cluster.
         * <p>
         * @return a `HelmChart` construct
         * @param id logical id of this chart. This parameter is required.
         * @param options options of this chart. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.HelmChart addHelmChart(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.HelmChartOptions options) {
            return software.amazon.jsii.Kernel.call(this, "addHelmChart", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.HelmChart.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(options, "options is required") });
        }

        /**
         * (experimental) Defines a Kubernetes resource in this cluster.
         * <p>
         * The manifest will be applied/deleted using kubectl as needed.
         * <p>
         * @return a `KubernetesManifest` object.
         * @param id logical id of this manifest. This parameter is required.
         * @param manifest a list of Kubernetes resource specifications. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.KubernetesManifest addManifest(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object>... manifest) {
            return software.amazon.jsii.Kernel.call(this, "addManifest", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.KubernetesManifest.class), java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(id, "id is required") }), java.util.Arrays.<Object>stream(manifest)).toArray(Object[]::new));
        }

        /**
         * (experimental) Creates a new service account with corresponding IAM Role (IRSA).
         * <p>
         * @param id logical id of service account. This parameter is required.
         * @param options service account options.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.ServiceAccount addServiceAccount(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.eks.ServiceAccountOptions options) {
            return software.amazon.jsii.Kernel.call(this, "addServiceAccount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.ServiceAccount.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
        }

        /**
         * (experimental) Creates a new service account with corresponding IAM Role (IRSA).
         * <p>
         * @param id logical id of service account. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.ServiceAccount addServiceAccount(final @org.jetbrains.annotations.NotNull java.lang.String id) {
            return software.amazon.jsii.Kernel.call(this, "addServiceAccount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.ServiceAccount.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
        }

        /**
         * (experimental) Connect capacity in the form of an existing AutoScalingGroup to the EKS cluster.
         * <p>
         * The AutoScalingGroup must be running an EKS-optimized AMI containing the
         * /etc/eks/bootstrap.sh script. This method will configure Security Groups,
         * add the right policies to the instance role, apply the right tags, and add
         * the required user data to the instance's launch configuration.
         * <p>
         * Spot instances will be labeled <code>lifecycle=Ec2Spot</code> and tainted with <code>PreferNoSchedule</code>.
         * If kubectl is enabled, the
         * <a href="https://github.com/awslabs/ec2-spot-labs/tree/master/ec2-spot-eks-solution/spot-termination-handler">spot interrupt handler</a>
         * daemon will be installed on all spot instances to handle
         * <a href="https://aws.amazon.com/blogs/aws/new-ec2-spot-instance-termination-notices/">EC2 Spot Instance Termination Notices</a>.
         * <p>
         * Prefer to use <code>addAutoScalingGroupCapacity</code> if possible.
         * <p>
         * @see <a href="https://docs.aws.amazon.com/eks/latest/userguide/launch-workers.html">https://docs.aws.amazon.com/eks/latest/userguide/launch-workers.html</a>
         * @param autoScalingGroup [disable-awslint:ref-via-interface]. This parameter is required.
         * @param options options for adding auto scaling groups, like customizing the bootstrap script. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final void connectAutoScalingGroupCapacity(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.AutoScalingGroup autoScalingGroup, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.AutoScalingGroupOptions options) {
            software.amazon.jsii.Kernel.call(this, "connectAutoScalingGroupCapacity", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(autoScalingGroup, "autoScalingGroup is required"), java.util.Objects.requireNonNull(options, "options is required") });
        }
    }

    /**
     * Internal default implementation for {@link ICluster}.
     */
    @software.amazon.jsii.Internal
    interface Jsii$Default extends ICluster, software.amazon.awscdk.core.IResource.Jsii$Default, software.amazon.awscdk.services.ec2.IConnectable.Jsii$Default {

        /**
         * (experimental) The construct tree node for this construct.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ConstructNode getNode() {
            return software.amazon.jsii.Kernel.get(this, "node", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.ConstructNode.class));
        }

        /**
         * (experimental) The environment this resource belongs to.
         * <p>
         * For resources that are created and managed by the CDK
         * (generally, those created by creating new class instances like Role, Bucket, etc.),
         * this is always the same as the environment of the stack they belong to;
         * however, for imported resources
         * (those obtained from static methods like fromRoleArn, fromBucketName, etc.),
         * that might be different than the stack they were imported into.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ResourceEnvironment getEnv() {
            return software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.ResourceEnvironment.class));
        }

        /**
         * (experimental) The stack in which this resource is defined.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Stack getStack() {
            return software.amazon.jsii.Kernel.get(this, "stack", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Stack.class));
        }

        /**
         * (experimental) The network connections associated with this resource.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Connections getConnections() {
            return software.amazon.jsii.Kernel.get(this, "connections", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Connections.class));
        }

        /**
         * (experimental) The unique ARN assigned to the service by AWS in the form of arn:aws:eks:.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.NotNull java.lang.String getClusterArn() {
            return software.amazon.jsii.Kernel.get(this, "clusterArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * (experimental) The certificate-authority-data for your cluster.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.NotNull java.lang.String getClusterCertificateAuthorityData() {
            return software.amazon.jsii.Kernel.get(this, "clusterCertificateAuthorityData", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * (experimental) Amazon Resource Name (ARN) or alias of the customer master key (CMK).
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.NotNull java.lang.String getClusterEncryptionConfigKeyArn() {
            return software.amazon.jsii.Kernel.get(this, "clusterEncryptionConfigKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * (experimental) The API Server endpoint URL.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.NotNull java.lang.String getClusterEndpoint() {
            return software.amazon.jsii.Kernel.get(this, "clusterEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * (experimental) The physical name of the Cluster.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.NotNull java.lang.String getClusterName() {
            return software.amazon.jsii.Kernel.get(this, "clusterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * (experimental) The cluster security group that was created by Amazon EKS for the cluster.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.ISecurityGroup getClusterSecurityGroup() {
            return software.amazon.jsii.Kernel.get(this, "clusterSecurityGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class));
        }

        /**
         * (experimental) The id of the cluster security group that was created by Amazon EKS for the cluster.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.NotNull java.lang.String getClusterSecurityGroupId() {
            return software.amazon.jsii.Kernel.get(this, "clusterSecurityGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * (experimental) The Open ID Connect Provider of the cluster used to configure Service Accounts.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IOpenIdConnectProvider getOpenIdConnectProvider() {
            return software.amazon.jsii.Kernel.get(this, "openIdConnectProvider", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IOpenIdConnectProvider.class));
        }

        /**
         * (experimental) Indicates whether Kubernetes resources can be automatically pruned.
         * <p>
         * When
         * this is enabled (default), prune labels will be allocated and injected to
         * each resource. These labels will then be used when issuing the <code>kubectl apply</code> operation with the <code>--prune</code> switch.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.NotNull java.lang.Boolean getPrune() {
            return software.amazon.jsii.Kernel.get(this, "prune", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * (experimental) The VPC in which this Cluster was created.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
        }

        /**
         * (experimental) A security group to associate with the Cluster Handler's Lambdas.
         * <p>
         * The Cluster Handler's Lambdas are responsible for calling AWS's EKS API.
         * <p>
         * Requires <code>placeClusterHandlerInVpc</code> to be set to true.
         * <p>
         * Default: - No security group.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.ISecurityGroup getClusterHandlerSecurityGroup() {
            return software.amazon.jsii.Kernel.get(this, "clusterHandlerSecurityGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class));
        }

        /**
         * (experimental) Custom environment variables when running `kubectl` against this cluster.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getKubectlEnvironment() {
            return java.util.Optional.ofNullable((java.util.Map<java.lang.String, java.lang.String>)(software.amazon.jsii.Kernel.get(this, "kubectlEnvironment", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableMap).orElse(null);
        }

        /**
         * (experimental) An IAM role that can perform kubectl operations against this cluster.
         * <p>
         * The role should be mapped to the <code>system:masters</code> Kubernetes RBAC role.
         * <p>
         * This role is directly passed to the lambda handler that sends Kube Ctl commands to the cluster.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getKubectlLambdaRole() {
            return software.amazon.jsii.Kernel.get(this, "kubectlLambdaRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
        }

        /**
         * (experimental) An AWS Lambda layer that includes `kubectl`, `helm` and the `aws` CLI.
         * <p>
         * If not defined, a default layer will be used.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.ILayerVersion getKubectlLayer() {
            return software.amazon.jsii.Kernel.get(this, "kubectlLayer", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.ILayerVersion.class));
        }

        /**
         * (experimental) Amount of memory to allocate to the provider's lambda function.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Size getKubectlMemory() {
            return software.amazon.jsii.Kernel.get(this, "kubectlMemory", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Size.class));
        }

        /**
         * (experimental) Subnets to host the `kubectl` compute resources.
         * <p>
         * If this is undefined, the k8s endpoint is expected to be accessible
         * publicly.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.ISubnet> getKubectlPrivateSubnets() {
            return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.services.ec2.ISubnet>)(software.amazon.jsii.Kernel.get(this, "kubectlPrivateSubnets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISubnet.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
        }

        /**
         * (experimental) Kubectl Provider for issuing kubectl commands against it.
         * <p>
         * If not defined, a default provider will be used
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.eks.IKubectlProvider getKubectlProvider() {
            return software.amazon.jsii.Kernel.get(this, "kubectlProvider", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.IKubectlProvider.class));
        }

        /**
         * (experimental) An IAM role that can perform kubectl operations against this cluster.
         * <p>
         * The role should be mapped to the <code>system:masters</code> Kubernetes RBAC role.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getKubectlRole() {
            return software.amazon.jsii.Kernel.get(this, "kubectlRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
        }

        /**
         * (experimental) A security group to use for `kubectl` execution.
         * <p>
         * If this is undefined, the k8s endpoint is expected to be accessible
         * publicly.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.ISecurityGroup getKubectlSecurityGroup() {
            return software.amazon.jsii.Kernel.get(this, "kubectlSecurityGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class));
        }

        /**
         * (experimental) An AWS Lambda layer that includes the NPM dependency `proxy-agent`.
         * <p>
         * If not defined, a default layer will be used.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.ILayerVersion getOnEventLayer() {
            return software.amazon.jsii.Kernel.get(this, "onEventLayer", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.ILayerVersion.class));
        }

        /**
         * (experimental) Apply the given removal policy to this resource.
         * <p>
         * The Removal Policy controls what happens to this resource when it stops
         * being managed by CloudFormation, either because you've removed it from the
         * CDK application or because you've made a change that requires the resource
         * to be replaced.
         * <p>
         * The resource can be deleted (<code>RemovalPolicy.DESTROY</code>), or left in your AWS
         * account for data recovery and cleanup later (<code>RemovalPolicy.RETAIN</code>).
         * <p>
         * @param policy This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default void applyRemovalPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.RemovalPolicy policy) {
            software.amazon.jsii.Kernel.call(this, "applyRemovalPolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(policy, "policy is required") });
        }

        /**
         * (experimental) Defines a CDK8s chart in this cluster.
         * <p>
         * @return a `KubernetesManifest` construct representing the chart.
         * @param id logical id of this chart. This parameter is required.
         * @param chart the cdk8s chart. This parameter is required.
         * @param options
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.KubernetesManifest addCdk8sChart(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.constructs.Construct chart, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.eks.KubernetesManifestOptions options) {
            return software.amazon.jsii.Kernel.call(this, "addCdk8sChart", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.KubernetesManifest.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(chart, "chart is required"), options });
        }

        /**
         * (experimental) Defines a Helm chart in this cluster.
         * <p>
         * @return a `HelmChart` construct
         * @param id logical id of this chart. This parameter is required.
         * @param options options of this chart. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.HelmChart addHelmChart(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.HelmChartOptions options) {
            return software.amazon.jsii.Kernel.call(this, "addHelmChart", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.HelmChart.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(options, "options is required") });
        }

        /**
         * (experimental) Defines a Kubernetes resource in this cluster.
         * <p>
         * The manifest will be applied/deleted using kubectl as needed.
         * <p>
         * @return a `KubernetesManifest` object.
         * @param id logical id of this manifest. This parameter is required.
         * @param manifest a list of Kubernetes resource specifications. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.KubernetesManifest addManifest(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object>... manifest) {
            return software.amazon.jsii.Kernel.call(this, "addManifest", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.KubernetesManifest.class), java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(id, "id is required") }), java.util.Arrays.<Object>stream(manifest)).toArray(Object[]::new));
        }

        /**
         * (experimental) Creates a new service account with corresponding IAM Role (IRSA).
         * <p>
         * @param id logical id of service account. This parameter is required.
         * @param options service account options.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.ServiceAccount addServiceAccount(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.eks.ServiceAccountOptions options) {
            return software.amazon.jsii.Kernel.call(this, "addServiceAccount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.ServiceAccount.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
        }

        /**
         * (experimental) Connect capacity in the form of an existing AutoScalingGroup to the EKS cluster.
         * <p>
         * The AutoScalingGroup must be running an EKS-optimized AMI containing the
         * /etc/eks/bootstrap.sh script. This method will configure Security Groups,
         * add the right policies to the instance role, apply the right tags, and add
         * the required user data to the instance's launch configuration.
         * <p>
         * Spot instances will be labeled <code>lifecycle=Ec2Spot</code> and tainted with <code>PreferNoSchedule</code>.
         * If kubectl is enabled, the
         * <a href="https://github.com/awslabs/ec2-spot-labs/tree/master/ec2-spot-eks-solution/spot-termination-handler">spot interrupt handler</a>
         * daemon will be installed on all spot instances to handle
         * <a href="https://aws.amazon.com/blogs/aws/new-ec2-spot-instance-termination-notices/">EC2 Spot Instance Termination Notices</a>.
         * <p>
         * Prefer to use <code>addAutoScalingGroupCapacity</code> if possible.
         * <p>
         * @see <a href="https://docs.aws.amazon.com/eks/latest/userguide/launch-workers.html">https://docs.aws.amazon.com/eks/latest/userguide/launch-workers.html</a>
         * @param autoScalingGroup [disable-awslint:ref-via-interface]. This parameter is required.
         * @param options options for adding auto scaling groups, like customizing the bootstrap script. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default void connectAutoScalingGroupCapacity(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.AutoScalingGroup autoScalingGroup, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.AutoScalingGroupOptions options) {
            software.amazon.jsii.Kernel.call(this, "connectAutoScalingGroupCapacity", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(autoScalingGroup, "autoScalingGroup is required"), java.util.Objects.requireNonNull(options, "options is required") });
        }
    }
}
