package software.amazon.awscdk.services.eks;

/**
 * (experimental) The AMI type for your node group.
 * <p>
 * GPU instance types should use the <code>AL2_x86_64_GPU</code> AMI type, which uses the
 * Amazon EKS-optimized Linux AMI with GPU support. Non-GPU instances should use the <code>AL2_x86_64</code> AMI type, which
 * uses the Amazon EKS-optimized Linux AMI.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Cluster cluster = Cluster.Builder.create(this, "HelloEKS")
 *         .version(KubernetesVersion.V1_21)
 *         .defaultCapacity(0)
 *         .build();
 * cluster.addNodegroupCapacity("custom-node-group", NodegroupOptions.builder()
 *         .instanceTypes(List.of(new InstanceType("m5.large")))
 *         .minSize(4)
 *         .diskSize(100)
 *         .amiType(NodegroupAmiType.AL2_X86_64_GPU)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:00.963Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_eks.NodegroupAmiType")
public enum NodegroupAmiType {
    /**
     * (experimental) Amazon Linux 2 (x86-64).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    AL2_X86_64,
    /**
     * (experimental) Amazon Linux 2 with GPU support.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    AL2_X86_64_GPU,
    /**
     * (experimental) Amazon Linux 2 (ARM-64).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    AL2_ARM_64,
    /**
     * (experimental) Bottlerocket Linux(ARM-64).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    BOTTLEROCKET_ARM_64,
    /**
     * (experimental) Bottlerocket(x86-64).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    BOTTLEROCKET_X86_64,
}
