package software.amazon.awscdk.services.eks;

/**
 * (experimental) Service Account.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // or create a new one using an existing issuer url
 * String issuerUrl;
 * // you can import an existing provider
 * IOpenIdConnectProvider provider = OpenIdConnectProvider.fromOpenIdConnectProviderArn(this, "Provider", "arn:aws:iam::123456:oidc-provider/oidc.eks.eu-west-1.amazonaws.com/id/AB123456ABC");
 * OpenIdConnectProvider provider2 = OpenIdConnectProvider.Builder.create(this, "Provider")
 *         .url(issuerUrl)
 *         .build();
 * ICluster cluster = Cluster.fromClusterAttributes(this, "MyCluster", ClusterAttributes.builder()
 *         .clusterName("Cluster")
 *         .openIdConnectProvider(provider)
 *         .kubectlRoleArn("arn:aws:iam::123456:role/service-role/k8sservicerole")
 *         .build());
 * ServiceAccount serviceAccount = cluster.addServiceAccount("MyServiceAccount");
 * Bucket bucket = new Bucket(this, "Bucket");
 * bucket.grantReadWrite(serviceAccount);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:00.973Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_eks.ServiceAccount")
public class ServiceAccount extends software.amazon.awscdk.core.Construct implements software.amazon.awscdk.services.iam.IPrincipal {

    protected ServiceAccount(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ServiceAccount(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public ServiceAccount(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.ServiceAccountProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (deprecated) Add to the policy of this principal.
     * <p>
     * @deprecated use `addToPrincipalPolicy()`
     * @param statement This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.Boolean addToPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement statement) {
        return software.amazon.jsii.Kernel.call(this, "addToPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { java.util.Objects.requireNonNull(statement, "statement is required") });
    }

    /**
     * (experimental) Add to the policy of this principal.
     * <p>
     * @param statement This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.AddToPrincipalPolicyResult addToPrincipalPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement statement) {
        return software.amazon.jsii.Kernel.call(this, "addToPrincipalPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.AddToPrincipalPolicyResult.class), new Object[] { java.util.Objects.requireNonNull(statement, "statement is required") });
    }

    /**
     * (experimental) When this Principal is used in an AssumeRole policy, the action to use.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getAssumeRoleAction() {
        return software.amazon.jsii.Kernel.get(this, "assumeRoleAction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The principal to grant permissions to.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IPrincipal getGrantPrincipal() {
        return software.amazon.jsii.Kernel.get(this, "grantPrincipal", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IPrincipal.class));
    }

    /**
     * (experimental) Return the policy fragment that identifies this principal in a Policy.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PrincipalPolicyFragment getPolicyFragment() {
        return software.amazon.jsii.Kernel.get(this, "policyFragment", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PrincipalPolicyFragment.class));
    }

    /**
     * (experimental) The role which is linked to the service account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole getRole() {
        return software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
    }

    /**
     * (experimental) The name of the service account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getServiceAccountName() {
        return software.amazon.jsii.Kernel.get(this, "serviceAccountName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The namespace where the service account is located in.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getServiceAccountNamespace() {
        return software.amazon.jsii.Kernel.get(this, "serviceAccountNamespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.eks.ServiceAccount}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.eks.ServiceAccount> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.eks.ServiceAccountProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.eks.ServiceAccountProps.Builder();
        }

        /**
         * (experimental) Additional annotations of the service account.
         * <p>
         * Default: - no additional annotations
         * <p>
         * @return {@code this}
         * @param annotations Additional annotations of the service account. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder annotations(final java.util.Map<java.lang.String, java.lang.String> annotations) {
            this.props.annotations(annotations);
            return this;
        }

        /**
         * (experimental) Additional labels of the service account.
         * <p>
         * Default: - no additional labels
         * <p>
         * @return {@code this}
         * @param labels Additional labels of the service account. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder labels(final java.util.Map<java.lang.String, java.lang.String> labels) {
            this.props.labels(labels);
            return this;
        }

        /**
         * (experimental) The name of the service account.
         * <p>
         * The name of a ServiceAccount object must be a valid DNS subdomain name.
         * https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/
         * <p>
         * Default: - If no name is given, it will use the id of the resource.
         * <p>
         * @return {@code this}
         * @param name The name of the service account. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * (experimental) The namespace of the service account.
         * <p>
         * All namespace names must be valid RFC 1123 DNS labels.
         * https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces/#namespaces-and-dns
         * <p>
         * Default: "default"
         * <p>
         * @return {@code this}
         * @param namespace The namespace of the service account. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder namespace(final java.lang.String namespace) {
            this.props.namespace(namespace);
            return this;
        }

        /**
         * (experimental) The cluster to apply the patch to.
         * <p>
         * @return {@code this}
         * @param cluster The cluster to apply the patch to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cluster(final software.amazon.awscdk.services.eks.ICluster cluster) {
            this.props.cluster(cluster);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.eks.ServiceAccount}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.eks.ServiceAccount build() {
            return new software.amazon.awscdk.services.eks.ServiceAccount(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
