package software.amazon.awscdk.services.eks.legacy;

/**
 * (experimental) Properties to instantiate the Cluster.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Cluster.Builder.create(this, "cluster")
 *         .defaultCapacity(10)
 *         .defaultCapacityInstance(new InstanceType("m2.xlarge"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:01.064Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_eks_legacy.ClusterProps")
@software.amazon.jsii.Jsii.Proxy(ClusterProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface ClusterProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) Name for the cluster.
     * <p>
     * Default: - Automatically generated name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getClusterName() {
        return null;
    }

    /**
     * (experimental) Number of instances to allocate as an initial capacity for this cluster.
     * <p>
     * Instance type can be configured through <code>defaultCapacityInstanceType</code>,
     * which defaults to <code>m5.large</code>.
     * <p>
     * Use <code>cluster.addCapacity</code> to add additional customized capacity. Set this
     * to <code>0</code> is you wish to avoid the initial capacity allocation.
     * <p>
     * Default: 2
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getDefaultCapacity() {
        return null;
    }

    /**
     * (experimental) The instance type to use for the default capacity.
     * <p>
     * This will only be taken
     * into account if <code>defaultCapacity</code> is &gt; 0.
     * <p>
     * Default: m5.large
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.InstanceType getDefaultCapacityInstance() {
        return null;
    }

    /**
     * (experimental) Allows defining `kubectrl`-related resources on this cluster.
     * <p>
     * If this is disabled, it will not be possible to use the following
     * capabilities:
     * <p>
     * <ul>
     * <li><code>addResource</code></li>
     * <li><code>addRoleMapping</code></li>
     * <li><code>addUserMapping</code></li>
     * <li><code>addMastersRole</code> and <code>props.mastersRole</code></li>
     * </ul>
     * <p>
     * If this is disabled, the cluster can only be managed by issuing <code>kubectl</code>
     * commands from a session that uses the IAM role/user that created the
     * account.
     * <p>
     * <em>NOTE</em>: changing this value will destoy the cluster. This is because a
     * managable cluster must be created using an AWS CloudFormation custom
     * resource which executes with an IAM role owned by the CDK app.
     * <p>
     * Default: true The cluster can be managed by the AWS CDK application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getKubectlEnabled() {
        return null;
    }

    /**
     * (experimental) An IAM role that will be added to the `system:masters` Kubernetes RBAC group.
     * <p>
     * Default: - By default, it will only possible to update this Kubernetes
     *   system by adding resources to this cluster via `addResource` or
     *   by defining `KubernetesResource` resources in your AWS CDK app.
     *   Use this if you wish to grant cluster administration privileges
     *   to another role.
     * <p>
     * @see <a href="https://kubernetes.io/docs/reference/access-authn-authz/rbac/#default-roles-and-role-bindings">https://kubernetes.io/docs/reference/access-authn-authz/rbac/#default-roles-and-role-bindings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getMastersRole() {
        return null;
    }

    /**
     * (experimental) Determines whether a CloudFormation output with the name of the cluster will be synthesized.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getOutputClusterName() {
        return null;
    }

    /**
     * (experimental) Determines whether a CloudFormation output with the `aws eks update-kubeconfig` command will be synthesized.
     * <p>
     * This command will include
     * the cluster name and, if applicable, the ARN of the masters IAM role.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getOutputConfigCommand() {
        return null;
    }

    /**
     * (experimental) Determines whether a CloudFormation output with the ARN of the "masters" IAM role will be synthesized (if `mastersRole` is specified).
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getOutputMastersRoleArn() {
        return null;
    }

    /**
     * (experimental) Role that provides permissions for the Kubernetes control plane to make calls to AWS API operations on your behalf.
     * <p>
     * Default: - A role is automatically created for you
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return null;
    }

    /**
     * (experimental) Security Group to use for Control Plane ENIs.
     * <p>
     * Default: - A security group is automatically created
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup() {
        return null;
    }

    /**
     * (experimental) The Kubernetes version to run in the cluster.
     * <p>
     * Default: - If not supplied, will use Amazon default version
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getVersion() {
        return null;
    }

    /**
     * (experimental) The VPC in which to create the Cluster.
     * <p>
     * Default: - a VPC with default configuration will be created and can be accessed through `cluster.vpc`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.IVpc getVpc() {
        return null;
    }

    /**
     * (experimental) Where to place EKS Control Plane ENIs.
     * <p>
     * If you want to create public load balancers, this must include public subnets.
     * <p>
     * For example, to only select private subnets, supply the following:
     * <p>
     * <blockquote><pre>
     * Map&lt;String, SubnetType&gt;[] vpcSubnets = List.of(Map.of("subnetType", SubnetType.PRIVATE_WITH_NAT));
     * </pre></blockquote>
     * <p>
     * Default: - All public and private subnets
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection> getVpcSubnets() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<ClusterProps> {
        java.lang.String clusterName;
        java.lang.Number defaultCapacity;
        software.amazon.awscdk.services.ec2.InstanceType defaultCapacityInstance;
        java.lang.Boolean kubectlEnabled;
        software.amazon.awscdk.services.iam.IRole mastersRole;
        java.lang.Boolean outputClusterName;
        java.lang.Boolean outputConfigCommand;
        java.lang.Boolean outputMastersRoleArn;
        software.amazon.awscdk.services.iam.IRole role;
        software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup;
        java.lang.String version;
        software.amazon.awscdk.services.ec2.IVpc vpc;
        java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection> vpcSubnets;

        /**
         * Sets the value of {@link ClusterProps#getClusterName}
         * @param clusterName Name for the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder clusterName(java.lang.String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        /**
         * Sets the value of {@link ClusterProps#getDefaultCapacity}
         * @param defaultCapacity Number of instances to allocate as an initial capacity for this cluster.
         *                        Instance type can be configured through <code>defaultCapacityInstanceType</code>,
         *                        which defaults to <code>m5.large</code>.
         *                        <p>
         *                        Use <code>cluster.addCapacity</code> to add additional customized capacity. Set this
         *                        to <code>0</code> is you wish to avoid the initial capacity allocation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder defaultCapacity(java.lang.Number defaultCapacity) {
            this.defaultCapacity = defaultCapacity;
            return this;
        }

        /**
         * Sets the value of {@link ClusterProps#getDefaultCapacityInstance}
         * @param defaultCapacityInstance The instance type to use for the default capacity.
         *                                This will only be taken
         *                                into account if <code>defaultCapacity</code> is &gt; 0.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder defaultCapacityInstance(software.amazon.awscdk.services.ec2.InstanceType defaultCapacityInstance) {
            this.defaultCapacityInstance = defaultCapacityInstance;
            return this;
        }

        /**
         * Sets the value of {@link ClusterProps#getKubectlEnabled}
         * @param kubectlEnabled Allows defining `kubectrl`-related resources on this cluster.
         *                       If this is disabled, it will not be possible to use the following
         *                       capabilities:
         *                       <p>
         *                       <ul>
         *                       <li><code>addResource</code></li>
         *                       <li><code>addRoleMapping</code></li>
         *                       <li><code>addUserMapping</code></li>
         *                       <li><code>addMastersRole</code> and <code>props.mastersRole</code></li>
         *                       </ul>
         *                       <p>
         *                       If this is disabled, the cluster can only be managed by issuing <code>kubectl</code>
         *                       commands from a session that uses the IAM role/user that created the
         *                       account.
         *                       <p>
         *                       <em>NOTE</em>: changing this value will destoy the cluster. This is because a
         *                       managable cluster must be created using an AWS CloudFormation custom
         *                       resource which executes with an IAM role owned by the CDK app.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder kubectlEnabled(java.lang.Boolean kubectlEnabled) {
            this.kubectlEnabled = kubectlEnabled;
            return this;
        }

        /**
         * Sets the value of {@link ClusterProps#getMastersRole}
         * @param mastersRole An IAM role that will be added to the `system:masters` Kubernetes RBAC group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder mastersRole(software.amazon.awscdk.services.iam.IRole mastersRole) {
            this.mastersRole = mastersRole;
            return this;
        }

        /**
         * Sets the value of {@link ClusterProps#getOutputClusterName}
         * @param outputClusterName Determines whether a CloudFormation output with the name of the cluster will be synthesized.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder outputClusterName(java.lang.Boolean outputClusterName) {
            this.outputClusterName = outputClusterName;
            return this;
        }

        /**
         * Sets the value of {@link ClusterProps#getOutputConfigCommand}
         * @param outputConfigCommand Determines whether a CloudFormation output with the `aws eks update-kubeconfig` command will be synthesized.
         *                            This command will include
         *                            the cluster name and, if applicable, the ARN of the masters IAM role.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder outputConfigCommand(java.lang.Boolean outputConfigCommand) {
            this.outputConfigCommand = outputConfigCommand;
            return this;
        }

        /**
         * Sets the value of {@link ClusterProps#getOutputMastersRoleArn}
         * @param outputMastersRoleArn Determines whether a CloudFormation output with the ARN of the "masters" IAM role will be synthesized (if `mastersRole` is specified).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder outputMastersRoleArn(java.lang.Boolean outputMastersRoleArn) {
            this.outputMastersRoleArn = outputMastersRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link ClusterProps#getRole}
         * @param role Role that provides permissions for the Kubernetes control plane to make calls to AWS API operations on your behalf.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link ClusterProps#getSecurityGroup}
         * @param securityGroup Security Group to use for Control Plane ENIs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder securityGroup(software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
            this.securityGroup = securityGroup;
            return this;
        }

        /**
         * Sets the value of {@link ClusterProps#getVersion}
         * @param version The Kubernetes version to run in the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder version(java.lang.String version) {
            this.version = version;
            return this;
        }

        /**
         * Sets the value of {@link ClusterProps#getVpc}
         * @param vpc The VPC in which to create the Cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Sets the value of {@link ClusterProps#getVpcSubnets}
         * @param vpcSubnets Where to place EKS Control Plane ENIs.
         *                   If you want to create public load balancers, this must include public subnets.
         *                   <p>
         *                   For example, to only select private subnets, supply the following:
         *                   <p>
         *                   <blockquote><pre>
         *                   Map&lt;String, SubnetType&gt;[] vpcSubnets = List.of(Map.of("subnetType", SubnetType.PRIVATE_WITH_NAT));
         *                   </pre></blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder vpcSubnets(java.util.List<? extends software.amazon.awscdk.services.ec2.SubnetSelection> vpcSubnets) {
            this.vpcSubnets = (java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection>)vpcSubnets;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ClusterProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public ClusterProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClusterProps {
        private final java.lang.String clusterName;
        private final java.lang.Number defaultCapacity;
        private final software.amazon.awscdk.services.ec2.InstanceType defaultCapacityInstance;
        private final java.lang.Boolean kubectlEnabled;
        private final software.amazon.awscdk.services.iam.IRole mastersRole;
        private final java.lang.Boolean outputClusterName;
        private final java.lang.Boolean outputConfigCommand;
        private final java.lang.Boolean outputMastersRoleArn;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup;
        private final java.lang.String version;
        private final software.amazon.awscdk.services.ec2.IVpc vpc;
        private final java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection> vpcSubnets;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.clusterName = software.amazon.jsii.Kernel.get(this, "clusterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.defaultCapacity = software.amazon.jsii.Kernel.get(this, "defaultCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.defaultCapacityInstance = software.amazon.jsii.Kernel.get(this, "defaultCapacityInstance", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InstanceType.class));
            this.kubectlEnabled = software.amazon.jsii.Kernel.get(this, "kubectlEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.mastersRole = software.amazon.jsii.Kernel.get(this, "mastersRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.outputClusterName = software.amazon.jsii.Kernel.get(this, "outputClusterName", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.outputConfigCommand = software.amazon.jsii.Kernel.get(this, "outputConfigCommand", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.outputMastersRoleArn = software.amazon.jsii.Kernel.get(this, "outputMastersRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.securityGroup = software.amazon.jsii.Kernel.get(this, "securityGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class));
            this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.vpc = software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
            this.vpcSubnets = software.amazon.jsii.Kernel.get(this, "vpcSubnets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetSelection.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.clusterName = builder.clusterName;
            this.defaultCapacity = builder.defaultCapacity;
            this.defaultCapacityInstance = builder.defaultCapacityInstance;
            this.kubectlEnabled = builder.kubectlEnabled;
            this.mastersRole = builder.mastersRole;
            this.outputClusterName = builder.outputClusterName;
            this.outputConfigCommand = builder.outputConfigCommand;
            this.outputMastersRoleArn = builder.outputMastersRoleArn;
            this.role = builder.role;
            this.securityGroup = builder.securityGroup;
            this.version = builder.version;
            this.vpc = builder.vpc;
            this.vpcSubnets = (java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection>)builder.vpcSubnets;
        }

        @Override
        public final java.lang.String getClusterName() {
            return this.clusterName;
        }

        @Override
        public final java.lang.Number getDefaultCapacity() {
            return this.defaultCapacity;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.InstanceType getDefaultCapacityInstance() {
            return this.defaultCapacityInstance;
        }

        @Override
        public final java.lang.Boolean getKubectlEnabled() {
            return this.kubectlEnabled;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getMastersRole() {
            return this.mastersRole;
        }

        @Override
        public final java.lang.Boolean getOutputClusterName() {
            return this.outputClusterName;
        }

        @Override
        public final java.lang.Boolean getOutputConfigCommand() {
            return this.outputConfigCommand;
        }

        @Override
        public final java.lang.Boolean getOutputMastersRoleArn() {
            return this.outputMastersRoleArn;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup() {
            return this.securityGroup;
        }

        @Override
        public final java.lang.String getVersion() {
            return this.version;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection> getVpcSubnets() {
            return this.vpcSubnets;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getClusterName() != null) {
                data.set("clusterName", om.valueToTree(this.getClusterName()));
            }
            if (this.getDefaultCapacity() != null) {
                data.set("defaultCapacity", om.valueToTree(this.getDefaultCapacity()));
            }
            if (this.getDefaultCapacityInstance() != null) {
                data.set("defaultCapacityInstance", om.valueToTree(this.getDefaultCapacityInstance()));
            }
            if (this.getKubectlEnabled() != null) {
                data.set("kubectlEnabled", om.valueToTree(this.getKubectlEnabled()));
            }
            if (this.getMastersRole() != null) {
                data.set("mastersRole", om.valueToTree(this.getMastersRole()));
            }
            if (this.getOutputClusterName() != null) {
                data.set("outputClusterName", om.valueToTree(this.getOutputClusterName()));
            }
            if (this.getOutputConfigCommand() != null) {
                data.set("outputConfigCommand", om.valueToTree(this.getOutputConfigCommand()));
            }
            if (this.getOutputMastersRoleArn() != null) {
                data.set("outputMastersRoleArn", om.valueToTree(this.getOutputMastersRoleArn()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            if (this.getSecurityGroup() != null) {
                data.set("securityGroup", om.valueToTree(this.getSecurityGroup()));
            }
            if (this.getVersion() != null) {
                data.set("version", om.valueToTree(this.getVersion()));
            }
            if (this.getVpc() != null) {
                data.set("vpc", om.valueToTree(this.getVpc()));
            }
            if (this.getVpcSubnets() != null) {
                data.set("vpcSubnets", om.valueToTree(this.getVpcSubnets()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_eks_legacy.ClusterProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ClusterProps.Jsii$Proxy that = (ClusterProps.Jsii$Proxy) o;

            if (this.clusterName != null ? !this.clusterName.equals(that.clusterName) : that.clusterName != null) return false;
            if (this.defaultCapacity != null ? !this.defaultCapacity.equals(that.defaultCapacity) : that.defaultCapacity != null) return false;
            if (this.defaultCapacityInstance != null ? !this.defaultCapacityInstance.equals(that.defaultCapacityInstance) : that.defaultCapacityInstance != null) return false;
            if (this.kubectlEnabled != null ? !this.kubectlEnabled.equals(that.kubectlEnabled) : that.kubectlEnabled != null) return false;
            if (this.mastersRole != null ? !this.mastersRole.equals(that.mastersRole) : that.mastersRole != null) return false;
            if (this.outputClusterName != null ? !this.outputClusterName.equals(that.outputClusterName) : that.outputClusterName != null) return false;
            if (this.outputConfigCommand != null ? !this.outputConfigCommand.equals(that.outputConfigCommand) : that.outputConfigCommand != null) return false;
            if (this.outputMastersRoleArn != null ? !this.outputMastersRoleArn.equals(that.outputMastersRoleArn) : that.outputMastersRoleArn != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            if (this.securityGroup != null ? !this.securityGroup.equals(that.securityGroup) : that.securityGroup != null) return false;
            if (this.version != null ? !this.version.equals(that.version) : that.version != null) return false;
            if (this.vpc != null ? !this.vpc.equals(that.vpc) : that.vpc != null) return false;
            return this.vpcSubnets != null ? this.vpcSubnets.equals(that.vpcSubnets) : that.vpcSubnets == null;
        }

        @Override
        public final int hashCode() {
            int result = this.clusterName != null ? this.clusterName.hashCode() : 0;
            result = 31 * result + (this.defaultCapacity != null ? this.defaultCapacity.hashCode() : 0);
            result = 31 * result + (this.defaultCapacityInstance != null ? this.defaultCapacityInstance.hashCode() : 0);
            result = 31 * result + (this.kubectlEnabled != null ? this.kubectlEnabled.hashCode() : 0);
            result = 31 * result + (this.mastersRole != null ? this.mastersRole.hashCode() : 0);
            result = 31 * result + (this.outputClusterName != null ? this.outputClusterName.hashCode() : 0);
            result = 31 * result + (this.outputConfigCommand != null ? this.outputConfigCommand.hashCode() : 0);
            result = 31 * result + (this.outputMastersRoleArn != null ? this.outputMastersRoleArn.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.securityGroup != null ? this.securityGroup.hashCode() : 0);
            result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
            result = 31 * result + (this.vpc != null ? this.vpc.hashCode() : 0);
            result = 31 * result + (this.vpcSubnets != null ? this.vpcSubnets.hashCode() : 0);
            return result;
        }
    }
}
