package software.amazon.awscdk.services.eks.legacy;

/**
 * (experimental) Represents a helm chart within the Kubernetes system.
 * <p>
 * Applies/deletes the resources using <code>kubectl</code> in sync with the resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Cluster cluster;
 * // option 1: use a construct
 * // option 1: use a construct
 * HelmChart.Builder.create(this, "NginxIngress")
 *         .cluster(cluster)
 *         .chart("nginx-ingress")
 *         .repository("https://helm.nginx.com/stable")
 *         .namespace("kube-system")
 *         .build();
 * // or, option2: use `addChart`
 * cluster.addChart("NginxIngress", HelmChartOptions.builder()
 *         .chart("nginx-ingress")
 *         .repository("https://helm.nginx.com/stable")
 *         .namespace("kube-system")
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:01.069Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_eks_legacy.HelmChart")
public class HelmChart extends software.amazon.awscdk.core.Construct {

    protected HelmChart(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected HelmChart(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        RESOURCE_TYPE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.legacy.HelmChart.class, "RESOURCE_TYPE", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public HelmChart(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.legacy.HelmChartProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) The CloudFormation reosurce type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String RESOURCE_TYPE;

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.eks.legacy.HelmChart}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.eks.legacy.HelmChart> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.eks.legacy.HelmChartProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.eks.legacy.HelmChartProps.Builder();
        }

        /**
         * (experimental) The name of the chart.
         * <p>
         * @return {@code this}
         * @param chart The name of the chart. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder chart(final java.lang.String chart) {
            this.props.chart(chart);
            return this;
        }

        /**
         * (experimental) The Kubernetes namespace scope of the requests.
         * <p>
         * Default: default
         * <p>
         * @return {@code this}
         * @param namespace The Kubernetes namespace scope of the requests. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder namespace(final java.lang.String namespace) {
            this.props.namespace(namespace);
            return this;
        }

        /**
         * (experimental) The name of the release.
         * <p>
         * Default: - If no release name is given, it will use the last 63 characters of the node's unique id.
         * <p>
         * @return {@code this}
         * @param release The name of the release. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder release(final java.lang.String release) {
            this.props.release(release);
            return this;
        }

        /**
         * (experimental) The repository which contains the chart.
         * <p>
         * For example: https://kubernetes-charts.storage.googleapis.com/
         * <p>
         * Default: - No repository will be used, which means that the chart needs to be an absolute URL.
         * <p>
         * @return {@code this}
         * @param repository The repository which contains the chart. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder repository(final java.lang.String repository) {
            this.props.repository(repository);
            return this;
        }

        /**
         * (experimental) The values to be used by the chart.
         * <p>
         * Default: - No values are provided to the chart.
         * <p>
         * @return {@code this}
         * @param values The values to be used by the chart. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder values(final java.util.Map<java.lang.String, ? extends java.lang.Object> values) {
            this.props.values(values);
            return this;
        }

        /**
         * (experimental) The chart version to install.
         * <p>
         * Default: - If this is not specified, the latest version is installed
         * <p>
         * @return {@code this}
         * @param version The chart version to install. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder version(final java.lang.String version) {
            this.props.version(version);
            return this;
        }

        /**
         * (experimental) The EKS cluster to apply this configuration to.
         * <p>
         * [disable-awslint:ref-via-interface]
         * <p>
         * @return {@code this}
         * @param cluster The EKS cluster to apply this configuration to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cluster(final software.amazon.awscdk.services.eks.legacy.Cluster cluster) {
            this.props.cluster(cluster);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.eks.legacy.HelmChart}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.eks.legacy.HelmChart build() {
            return new software.amazon.awscdk.services.eks.legacy.HelmChart(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
