package software.amazon.awscdk.services.eks.legacy;

/**
 * (experimental) Helm Chart properties.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Cluster cluster;
 * // option 1: use a construct
 * // option 1: use a construct
 * HelmChart.Builder.create(this, "NginxIngress")
 *         .cluster(cluster)
 *         .chart("nginx-ingress")
 *         .repository("https://helm.nginx.com/stable")
 *         .namespace("kube-system")
 *         .build();
 * // or, option2: use `addChart`
 * cluster.addChart("NginxIngress", HelmChartOptions.builder()
 *         .chart("nginx-ingress")
 *         .repository("https://helm.nginx.com/stable")
 *         .namespace("kube-system")
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:01.085Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_eks_legacy.HelmChartProps")
@software.amazon.jsii.Jsii.Proxy(HelmChartProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface HelmChartProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.eks.legacy.HelmChartOptions {

    /**
     * (experimental) The EKS cluster to apply this configuration to.
     * <p>
     * [disable-awslint:ref-via-interface]
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.legacy.Cluster getCluster();

    /**
     * @return a {@link Builder} of {@link HelmChartProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link HelmChartProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<HelmChartProps> {
        software.amazon.awscdk.services.eks.legacy.Cluster cluster;
        java.lang.String chart;
        java.lang.String namespace;
        java.lang.String release;
        java.lang.String repository;
        java.util.Map<java.lang.String, java.lang.Object> values;
        java.lang.String version;

        /**
         * Sets the value of {@link HelmChartProps#getCluster}
         * @param cluster The EKS cluster to apply this configuration to. This parameter is required.
         *                [disable-awslint:ref-via-interface]
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cluster(software.amazon.awscdk.services.eks.legacy.Cluster cluster) {
            this.cluster = cluster;
            return this;
        }

        /**
         * Sets the value of {@link HelmChartProps#getChart}
         * @param chart The name of the chart. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder chart(java.lang.String chart) {
            this.chart = chart;
            return this;
        }

        /**
         * Sets the value of {@link HelmChartProps#getNamespace}
         * @param namespace The Kubernetes namespace scope of the requests.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder namespace(java.lang.String namespace) {
            this.namespace = namespace;
            return this;
        }

        /**
         * Sets the value of {@link HelmChartProps#getRelease}
         * @param release The name of the release.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder release(java.lang.String release) {
            this.release = release;
            return this;
        }

        /**
         * Sets the value of {@link HelmChartProps#getRepository}
         * @param repository The repository which contains the chart.
         *                   For example: https://kubernetes-charts.storage.googleapis.com/
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder repository(java.lang.String repository) {
            this.repository = repository;
            return this;
        }

        /**
         * Sets the value of {@link HelmChartProps#getValues}
         * @param values The values to be used by the chart.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder values(java.util.Map<java.lang.String, ? extends java.lang.Object> values) {
            this.values = (java.util.Map<java.lang.String, java.lang.Object>)values;
            return this;
        }

        /**
         * Sets the value of {@link HelmChartProps#getVersion}
         * @param version The chart version to install.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder version(java.lang.String version) {
            this.version = version;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link HelmChartProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public HelmChartProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link HelmChartProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HelmChartProps {
        private final software.amazon.awscdk.services.eks.legacy.Cluster cluster;
        private final java.lang.String chart;
        private final java.lang.String namespace;
        private final java.lang.String release;
        private final java.lang.String repository;
        private final java.util.Map<java.lang.String, java.lang.Object> values;
        private final java.lang.String version;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.cluster = software.amazon.jsii.Kernel.get(this, "cluster", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.legacy.Cluster.class));
            this.chart = software.amazon.jsii.Kernel.get(this, "chart", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.namespace = software.amazon.jsii.Kernel.get(this, "namespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.release = software.amazon.jsii.Kernel.get(this, "release", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.repository = software.amazon.jsii.Kernel.get(this, "repository", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.values = software.amazon.jsii.Kernel.get(this, "values", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.cluster = java.util.Objects.requireNonNull(builder.cluster, "cluster is required");
            this.chart = java.util.Objects.requireNonNull(builder.chart, "chart is required");
            this.namespace = builder.namespace;
            this.release = builder.release;
            this.repository = builder.repository;
            this.values = (java.util.Map<java.lang.String, java.lang.Object>)builder.values;
            this.version = builder.version;
        }

        @Override
        public final software.amazon.awscdk.services.eks.legacy.Cluster getCluster() {
            return this.cluster;
        }

        @Override
        public final java.lang.String getChart() {
            return this.chart;
        }

        @Override
        public final java.lang.String getNamespace() {
            return this.namespace;
        }

        @Override
        public final java.lang.String getRelease() {
            return this.release;
        }

        @Override
        public final java.lang.String getRepository() {
            return this.repository;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getValues() {
            return this.values;
        }

        @Override
        public final java.lang.String getVersion() {
            return this.version;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("cluster", om.valueToTree(this.getCluster()));
            data.set("chart", om.valueToTree(this.getChart()));
            if (this.getNamespace() != null) {
                data.set("namespace", om.valueToTree(this.getNamespace()));
            }
            if (this.getRelease() != null) {
                data.set("release", om.valueToTree(this.getRelease()));
            }
            if (this.getRepository() != null) {
                data.set("repository", om.valueToTree(this.getRepository()));
            }
            if (this.getValues() != null) {
                data.set("values", om.valueToTree(this.getValues()));
            }
            if (this.getVersion() != null) {
                data.set("version", om.valueToTree(this.getVersion()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_eks_legacy.HelmChartProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            HelmChartProps.Jsii$Proxy that = (HelmChartProps.Jsii$Proxy) o;

            if (!cluster.equals(that.cluster)) return false;
            if (!chart.equals(that.chart)) return false;
            if (this.namespace != null ? !this.namespace.equals(that.namespace) : that.namespace != null) return false;
            if (this.release != null ? !this.release.equals(that.release) : that.release != null) return false;
            if (this.repository != null ? !this.repository.equals(that.repository) : that.repository != null) return false;
            if (this.values != null ? !this.values.equals(that.values) : that.values != null) return false;
            return this.version != null ? this.version.equals(that.version) : that.version == null;
        }

        @Override
        public final int hashCode() {
            int result = this.cluster.hashCode();
            result = 31 * result + (this.chart.hashCode());
            result = 31 * result + (this.namespace != null ? this.namespace.hashCode() : 0);
            result = 31 * result + (this.release != null ? this.release.hashCode() : 0);
            result = 31 * result + (this.repository != null ? this.repository.hashCode() : 0);
            result = 31 * result + (this.values != null ? this.values.hashCode() : 0);
            result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
            return result;
        }
    }
}
