package software.amazon.awscdk.services.eks.legacy;

/**
 * (experimental) Represents a resource within the Kubernetes system.
 * <p>
 * Alternatively, you can use <code>cluster.addResource(resource[, resource, ...])</code>
 * to define resources on this cluster.
 * <p>
 * Applies/deletes the resources using <code>kubectl</code> in sync with the resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Cluster cluster;
 * Map&lt;String, String&gt; appLabel = Map.of("app", "hello-kubernetes");
 * Map&lt;String, Object&gt; deployment = Map.of(
 *         "apiVersion", "apps/v1",
 *         "kind", "Deployment",
 *         "metadata", Map.of("name", "hello-kubernetes"),
 *         "spec", Map.of(
 *                 "replicas", 3,
 *                 "selector", Map.of("matchLabels", appLabel),
 *                 "template", Map.of(
 *                         "metadata", Map.of("labels", appLabel),
 *                         "spec", Map.of(
 *                                 "containers", List.of(Map.of(
 *                                         "name", "hello-kubernetes",
 *                                         "image", "paulbouwer/hello-kubernetes:1.5",
 *                                         "ports", List.of(Map.of("containerPort", 8080))))))));
 * Map&lt;String, Object&gt; service = Map.of(
 *         "apiVersion", "v1",
 *         "kind", "Service",
 *         "metadata", Map.of("name", "hello-kubernetes"),
 *         "spec", Map.of(
 *                 "type", "LoadBalancer",
 *                 "ports", List.of(Map.of("port", 80, "targetPort", 8080)),
 *                 "selector", appLabel));
 * // option 1: use a construct
 * // option 1: use a construct
 * KubernetesResource.Builder.create(this, "hello-kub")
 *         .cluster(cluster)
 *         .manifest(List.of(deployment, service))
 *         .build();
 * // or, option2: use `addResource`
 * cluster.addResource("hello-kub", service, deployment);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:01.087Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_eks_legacy.KubernetesResource")
public class KubernetesResource extends software.amazon.awscdk.core.Construct {

    protected KubernetesResource(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected KubernetesResource(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        RESOURCE_TYPE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.legacy.KubernetesResource.class, "RESOURCE_TYPE", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public KubernetesResource(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.legacy.KubernetesResourceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) The CloudFormation reosurce type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String RESOURCE_TYPE;

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.eks.legacy.KubernetesResource}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.eks.legacy.KubernetesResource> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.eks.legacy.KubernetesResourceProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.eks.legacy.KubernetesResourceProps.Builder();
        }

        /**
         * (experimental) The EKS cluster to apply this configuration to.
         * <p>
         * [disable-awslint:ref-via-interface]
         * <p>
         * @return {@code this}
         * @param cluster The EKS cluster to apply this configuration to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cluster(final software.amazon.awscdk.services.eks.legacy.Cluster cluster) {
            this.props.cluster(cluster);
            return this;
        }

        /**
         * (experimental) The resource manifest.
         * <p>
         * Consists of any number of child resources.
         * <p>
         * When the resource is created/updated, this manifest will be applied to the
         * cluster through <code>kubectl apply</code> and when the resource or the stack is
         * deleted, the manifest will be deleted through <code>kubectl delete</code>.
         * <p>
         * <blockquote><pre>
         * const manifest = {
         *    apiVersion: 'v1',
         *    kind: 'Pod',
         *    metadata: { name: 'mypod' },
         *    spec: {
         *      containers: [ { name: 'hello', image: 'paulbouwer/hello-kubernetes:1.5', ports: [ { containerPort: 8080 } ] } ]
         *    }
         * }
         * </pre></blockquote>
         * <p>
         * @return {@code this}
         * @param manifest The resource manifest. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder manifest(final java.util.List<? extends java.lang.Object> manifest) {
            this.props.manifest(manifest);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.eks.legacy.KubernetesResource}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.eks.legacy.KubernetesResource build() {
            return new software.amazon.awscdk.services.eks.legacy.KubernetesResource(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
