package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * (experimental) Options for `NetworkListenerAction.forward()`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
 * Duration duration;
 * NetworkForwardOptions networkForwardOptions = NetworkForwardOptions.builder()
 *         .stickinessDuration(duration)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:01.442Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_elasticloadbalancingv2.NetworkForwardOptions")
@software.amazon.jsii.Jsii.Proxy(NetworkForwardOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface NetworkForwardOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) For how long clients should be directed to the same target group.
     * <p>
     * Range between 1 second and 7 days.
     * <p>
     * Default: - No stickiness
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getStickinessDuration() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link NetworkForwardOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link NetworkForwardOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<NetworkForwardOptions> {
        software.amazon.awscdk.core.Duration stickinessDuration;

        /**
         * Sets the value of {@link NetworkForwardOptions#getStickinessDuration}
         * @param stickinessDuration For how long clients should be directed to the same target group.
         *                           Range between 1 second and 7 days.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder stickinessDuration(software.amazon.awscdk.core.Duration stickinessDuration) {
            this.stickinessDuration = stickinessDuration;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link NetworkForwardOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public NetworkForwardOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link NetworkForwardOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NetworkForwardOptions {
        private final software.amazon.awscdk.core.Duration stickinessDuration;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.stickinessDuration = software.amazon.jsii.Kernel.get(this, "stickinessDuration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.stickinessDuration = builder.stickinessDuration;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getStickinessDuration() {
            return this.stickinessDuration;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getStickinessDuration() != null) {
                data.set("stickinessDuration", om.valueToTree(this.getStickinessDuration()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_elasticloadbalancingv2.NetworkForwardOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            NetworkForwardOptions.Jsii$Proxy that = (NetworkForwardOptions.Jsii$Proxy) o;

            return this.stickinessDuration != null ? this.stickinessDuration.equals(that.stickinessDuration) : that.stickinessDuration == null;
        }

        @Override
        public final int hashCode() {
            int result = this.stickinessDuration != null ? this.stickinessDuration.hashCode() : 0;
            return result;
        }
    }
}
