package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * (experimental) Backend protocol for network load balancers and health checks.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * INetworkListener listener = NetworkListener.fromLookup(this, "ALBListener", NetworkListenerLookupOptions.builder()
 *         .loadBalancerTags(Map.of(
 *                 "Cluster", "MyClusterName"))
 *         .listenerProtocol(Protocol.TCP)
 *         .listenerPort(12345)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:01.458Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_elasticloadbalancingv2.Protocol")
public enum Protocol {
    /**
     * (experimental) HTTP (ALB health checks and NLB health checks).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    HTTP,
    /**
     * (experimental) HTTPS (ALB health checks and NLB health checks).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    HTTPS,
    /**
     * (experimental) TCP (NLB, NLB health checks).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    TCP,
    /**
     * (experimental) TLS (NLB).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    TLS,
    /**
     * (experimental) UDP (NLB).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    UDP,
    /**
     * (experimental) Listen to both TCP and UDP on the same port (NLB).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    TCP_UDP,
}
