package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * (experimental) How to interpret the load balancing target identifiers.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * ApplicationTargetGroup tg = ApplicationTargetGroup.Builder.create(this, "TG")
 *         .targetType(TargetType.IP)
 *         .port(50051)
 *         .protocol(ApplicationProtocol.HTTP)
 *         .protocolVersion(ApplicationProtocolVersion.GRPC)
 *         .healthCheck(HealthCheck.builder()
 *                 .enabled(true)
 *                 .healthyGrpcCodes("0-99")
 *                 .build())
 *         .vpc(vpc)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:01.467Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_elasticloadbalancingv2.TargetType")
public enum TargetType {
    /**
     * (experimental) Targets identified by instance ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    INSTANCE,
    /**
     * (experimental) Targets identified by IP address.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    IP,
    /**
     * (experimental) Target is a single Lambda Function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    LAMBDA,
    /**
     * (experimental) Target is a single Application Load Balancer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    ALB,
}
