package software.amazon.awscdk.services.elasticloadbalancingv2.targets;

/**
 * (experimental) An IP address that is a target for load balancing.
 * <p>
 * Specify IP addresses from the subnets of the virtual private cloud (VPC) for
 * the target group, the RFC 1918 range (10.0.0.0/8, 172.16.0.0/12, and
 * 192.168.0.0/16), and the RFC 6598 range (100.64.0.0/10). You can't specify
 * publicly routable IP addresses.
 * <p>
 * If you register a target of this type, you are responsible for making
 * sure the load balancer's security group can send packets to the IP address.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.elasticloadbalancingv2.targets.*;
 * IpTarget ipTarget = new IpTarget("ipAddress", 123, "availabilityZone");
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:01.480Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_elasticloadbalancingv2_targets.IpTarget")
public class IpTarget extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerTarget, software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancerTarget {

    protected IpTarget(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected IpTarget(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * (experimental) Create a new IPAddress target.
     * <p>
     * The availabilityZone parameter determines whether the target receives
     * traffic from the load balancer nodes in the specified Availability Zone
     * or from all enabled Availability Zones for the load balancer.
     * <p>
     * This parameter is not supported if the target type of the target group
     * is instance. If the IP address is in a subnet of the VPC for the target
     * group, the Availability Zone is automatically detected and this
     * parameter is optional. If the IP address is outside the VPC, this
     * parameter is required.
     * <p>
     * With an Application Load Balancer, if the IP address is outside the VPC
     * for the target group, the only supported value is all.
     * <p>
     * Default is automatic.
     * <p>
     * @param ipAddress The IP Address to load balance to. This parameter is required.
     * @param port Override the group's default port.
     * @param availabilityZone Availability zone to send traffic from.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public IpTarget(final @org.jetbrains.annotations.NotNull java.lang.String ipAddress, final @org.jetbrains.annotations.Nullable java.lang.Number port, final @org.jetbrains.annotations.Nullable java.lang.String availabilityZone) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(ipAddress, "ipAddress is required"), port, availabilityZone });
    }

    /**
     * (experimental) Create a new IPAddress target.
     * <p>
     * The availabilityZone parameter determines whether the target receives
     * traffic from the load balancer nodes in the specified Availability Zone
     * or from all enabled Availability Zones for the load balancer.
     * <p>
     * This parameter is not supported if the target type of the target group
     * is instance. If the IP address is in a subnet of the VPC for the target
     * group, the Availability Zone is automatically detected and this
     * parameter is optional. If the IP address is outside the VPC, this
     * parameter is required.
     * <p>
     * With an Application Load Balancer, if the IP address is outside the VPC
     * for the target group, the only supported value is all.
     * <p>
     * Default is automatic.
     * <p>
     * @param ipAddress The IP Address to load balance to. This parameter is required.
     * @param port Override the group's default port.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public IpTarget(final @org.jetbrains.annotations.NotNull java.lang.String ipAddress, final @org.jetbrains.annotations.Nullable java.lang.Number port) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(ipAddress, "ipAddress is required"), port });
    }

    /**
     * (experimental) Create a new IPAddress target.
     * <p>
     * The availabilityZone parameter determines whether the target receives
     * traffic from the load balancer nodes in the specified Availability Zone
     * or from all enabled Availability Zones for the load balancer.
     * <p>
     * This parameter is not supported if the target type of the target group
     * is instance. If the IP address is in a subnet of the VPC for the target
     * group, the Availability Zone is automatically detected and this
     * parameter is optional. If the IP address is outside the VPC, this
     * parameter is required.
     * <p>
     * With an Application Load Balancer, if the IP address is outside the VPC
     * for the target group, the only supported value is all.
     * <p>
     * Default is automatic.
     * <p>
     * @param ipAddress The IP Address to load balance to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public IpTarget(final @org.jetbrains.annotations.NotNull java.lang.String ipAddress) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(ipAddress, "ipAddress is required") });
    }

    /**
     * (experimental) Register this instance target with a load balancer.
     * <p>
     * Don't call this, it is called automatically when you add the target to a
     * load balancer.
     * <p>
     * @param targetGroup This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerTargetProps attachToApplicationTargetGroup(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup targetGroup) {
        return software.amazon.jsii.Kernel.call(this, "attachToApplicationTargetGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerTargetProps.class), new Object[] { java.util.Objects.requireNonNull(targetGroup, "targetGroup is required") });
    }

    /**
     * (experimental) Register this instance target with a load balancer.
     * <p>
     * Don't call this, it is called automatically when you add the target to a
     * load balancer.
     * <p>
     * @param targetGroup This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerTargetProps attachToNetworkTargetGroup(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup targetGroup) {
        return software.amazon.jsii.Kernel.call(this, "attachToNetworkTargetGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerTargetProps.class), new Object[] { java.util.Objects.requireNonNull(targetGroup, "targetGroup is required") });
    }
}
