package software.amazon.awscdk.services.emr;

/**
 * A CloudFormation `AWS::EMR::Cluster`.
 * <p>
 * The <code>AWS::EMR::Cluster</code> resource specifies an Amazon EMR cluster. This cluster is a collection of Amazon EC2 instances that run open source big data frameworks and applications to process and analyze vast amounts of data. For more information, see the <a href="https://docs.aws.amazon.com//emr/latest/ManagementGuide/">Amazon EMR Management Guide</a> .
 * <p>
 * Amazon EMR now supports launching task instance groups and task instance fleets as part of the <code>AWS::EMR::Cluster</code> resource. This can be done by using the <code>JobFlowInstancesConfig</code> property type's <code>TaskInstanceGroups</code> and <code>TaskInstanceFleets</code> subproperties. Using these subproperties reduces delays in provisioning task nodes compared to specifying task nodes with the <code>AWS::EMR::InstanceGroupConfig</code> and <code>AWS::EMR::InstanceFleetConfig</code> resources. Please refer to the examples at the bottom of this page to learn how to use these subproperties.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.emr.*;
 * Object additionalInfo;
 * ConfigurationProperty configurationProperty_;
 * CfnCluster cfnCluster = CfnCluster.Builder.create(this, "MyCfnCluster")
 *         .instances(JobFlowInstancesConfigProperty.builder()
 *                 .additionalMasterSecurityGroups(List.of("additionalMasterSecurityGroups"))
 *                 .additionalSlaveSecurityGroups(List.of("additionalSlaveSecurityGroups"))
 *                 .coreInstanceFleet(InstanceFleetConfigProperty.builder()
 *                         .instanceTypeConfigs(List.of(InstanceTypeConfigProperty.builder()
 *                                 .instanceType("instanceType")
 *                                 // the properties below are optional
 *                                 .bidPrice("bidPrice")
 *                                 .bidPriceAsPercentageOfOnDemandPrice(123)
 *                                 .configurations(List.of(ConfigurationProperty.builder()
 *                                         .classification("classification")
 *                                         .configurationProperties(Map.of(
 *                                                 "configurationPropertiesKey", "configurationProperties"))
 *                                         .configurations(List.of(configurationProperty_))
 *                                         .build()))
 *                                 .customAmiId("customAmiId")
 *                                 .ebsConfiguration(EbsConfigurationProperty.builder()
 *                                         .ebsBlockDeviceConfigs(List.of(EbsBlockDeviceConfigProperty.builder()
 *                                                 .volumeSpecification(VolumeSpecificationProperty.builder()
 *                                                         .sizeInGb(123)
 *                                                         .volumeType("volumeType")
 *                                                         // the properties below are optional
 *                                                         .iops(123)
 *                                                         .build())
 *                                                 // the properties below are optional
 *                                                 .volumesPerInstance(123)
 *                                                 .build()))
 *                                         .ebsOptimized(false)
 *                                         .build())
 *                                 .weightedCapacity(123)
 *                                 .build()))
 *                         .launchSpecifications(InstanceFleetProvisioningSpecificationsProperty.builder()
 *                                 .onDemandSpecification(OnDemandProvisioningSpecificationProperty.builder()
 *                                         .allocationStrategy("allocationStrategy")
 *                                         .build())
 *                                 .spotSpecification(SpotProvisioningSpecificationProperty.builder()
 *                                         .timeoutAction("timeoutAction")
 *                                         .timeoutDurationMinutes(123)
 *                                         // the properties below are optional
 *                                         .allocationStrategy("allocationStrategy")
 *                                         .blockDurationMinutes(123)
 *                                         .build())
 *                                 .build())
 *                         .name("name")
 *                         .targetOnDemandCapacity(123)
 *                         .targetSpotCapacity(123)
 *                         .build())
 *                 .coreInstanceGroup(InstanceGroupConfigProperty.builder()
 *                         .instanceCount(123)
 *                         .instanceType("instanceType")
 *                         // the properties below are optional
 *                         .autoScalingPolicy(AutoScalingPolicyProperty.builder()
 *                                 .constraints(ScalingConstraintsProperty.builder()
 *                                         .maxCapacity(123)
 *                                         .minCapacity(123)
 *                                         .build())
 *                                 .rules(List.of(ScalingRuleProperty.builder()
 *                                         .action(ScalingActionProperty.builder()
 *                                                 .simpleScalingPolicyConfiguration(SimpleScalingPolicyConfigurationProperty.builder()
 *                                                         .scalingAdjustment(123)
 *                                                         // the properties below are optional
 *                                                         .adjustmentType("adjustmentType")
 *                                                         .coolDown(123)
 *                                                         .build())
 *                                                 // the properties below are optional
 *                                                 .market("market")
 *                                                 .build())
 *                                         .name("name")
 *                                         .trigger(ScalingTriggerProperty.builder()
 *                                                 .cloudWatchAlarmDefinition(CloudWatchAlarmDefinitionProperty.builder()
 *                                                         .comparisonOperator("comparisonOperator")
 *                                                         .metricName("metricName")
 *                                                         .period(123)
 *                                                         .threshold(123)
 *                                                         // the properties below are optional
 *                                                         .dimensions(List.of(MetricDimensionProperty.builder()
 *                                                                 .key("key")
 *                                                                 .value("value")
 *                                                                 .build()))
 *                                                         .evaluationPeriods(123)
 *                                                         .namespace("namespace")
 *                                                         .statistic("statistic")
 *                                                         .unit("unit")
 *                                                         .build())
 *                                                 .build())
 *                                         // the properties below are optional
 *                                         .description("description")
 *                                         .build()))
 *                                 .build())
 *                         .bidPrice("bidPrice")
 *                         .configurations(List.of(ConfigurationProperty.builder()
 *                                 .classification("classification")
 *                                 .configurationProperties(Map.of(
 *                                         "configurationPropertiesKey", "configurationProperties"))
 *                                 .configurations(List.of(configurationProperty_))
 *                                 .build()))
 *                         .customAmiId("customAmiId")
 *                         .ebsConfiguration(EbsConfigurationProperty.builder()
 *                                 .ebsBlockDeviceConfigs(List.of(EbsBlockDeviceConfigProperty.builder()
 *                                         .volumeSpecification(VolumeSpecificationProperty.builder()
 *                                                 .sizeInGb(123)
 *                                                 .volumeType("volumeType")
 *                                                 // the properties below are optional
 *                                                 .iops(123)
 *                                                 .build())
 *                                         // the properties below are optional
 *                                         .volumesPerInstance(123)
 *                                         .build()))
 *                                 .ebsOptimized(false)
 *                                 .build())
 *                         .market("market")
 *                         .name("name")
 *                         .build())
 *                 .ec2KeyName("ec2KeyName")
 *                 .ec2SubnetId("ec2SubnetId")
 *                 .ec2SubnetIds(List.of("ec2SubnetIds"))
 *                 .emrManagedMasterSecurityGroup("emrManagedMasterSecurityGroup")
 *                 .emrManagedSlaveSecurityGroup("emrManagedSlaveSecurityGroup")
 *                 .hadoopVersion("hadoopVersion")
 *                 .keepJobFlowAliveWhenNoSteps(false)
 *                 .masterInstanceFleet(InstanceFleetConfigProperty.builder()
 *                         .instanceTypeConfigs(List.of(InstanceTypeConfigProperty.builder()
 *                                 .instanceType("instanceType")
 *                                 // the properties below are optional
 *                                 .bidPrice("bidPrice")
 *                                 .bidPriceAsPercentageOfOnDemandPrice(123)
 *                                 .configurations(List.of(ConfigurationProperty.builder()
 *                                         .classification("classification")
 *                                         .configurationProperties(Map.of(
 *                                                 "configurationPropertiesKey", "configurationProperties"))
 *                                         .configurations(List.of(configurationProperty_))
 *                                         .build()))
 *                                 .customAmiId("customAmiId")
 *                                 .ebsConfiguration(EbsConfigurationProperty.builder()
 *                                         .ebsBlockDeviceConfigs(List.of(EbsBlockDeviceConfigProperty.builder()
 *                                                 .volumeSpecification(VolumeSpecificationProperty.builder()
 *                                                         .sizeInGb(123)
 *                                                         .volumeType("volumeType")
 *                                                         // the properties below are optional
 *                                                         .iops(123)
 *                                                         .build())
 *                                                 // the properties below are optional
 *                                                 .volumesPerInstance(123)
 *                                                 .build()))
 *                                         .ebsOptimized(false)
 *                                         .build())
 *                                 .weightedCapacity(123)
 *                                 .build()))
 *                         .launchSpecifications(InstanceFleetProvisioningSpecificationsProperty.builder()
 *                                 .onDemandSpecification(OnDemandProvisioningSpecificationProperty.builder()
 *                                         .allocationStrategy("allocationStrategy")
 *                                         .build())
 *                                 .spotSpecification(SpotProvisioningSpecificationProperty.builder()
 *                                         .timeoutAction("timeoutAction")
 *                                         .timeoutDurationMinutes(123)
 *                                         // the properties below are optional
 *                                         .allocationStrategy("allocationStrategy")
 *                                         .blockDurationMinutes(123)
 *                                         .build())
 *                                 .build())
 *                         .name("name")
 *                         .targetOnDemandCapacity(123)
 *                         .targetSpotCapacity(123)
 *                         .build())
 *                 .masterInstanceGroup(InstanceGroupConfigProperty.builder()
 *                         .instanceCount(123)
 *                         .instanceType("instanceType")
 *                         // the properties below are optional
 *                         .autoScalingPolicy(AutoScalingPolicyProperty.builder()
 *                                 .constraints(ScalingConstraintsProperty.builder()
 *                                         .maxCapacity(123)
 *                                         .minCapacity(123)
 *                                         .build())
 *                                 .rules(List.of(ScalingRuleProperty.builder()
 *                                         .action(ScalingActionProperty.builder()
 *                                                 .simpleScalingPolicyConfiguration(SimpleScalingPolicyConfigurationProperty.builder()
 *                                                         .scalingAdjustment(123)
 *                                                         // the properties below are optional
 *                                                         .adjustmentType("adjustmentType")
 *                                                         .coolDown(123)
 *                                                         .build())
 *                                                 // the properties below are optional
 *                                                 .market("market")
 *                                                 .build())
 *                                         .name("name")
 *                                         .trigger(ScalingTriggerProperty.builder()
 *                                                 .cloudWatchAlarmDefinition(CloudWatchAlarmDefinitionProperty.builder()
 *                                                         .comparisonOperator("comparisonOperator")
 *                                                         .metricName("metricName")
 *                                                         .period(123)
 *                                                         .threshold(123)
 *                                                         // the properties below are optional
 *                                                         .dimensions(List.of(MetricDimensionProperty.builder()
 *                                                                 .key("key")
 *                                                                 .value("value")
 *                                                                 .build()))
 *                                                         .evaluationPeriods(123)
 *                                                         .namespace("namespace")
 *                                                         .statistic("statistic")
 *                                                         .unit("unit")
 *                                                         .build())
 *                                                 .build())
 *                                         // the properties below are optional
 *                                         .description("description")
 *                                         .build()))
 *                                 .build())
 *                         .bidPrice("bidPrice")
 *                         .configurations(List.of(ConfigurationProperty.builder()
 *                                 .classification("classification")
 *                                 .configurationProperties(Map.of(
 *                                         "configurationPropertiesKey", "configurationProperties"))
 *                                 .configurations(List.of(configurationProperty_))
 *                                 .build()))
 *                         .customAmiId("customAmiId")
 *                         .ebsConfiguration(EbsConfigurationProperty.builder()
 *                                 .ebsBlockDeviceConfigs(List.of(EbsBlockDeviceConfigProperty.builder()
 *                                         .volumeSpecification(VolumeSpecificationProperty.builder()
 *                                                 .sizeInGb(123)
 *                                                 .volumeType("volumeType")
 *                                                 // the properties below are optional
 *                                                 .iops(123)
 *                                                 .build())
 *                                         // the properties below are optional
 *                                         .volumesPerInstance(123)
 *                                         .build()))
 *                                 .ebsOptimized(false)
 *                                 .build())
 *                         .market("market")
 *                         .name("name")
 *                         .build())
 *                 .placement(PlacementTypeProperty.builder()
 *                         .availabilityZone("availabilityZone")
 *                         .build())
 *                 .serviceAccessSecurityGroup("serviceAccessSecurityGroup")
 *                 .taskInstanceFleets(List.of(InstanceFleetConfigProperty.builder()
 *                         .instanceTypeConfigs(List.of(InstanceTypeConfigProperty.builder()
 *                                 .instanceType("instanceType")
 *                                 // the properties below are optional
 *                                 .bidPrice("bidPrice")
 *                                 .bidPriceAsPercentageOfOnDemandPrice(123)
 *                                 .configurations(List.of(ConfigurationProperty.builder()
 *                                         .classification("classification")
 *                                         .configurationProperties(Map.of(
 *                                                 "configurationPropertiesKey", "configurationProperties"))
 *                                         .configurations(List.of(configurationProperty_))
 *                                         .build()))
 *                                 .customAmiId("customAmiId")
 *                                 .ebsConfiguration(EbsConfigurationProperty.builder()
 *                                         .ebsBlockDeviceConfigs(List.of(EbsBlockDeviceConfigProperty.builder()
 *                                                 .volumeSpecification(VolumeSpecificationProperty.builder()
 *                                                         .sizeInGb(123)
 *                                                         .volumeType("volumeType")
 *                                                         // the properties below are optional
 *                                                         .iops(123)
 *                                                         .build())
 *                                                 // the properties below are optional
 *                                                 .volumesPerInstance(123)
 *                                                 .build()))
 *                                         .ebsOptimized(false)
 *                                         .build())
 *                                 .weightedCapacity(123)
 *                                 .build()))
 *                         .launchSpecifications(InstanceFleetProvisioningSpecificationsProperty.builder()
 *                                 .onDemandSpecification(OnDemandProvisioningSpecificationProperty.builder()
 *                                         .allocationStrategy("allocationStrategy")
 *                                         .build())
 *                                 .spotSpecification(SpotProvisioningSpecificationProperty.builder()
 *                                         .timeoutAction("timeoutAction")
 *                                         .timeoutDurationMinutes(123)
 *                                         // the properties below are optional
 *                                         .allocationStrategy("allocationStrategy")
 *                                         .blockDurationMinutes(123)
 *                                         .build())
 *                                 .build())
 *                         .name("name")
 *                         .targetOnDemandCapacity(123)
 *                         .targetSpotCapacity(123)
 *                         .build()))
 *                 .taskInstanceGroups(List.of(InstanceGroupConfigProperty.builder()
 *                         .instanceCount(123)
 *                         .instanceType("instanceType")
 *                         // the properties below are optional
 *                         .autoScalingPolicy(AutoScalingPolicyProperty.builder()
 *                                 .constraints(ScalingConstraintsProperty.builder()
 *                                         .maxCapacity(123)
 *                                         .minCapacity(123)
 *                                         .build())
 *                                 .rules(List.of(ScalingRuleProperty.builder()
 *                                         .action(ScalingActionProperty.builder()
 *                                                 .simpleScalingPolicyConfiguration(SimpleScalingPolicyConfigurationProperty.builder()
 *                                                         .scalingAdjustment(123)
 *                                                         // the properties below are optional
 *                                                         .adjustmentType("adjustmentType")
 *                                                         .coolDown(123)
 *                                                         .build())
 *                                                 // the properties below are optional
 *                                                 .market("market")
 *                                                 .build())
 *                                         .name("name")
 *                                         .trigger(ScalingTriggerProperty.builder()
 *                                                 .cloudWatchAlarmDefinition(CloudWatchAlarmDefinitionProperty.builder()
 *                                                         .comparisonOperator("comparisonOperator")
 *                                                         .metricName("metricName")
 *                                                         .period(123)
 *                                                         .threshold(123)
 *                                                         // the properties below are optional
 *                                                         .dimensions(List.of(MetricDimensionProperty.builder()
 *                                                                 .key("key")
 *                                                                 .value("value")
 *                                                                 .build()))
 *                                                         .evaluationPeriods(123)
 *                                                         .namespace("namespace")
 *                                                         .statistic("statistic")
 *                                                         .unit("unit")
 *                                                         .build())
 *                                                 .build())
 *                                         // the properties below are optional
 *                                         .description("description")
 *                                         .build()))
 *                                 .build())
 *                         .bidPrice("bidPrice")
 *                         .configurations(List.of(ConfigurationProperty.builder()
 *                                 .classification("classification")
 *                                 .configurationProperties(Map.of(
 *                                         "configurationPropertiesKey", "configurationProperties"))
 *                                 .configurations(List.of(configurationProperty_))
 *                                 .build()))
 *                         .customAmiId("customAmiId")
 *                         .ebsConfiguration(EbsConfigurationProperty.builder()
 *                                 .ebsBlockDeviceConfigs(List.of(EbsBlockDeviceConfigProperty.builder()
 *                                         .volumeSpecification(VolumeSpecificationProperty.builder()
 *                                                 .sizeInGb(123)
 *                                                 .volumeType("volumeType")
 *                                                 // the properties below are optional
 *                                                 .iops(123)
 *                                                 .build())
 *                                         // the properties below are optional
 *                                         .volumesPerInstance(123)
 *                                         .build()))
 *                                 .ebsOptimized(false)
 *                                 .build())
 *                         .market("market")
 *                         .name("name")
 *                         .build()))
 *                 .terminationProtected(false)
 *                 .build())
 *         .jobFlowRole("jobFlowRole")
 *         .name("name")
 *         .serviceRole("serviceRole")
 *         // the properties below are optional
 *         .additionalInfo(additionalInfo)
 *         .applications(List.of(ApplicationProperty.builder()
 *                 .additionalInfo(Map.of(
 *                         "additionalInfoKey", "additionalInfo"))
 *                 .args(List.of("args"))
 *                 .name("name")
 *                 .version("version")
 *                 .build()))
 *         .autoScalingRole("autoScalingRole")
 *         .autoTerminationPolicy(AutoTerminationPolicyProperty.builder()
 *                 .idleTimeout(123)
 *                 .build())
 *         .bootstrapActions(List.of(BootstrapActionConfigProperty.builder()
 *                 .name("name")
 *                 .scriptBootstrapAction(ScriptBootstrapActionConfigProperty.builder()
 *                         .path("path")
 *                         // the properties below are optional
 *                         .args(List.of("args"))
 *                         .build())
 *                 .build()))
 *         .configurations(List.of(ConfigurationProperty.builder()
 *                 .classification("classification")
 *                 .configurationProperties(Map.of(
 *                         "configurationPropertiesKey", "configurationProperties"))
 *                 .configurations(List.of(configurationProperty_))
 *                 .build()))
 *         .customAmiId("customAmiId")
 *         .ebsRootVolumeSize(123)
 *         .kerberosAttributes(KerberosAttributesProperty.builder()
 *                 .kdcAdminPassword("kdcAdminPassword")
 *                 .realm("realm")
 *                 // the properties below are optional
 *                 .adDomainJoinPassword("adDomainJoinPassword")
 *                 .adDomainJoinUser("adDomainJoinUser")
 *                 .crossRealmTrustPrincipalPassword("crossRealmTrustPrincipalPassword")
 *                 .build())
 *         .logEncryptionKmsKeyId("logEncryptionKmsKeyId")
 *         .logUri("logUri")
 *         .managedScalingPolicy(ManagedScalingPolicyProperty.builder()
 *                 .computeLimits(ComputeLimitsProperty.builder()
 *                         .maximumCapacityUnits(123)
 *                         .minimumCapacityUnits(123)
 *                         .unitType("unitType")
 *                         // the properties below are optional
 *                         .maximumCoreCapacityUnits(123)
 *                         .maximumOnDemandCapacityUnits(123)
 *                         .build())
 *                 .build())
 *         .osReleaseLabel("osReleaseLabel")
 *         .releaseLabel("releaseLabel")
 *         .scaleDownBehavior("scaleDownBehavior")
 *         .securityConfiguration("securityConfiguration")
 *         .stepConcurrencyLevel(123)
 *         .steps(List.of(StepConfigProperty.builder()
 *                 .hadoopJarStep(HadoopJarStepConfigProperty.builder()
 *                         .jar("jar")
 *                         // the properties below are optional
 *                         .args(List.of("args"))
 *                         .mainClass("mainClass")
 *                         .stepProperties(List.of(KeyValueProperty.builder()
 *                                 .key("key")
 *                                 .value("value")
 *                                 .build()))
 *                         .build())
 *                 .name("name")
 *                 // the properties below are optional
 *                 .actionOnFailure("actionOnFailure")
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .visibleToAllUsers(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:01.587Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_emr.CfnCluster")
public class CfnCluster extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnCluster(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCluster(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.emr.CfnCluster.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::EMR::Cluster`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnCluster(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.emr.CfnClusterProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The public DNS name of the master node (instance), such as `ec2-12-123-123-123.us-west-2.compute.amazonaws.com` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrMasterPublicDns() {
        return software.amazon.jsii.Kernel.get(this, "attrMasterPublicDns", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A list of tags associated with a cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * A JSON string for selecting additional features.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getAdditionalInfo() {
        return software.amazon.jsii.Kernel.get(this, "additionalInfo", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A JSON string for selecting additional features.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAdditionalInfo(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "additionalInfo", java.util.Objects.requireNonNull(value, "additionalInfo is required"));
    }

    /**
     * A specification of the number and type of Amazon EC2 instances.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getInstances() {
        return software.amazon.jsii.Kernel.get(this, "instances", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A specification of the number and type of Amazon EC2 instances.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstances(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.emr.CfnCluster.JobFlowInstancesConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "instances", java.util.Objects.requireNonNull(value, "instances is required"));
    }

    /**
     * A specification of the number and type of Amazon EC2 instances.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstances(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "instances", java.util.Objects.requireNonNull(value, "instances is required"));
    }

    /**
     * Also called instance profile and EC2 role.
     * <p>
     * An IAM role for an EMR cluster. The EC2 instances of the cluster assume this role. The default role is <code>EMR_EC2_DefaultRole</code> . In order to use the default role, you must have already created it using the CLI or console.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getJobFlowRole() {
        return software.amazon.jsii.Kernel.get(this, "jobFlowRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Also called instance profile and EC2 role.
     * <p>
     * An IAM role for an EMR cluster. The EC2 instances of the cluster assume this role. The default role is <code>EMR_EC2_DefaultRole</code> . In order to use the default role, you must have already created it using the CLI or console.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setJobFlowRole(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "jobFlowRole", java.util.Objects.requireNonNull(value, "jobFlowRole is required"));
    }

    /**
     * The name of the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The IAM role that Amazon EMR assumes in order to access AWS resources on your behalf.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getServiceRole() {
        return software.amazon.jsii.Kernel.get(this, "serviceRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The IAM role that Amazon EMR assumes in order to access AWS resources on your behalf.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServiceRole(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "serviceRole", java.util.Objects.requireNonNull(value, "serviceRole is required"));
    }

    /**
     * The applications to install on this cluster, for example, Spark, Flink, Oozie, Zeppelin, and so on.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getApplications() {
        return software.amazon.jsii.Kernel.get(this, "applications", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The applications to install on this cluster, for example, Spark, Flink, Oozie, Zeppelin, and so on.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApplications(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "applications", value);
    }

    /**
     * The applications to install on this cluster, for example, Spark, Flink, Oozie, Zeppelin, and so on.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApplications(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.emr.CfnCluster.ApplicationProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.core.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.emr.CfnCluster.ApplicationProperty, software.amazon.awscdk.core.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "applications", value);
    }

    /**
     * An IAM role for automatic scaling policies.
     * <p>
     * The default role is <code>EMR_AutoScaling_DefaultRole</code> . The IAM role provides permissions that the automatic scaling feature requires to launch and terminate EC2 instances in an instance group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAutoScalingRole() {
        return software.amazon.jsii.Kernel.get(this, "autoScalingRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * An IAM role for automatic scaling policies.
     * <p>
     * The default role is <code>EMR_AutoScaling_DefaultRole</code> . The IAM role provides permissions that the automatic scaling feature requires to launch and terminate EC2 instances in an instance group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoScalingRole(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "autoScalingRole", value);
    }

    /**
     * `AWS::EMR::Cluster.AutoTerminationPolicy`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAutoTerminationPolicy() {
        return software.amazon.jsii.Kernel.get(this, "autoTerminationPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::EMR::Cluster.AutoTerminationPolicy`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoTerminationPolicy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.emr.CfnCluster.AutoTerminationPolicyProperty value) {
        software.amazon.jsii.Kernel.set(this, "autoTerminationPolicy", value);
    }

    /**
     * `AWS::EMR::Cluster.AutoTerminationPolicy`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoTerminationPolicy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "autoTerminationPolicy", value);
    }

    /**
     * A list of bootstrap actions to run before Hadoop starts on the cluster nodes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getBootstrapActions() {
        return software.amazon.jsii.Kernel.get(this, "bootstrapActions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of bootstrap actions to run before Hadoop starts on the cluster nodes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBootstrapActions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "bootstrapActions", value);
    }

    /**
     * A list of bootstrap actions to run before Hadoop starts on the cluster nodes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBootstrapActions(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.emr.CfnCluster.BootstrapActionConfigProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.core.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.emr.CfnCluster.BootstrapActionConfigProperty, software.amazon.awscdk.core.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "bootstrapActions", value);
    }

    /**
     * Applies only to Amazon EMR releases 4.x and later. The list of Configurations supplied to the EMR cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getConfigurations() {
        return software.amazon.jsii.Kernel.get(this, "configurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Applies only to Amazon EMR releases 4.x and later. The list of Configurations supplied to the EMR cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfigurations(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "configurations", value);
    }

    /**
     * Applies only to Amazon EMR releases 4.x and later. The list of Configurations supplied to the EMR cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfigurations(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.emr.CfnCluster.ConfigurationProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.core.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.emr.CfnCluster.ConfigurationProperty, software.amazon.awscdk.core.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "configurations", value);
    }

    /**
     * Available only in Amazon EMR version 5.7.0 and later. The ID of a custom Amazon EBS-backed Linux AMI if the cluster uses a custom AMI.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCustomAmiId() {
        return software.amazon.jsii.Kernel.get(this, "customAmiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Available only in Amazon EMR version 5.7.0 and later. The ID of a custom Amazon EBS-backed Linux AMI if the cluster uses a custom AMI.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCustomAmiId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "customAmiId", value);
    }

    /**
     * The size, in GiB, of the Amazon EBS root device volume of the Linux AMI that is used for each EC2 instance.
     * <p>
     * Available in Amazon EMR version 4.x and later.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getEbsRootVolumeSize() {
        return software.amazon.jsii.Kernel.get(this, "ebsRootVolumeSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The size, in GiB, of the Amazon EBS root device volume of the Linux AMI that is used for each EC2 instance.
     * <p>
     * Available in Amazon EMR version 4.x and later.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEbsRootVolumeSize(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "ebsRootVolumeSize", value);
    }

    /**
     * Attributes for Kerberos configuration when Kerberos authentication is enabled using a security configuration.
     * <p>
     * For more information see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-kerberos.html">Use Kerberos Authentication</a> in the <em>Amazon EMR Management Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getKerberosAttributes() {
        return software.amazon.jsii.Kernel.get(this, "kerberosAttributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Attributes for Kerberos configuration when Kerberos authentication is enabled using a security configuration.
     * <p>
     * For more information see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-kerberos.html">Use Kerberos Authentication</a> in the <em>Amazon EMR Management Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKerberosAttributes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.emr.CfnCluster.KerberosAttributesProperty value) {
        software.amazon.jsii.Kernel.set(this, "kerberosAttributes", value);
    }

    /**
     * Attributes for Kerberos configuration when Kerberos authentication is enabled using a security configuration.
     * <p>
     * For more information see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-kerberos.html">Use Kerberos Authentication</a> in the <em>Amazon EMR Management Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKerberosAttributes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "kerberosAttributes", value);
    }

    /**
     * The AWS KMS key used for encrypting log files.
     * <p>
     * This attribute is only available with EMR version 5.30.0 and later, excluding EMR 6.0.0.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getLogEncryptionKmsKeyId() {
        return software.amazon.jsii.Kernel.get(this, "logEncryptionKmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The AWS KMS key used for encrypting log files.
     * <p>
     * This attribute is only available with EMR version 5.30.0 and later, excluding EMR 6.0.0.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLogEncryptionKmsKeyId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "logEncryptionKmsKeyId", value);
    }

    /**
     * The path to the Amazon S3 location where logs for this cluster are stored.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getLogUri() {
        return software.amazon.jsii.Kernel.get(this, "logUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The path to the Amazon S3 location where logs for this cluster are stored.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLogUri(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "logUri", value);
    }

    /**
     * Creates or updates a managed scaling policy for an Amazon EMR cluster.
     * <p>
     * The managed scaling policy defines the limits for resources, such as EC2 instances that can be added or terminated from a cluster. The policy only applies to the core and task nodes. The master node cannot be scaled after initial configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getManagedScalingPolicy() {
        return software.amazon.jsii.Kernel.get(this, "managedScalingPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Creates or updates a managed scaling policy for an Amazon EMR cluster.
     * <p>
     * The managed scaling policy defines the limits for resources, such as EC2 instances that can be added or terminated from a cluster. The policy only applies to the core and task nodes. The master node cannot be scaled after initial configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setManagedScalingPolicy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.emr.CfnCluster.ManagedScalingPolicyProperty value) {
        software.amazon.jsii.Kernel.set(this, "managedScalingPolicy", value);
    }

    /**
     * Creates or updates a managed scaling policy for an Amazon EMR cluster.
     * <p>
     * The managed scaling policy defines the limits for resources, such as EC2 instances that can be added or terminated from a cluster. The policy only applies to the core and task nodes. The master node cannot be scaled after initial configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setManagedScalingPolicy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "managedScalingPolicy", value);
    }

    /**
     * The Amazon Linux release specified in a cluster launch RunJobFlow request.
     * <p>
     * If no Amazon Linux release was specified, the default Amazon Linux release is shown in the response.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getOsReleaseLabel() {
        return software.amazon.jsii.Kernel.get(this, "osReleaseLabel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Linux release specified in a cluster launch RunJobFlow request.
     * <p>
     * If no Amazon Linux release was specified, the default Amazon Linux release is shown in the response.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOsReleaseLabel(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "osReleaseLabel", value);
    }

    /**
     * The Amazon EMR release label, which determines the version of open-source application packages installed on the cluster.
     * <p>
     * Release labels are in the form <code>emr-x.x.x</code> , where x.x.x is an Amazon EMR release version such as <code>emr-5.14.0</code> . For more information about Amazon EMR release versions and included application versions and features, see <a href="https://docs.aws.amazon.com/emr/latest/ReleaseGuide/"></a> . The release label applies only to Amazon EMR releases version 4.0 and later. Earlier versions use <code>AmiVersion</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getReleaseLabel() {
        return software.amazon.jsii.Kernel.get(this, "releaseLabel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon EMR release label, which determines the version of open-source application packages installed on the cluster.
     * <p>
     * Release labels are in the form <code>emr-x.x.x</code> , where x.x.x is an Amazon EMR release version such as <code>emr-5.14.0</code> . For more information about Amazon EMR release versions and included application versions and features, see <a href="https://docs.aws.amazon.com/emr/latest/ReleaseGuide/"></a> . The release label applies only to Amazon EMR releases version 4.0 and later. Earlier versions use <code>AmiVersion</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReleaseLabel(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "releaseLabel", value);
    }

    /**
     * The way that individual Amazon EC2 instances terminate when an automatic scale-in activity occurs or an instance group is resized.
     * <p>
     * <code>TERMINATE_AT_INSTANCE_HOUR</code> indicates that Amazon EMR terminates nodes at the instance-hour boundary, regardless of when the request to terminate the instance was submitted. This option is only available with Amazon EMR 5.1.0 and later and is the default for clusters created using that version. <code>TERMINATE_AT_TASK_COMPLETION</code> indicates that Amazon EMR adds nodes to a deny list and drains tasks from nodes before terminating the Amazon EC2 instances, regardless of the instance-hour boundary. With either behavior, Amazon EMR removes the least active nodes first and blocks instance termination if it could lead to HDFS corruption. <code>TERMINATE_AT_TASK_COMPLETION</code> is available only in Amazon EMR version 4.1.0 and later, and is the default for versions of Amazon EMR earlier than 5.1.0.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getScaleDownBehavior() {
        return software.amazon.jsii.Kernel.get(this, "scaleDownBehavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The way that individual Amazon EC2 instances terminate when an automatic scale-in activity occurs or an instance group is resized.
     * <p>
     * <code>TERMINATE_AT_INSTANCE_HOUR</code> indicates that Amazon EMR terminates nodes at the instance-hour boundary, regardless of when the request to terminate the instance was submitted. This option is only available with Amazon EMR 5.1.0 and later and is the default for clusters created using that version. <code>TERMINATE_AT_TASK_COMPLETION</code> indicates that Amazon EMR adds nodes to a deny list and drains tasks from nodes before terminating the Amazon EC2 instances, regardless of the instance-hour boundary. With either behavior, Amazon EMR removes the least active nodes first and blocks instance termination if it could lead to HDFS corruption. <code>TERMINATE_AT_TASK_COMPLETION</code> is available only in Amazon EMR version 4.1.0 and later, and is the default for versions of Amazon EMR earlier than 5.1.0.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setScaleDownBehavior(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "scaleDownBehavior", value);
    }

    /**
     * The name of the security configuration applied to the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSecurityConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "securityConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the security configuration applied to the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSecurityConfiguration(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "securityConfiguration", value);
    }

    /**
     * Specifies the number of steps that can be executed concurrently.
     * <p>
     * The default value is <code>1</code> . The maximum value is <code>256</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getStepConcurrencyLevel() {
        return software.amazon.jsii.Kernel.get(this, "stepConcurrencyLevel", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * Specifies the number of steps that can be executed concurrently.
     * <p>
     * The default value is <code>1</code> . The maximum value is <code>256</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStepConcurrencyLevel(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "stepConcurrencyLevel", value);
    }

    /**
     * A list of steps to run.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSteps() {
        return software.amazon.jsii.Kernel.get(this, "steps", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of steps to run.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSteps(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "steps", value);
    }

    /**
     * A list of steps to run.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSteps(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.emr.CfnCluster.StepConfigProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.core.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.emr.CfnCluster.StepConfigProperty, software.amazon.awscdk.core.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "steps", value);
    }

    /**
     * Indicates whether the cluster is visible to all IAM users of the AWS account associated with the cluster.
     * <p>
     * If this value is set to <code>true</code> , all IAM users of that AWS account can view and manage the cluster if they have the proper policy permissions set. If this value is <code>false</code> , only the IAM user that created the cluster can view and manage it. This value can be changed using the SetVisibleToAllUsers action.
     * <p>
     * <blockquote>
     * <p>
     * When you create clusters directly through the EMR console or API, this value is set to <code>true</code> by default. However, for <code>AWS::EMR::Cluster</code> resources in CloudFormation, the default is <code>false</code> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getVisibleToAllUsers() {
        return software.amazon.jsii.Kernel.get(this, "visibleToAllUsers", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Indicates whether the cluster is visible to all IAM users of the AWS account associated with the cluster.
     * <p>
     * If this value is set to <code>true</code> , all IAM users of that AWS account can view and manage the cluster if they have the proper policy permissions set. If this value is <code>false</code> , only the IAM user that created the cluster can view and manage it. This value can be changed using the SetVisibleToAllUsers action.
     * <p>
     * <blockquote>
     * <p>
     * When you create clusters directly through the EMR console or API, this value is set to <code>true</code> by default. However, for <code>AWS::EMR::Cluster</code> resources in CloudFormation, the default is <code>false</code> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVisibleToAllUsers(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "visibleToAllUsers", value);
    }

    /**
     * Indicates whether the cluster is visible to all IAM users of the AWS account associated with the cluster.
     * <p>
     * If this value is set to <code>true</code> , all IAM users of that AWS account can view and manage the cluster if they have the proper policy permissions set. If this value is <code>false</code> , only the IAM user that created the cluster can view and manage it. This value can be changed using the SetVisibleToAllUsers action.
     * <p>
     * <blockquote>
     * <p>
     * When you create clusters directly through the EMR console or API, this value is set to <code>true</code> by default. However, for <code>AWS::EMR::Cluster</code> resources in CloudFormation, the default is <code>false</code> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVisibleToAllUsers(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "visibleToAllUsers", value);
    }
    /**
     * `Application` is a property of `AWS::EMR::Cluster` .
     * <p>
     * The <code>Application</code> property type defines the open-source big data applications for EMR to install and configure when a cluster is created.
     * <p>
     * With Amazon EMR release version 4.0 and later, the only accepted parameter is the application <code>Name</code> . To pass arguments to these applications, you use configuration classifications specified using JSON objects in a <code>Configuration</code> property. For more information, see <a href="https://docs.aws.amazon.com//emr/latest/ReleaseGuide/emr-configure-apps.html">Configuring Applications</a> .
     * <p>
     * With earlier Amazon EMR releases, the application is any AWS or third-party software that you can add to the cluster. You can specify the version of the application and arguments to pass to it. Amazon EMR accepts and forwards the argument list to the corresponding installation script as a bootstrap action argument.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emr.*;
     * ApplicationProperty applicationProperty = ApplicationProperty.builder()
     *         .additionalInfo(Map.of(
     *                 "additionalInfoKey", "additionalInfo"))
     *         .args(List.of("args"))
     *         .name("name")
     *         .version("version")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_emr.CfnCluster.ApplicationProperty")
    @software.amazon.jsii.Jsii.Proxy(ApplicationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ApplicationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * This option is for advanced users only.
         * <p>
         * This is meta information about clusters and applications that are used for testing and troubleshooting.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAdditionalInfo() {
            return null;
        }

        /**
         * Arguments for Amazon EMR to pass to the application.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getArgs() {
            return null;
        }

        /**
         * The name of the application.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * The version of the application.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVersion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ApplicationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ApplicationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ApplicationProperty> {
            java.lang.Object additionalInfo;
            java.util.List<java.lang.String> args;
            java.lang.String name;
            java.lang.String version;

            /**
             * Sets the value of {@link ApplicationProperty#getAdditionalInfo}
             * @param additionalInfo This option is for advanced users only.
             *                       This is meta information about clusters and applications that are used for testing and troubleshooting.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder additionalInfo(software.amazon.awscdk.core.IResolvable additionalInfo) {
                this.additionalInfo = additionalInfo;
                return this;
            }

            /**
             * Sets the value of {@link ApplicationProperty#getAdditionalInfo}
             * @param additionalInfo This option is for advanced users only.
             *                       This is meta information about clusters and applications that are used for testing and troubleshooting.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder additionalInfo(java.util.Map<java.lang.String, java.lang.String> additionalInfo) {
                this.additionalInfo = additionalInfo;
                return this;
            }

            /**
             * Sets the value of {@link ApplicationProperty#getArgs}
             * @param args Arguments for Amazon EMR to pass to the application.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder args(java.util.List<java.lang.String> args) {
                this.args = args;
                return this;
            }

            /**
             * Sets the value of {@link ApplicationProperty#getName}
             * @param name The name of the application.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link ApplicationProperty#getVersion}
             * @param version The version of the application.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder version(java.lang.String version) {
                this.version = version;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ApplicationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ApplicationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ApplicationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApplicationProperty {
            private final java.lang.Object additionalInfo;
            private final java.util.List<java.lang.String> args;
            private final java.lang.String name;
            private final java.lang.String version;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.additionalInfo = software.amazon.jsii.Kernel.get(this, "additionalInfo", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.args = software.amazon.jsii.Kernel.get(this, "args", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.additionalInfo = builder.additionalInfo;
                this.args = builder.args;
                this.name = builder.name;
                this.version = builder.version;
            }

            @Override
            public final java.lang.Object getAdditionalInfo() {
                return this.additionalInfo;
            }

            @Override
            public final java.util.List<java.lang.String> getArgs() {
                return this.args;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getVersion() {
                return this.version;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAdditionalInfo() != null) {
                    data.set("additionalInfo", om.valueToTree(this.getAdditionalInfo()));
                }
                if (this.getArgs() != null) {
                    data.set("args", om.valueToTree(this.getArgs()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getVersion() != null) {
                    data.set("version", om.valueToTree(this.getVersion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_emr.CfnCluster.ApplicationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ApplicationProperty.Jsii$Proxy that = (ApplicationProperty.Jsii$Proxy) o;

                if (this.additionalInfo != null ? !this.additionalInfo.equals(that.additionalInfo) : that.additionalInfo != null) return false;
                if (this.args != null ? !this.args.equals(that.args) : that.args != null) return false;
                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                return this.version != null ? this.version.equals(that.version) : that.version == null;
            }

            @Override
            public final int hashCode() {
                int result = this.additionalInfo != null ? this.additionalInfo.hashCode() : 0;
                result = 31 * result + (this.args != null ? this.args.hashCode() : 0);
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * `AutoScalingPolicy` is a subproperty of `InstanceGroupConfig` .
     * <p>
     * <code>AutoScalingPolicy</code> defines how an instance group dynamically adds and terminates EC2 instances in response to the value of a CloudWatch metric. For more information, see <a href="https://docs.aws.amazon.com//emr/latest/ManagementGuide/emr-automatic-scaling.html">Using Automatic Scaling in Amazon EMR</a> in the <em>Amazon EMR Management Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emr.*;
     * AutoScalingPolicyProperty autoScalingPolicyProperty = AutoScalingPolicyProperty.builder()
     *         .constraints(ScalingConstraintsProperty.builder()
     *                 .maxCapacity(123)
     *                 .minCapacity(123)
     *                 .build())
     *         .rules(List.of(ScalingRuleProperty.builder()
     *                 .action(ScalingActionProperty.builder()
     *                         .simpleScalingPolicyConfiguration(SimpleScalingPolicyConfigurationProperty.builder()
     *                                 .scalingAdjustment(123)
     *                                 // the properties below are optional
     *                                 .adjustmentType("adjustmentType")
     *                                 .coolDown(123)
     *                                 .build())
     *                         // the properties below are optional
     *                         .market("market")
     *                         .build())
     *                 .name("name")
     *                 .trigger(ScalingTriggerProperty.builder()
     *                         .cloudWatchAlarmDefinition(CloudWatchAlarmDefinitionProperty.builder()
     *                                 .comparisonOperator("comparisonOperator")
     *                                 .metricName("metricName")
     *                                 .period(123)
     *                                 .threshold(123)
     *                                 // the properties below are optional
     *                                 .dimensions(List.of(MetricDimensionProperty.builder()
     *                                         .key("key")
     *                                         .value("value")
     *                                         .build()))
     *                                 .evaluationPeriods(123)
     *                                 .namespace("namespace")
     *                                 .statistic("statistic")
     *                                 .unit("unit")
     *                                 .build())
     *                         .build())
     *                 // the properties below are optional
     *                 .description("description")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_emr.CfnCluster.AutoScalingPolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(AutoScalingPolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AutoScalingPolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The upper and lower EC2 instance limits for an automatic scaling policy.
         * <p>
         * Automatic scaling activity will not cause an instance group to grow above or below these limits.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getConstraints();

        /**
         * The scale-in and scale-out rules that comprise the automatic scaling policy.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getRules();

        /**
         * @return a {@link Builder} of {@link AutoScalingPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AutoScalingPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AutoScalingPolicyProperty> {
            java.lang.Object constraints;
            java.lang.Object rules;

            /**
             * Sets the value of {@link AutoScalingPolicyProperty#getConstraints}
             * @param constraints The upper and lower EC2 instance limits for an automatic scaling policy. This parameter is required.
             *                    Automatic scaling activity will not cause an instance group to grow above or below these limits.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder constraints(software.amazon.awscdk.services.emr.CfnCluster.ScalingConstraintsProperty constraints) {
                this.constraints = constraints;
                return this;
            }

            /**
             * Sets the value of {@link AutoScalingPolicyProperty#getConstraints}
             * @param constraints The upper and lower EC2 instance limits for an automatic scaling policy. This parameter is required.
             *                    Automatic scaling activity will not cause an instance group to grow above or below these limits.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder constraints(software.amazon.awscdk.core.IResolvable constraints) {
                this.constraints = constraints;
                return this;
            }

            /**
             * Sets the value of {@link AutoScalingPolicyProperty#getRules}
             * @param rules The scale-in and scale-out rules that comprise the automatic scaling policy. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rules(software.amazon.awscdk.core.IResolvable rules) {
                this.rules = rules;
                return this;
            }

            /**
             * Sets the value of {@link AutoScalingPolicyProperty#getRules}
             * @param rules The scale-in and scale-out rules that comprise the automatic scaling policy. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rules(java.util.List<? extends java.lang.Object> rules) {
                this.rules = rules;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AutoScalingPolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AutoScalingPolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AutoScalingPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AutoScalingPolicyProperty {
            private final java.lang.Object constraints;
            private final java.lang.Object rules;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.constraints = software.amazon.jsii.Kernel.get(this, "constraints", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.rules = software.amazon.jsii.Kernel.get(this, "rules", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.constraints = java.util.Objects.requireNonNull(builder.constraints, "constraints is required");
                this.rules = java.util.Objects.requireNonNull(builder.rules, "rules is required");
            }

            @Override
            public final java.lang.Object getConstraints() {
                return this.constraints;
            }

            @Override
            public final java.lang.Object getRules() {
                return this.rules;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("constraints", om.valueToTree(this.getConstraints()));
                data.set("rules", om.valueToTree(this.getRules()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_emr.CfnCluster.AutoScalingPolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AutoScalingPolicyProperty.Jsii$Proxy that = (AutoScalingPolicyProperty.Jsii$Proxy) o;

                if (!constraints.equals(that.constraints)) return false;
                return this.rules.equals(that.rules);
            }

            @Override
            public final int hashCode() {
                int result = this.constraints.hashCode();
                result = 31 * result + (this.rules.hashCode());
                return result;
            }
        }
    }
    /**
     * An auto-termination policy for an Amazon EMR cluster.
     * <p>
     * An auto-termination policy defines the amount of idle time in seconds after which a cluster automatically terminates. For alternative cluster termination options, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-termination.html">Control cluster termination</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emr.*;
     * AutoTerminationPolicyProperty autoTerminationPolicyProperty = AutoTerminationPolicyProperty.builder()
     *         .idleTimeout(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_emr.CfnCluster.AutoTerminationPolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(AutoTerminationPolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AutoTerminationPolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the amount of idle time in seconds after which the cluster automatically terminates.
         * <p>
         * You can specify a minimum of 60 seconds and a maximum of 604800 seconds (seven days).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getIdleTimeout() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AutoTerminationPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AutoTerminationPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AutoTerminationPolicyProperty> {
            java.lang.Number idleTimeout;

            /**
             * Sets the value of {@link AutoTerminationPolicyProperty#getIdleTimeout}
             * @param idleTimeout Specifies the amount of idle time in seconds after which the cluster automatically terminates.
             *                    You can specify a minimum of 60 seconds and a maximum of 604800 seconds (seven days).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder idleTimeout(java.lang.Number idleTimeout) {
                this.idleTimeout = idleTimeout;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AutoTerminationPolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AutoTerminationPolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AutoTerminationPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AutoTerminationPolicyProperty {
            private final java.lang.Number idleTimeout;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.idleTimeout = software.amazon.jsii.Kernel.get(this, "idleTimeout", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.idleTimeout = builder.idleTimeout;
            }

            @Override
            public final java.lang.Number getIdleTimeout() {
                return this.idleTimeout;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getIdleTimeout() != null) {
                    data.set("idleTimeout", om.valueToTree(this.getIdleTimeout()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_emr.CfnCluster.AutoTerminationPolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AutoTerminationPolicyProperty.Jsii$Proxy that = (AutoTerminationPolicyProperty.Jsii$Proxy) o;

                return this.idleTimeout != null ? this.idleTimeout.equals(that.idleTimeout) : that.idleTimeout == null;
            }

            @Override
            public final int hashCode() {
                int result = this.idleTimeout != null ? this.idleTimeout.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * `BootstrapActionConfig` is a property of `AWS::EMR::Cluster` that can be used to run bootstrap actions on EMR clusters.
     * <p>
     * You can use a bootstrap action to install software and configure EC2 instances for all cluster nodes before EMR installs and configures open-source big data applications on cluster instances. For more information, see <a href="https://docs.aws.amazon.com//emr/latest/ManagementGuide/emr-plan-bootstrap.html">Create Bootstrap Actions to Install Additional Software</a> in the <em>Amazon EMR Management Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emr.*;
     * BootstrapActionConfigProperty bootstrapActionConfigProperty = BootstrapActionConfigProperty.builder()
     *         .name("name")
     *         .scriptBootstrapAction(ScriptBootstrapActionConfigProperty.builder()
     *                 .path("path")
     *                 // the properties below are optional
     *                 .args(List.of("args"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_emr.CfnCluster.BootstrapActionConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(BootstrapActionConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BootstrapActionConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the bootstrap action.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The script run by the bootstrap action.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getScriptBootstrapAction();

        /**
         * @return a {@link Builder} of {@link BootstrapActionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BootstrapActionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BootstrapActionConfigProperty> {
            java.lang.String name;
            java.lang.Object scriptBootstrapAction;

            /**
             * Sets the value of {@link BootstrapActionConfigProperty#getName}
             * @param name The name of the bootstrap action. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link BootstrapActionConfigProperty#getScriptBootstrapAction}
             * @param scriptBootstrapAction The script run by the bootstrap action. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scriptBootstrapAction(software.amazon.awscdk.services.emr.CfnCluster.ScriptBootstrapActionConfigProperty scriptBootstrapAction) {
                this.scriptBootstrapAction = scriptBootstrapAction;
                return this;
            }

            /**
             * Sets the value of {@link BootstrapActionConfigProperty#getScriptBootstrapAction}
             * @param scriptBootstrapAction The script run by the bootstrap action. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scriptBootstrapAction(software.amazon.awscdk.core.IResolvable scriptBootstrapAction) {
                this.scriptBootstrapAction = scriptBootstrapAction;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BootstrapActionConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BootstrapActionConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BootstrapActionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BootstrapActionConfigProperty {
            private final java.lang.String name;
            private final java.lang.Object scriptBootstrapAction;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.scriptBootstrapAction = software.amazon.jsii.Kernel.get(this, "scriptBootstrapAction", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.scriptBootstrapAction = java.util.Objects.requireNonNull(builder.scriptBootstrapAction, "scriptBootstrapAction is required");
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getScriptBootstrapAction() {
                return this.scriptBootstrapAction;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("scriptBootstrapAction", om.valueToTree(this.getScriptBootstrapAction()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_emr.CfnCluster.BootstrapActionConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BootstrapActionConfigProperty.Jsii$Proxy that = (BootstrapActionConfigProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.scriptBootstrapAction.equals(that.scriptBootstrapAction);
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.scriptBootstrapAction.hashCode());
                return result;
            }
        }
    }
    /**
     * `CloudWatchAlarmDefinition` is a subproperty of the `ScalingTrigger` property, which determines when to trigger an automatic scaling activity.
     * <p>
     * Scaling activity begins when you satisfy the defined alarm conditions.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emr.*;
     * CloudWatchAlarmDefinitionProperty cloudWatchAlarmDefinitionProperty = CloudWatchAlarmDefinitionProperty.builder()
     *         .comparisonOperator("comparisonOperator")
     *         .metricName("metricName")
     *         .period(123)
     *         .threshold(123)
     *         // the properties below are optional
     *         .dimensions(List.of(MetricDimensionProperty.builder()
     *                 .key("key")
     *                 .value("value")
     *                 .build()))
     *         .evaluationPeriods(123)
     *         .namespace("namespace")
     *         .statistic("statistic")
     *         .unit("unit")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_emr.CfnCluster.CloudWatchAlarmDefinitionProperty")
    @software.amazon.jsii.Jsii.Proxy(CloudWatchAlarmDefinitionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CloudWatchAlarmDefinitionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Determines how the metric specified by `MetricName` is compared to the value specified by `Threshold` .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getComparisonOperator();

        /**
         * The name of the CloudWatch metric that is watched to determine an alarm condition.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMetricName();

        /**
         * The period, in seconds, over which the statistic is applied.
         * <p>
         * EMR CloudWatch metrics are emitted every five minutes (300 seconds), so if an EMR CloudWatch metric is specified, specify <code>300</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getPeriod();

        /**
         * The value against which the specified statistic is compared.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getThreshold();

        /**
         * A CloudWatch metric dimension.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDimensions() {
            return null;
        }

        /**
         * The number of periods, in five-minute increments, during which the alarm condition must exist before the alarm triggers automatic scaling activity.
         * <p>
         * The default value is <code>1</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getEvaluationPeriods() {
            return null;
        }

        /**
         * The namespace for the CloudWatch metric.
         * <p>
         * The default is <code>AWS/ElasticMapReduce</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNamespace() {
            return null;
        }

        /**
         * The statistic to apply to the metric associated with the alarm.
         * <p>
         * The default is <code>AVERAGE</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStatistic() {
            return null;
        }

        /**
         * The unit of measure associated with the CloudWatch metric being watched.
         * <p>
         * The value specified for <code>Unit</code> must correspond to the units specified in the CloudWatch metric.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUnit() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CloudWatchAlarmDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CloudWatchAlarmDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CloudWatchAlarmDefinitionProperty> {
            java.lang.String comparisonOperator;
            java.lang.String metricName;
            java.lang.Number period;
            java.lang.Number threshold;
            java.lang.Object dimensions;
            java.lang.Number evaluationPeriods;
            java.lang.String namespace;
            java.lang.String statistic;
            java.lang.String unit;

            /**
             * Sets the value of {@link CloudWatchAlarmDefinitionProperty#getComparisonOperator}
             * @param comparisonOperator Determines how the metric specified by `MetricName` is compared to the value specified by `Threshold` . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder comparisonOperator(java.lang.String comparisonOperator) {
                this.comparisonOperator = comparisonOperator;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchAlarmDefinitionProperty#getMetricName}
             * @param metricName The name of the CloudWatch metric that is watched to determine an alarm condition. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricName(java.lang.String metricName) {
                this.metricName = metricName;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchAlarmDefinitionProperty#getPeriod}
             * @param period The period, in seconds, over which the statistic is applied. This parameter is required.
             *               EMR CloudWatch metrics are emitted every five minutes (300 seconds), so if an EMR CloudWatch metric is specified, specify <code>300</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder period(java.lang.Number period) {
                this.period = period;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchAlarmDefinitionProperty#getThreshold}
             * @param threshold The value against which the specified statistic is compared. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder threshold(java.lang.Number threshold) {
                this.threshold = threshold;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchAlarmDefinitionProperty#getDimensions}
             * @param dimensions A CloudWatch metric dimension.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dimensions(software.amazon.awscdk.core.IResolvable dimensions) {
                this.dimensions = dimensions;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchAlarmDefinitionProperty#getDimensions}
             * @param dimensions A CloudWatch metric dimension.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dimensions(java.util.List<? extends java.lang.Object> dimensions) {
                this.dimensions = dimensions;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchAlarmDefinitionProperty#getEvaluationPeriods}
             * @param evaluationPeriods The number of periods, in five-minute increments, during which the alarm condition must exist before the alarm triggers automatic scaling activity.
             *                          The default value is <code>1</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder evaluationPeriods(java.lang.Number evaluationPeriods) {
                this.evaluationPeriods = evaluationPeriods;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchAlarmDefinitionProperty#getNamespace}
             * @param namespace The namespace for the CloudWatch metric.
             *                  The default is <code>AWS/ElasticMapReduce</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder namespace(java.lang.String namespace) {
                this.namespace = namespace;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchAlarmDefinitionProperty#getStatistic}
             * @param statistic The statistic to apply to the metric associated with the alarm.
             *                  The default is <code>AVERAGE</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statistic(java.lang.String statistic) {
                this.statistic = statistic;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchAlarmDefinitionProperty#getUnit}
             * @param unit The unit of measure associated with the CloudWatch metric being watched.
             *             The value specified for <code>Unit</code> must correspond to the units specified in the CloudWatch metric.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder unit(java.lang.String unit) {
                this.unit = unit;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CloudWatchAlarmDefinitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CloudWatchAlarmDefinitionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CloudWatchAlarmDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CloudWatchAlarmDefinitionProperty {
            private final java.lang.String comparisonOperator;
            private final java.lang.String metricName;
            private final java.lang.Number period;
            private final java.lang.Number threshold;
            private final java.lang.Object dimensions;
            private final java.lang.Number evaluationPeriods;
            private final java.lang.String namespace;
            private final java.lang.String statistic;
            private final java.lang.String unit;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.comparisonOperator = software.amazon.jsii.Kernel.get(this, "comparisonOperator", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.metricName = software.amazon.jsii.Kernel.get(this, "metricName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.period = software.amazon.jsii.Kernel.get(this, "period", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.threshold = software.amazon.jsii.Kernel.get(this, "threshold", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.dimensions = software.amazon.jsii.Kernel.get(this, "dimensions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.evaluationPeriods = software.amazon.jsii.Kernel.get(this, "evaluationPeriods", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.namespace = software.amazon.jsii.Kernel.get(this, "namespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.statistic = software.amazon.jsii.Kernel.get(this, "statistic", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.unit = software.amazon.jsii.Kernel.get(this, "unit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.comparisonOperator = java.util.Objects.requireNonNull(builder.comparisonOperator, "comparisonOperator is required");
                this.metricName = java.util.Objects.requireNonNull(builder.metricName, "metricName is required");
                this.period = java.util.Objects.requireNonNull(builder.period, "period is required");
                this.threshold = java.util.Objects.requireNonNull(builder.threshold, "threshold is required");
                this.dimensions = builder.dimensions;
                this.evaluationPeriods = builder.evaluationPeriods;
                this.namespace = builder.namespace;
                this.statistic = builder.statistic;
                this.unit = builder.unit;
            }

            @Override
            public final java.lang.String getComparisonOperator() {
                return this.comparisonOperator;
            }

            @Override
            public final java.lang.String getMetricName() {
                return this.metricName;
            }

            @Override
            public final java.lang.Number getPeriod() {
                return this.period;
            }

            @Override
            public final java.lang.Number getThreshold() {
                return this.threshold;
            }

            @Override
            public final java.lang.Object getDimensions() {
                return this.dimensions;
            }

            @Override
            public final java.lang.Number getEvaluationPeriods() {
                return this.evaluationPeriods;
            }

            @Override
            public final java.lang.String getNamespace() {
                return this.namespace;
            }

            @Override
            public final java.lang.String getStatistic() {
                return this.statistic;
            }

            @Override
            public final java.lang.String getUnit() {
                return this.unit;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("comparisonOperator", om.valueToTree(this.getComparisonOperator()));
                data.set("metricName", om.valueToTree(this.getMetricName()));
                data.set("period", om.valueToTree(this.getPeriod()));
                data.set("threshold", om.valueToTree(this.getThreshold()));
                if (this.getDimensions() != null) {
                    data.set("dimensions", om.valueToTree(this.getDimensions()));
                }
                if (this.getEvaluationPeriods() != null) {
                    data.set("evaluationPeriods", om.valueToTree(this.getEvaluationPeriods()));
                }
                if (this.getNamespace() != null) {
                    data.set("namespace", om.valueToTree(this.getNamespace()));
                }
                if (this.getStatistic() != null) {
                    data.set("statistic", om.valueToTree(this.getStatistic()));
                }
                if (this.getUnit() != null) {
                    data.set("unit", om.valueToTree(this.getUnit()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_emr.CfnCluster.CloudWatchAlarmDefinitionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CloudWatchAlarmDefinitionProperty.Jsii$Proxy that = (CloudWatchAlarmDefinitionProperty.Jsii$Proxy) o;

                if (!comparisonOperator.equals(that.comparisonOperator)) return false;
                if (!metricName.equals(that.metricName)) return false;
                if (!period.equals(that.period)) return false;
                if (!threshold.equals(that.threshold)) return false;
                if (this.dimensions != null ? !this.dimensions.equals(that.dimensions) : that.dimensions != null) return false;
                if (this.evaluationPeriods != null ? !this.evaluationPeriods.equals(that.evaluationPeriods) : that.evaluationPeriods != null) return false;
                if (this.namespace != null ? !this.namespace.equals(that.namespace) : that.namespace != null) return false;
                if (this.statistic != null ? !this.statistic.equals(that.statistic) : that.statistic != null) return false;
                return this.unit != null ? this.unit.equals(that.unit) : that.unit == null;
            }

            @Override
            public final int hashCode() {
                int result = this.comparisonOperator.hashCode();
                result = 31 * result + (this.metricName.hashCode());
                result = 31 * result + (this.period.hashCode());
                result = 31 * result + (this.threshold.hashCode());
                result = 31 * result + (this.dimensions != null ? this.dimensions.hashCode() : 0);
                result = 31 * result + (this.evaluationPeriods != null ? this.evaluationPeriods.hashCode() : 0);
                result = 31 * result + (this.namespace != null ? this.namespace.hashCode() : 0);
                result = 31 * result + (this.statistic != null ? this.statistic.hashCode() : 0);
                result = 31 * result + (this.unit != null ? this.unit.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The EC2 unit limits for a managed scaling policy.
     * <p>
     * The managed scaling activity of a cluster can not be above or below these limits. The limit only applies to the core and task nodes. The master node cannot be scaled after initial configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emr.*;
     * ComputeLimitsProperty computeLimitsProperty = ComputeLimitsProperty.builder()
     *         .maximumCapacityUnits(123)
     *         .minimumCapacityUnits(123)
     *         .unitType("unitType")
     *         // the properties below are optional
     *         .maximumCoreCapacityUnits(123)
     *         .maximumOnDemandCapacityUnits(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_emr.CfnCluster.ComputeLimitsProperty")
    @software.amazon.jsii.Jsii.Proxy(ComputeLimitsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ComputeLimitsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The upper boundary of EC2 units.
         * <p>
         * It is measured through vCPU cores or instances for instance groups and measured through units for instance fleets. Managed scaling activities are not allowed beyond this boundary. The limit only applies to the core and task nodes. The master node cannot be scaled after initial configuration.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMaximumCapacityUnits();

        /**
         * The lower boundary of EC2 units.
         * <p>
         * It is measured through vCPU cores or instances for instance groups and measured through units for instance fleets. Managed scaling activities are not allowed beyond this boundary. The limit only applies to the core and task nodes. The master node cannot be scaled after initial configuration.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMinimumCapacityUnits();

        /**
         * The unit type used for specifying a managed scaling policy.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getUnitType();

        /**
         * The upper boundary of EC2 units for core node type in a cluster.
         * <p>
         * It is measured through vCPU cores or instances for instance groups and measured through units for instance fleets. The core units are not allowed to scale beyond this boundary. The parameter is used to split capacity allocation between core and task nodes.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaximumCoreCapacityUnits() {
            return null;
        }

        /**
         * The upper boundary of On-Demand EC2 units.
         * <p>
         * It is measured through vCPU cores or instances for instance groups and measured through units for instance fleets. The On-Demand units are not allowed to scale beyond this boundary. The parameter is used to split capacity allocation between On-Demand and Spot Instances.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaximumOnDemandCapacityUnits() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ComputeLimitsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ComputeLimitsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ComputeLimitsProperty> {
            java.lang.Number maximumCapacityUnits;
            java.lang.Number minimumCapacityUnits;
            java.lang.String unitType;
            java.lang.Number maximumCoreCapacityUnits;
            java.lang.Number maximumOnDemandCapacityUnits;

            /**
             * Sets the value of {@link ComputeLimitsProperty#getMaximumCapacityUnits}
             * @param maximumCapacityUnits The upper boundary of EC2 units. This parameter is required.
             *                             It is measured through vCPU cores or instances for instance groups and measured through units for instance fleets. Managed scaling activities are not allowed beyond this boundary. The limit only applies to the core and task nodes. The master node cannot be scaled after initial configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximumCapacityUnits(java.lang.Number maximumCapacityUnits) {
                this.maximumCapacityUnits = maximumCapacityUnits;
                return this;
            }

            /**
             * Sets the value of {@link ComputeLimitsProperty#getMinimumCapacityUnits}
             * @param minimumCapacityUnits The lower boundary of EC2 units. This parameter is required.
             *                             It is measured through vCPU cores or instances for instance groups and measured through units for instance fleets. Managed scaling activities are not allowed beyond this boundary. The limit only applies to the core and task nodes. The master node cannot be scaled after initial configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minimumCapacityUnits(java.lang.Number minimumCapacityUnits) {
                this.minimumCapacityUnits = minimumCapacityUnits;
                return this;
            }

            /**
             * Sets the value of {@link ComputeLimitsProperty#getUnitType}
             * @param unitType The unit type used for specifying a managed scaling policy. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder unitType(java.lang.String unitType) {
                this.unitType = unitType;
                return this;
            }

            /**
             * Sets the value of {@link ComputeLimitsProperty#getMaximumCoreCapacityUnits}
             * @param maximumCoreCapacityUnits The upper boundary of EC2 units for core node type in a cluster.
             *                                 It is measured through vCPU cores or instances for instance groups and measured through units for instance fleets. The core units are not allowed to scale beyond this boundary. The parameter is used to split capacity allocation between core and task nodes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximumCoreCapacityUnits(java.lang.Number maximumCoreCapacityUnits) {
                this.maximumCoreCapacityUnits = maximumCoreCapacityUnits;
                return this;
            }

            /**
             * Sets the value of {@link ComputeLimitsProperty#getMaximumOnDemandCapacityUnits}
             * @param maximumOnDemandCapacityUnits The upper boundary of On-Demand EC2 units.
             *                                     It is measured through vCPU cores or instances for instance groups and measured through units for instance fleets. The On-Demand units are not allowed to scale beyond this boundary. The parameter is used to split capacity allocation between On-Demand and Spot Instances.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximumOnDemandCapacityUnits(java.lang.Number maximumOnDemandCapacityUnits) {
                this.maximumOnDemandCapacityUnits = maximumOnDemandCapacityUnits;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ComputeLimitsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ComputeLimitsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ComputeLimitsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ComputeLimitsProperty {
            private final java.lang.Number maximumCapacityUnits;
            private final java.lang.Number minimumCapacityUnits;
            private final java.lang.String unitType;
            private final java.lang.Number maximumCoreCapacityUnits;
            private final java.lang.Number maximumOnDemandCapacityUnits;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maximumCapacityUnits = software.amazon.jsii.Kernel.get(this, "maximumCapacityUnits", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.minimumCapacityUnits = software.amazon.jsii.Kernel.get(this, "minimumCapacityUnits", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.unitType = software.amazon.jsii.Kernel.get(this, "unitType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.maximumCoreCapacityUnits = software.amazon.jsii.Kernel.get(this, "maximumCoreCapacityUnits", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maximumOnDemandCapacityUnits = software.amazon.jsii.Kernel.get(this, "maximumOnDemandCapacityUnits", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maximumCapacityUnits = java.util.Objects.requireNonNull(builder.maximumCapacityUnits, "maximumCapacityUnits is required");
                this.minimumCapacityUnits = java.util.Objects.requireNonNull(builder.minimumCapacityUnits, "minimumCapacityUnits is required");
                this.unitType = java.util.Objects.requireNonNull(builder.unitType, "unitType is required");
                this.maximumCoreCapacityUnits = builder.maximumCoreCapacityUnits;
                this.maximumOnDemandCapacityUnits = builder.maximumOnDemandCapacityUnits;
            }

            @Override
            public final java.lang.Number getMaximumCapacityUnits() {
                return this.maximumCapacityUnits;
            }

            @Override
            public final java.lang.Number getMinimumCapacityUnits() {
                return this.minimumCapacityUnits;
            }

            @Override
            public final java.lang.String getUnitType() {
                return this.unitType;
            }

            @Override
            public final java.lang.Number getMaximumCoreCapacityUnits() {
                return this.maximumCoreCapacityUnits;
            }

            @Override
            public final java.lang.Number getMaximumOnDemandCapacityUnits() {
                return this.maximumOnDemandCapacityUnits;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("maximumCapacityUnits", om.valueToTree(this.getMaximumCapacityUnits()));
                data.set("minimumCapacityUnits", om.valueToTree(this.getMinimumCapacityUnits()));
                data.set("unitType", om.valueToTree(this.getUnitType()));
                if (this.getMaximumCoreCapacityUnits() != null) {
                    data.set("maximumCoreCapacityUnits", om.valueToTree(this.getMaximumCoreCapacityUnits()));
                }
                if (this.getMaximumOnDemandCapacityUnits() != null) {
                    data.set("maximumOnDemandCapacityUnits", om.valueToTree(this.getMaximumOnDemandCapacityUnits()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_emr.CfnCluster.ComputeLimitsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ComputeLimitsProperty.Jsii$Proxy that = (ComputeLimitsProperty.Jsii$Proxy) o;

                if (!maximumCapacityUnits.equals(that.maximumCapacityUnits)) return false;
                if (!minimumCapacityUnits.equals(that.minimumCapacityUnits)) return false;
                if (!unitType.equals(that.unitType)) return false;
                if (this.maximumCoreCapacityUnits != null ? !this.maximumCoreCapacityUnits.equals(that.maximumCoreCapacityUnits) : that.maximumCoreCapacityUnits != null) return false;
                return this.maximumOnDemandCapacityUnits != null ? this.maximumOnDemandCapacityUnits.equals(that.maximumOnDemandCapacityUnits) : that.maximumOnDemandCapacityUnits == null;
            }

            @Override
            public final int hashCode() {
                int result = this.maximumCapacityUnits.hashCode();
                result = 31 * result + (this.minimumCapacityUnits.hashCode());
                result = 31 * result + (this.unitType.hashCode());
                result = 31 * result + (this.maximumCoreCapacityUnits != null ? this.maximumCoreCapacityUnits.hashCode() : 0);
                result = 31 * result + (this.maximumOnDemandCapacityUnits != null ? this.maximumOnDemandCapacityUnits.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * > Used only with Amazon EMR release 4.0 and later.
     * <p>
     * <code>Configuration</code> is a subproperty of <code>InstanceFleetConfig</code> or <code>InstanceGroupConfig</code> . <code>Configuration</code> specifies optional configurations for customizing open-source big data applications and environment parameters. A configuration consists of a classification, properties, and optional nested configurations. A classification refers to an application-specific configuration file. Properties are the settings you want to change in that file. For more information, see <a href="https://docs.aws.amazon.com/emr/latest/ReleaseGuide/emr-configure-apps.html">Configuring Applications</a> in the <em>Amazon EMR Release Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emr.*;
     * ConfigurationProperty configurationProperty_;
     * ConfigurationProperty configurationProperty = ConfigurationProperty.builder()
     *         .classification("classification")
     *         .configurationProperties(Map.of(
     *                 "configurationPropertiesKey", "configurationProperties"))
     *         .configurations(List.of(ConfigurationProperty.builder()
     *                 .classification("classification")
     *                 .configurationProperties(Map.of(
     *                         "configurationPropertiesKey", "configurationProperties"))
     *                 .configurations(List.of(configurationProperty_))
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_emr.CfnCluster.ConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The classification within a configuration.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getClassification() {
            return null;
        }

        /**
         * A list of additional configurations to apply within a configuration object.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConfigurationProperties() {
            return null;
        }

        /**
         * A list of additional configurations to apply within a configuration object.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConfigurations() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConfigurationProperty> {
            java.lang.String classification;
            java.lang.Object configurationProperties;
            java.lang.Object configurations;

            /**
             * Sets the value of {@link ConfigurationProperty#getClassification}
             * @param classification The classification within a configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder classification(java.lang.String classification) {
                this.classification = classification;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationProperty#getConfigurationProperties}
             * @param configurationProperties A list of additional configurations to apply within a configuration object.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configurationProperties(software.amazon.awscdk.core.IResolvable configurationProperties) {
                this.configurationProperties = configurationProperties;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationProperty#getConfigurationProperties}
             * @param configurationProperties A list of additional configurations to apply within a configuration object.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configurationProperties(java.util.Map<java.lang.String, java.lang.String> configurationProperties) {
                this.configurationProperties = configurationProperties;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationProperty#getConfigurations}
             * @param configurations A list of additional configurations to apply within a configuration object.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configurations(software.amazon.awscdk.core.IResolvable configurations) {
                this.configurations = configurations;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationProperty#getConfigurations}
             * @param configurations A list of additional configurations to apply within a configuration object.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configurations(java.util.List<? extends java.lang.Object> configurations) {
                this.configurations = configurations;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConfigurationProperty {
            private final java.lang.String classification;
            private final java.lang.Object configurationProperties;
            private final java.lang.Object configurations;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.classification = software.amazon.jsii.Kernel.get(this, "classification", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.configurationProperties = software.amazon.jsii.Kernel.get(this, "configurationProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.configurations = software.amazon.jsii.Kernel.get(this, "configurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.classification = builder.classification;
                this.configurationProperties = builder.configurationProperties;
                this.configurations = builder.configurations;
            }

            @Override
            public final java.lang.String getClassification() {
                return this.classification;
            }

            @Override
            public final java.lang.Object getConfigurationProperties() {
                return this.configurationProperties;
            }

            @Override
            public final java.lang.Object getConfigurations() {
                return this.configurations;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getClassification() != null) {
                    data.set("classification", om.valueToTree(this.getClassification()));
                }
                if (this.getConfigurationProperties() != null) {
                    data.set("configurationProperties", om.valueToTree(this.getConfigurationProperties()));
                }
                if (this.getConfigurations() != null) {
                    data.set("configurations", om.valueToTree(this.getConfigurations()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_emr.CfnCluster.ConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConfigurationProperty.Jsii$Proxy that = (ConfigurationProperty.Jsii$Proxy) o;

                if (this.classification != null ? !this.classification.equals(that.classification) : that.classification != null) return false;
                if (this.configurationProperties != null ? !this.configurationProperties.equals(that.configurationProperties) : that.configurationProperties != null) return false;
                return this.configurations != null ? this.configurations.equals(that.configurations) : that.configurations == null;
            }

            @Override
            public final int hashCode() {
                int result = this.classification != null ? this.classification.hashCode() : 0;
                result = 31 * result + (this.configurationProperties != null ? this.configurationProperties.hashCode() : 0);
                result = 31 * result + (this.configurations != null ? this.configurations.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * `EbsBlockDeviceConfig` is a subproperty of the `EbsConfiguration` property type.
     * <p>
     * <code>EbsBlockDeviceConfig</code> defines the number and type of EBS volumes to associate with all EC2 instances in an EMR cluster.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emr.*;
     * EbsBlockDeviceConfigProperty ebsBlockDeviceConfigProperty = EbsBlockDeviceConfigProperty.builder()
     *         .volumeSpecification(VolumeSpecificationProperty.builder()
     *                 .sizeInGb(123)
     *                 .volumeType("volumeType")
     *                 // the properties below are optional
     *                 .iops(123)
     *                 .build())
     *         // the properties below are optional
     *         .volumesPerInstance(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_emr.CfnCluster.EbsBlockDeviceConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(EbsBlockDeviceConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EbsBlockDeviceConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * EBS volume specifications such as volume type, IOPS, size (GiB) and throughput (MiB/s) that are requested for the EBS volume attached to an EC2 instance in the cluster.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getVolumeSpecification();

        /**
         * Number of EBS volumes with a specific volume configuration that are associated with every instance in the instance group.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getVolumesPerInstance() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EbsBlockDeviceConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EbsBlockDeviceConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EbsBlockDeviceConfigProperty> {
            java.lang.Object volumeSpecification;
            java.lang.Number volumesPerInstance;

            /**
             * Sets the value of {@link EbsBlockDeviceConfigProperty#getVolumeSpecification}
             * @param volumeSpecification EBS volume specifications such as volume type, IOPS, size (GiB) and throughput (MiB/s) that are requested for the EBS volume attached to an EC2 instance in the cluster. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumeSpecification(software.amazon.awscdk.services.emr.CfnCluster.VolumeSpecificationProperty volumeSpecification) {
                this.volumeSpecification = volumeSpecification;
                return this;
            }

            /**
             * Sets the value of {@link EbsBlockDeviceConfigProperty#getVolumeSpecification}
             * @param volumeSpecification EBS volume specifications such as volume type, IOPS, size (GiB) and throughput (MiB/s) that are requested for the EBS volume attached to an EC2 instance in the cluster. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumeSpecification(software.amazon.awscdk.core.IResolvable volumeSpecification) {
                this.volumeSpecification = volumeSpecification;
                return this;
            }

            /**
             * Sets the value of {@link EbsBlockDeviceConfigProperty#getVolumesPerInstance}
             * @param volumesPerInstance Number of EBS volumes with a specific volume configuration that are associated with every instance in the instance group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumesPerInstance(java.lang.Number volumesPerInstance) {
                this.volumesPerInstance = volumesPerInstance;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EbsBlockDeviceConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EbsBlockDeviceConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EbsBlockDeviceConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EbsBlockDeviceConfigProperty {
            private final java.lang.Object volumeSpecification;
            private final java.lang.Number volumesPerInstance;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.volumeSpecification = software.amazon.jsii.Kernel.get(this, "volumeSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.volumesPerInstance = software.amazon.jsii.Kernel.get(this, "volumesPerInstance", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.volumeSpecification = java.util.Objects.requireNonNull(builder.volumeSpecification, "volumeSpecification is required");
                this.volumesPerInstance = builder.volumesPerInstance;
            }

            @Override
            public final java.lang.Object getVolumeSpecification() {
                return this.volumeSpecification;
            }

            @Override
            public final java.lang.Number getVolumesPerInstance() {
                return this.volumesPerInstance;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("volumeSpecification", om.valueToTree(this.getVolumeSpecification()));
                if (this.getVolumesPerInstance() != null) {
                    data.set("volumesPerInstance", om.valueToTree(this.getVolumesPerInstance()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_emr.CfnCluster.EbsBlockDeviceConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EbsBlockDeviceConfigProperty.Jsii$Proxy that = (EbsBlockDeviceConfigProperty.Jsii$Proxy) o;

                if (!volumeSpecification.equals(that.volumeSpecification)) return false;
                return this.volumesPerInstance != null ? this.volumesPerInstance.equals(that.volumesPerInstance) : that.volumesPerInstance == null;
            }

            @Override
            public final int hashCode() {
                int result = this.volumeSpecification.hashCode();
                result = 31 * result + (this.volumesPerInstance != null ? this.volumesPerInstance.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * `EbsConfiguration` is a subproperty of `InstanceFleetConfig` or `InstanceGroupConfig` .
     * <p>
     * <code>EbsConfiguration</code> determines the EBS volumes to attach to EMR cluster instances.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emr.*;
     * EbsConfigurationProperty ebsConfigurationProperty = EbsConfigurationProperty.builder()
     *         .ebsBlockDeviceConfigs(List.of(EbsBlockDeviceConfigProperty.builder()
     *                 .volumeSpecification(VolumeSpecificationProperty.builder()
     *                         .sizeInGb(123)
     *                         .volumeType("volumeType")
     *                         // the properties below are optional
     *                         .iops(123)
     *                         .build())
     *                 // the properties below are optional
     *                 .volumesPerInstance(123)
     *                 .build()))
     *         .ebsOptimized(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_emr.CfnCluster.EbsConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(EbsConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EbsConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An array of Amazon EBS volume specifications attached to a cluster instance.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEbsBlockDeviceConfigs() {
            return null;
        }

        /**
         * Indicates whether an Amazon EBS volume is EBS-optimized.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEbsOptimized() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EbsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EbsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EbsConfigurationProperty> {
            java.lang.Object ebsBlockDeviceConfigs;
            java.lang.Object ebsOptimized;

            /**
             * Sets the value of {@link EbsConfigurationProperty#getEbsBlockDeviceConfigs}
             * @param ebsBlockDeviceConfigs An array of Amazon EBS volume specifications attached to a cluster instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ebsBlockDeviceConfigs(software.amazon.awscdk.core.IResolvable ebsBlockDeviceConfigs) {
                this.ebsBlockDeviceConfigs = ebsBlockDeviceConfigs;
                return this;
            }

            /**
             * Sets the value of {@link EbsConfigurationProperty#getEbsBlockDeviceConfigs}
             * @param ebsBlockDeviceConfigs An array of Amazon EBS volume specifications attached to a cluster instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ebsBlockDeviceConfigs(java.util.List<? extends java.lang.Object> ebsBlockDeviceConfigs) {
                this.ebsBlockDeviceConfigs = ebsBlockDeviceConfigs;
                return this;
            }

            /**
             * Sets the value of {@link EbsConfigurationProperty#getEbsOptimized}
             * @param ebsOptimized Indicates whether an Amazon EBS volume is EBS-optimized.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ebsOptimized(java.lang.Boolean ebsOptimized) {
                this.ebsOptimized = ebsOptimized;
                return this;
            }

            /**
             * Sets the value of {@link EbsConfigurationProperty#getEbsOptimized}
             * @param ebsOptimized Indicates whether an Amazon EBS volume is EBS-optimized.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ebsOptimized(software.amazon.awscdk.core.IResolvable ebsOptimized) {
                this.ebsOptimized = ebsOptimized;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EbsConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EbsConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EbsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EbsConfigurationProperty {
            private final java.lang.Object ebsBlockDeviceConfigs;
            private final java.lang.Object ebsOptimized;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.ebsBlockDeviceConfigs = software.amazon.jsii.Kernel.get(this, "ebsBlockDeviceConfigs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ebsOptimized = software.amazon.jsii.Kernel.get(this, "ebsOptimized", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.ebsBlockDeviceConfigs = builder.ebsBlockDeviceConfigs;
                this.ebsOptimized = builder.ebsOptimized;
            }

            @Override
            public final java.lang.Object getEbsBlockDeviceConfigs() {
                return this.ebsBlockDeviceConfigs;
            }

            @Override
            public final java.lang.Object getEbsOptimized() {
                return this.ebsOptimized;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEbsBlockDeviceConfigs() != null) {
                    data.set("ebsBlockDeviceConfigs", om.valueToTree(this.getEbsBlockDeviceConfigs()));
                }
                if (this.getEbsOptimized() != null) {
                    data.set("ebsOptimized", om.valueToTree(this.getEbsOptimized()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_emr.CfnCluster.EbsConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EbsConfigurationProperty.Jsii$Proxy that = (EbsConfigurationProperty.Jsii$Proxy) o;

                if (this.ebsBlockDeviceConfigs != null ? !this.ebsBlockDeviceConfigs.equals(that.ebsBlockDeviceConfigs) : that.ebsBlockDeviceConfigs != null) return false;
                return this.ebsOptimized != null ? this.ebsOptimized.equals(that.ebsOptimized) : that.ebsOptimized == null;
            }

            @Override
            public final int hashCode() {
                int result = this.ebsBlockDeviceConfigs != null ? this.ebsBlockDeviceConfigs.hashCode() : 0;
                result = 31 * result + (this.ebsOptimized != null ? this.ebsOptimized.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The `HadoopJarStepConfig` property type specifies a job flow step consisting of a JAR file whose main function will be executed.
     * <p>
     * The main function submits a job for the cluster to execute as a step on the master node, and then waits for the job to finish or fail before executing subsequent steps.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emr.*;
     * HadoopJarStepConfigProperty hadoopJarStepConfigProperty = HadoopJarStepConfigProperty.builder()
     *         .jar("jar")
     *         // the properties below are optional
     *         .args(List.of("args"))
     *         .mainClass("mainClass")
     *         .stepProperties(List.of(KeyValueProperty.builder()
     *                 .key("key")
     *                 .value("value")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_emr.CfnCluster.HadoopJarStepConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(HadoopJarStepConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HadoopJarStepConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A path to a JAR file run during the step.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getJar();

        /**
         * A list of command line arguments passed to the JAR file's main function when executed.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getArgs() {
            return null;
        }

        /**
         * The name of the main class in the specified Java file.
         * <p>
         * If not specified, the JAR file should specify a Main-Class in its manifest file.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMainClass() {
            return null;
        }

        /**
         * A list of Java properties that are set when the step runs.
         * <p>
         * You can use these properties to pass key-value pairs to your main function.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStepProperties() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HadoopJarStepConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HadoopJarStepConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HadoopJarStepConfigProperty> {
            java.lang.String jar;
            java.util.List<java.lang.String> args;
            java.lang.String mainClass;
            java.lang.Object stepProperties;

            /**
             * Sets the value of {@link HadoopJarStepConfigProperty#getJar}
             * @param jar A path to a JAR file run during the step. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jar(java.lang.String jar) {
                this.jar = jar;
                return this;
            }

            /**
             * Sets the value of {@link HadoopJarStepConfigProperty#getArgs}
             * @param args A list of command line arguments passed to the JAR file's main function when executed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder args(java.util.List<java.lang.String> args) {
                this.args = args;
                return this;
            }

            /**
             * Sets the value of {@link HadoopJarStepConfigProperty#getMainClass}
             * @param mainClass The name of the main class in the specified Java file.
             *                  If not specified, the JAR file should specify a Main-Class in its manifest file.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mainClass(java.lang.String mainClass) {
                this.mainClass = mainClass;
                return this;
            }

            /**
             * Sets the value of {@link HadoopJarStepConfigProperty#getStepProperties}
             * @param stepProperties A list of Java properties that are set when the step runs.
             *                       You can use these properties to pass key-value pairs to your main function.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stepProperties(software.amazon.awscdk.core.IResolvable stepProperties) {
                this.stepProperties = stepProperties;
                return this;
            }

            /**
             * Sets the value of {@link HadoopJarStepConfigProperty#getStepProperties}
             * @param stepProperties A list of Java properties that are set when the step runs.
             *                       You can use these properties to pass key-value pairs to your main function.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stepProperties(java.util.List<? extends java.lang.Object> stepProperties) {
                this.stepProperties = stepProperties;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HadoopJarStepConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HadoopJarStepConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HadoopJarStepConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HadoopJarStepConfigProperty {
            private final java.lang.String jar;
            private final java.util.List<java.lang.String> args;
            private final java.lang.String mainClass;
            private final java.lang.Object stepProperties;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.jar = software.amazon.jsii.Kernel.get(this, "jar", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.args = software.amazon.jsii.Kernel.get(this, "args", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.mainClass = software.amazon.jsii.Kernel.get(this, "mainClass", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.stepProperties = software.amazon.jsii.Kernel.get(this, "stepProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.jar = java.util.Objects.requireNonNull(builder.jar, "jar is required");
                this.args = builder.args;
                this.mainClass = builder.mainClass;
                this.stepProperties = builder.stepProperties;
            }

            @Override
            public final java.lang.String getJar() {
                return this.jar;
            }

            @Override
            public final java.util.List<java.lang.String> getArgs() {
                return this.args;
            }

            @Override
            public final java.lang.String getMainClass() {
                return this.mainClass;
            }

            @Override
            public final java.lang.Object getStepProperties() {
                return this.stepProperties;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("jar", om.valueToTree(this.getJar()));
                if (this.getArgs() != null) {
                    data.set("args", om.valueToTree(this.getArgs()));
                }
                if (this.getMainClass() != null) {
                    data.set("mainClass", om.valueToTree(this.getMainClass()));
                }
                if (this.getStepProperties() != null) {
                    data.set("stepProperties", om.valueToTree(this.getStepProperties()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_emr.CfnCluster.HadoopJarStepConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HadoopJarStepConfigProperty.Jsii$Proxy that = (HadoopJarStepConfigProperty.Jsii$Proxy) o;

                if (!jar.equals(that.jar)) return false;
                if (this.args != null ? !this.args.equals(that.args) : that.args != null) return false;
                if (this.mainClass != null ? !this.mainClass.equals(that.mainClass) : that.mainClass != null) return false;
                return this.stepProperties != null ? this.stepProperties.equals(that.stepProperties) : that.stepProperties == null;
            }

            @Override
            public final int hashCode() {
                int result = this.jar.hashCode();
                result = 31 * result + (this.args != null ? this.args.hashCode() : 0);
                result = 31 * result + (this.mainClass != null ? this.mainClass.hashCode() : 0);
                result = 31 * result + (this.stepProperties != null ? this.stepProperties.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Use `InstanceFleetConfig` to define instance fleets for an EMR cluster.
     * <p>
     * A cluster can not use both instance fleets and instance groups. For more information, see <a href="https://docs.aws.amazon.com//emr/latest/ManagementGuide/emr-instance-group-configuration.html">Configure Instance Fleets</a> in the <em>Amazon EMR Management Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x versions.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emr.*;
     * ConfigurationProperty configurationProperty_;
     * InstanceFleetConfigProperty instanceFleetConfigProperty = InstanceFleetConfigProperty.builder()
     *         .instanceTypeConfigs(List.of(InstanceTypeConfigProperty.builder()
     *                 .instanceType("instanceType")
     *                 // the properties below are optional
     *                 .bidPrice("bidPrice")
     *                 .bidPriceAsPercentageOfOnDemandPrice(123)
     *                 .configurations(List.of(ConfigurationProperty.builder()
     *                         .classification("classification")
     *                         .configurationProperties(Map.of(
     *                                 "configurationPropertiesKey", "configurationProperties"))
     *                         .configurations(List.of(configurationProperty_))
     *                         .build()))
     *                 .customAmiId("customAmiId")
     *                 .ebsConfiguration(EbsConfigurationProperty.builder()
     *                         .ebsBlockDeviceConfigs(List.of(EbsBlockDeviceConfigProperty.builder()
     *                                 .volumeSpecification(VolumeSpecificationProperty.builder()
     *                                         .sizeInGb(123)
     *                                         .volumeType("volumeType")
     *                                         // the properties below are optional
     *                                         .iops(123)
     *                                         .build())
     *                                 // the properties below are optional
     *                                 .volumesPerInstance(123)
     *                                 .build()))
     *                         .ebsOptimized(false)
     *                         .build())
     *                 .weightedCapacity(123)
     *                 .build()))
     *         .launchSpecifications(InstanceFleetProvisioningSpecificationsProperty.builder()
     *                 .onDemandSpecification(OnDemandProvisioningSpecificationProperty.builder()
     *                         .allocationStrategy("allocationStrategy")
     *                         .build())
     *                 .spotSpecification(SpotProvisioningSpecificationProperty.builder()
     *                         .timeoutAction("timeoutAction")
     *                         .timeoutDurationMinutes(123)
     *                         // the properties below are optional
     *                         .allocationStrategy("allocationStrategy")
     *                         .blockDurationMinutes(123)
     *                         .build())
     *                 .build())
     *         .name("name")
     *         .targetOnDemandCapacity(123)
     *         .targetSpotCapacity(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_emr.CfnCluster.InstanceFleetConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(InstanceFleetConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InstanceFleetConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The instance type configurations that define the EC2 instances in the instance fleet.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInstanceTypeConfigs() {
            return null;
        }

        /**
         * The launch specification for the instance fleet.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLaunchSpecifications() {
            return null;
        }

        /**
         * The friendly name of the instance fleet.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * The target capacity of On-Demand units for the instance fleet, which determines how many On-Demand instances to provision.
         * <p>
         * When the instance fleet launches, Amazon EMR tries to provision On-Demand instances as specified by <code>InstanceTypeConfig</code> . Each instance configuration has a specified <code>WeightedCapacity</code> . When an On-Demand instance is provisioned, the <code>WeightedCapacity</code> units count toward the target capacity. Amazon EMR provisions instances until the target capacity is totally fulfilled, even if this results in an overage. For example, if there are 2 units remaining to fulfill capacity, and Amazon EMR can only provision an instance with a <code>WeightedCapacity</code> of 5 units, the instance is provisioned, and the target capacity is exceeded by 3 units.
         * <p>
         * <blockquote>
         * <p>
         * If not specified or set to 0, only Spot instances are provisioned for the instance fleet using <code>TargetSpotCapacity</code> . At least one of <code>TargetSpotCapacity</code> and <code>TargetOnDemandCapacity</code> should be greater than 0. For a master instance fleet, only one of <code>TargetSpotCapacity</code> and <code>TargetOnDemandCapacity</code> can be specified, and its value must be 1.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTargetOnDemandCapacity() {
            return null;
        }

        /**
         * The target capacity of Spot units for the instance fleet, which determines how many Spot instances to provision.
         * <p>
         * When the instance fleet launches, Amazon EMR tries to provision Spot instances as specified by <code>InstanceTypeConfig</code> . Each instance configuration has a specified <code>WeightedCapacity</code> . When a Spot instance is provisioned, the <code>WeightedCapacity</code> units count toward the target capacity. Amazon EMR provisions instances until the target capacity is totally fulfilled, even if this results in an overage. For example, if there are 2 units remaining to fulfill capacity, and Amazon EMR can only provision an instance with a <code>WeightedCapacity</code> of 5 units, the instance is provisioned, and the target capacity is exceeded by 3 units.
         * <p>
         * <blockquote>
         * <p>
         * If not specified or set to 0, only On-Demand instances are provisioned for the instance fleet. At least one of <code>TargetSpotCapacity</code> and <code>TargetOnDemandCapacity</code> should be greater than 0. For a master instance fleet, only one of <code>TargetSpotCapacity</code> and <code>TargetOnDemandCapacity</code> can be specified, and its value must be 1.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTargetSpotCapacity() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InstanceFleetConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InstanceFleetConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InstanceFleetConfigProperty> {
            java.lang.Object instanceTypeConfigs;
            java.lang.Object launchSpecifications;
            java.lang.String name;
            java.lang.Number targetOnDemandCapacity;
            java.lang.Number targetSpotCapacity;

            /**
             * Sets the value of {@link InstanceFleetConfigProperty#getInstanceTypeConfigs}
             * @param instanceTypeConfigs The instance type configurations that define the EC2 instances in the instance fleet.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceTypeConfigs(software.amazon.awscdk.core.IResolvable instanceTypeConfigs) {
                this.instanceTypeConfigs = instanceTypeConfigs;
                return this;
            }

            /**
             * Sets the value of {@link InstanceFleetConfigProperty#getInstanceTypeConfigs}
             * @param instanceTypeConfigs The instance type configurations that define the EC2 instances in the instance fleet.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceTypeConfigs(java.util.List<? extends java.lang.Object> instanceTypeConfigs) {
                this.instanceTypeConfigs = instanceTypeConfigs;
                return this;
            }

            /**
             * Sets the value of {@link InstanceFleetConfigProperty#getLaunchSpecifications}
             * @param launchSpecifications The launch specification for the instance fleet.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder launchSpecifications(software.amazon.awscdk.services.emr.CfnCluster.InstanceFleetProvisioningSpecificationsProperty launchSpecifications) {
                this.launchSpecifications = launchSpecifications;
                return this;
            }

            /**
             * Sets the value of {@link InstanceFleetConfigProperty#getLaunchSpecifications}
             * @param launchSpecifications The launch specification for the instance fleet.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder launchSpecifications(software.amazon.awscdk.core.IResolvable launchSpecifications) {
                this.launchSpecifications = launchSpecifications;
                return this;
            }

            /**
             * Sets the value of {@link InstanceFleetConfigProperty#getName}
             * @param name The friendly name of the instance fleet.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link InstanceFleetConfigProperty#getTargetOnDemandCapacity}
             * @param targetOnDemandCapacity The target capacity of On-Demand units for the instance fleet, which determines how many On-Demand instances to provision.
             *                               When the instance fleet launches, Amazon EMR tries to provision On-Demand instances as specified by <code>InstanceTypeConfig</code> . Each instance configuration has a specified <code>WeightedCapacity</code> . When an On-Demand instance is provisioned, the <code>WeightedCapacity</code> units count toward the target capacity. Amazon EMR provisions instances until the target capacity is totally fulfilled, even if this results in an overage. For example, if there are 2 units remaining to fulfill capacity, and Amazon EMR can only provision an instance with a <code>WeightedCapacity</code> of 5 units, the instance is provisioned, and the target capacity is exceeded by 3 units.
             *                               <p>
             *                               <blockquote>
             *                               <p>
             *                               If not specified or set to 0, only Spot instances are provisioned for the instance fleet using <code>TargetSpotCapacity</code> . At least one of <code>TargetSpotCapacity</code> and <code>TargetOnDemandCapacity</code> should be greater than 0. For a master instance fleet, only one of <code>TargetSpotCapacity</code> and <code>TargetOnDemandCapacity</code> can be specified, and its value must be 1.
             *                               <p>
             *                               </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetOnDemandCapacity(java.lang.Number targetOnDemandCapacity) {
                this.targetOnDemandCapacity = targetOnDemandCapacity;
                return this;
            }

            /**
             * Sets the value of {@link InstanceFleetConfigProperty#getTargetSpotCapacity}
             * @param targetSpotCapacity The target capacity of Spot units for the instance fleet, which determines how many Spot instances to provision.
             *                           When the instance fleet launches, Amazon EMR tries to provision Spot instances as specified by <code>InstanceTypeConfig</code> . Each instance configuration has a specified <code>WeightedCapacity</code> . When a Spot instance is provisioned, the <code>WeightedCapacity</code> units count toward the target capacity. Amazon EMR provisions instances until the target capacity is totally fulfilled, even if this results in an overage. For example, if there are 2 units remaining to fulfill capacity, and Amazon EMR can only provision an instance with a <code>WeightedCapacity</code> of 5 units, the instance is provisioned, and the target capacity is exceeded by 3 units.
             *                           <p>
             *                           <blockquote>
             *                           <p>
             *                           If not specified or set to 0, only On-Demand instances are provisioned for the instance fleet. At least one of <code>TargetSpotCapacity</code> and <code>TargetOnDemandCapacity</code> should be greater than 0. For a master instance fleet, only one of <code>TargetSpotCapacity</code> and <code>TargetOnDemandCapacity</code> can be specified, and its value must be 1.
             *                           <p>
             *                           </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetSpotCapacity(java.lang.Number targetSpotCapacity) {
                this.targetSpotCapacity = targetSpotCapacity;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InstanceFleetConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InstanceFleetConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InstanceFleetConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InstanceFleetConfigProperty {
            private final java.lang.Object instanceTypeConfigs;
            private final java.lang.Object launchSpecifications;
            private final java.lang.String name;
            private final java.lang.Number targetOnDemandCapacity;
            private final java.lang.Number targetSpotCapacity;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.instanceTypeConfigs = software.amazon.jsii.Kernel.get(this, "instanceTypeConfigs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.launchSpecifications = software.amazon.jsii.Kernel.get(this, "launchSpecifications", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.targetOnDemandCapacity = software.amazon.jsii.Kernel.get(this, "targetOnDemandCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.targetSpotCapacity = software.amazon.jsii.Kernel.get(this, "targetSpotCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.instanceTypeConfigs = builder.instanceTypeConfigs;
                this.launchSpecifications = builder.launchSpecifications;
                this.name = builder.name;
                this.targetOnDemandCapacity = builder.targetOnDemandCapacity;
                this.targetSpotCapacity = builder.targetSpotCapacity;
            }

            @Override
            public final java.lang.Object getInstanceTypeConfigs() {
                return this.instanceTypeConfigs;
            }

            @Override
            public final java.lang.Object getLaunchSpecifications() {
                return this.launchSpecifications;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Number getTargetOnDemandCapacity() {
                return this.targetOnDemandCapacity;
            }

            @Override
            public final java.lang.Number getTargetSpotCapacity() {
                return this.targetSpotCapacity;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getInstanceTypeConfigs() != null) {
                    data.set("instanceTypeConfigs", om.valueToTree(this.getInstanceTypeConfigs()));
                }
                if (this.getLaunchSpecifications() != null) {
                    data.set("launchSpecifications", om.valueToTree(this.getLaunchSpecifications()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getTargetOnDemandCapacity() != null) {
                    data.set("targetOnDemandCapacity", om.valueToTree(this.getTargetOnDemandCapacity()));
                }
                if (this.getTargetSpotCapacity() != null) {
                    data.set("targetSpotCapacity", om.valueToTree(this.getTargetSpotCapacity()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_emr.CfnCluster.InstanceFleetConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InstanceFleetConfigProperty.Jsii$Proxy that = (InstanceFleetConfigProperty.Jsii$Proxy) o;

                if (this.instanceTypeConfigs != null ? !this.instanceTypeConfigs.equals(that.instanceTypeConfigs) : that.instanceTypeConfigs != null) return false;
                if (this.launchSpecifications != null ? !this.launchSpecifications.equals(that.launchSpecifications) : that.launchSpecifications != null) return false;
                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                if (this.targetOnDemandCapacity != null ? !this.targetOnDemandCapacity.equals(that.targetOnDemandCapacity) : that.targetOnDemandCapacity != null) return false;
                return this.targetSpotCapacity != null ? this.targetSpotCapacity.equals(that.targetSpotCapacity) : that.targetSpotCapacity == null;
            }

            @Override
            public final int hashCode() {
                int result = this.instanceTypeConfigs != null ? this.instanceTypeConfigs.hashCode() : 0;
                result = 31 * result + (this.launchSpecifications != null ? this.launchSpecifications.hashCode() : 0);
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                result = 31 * result + (this.targetOnDemandCapacity != null ? this.targetOnDemandCapacity.hashCode() : 0);
                result = 31 * result + (this.targetSpotCapacity != null ? this.targetSpotCapacity.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * `InstanceFleetProvisioningSpecification` is a subproperty of `InstanceFleetConfig` .
     * <p>
     * <code>InstanceFleetProvisioningSpecification</code> defines the launch specification for Spot instances in an instance fleet, which determines the defined duration and provisioning timeout behavior for Spot instances.
     * <p>
     * <blockquote>
     * <p>
     * The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x versions.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emr.*;
     * InstanceFleetProvisioningSpecificationsProperty instanceFleetProvisioningSpecificationsProperty = InstanceFleetProvisioningSpecificationsProperty.builder()
     *         .onDemandSpecification(OnDemandProvisioningSpecificationProperty.builder()
     *                 .allocationStrategy("allocationStrategy")
     *                 .build())
     *         .spotSpecification(SpotProvisioningSpecificationProperty.builder()
     *                 .timeoutAction("timeoutAction")
     *                 .timeoutDurationMinutes(123)
     *                 // the properties below are optional
     *                 .allocationStrategy("allocationStrategy")
     *                 .blockDurationMinutes(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_emr.CfnCluster.InstanceFleetProvisioningSpecificationsProperty")
    @software.amazon.jsii.Jsii.Proxy(InstanceFleetProvisioningSpecificationsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InstanceFleetProvisioningSpecificationsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The launch specification for On-Demand Instances in the instance fleet, which determines the allocation strategy.
         * <p>
         * <blockquote>
         * <p>
         * The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x versions. On-Demand Instances allocation strategy is available in Amazon EMR version 5.12.1 and later.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOnDemandSpecification() {
            return null;
        }

        /**
         * The launch specification for Spot Instances in the fleet, which determines the defined duration, provisioning timeout behavior, and allocation strategy.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSpotSpecification() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InstanceFleetProvisioningSpecificationsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InstanceFleetProvisioningSpecificationsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InstanceFleetProvisioningSpecificationsProperty> {
            java.lang.Object onDemandSpecification;
            java.lang.Object spotSpecification;

            /**
             * Sets the value of {@link InstanceFleetProvisioningSpecificationsProperty#getOnDemandSpecification}
             * @param onDemandSpecification The launch specification for On-Demand Instances in the instance fleet, which determines the allocation strategy.
             *                              <blockquote>
             *                              <p>
             *                              The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x versions. On-Demand Instances allocation strategy is available in Amazon EMR version 5.12.1 and later.
             *                              <p>
             *                              </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onDemandSpecification(software.amazon.awscdk.services.emr.CfnCluster.OnDemandProvisioningSpecificationProperty onDemandSpecification) {
                this.onDemandSpecification = onDemandSpecification;
                return this;
            }

            /**
             * Sets the value of {@link InstanceFleetProvisioningSpecificationsProperty#getOnDemandSpecification}
             * @param onDemandSpecification The launch specification for On-Demand Instances in the instance fleet, which determines the allocation strategy.
             *                              <blockquote>
             *                              <p>
             *                              The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x versions. On-Demand Instances allocation strategy is available in Amazon EMR version 5.12.1 and later.
             *                              <p>
             *                              </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onDemandSpecification(software.amazon.awscdk.core.IResolvable onDemandSpecification) {
                this.onDemandSpecification = onDemandSpecification;
                return this;
            }

            /**
             * Sets the value of {@link InstanceFleetProvisioningSpecificationsProperty#getSpotSpecification}
             * @param spotSpecification The launch specification for Spot Instances in the fleet, which determines the defined duration, provisioning timeout behavior, and allocation strategy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder spotSpecification(software.amazon.awscdk.services.emr.CfnCluster.SpotProvisioningSpecificationProperty spotSpecification) {
                this.spotSpecification = spotSpecification;
                return this;
            }

            /**
             * Sets the value of {@link InstanceFleetProvisioningSpecificationsProperty#getSpotSpecification}
             * @param spotSpecification The launch specification for Spot Instances in the fleet, which determines the defined duration, provisioning timeout behavior, and allocation strategy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder spotSpecification(software.amazon.awscdk.core.IResolvable spotSpecification) {
                this.spotSpecification = spotSpecification;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InstanceFleetProvisioningSpecificationsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InstanceFleetProvisioningSpecificationsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InstanceFleetProvisioningSpecificationsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InstanceFleetProvisioningSpecificationsProperty {
            private final java.lang.Object onDemandSpecification;
            private final java.lang.Object spotSpecification;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.onDemandSpecification = software.amazon.jsii.Kernel.get(this, "onDemandSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.spotSpecification = software.amazon.jsii.Kernel.get(this, "spotSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.onDemandSpecification = builder.onDemandSpecification;
                this.spotSpecification = builder.spotSpecification;
            }

            @Override
            public final java.lang.Object getOnDemandSpecification() {
                return this.onDemandSpecification;
            }

            @Override
            public final java.lang.Object getSpotSpecification() {
                return this.spotSpecification;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getOnDemandSpecification() != null) {
                    data.set("onDemandSpecification", om.valueToTree(this.getOnDemandSpecification()));
                }
                if (this.getSpotSpecification() != null) {
                    data.set("spotSpecification", om.valueToTree(this.getSpotSpecification()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_emr.CfnCluster.InstanceFleetProvisioningSpecificationsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InstanceFleetProvisioningSpecificationsProperty.Jsii$Proxy that = (InstanceFleetProvisioningSpecificationsProperty.Jsii$Proxy) o;

                if (this.onDemandSpecification != null ? !this.onDemandSpecification.equals(that.onDemandSpecification) : that.onDemandSpecification != null) return false;
                return this.spotSpecification != null ? this.spotSpecification.equals(that.spotSpecification) : that.spotSpecification == null;
            }

            @Override
            public final int hashCode() {
                int result = this.onDemandSpecification != null ? this.onDemandSpecification.hashCode() : 0;
                result = 31 * result + (this.spotSpecification != null ? this.spotSpecification.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Use `InstanceGroupConfig` to define instance groups for an EMR cluster.
     * <p>
     * A cluster can not use both instance groups and instance fleets. For more information, see <a href="https://docs.aws.amazon.com//emr/latest/ManagementGuide/emr-instance-group-configuration.html">Create a Cluster with Instance Fleets or Uniform Instance Groups</a> in the <em>Amazon EMR Management Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emr.*;
     * ConfigurationProperty configurationProperty_;
     * InstanceGroupConfigProperty instanceGroupConfigProperty = InstanceGroupConfigProperty.builder()
     *         .instanceCount(123)
     *         .instanceType("instanceType")
     *         // the properties below are optional
     *         .autoScalingPolicy(AutoScalingPolicyProperty.builder()
     *                 .constraints(ScalingConstraintsProperty.builder()
     *                         .maxCapacity(123)
     *                         .minCapacity(123)
     *                         .build())
     *                 .rules(List.of(ScalingRuleProperty.builder()
     *                         .action(ScalingActionProperty.builder()
     *                                 .simpleScalingPolicyConfiguration(SimpleScalingPolicyConfigurationProperty.builder()
     *                                         .scalingAdjustment(123)
     *                                         // the properties below are optional
     *                                         .adjustmentType("adjustmentType")
     *                                         .coolDown(123)
     *                                         .build())
     *                                 // the properties below are optional
     *                                 .market("market")
     *                                 .build())
     *                         .name("name")
     *                         .trigger(ScalingTriggerProperty.builder()
     *                                 .cloudWatchAlarmDefinition(CloudWatchAlarmDefinitionProperty.builder()
     *                                         .comparisonOperator("comparisonOperator")
     *                                         .metricName("metricName")
     *                                         .period(123)
     *                                         .threshold(123)
     *                                         // the properties below are optional
     *                                         .dimensions(List.of(MetricDimensionProperty.builder()
     *                                                 .key("key")
     *                                                 .value("value")
     *                                                 .build()))
     *                                         .evaluationPeriods(123)
     *                                         .namespace("namespace")
     *                                         .statistic("statistic")
     *                                         .unit("unit")
     *                                         .build())
     *                                 .build())
     *                         // the properties below are optional
     *                         .description("description")
     *                         .build()))
     *                 .build())
     *         .bidPrice("bidPrice")
     *         .configurations(List.of(ConfigurationProperty.builder()
     *                 .classification("classification")
     *                 .configurationProperties(Map.of(
     *                         "configurationPropertiesKey", "configurationProperties"))
     *                 .configurations(List.of(configurationProperty_))
     *                 .build()))
     *         .customAmiId("customAmiId")
     *         .ebsConfiguration(EbsConfigurationProperty.builder()
     *                 .ebsBlockDeviceConfigs(List.of(EbsBlockDeviceConfigProperty.builder()
     *                         .volumeSpecification(VolumeSpecificationProperty.builder()
     *                                 .sizeInGb(123)
     *                                 .volumeType("volumeType")
     *                                 // the properties below are optional
     *                                 .iops(123)
     *                                 .build())
     *                         // the properties below are optional
     *                         .volumesPerInstance(123)
     *                         .build()))
     *                 .ebsOptimized(false)
     *                 .build())
     *         .market("market")
     *         .name("name")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_emr.CfnCluster.InstanceGroupConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(InstanceGroupConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InstanceGroupConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Target number of instances for the instance group.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getInstanceCount();

        /**
         * The EC2 instance type for all instances in the instance group.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInstanceType();

        /**
         * `AutoScalingPolicy` is a subproperty of the [InstanceGroupConfig](https://docs.aws.amazon.com//AWSCloudFormation/latest/UserGuide/aws-properties-emr-cluster-jobflowinstancesconfig-instancegroupconfig.html) property type that specifies the constraints and rules of an automatic scaling policy in Amazon EMR . The automatic scaling policy defines how an instance group dynamically adds and terminates EC2 instances in response to the value of a CloudWatch metric. Only core and task instance groups can use automatic scaling policies. For more information, see [Using Automatic Scaling in Amazon EMR](https://docs.aws.amazon.com//emr/latest/ManagementGuide/emr-automatic-scaling.html) .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAutoScalingPolicy() {
            return null;
        }

        /**
         * If specified, indicates that the instance group uses Spot Instances.
         * <p>
         * This is the maximum price you are willing to pay for Spot Instances. Specify <code>OnDemandPrice</code> to set the amount equal to the On-Demand price, or specify an amount in USD.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBidPrice() {
            return null;
        }

        /**
         * > Amazon EMR releases 4.x or later.
         * <p>
         * The list of configurations supplied for an EMR cluster instance group. You can specify a separate configuration for each instance group (master, core, and task).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConfigurations() {
            return null;
        }

        /**
         * The custom AMI ID to use for the provisioned instance group.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCustomAmiId() {
            return null;
        }

        /**
         * EBS configurations that will be attached to each EC2 instance in the instance group.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEbsConfiguration() {
            return null;
        }

        /**
         * Market type of the EC2 instances used to create a cluster node.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMarket() {
            return null;
        }

        /**
         * Friendly name given to the instance group.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InstanceGroupConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InstanceGroupConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InstanceGroupConfigProperty> {
            java.lang.Number instanceCount;
            java.lang.String instanceType;
            java.lang.Object autoScalingPolicy;
            java.lang.String bidPrice;
            java.lang.Object configurations;
            java.lang.String customAmiId;
            java.lang.Object ebsConfiguration;
            java.lang.String market;
            java.lang.String name;

            /**
             * Sets the value of {@link InstanceGroupConfigProperty#getInstanceCount}
             * @param instanceCount Target number of instances for the instance group. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceCount(java.lang.Number instanceCount) {
                this.instanceCount = instanceCount;
                return this;
            }

            /**
             * Sets the value of {@link InstanceGroupConfigProperty#getInstanceType}
             * @param instanceType The EC2 instance type for all instances in the instance group. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceType(java.lang.String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            /**
             * Sets the value of {@link InstanceGroupConfigProperty#getAutoScalingPolicy}
             * @param autoScalingPolicy `AutoScalingPolicy` is a subproperty of the [InstanceGroupConfig](https://docs.aws.amazon.com//AWSCloudFormation/latest/UserGuide/aws-properties-emr-cluster-jobflowinstancesconfig-instancegroupconfig.html) property type that specifies the constraints and rules of an automatic scaling policy in Amazon EMR . The automatic scaling policy defines how an instance group dynamically adds and terminates EC2 instances in response to the value of a CloudWatch metric. Only core and task instance groups can use automatic scaling policies. For more information, see [Using Automatic Scaling in Amazon EMR](https://docs.aws.amazon.com//emr/latest/ManagementGuide/emr-automatic-scaling.html) .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoScalingPolicy(software.amazon.awscdk.services.emr.CfnCluster.AutoScalingPolicyProperty autoScalingPolicy) {
                this.autoScalingPolicy = autoScalingPolicy;
                return this;
            }

            /**
             * Sets the value of {@link InstanceGroupConfigProperty#getAutoScalingPolicy}
             * @param autoScalingPolicy `AutoScalingPolicy` is a subproperty of the [InstanceGroupConfig](https://docs.aws.amazon.com//AWSCloudFormation/latest/UserGuide/aws-properties-emr-cluster-jobflowinstancesconfig-instancegroupconfig.html) property type that specifies the constraints and rules of an automatic scaling policy in Amazon EMR . The automatic scaling policy defines how an instance group dynamically adds and terminates EC2 instances in response to the value of a CloudWatch metric. Only core and task instance groups can use automatic scaling policies. For more information, see [Using Automatic Scaling in Amazon EMR](https://docs.aws.amazon.com//emr/latest/ManagementGuide/emr-automatic-scaling.html) .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoScalingPolicy(software.amazon.awscdk.core.IResolvable autoScalingPolicy) {
                this.autoScalingPolicy = autoScalingPolicy;
                return this;
            }

            /**
             * Sets the value of {@link InstanceGroupConfigProperty#getBidPrice}
             * @param bidPrice If specified, indicates that the instance group uses Spot Instances.
             *                 This is the maximum price you are willing to pay for Spot Instances. Specify <code>OnDemandPrice</code> to set the amount equal to the On-Demand price, or specify an amount in USD.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bidPrice(java.lang.String bidPrice) {
                this.bidPrice = bidPrice;
                return this;
            }

            /**
             * Sets the value of {@link InstanceGroupConfigProperty#getConfigurations}
             * @param configurations > Amazon EMR releases 4.x or later.
             *                       The list of configurations supplied for an EMR cluster instance group. You can specify a separate configuration for each instance group (master, core, and task).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configurations(software.amazon.awscdk.core.IResolvable configurations) {
                this.configurations = configurations;
                return this;
            }

            /**
             * Sets the value of {@link InstanceGroupConfigProperty#getConfigurations}
             * @param configurations > Amazon EMR releases 4.x or later.
             *                       The list of configurations supplied for an EMR cluster instance group. You can specify a separate configuration for each instance group (master, core, and task).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configurations(java.util.List<? extends java.lang.Object> configurations) {
                this.configurations = configurations;
                return this;
            }

            /**
             * Sets the value of {@link InstanceGroupConfigProperty#getCustomAmiId}
             * @param customAmiId The custom AMI ID to use for the provisioned instance group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customAmiId(java.lang.String customAmiId) {
                this.customAmiId = customAmiId;
                return this;
            }

            /**
             * Sets the value of {@link InstanceGroupConfigProperty#getEbsConfiguration}
             * @param ebsConfiguration EBS configurations that will be attached to each EC2 instance in the instance group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ebsConfiguration(software.amazon.awscdk.services.emr.CfnCluster.EbsConfigurationProperty ebsConfiguration) {
                this.ebsConfiguration = ebsConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link InstanceGroupConfigProperty#getEbsConfiguration}
             * @param ebsConfiguration EBS configurations that will be attached to each EC2 instance in the instance group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ebsConfiguration(software.amazon.awscdk.core.IResolvable ebsConfiguration) {
                this.ebsConfiguration = ebsConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link InstanceGroupConfigProperty#getMarket}
             * @param market Market type of the EC2 instances used to create a cluster node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder market(java.lang.String market) {
                this.market = market;
                return this;
            }

            /**
             * Sets the value of {@link InstanceGroupConfigProperty#getName}
             * @param name Friendly name given to the instance group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InstanceGroupConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InstanceGroupConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InstanceGroupConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InstanceGroupConfigProperty {
            private final java.lang.Number instanceCount;
            private final java.lang.String instanceType;
            private final java.lang.Object autoScalingPolicy;
            private final java.lang.String bidPrice;
            private final java.lang.Object configurations;
            private final java.lang.String customAmiId;
            private final java.lang.Object ebsConfiguration;
            private final java.lang.String market;
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.instanceCount = software.amazon.jsii.Kernel.get(this, "instanceCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.autoScalingPolicy = software.amazon.jsii.Kernel.get(this, "autoScalingPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.bidPrice = software.amazon.jsii.Kernel.get(this, "bidPrice", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.configurations = software.amazon.jsii.Kernel.get(this, "configurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.customAmiId = software.amazon.jsii.Kernel.get(this, "customAmiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.ebsConfiguration = software.amazon.jsii.Kernel.get(this, "ebsConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.market = software.amazon.jsii.Kernel.get(this, "market", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.instanceCount = java.util.Objects.requireNonNull(builder.instanceCount, "instanceCount is required");
                this.instanceType = java.util.Objects.requireNonNull(builder.instanceType, "instanceType is required");
                this.autoScalingPolicy = builder.autoScalingPolicy;
                this.bidPrice = builder.bidPrice;
                this.configurations = builder.configurations;
                this.customAmiId = builder.customAmiId;
                this.ebsConfiguration = builder.ebsConfiguration;
                this.market = builder.market;
                this.name = builder.name;
            }

            @Override
            public final java.lang.Number getInstanceCount() {
                return this.instanceCount;
            }

            @Override
            public final java.lang.String getInstanceType() {
                return this.instanceType;
            }

            @Override
            public final java.lang.Object getAutoScalingPolicy() {
                return this.autoScalingPolicy;
            }

            @Override
            public final java.lang.String getBidPrice() {
                return this.bidPrice;
            }

            @Override
            public final java.lang.Object getConfigurations() {
                return this.configurations;
            }

            @Override
            public final java.lang.String getCustomAmiId() {
                return this.customAmiId;
            }

            @Override
            public final java.lang.Object getEbsConfiguration() {
                return this.ebsConfiguration;
            }

            @Override
            public final java.lang.String getMarket() {
                return this.market;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("instanceCount", om.valueToTree(this.getInstanceCount()));
                data.set("instanceType", om.valueToTree(this.getInstanceType()));
                if (this.getAutoScalingPolicy() != null) {
                    data.set("autoScalingPolicy", om.valueToTree(this.getAutoScalingPolicy()));
                }
                if (this.getBidPrice() != null) {
                    data.set("bidPrice", om.valueToTree(this.getBidPrice()));
                }
                if (this.getConfigurations() != null) {
                    data.set("configurations", om.valueToTree(this.getConfigurations()));
                }
                if (this.getCustomAmiId() != null) {
                    data.set("customAmiId", om.valueToTree(this.getCustomAmiId()));
                }
                if (this.getEbsConfiguration() != null) {
                    data.set("ebsConfiguration", om.valueToTree(this.getEbsConfiguration()));
                }
                if (this.getMarket() != null) {
                    data.set("market", om.valueToTree(this.getMarket()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_emr.CfnCluster.InstanceGroupConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InstanceGroupConfigProperty.Jsii$Proxy that = (InstanceGroupConfigProperty.Jsii$Proxy) o;

                if (!instanceCount.equals(that.instanceCount)) return false;
                if (!instanceType.equals(that.instanceType)) return false;
                if (this.autoScalingPolicy != null ? !this.autoScalingPolicy.equals(that.autoScalingPolicy) : that.autoScalingPolicy != null) return false;
                if (this.bidPrice != null ? !this.bidPrice.equals(that.bidPrice) : that.bidPrice != null) return false;
                if (this.configurations != null ? !this.configurations.equals(that.configurations) : that.configurations != null) return false;
                if (this.customAmiId != null ? !this.customAmiId.equals(that.customAmiId) : that.customAmiId != null) return false;
                if (this.ebsConfiguration != null ? !this.ebsConfiguration.equals(that.ebsConfiguration) : that.ebsConfiguration != null) return false;
                if (this.market != null ? !this.market.equals(that.market) : that.market != null) return false;
                return this.name != null ? this.name.equals(that.name) : that.name == null;
            }

            @Override
            public final int hashCode() {
                int result = this.instanceCount.hashCode();
                result = 31 * result + (this.instanceType.hashCode());
                result = 31 * result + (this.autoScalingPolicy != null ? this.autoScalingPolicy.hashCode() : 0);
                result = 31 * result + (this.bidPrice != null ? this.bidPrice.hashCode() : 0);
                result = 31 * result + (this.configurations != null ? this.configurations.hashCode() : 0);
                result = 31 * result + (this.customAmiId != null ? this.customAmiId.hashCode() : 0);
                result = 31 * result + (this.ebsConfiguration != null ? this.ebsConfiguration.hashCode() : 0);
                result = 31 * result + (this.market != null ? this.market.hashCode() : 0);
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * > The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x versions.
     * <p>
     * <code>InstanceTypeConfig</code> is a sub-property of <code>InstanceFleetConfig</code> . <code>InstanceTypeConfig</code> determines the EC2 instances that Amazon EMR attempts to provision to fulfill On-Demand and Spot target capacities.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emr.*;
     * ConfigurationProperty configurationProperty_;
     * InstanceTypeConfigProperty instanceTypeConfigProperty = InstanceTypeConfigProperty.builder()
     *         .instanceType("instanceType")
     *         // the properties below are optional
     *         .bidPrice("bidPrice")
     *         .bidPriceAsPercentageOfOnDemandPrice(123)
     *         .configurations(List.of(ConfigurationProperty.builder()
     *                 .classification("classification")
     *                 .configurationProperties(Map.of(
     *                         "configurationPropertiesKey", "configurationProperties"))
     *                 .configurations(List.of(configurationProperty_))
     *                 .build()))
     *         .customAmiId("customAmiId")
     *         .ebsConfiguration(EbsConfigurationProperty.builder()
     *                 .ebsBlockDeviceConfigs(List.of(EbsBlockDeviceConfigProperty.builder()
     *                         .volumeSpecification(VolumeSpecificationProperty.builder()
     *                                 .sizeInGb(123)
     *                                 .volumeType("volumeType")
     *                                 // the properties below are optional
     *                                 .iops(123)
     *                                 .build())
     *                         // the properties below are optional
     *                         .volumesPerInstance(123)
     *                         .build()))
     *                 .ebsOptimized(false)
     *                 .build())
     *         .weightedCapacity(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_emr.CfnCluster.InstanceTypeConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(InstanceTypeConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InstanceTypeConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An EC2 instance type, such as `m3.xlarge` .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInstanceType();

        /**
         * The bid price for each EC2 Spot Instance type as defined by `InstanceType` .
         * <p>
         * Expressed in USD. If neither <code>BidPrice</code> nor <code>BidPriceAsPercentageOfOnDemandPrice</code> is provided, <code>BidPriceAsPercentageOfOnDemandPrice</code> defaults to 100%.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBidPrice() {
            return null;
        }

        /**
         * The bid price, as a percentage of On-Demand price, for each EC2 Spot Instance as defined by `InstanceType` .
         * <p>
         * Expressed as a number (for example, 20 specifies 20%). If neither <code>BidPrice</code> nor <code>BidPriceAsPercentageOfOnDemandPrice</code> is provided, <code>BidPriceAsPercentageOfOnDemandPrice</code> defaults to 100%.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getBidPriceAsPercentageOfOnDemandPrice() {
            return null;
        }

        /**
         * A configuration classification that applies when provisioning cluster instances, which can include configurations for applications and software that run on the cluster.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConfigurations() {
            return null;
        }

        /**
         * The custom AMI ID to use for the instance type.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCustomAmiId() {
            return null;
        }

        /**
         * The configuration of Amazon Elastic Block Store (Amazon EBS) attached to each instance as defined by `InstanceType` .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEbsConfiguration() {
            return null;
        }

        /**
         * The number of units that a provisioned instance of this type provides toward fulfilling the target capacities defined in `InstanceFleetConfig` .
         * <p>
         * This value is 1 for a master instance fleet, and must be 1 or greater for core and task instance fleets. Defaults to 1 if not specified.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getWeightedCapacity() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InstanceTypeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InstanceTypeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InstanceTypeConfigProperty> {
            java.lang.String instanceType;
            java.lang.String bidPrice;
            java.lang.Number bidPriceAsPercentageOfOnDemandPrice;
            java.lang.Object configurations;
            java.lang.String customAmiId;
            java.lang.Object ebsConfiguration;
            java.lang.Number weightedCapacity;

            /**
             * Sets the value of {@link InstanceTypeConfigProperty#getInstanceType}
             * @param instanceType An EC2 instance type, such as `m3.xlarge` . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceType(java.lang.String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            /**
             * Sets the value of {@link InstanceTypeConfigProperty#getBidPrice}
             * @param bidPrice The bid price for each EC2 Spot Instance type as defined by `InstanceType` .
             *                 Expressed in USD. If neither <code>BidPrice</code> nor <code>BidPriceAsPercentageOfOnDemandPrice</code> is provided, <code>BidPriceAsPercentageOfOnDemandPrice</code> defaults to 100%.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bidPrice(java.lang.String bidPrice) {
                this.bidPrice = bidPrice;
                return this;
            }

            /**
             * Sets the value of {@link InstanceTypeConfigProperty#getBidPriceAsPercentageOfOnDemandPrice}
             * @param bidPriceAsPercentageOfOnDemandPrice The bid price, as a percentage of On-Demand price, for each EC2 Spot Instance as defined by `InstanceType` .
             *                                            Expressed as a number (for example, 20 specifies 20%). If neither <code>BidPrice</code> nor <code>BidPriceAsPercentageOfOnDemandPrice</code> is provided, <code>BidPriceAsPercentageOfOnDemandPrice</code> defaults to 100%.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bidPriceAsPercentageOfOnDemandPrice(java.lang.Number bidPriceAsPercentageOfOnDemandPrice) {
                this.bidPriceAsPercentageOfOnDemandPrice = bidPriceAsPercentageOfOnDemandPrice;
                return this;
            }

            /**
             * Sets the value of {@link InstanceTypeConfigProperty#getConfigurations}
             * @param configurations A configuration classification that applies when provisioning cluster instances, which can include configurations for applications and software that run on the cluster.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configurations(software.amazon.awscdk.core.IResolvable configurations) {
                this.configurations = configurations;
                return this;
            }

            /**
             * Sets the value of {@link InstanceTypeConfigProperty#getConfigurations}
             * @param configurations A configuration classification that applies when provisioning cluster instances, which can include configurations for applications and software that run on the cluster.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configurations(java.util.List<? extends java.lang.Object> configurations) {
                this.configurations = configurations;
                return this;
            }

            /**
             * Sets the value of {@link InstanceTypeConfigProperty#getCustomAmiId}
             * @param customAmiId The custom AMI ID to use for the instance type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customAmiId(java.lang.String customAmiId) {
                this.customAmiId = customAmiId;
                return this;
            }

            /**
             * Sets the value of {@link InstanceTypeConfigProperty#getEbsConfiguration}
             * @param ebsConfiguration The configuration of Amazon Elastic Block Store (Amazon EBS) attached to each instance as defined by `InstanceType` .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ebsConfiguration(software.amazon.awscdk.services.emr.CfnCluster.EbsConfigurationProperty ebsConfiguration) {
                this.ebsConfiguration = ebsConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link InstanceTypeConfigProperty#getEbsConfiguration}
             * @param ebsConfiguration The configuration of Amazon Elastic Block Store (Amazon EBS) attached to each instance as defined by `InstanceType` .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ebsConfiguration(software.amazon.awscdk.core.IResolvable ebsConfiguration) {
                this.ebsConfiguration = ebsConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link InstanceTypeConfigProperty#getWeightedCapacity}
             * @param weightedCapacity The number of units that a provisioned instance of this type provides toward fulfilling the target capacities defined in `InstanceFleetConfig` .
             *                         This value is 1 for a master instance fleet, and must be 1 or greater for core and task instance fleets. Defaults to 1 if not specified.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder weightedCapacity(java.lang.Number weightedCapacity) {
                this.weightedCapacity = weightedCapacity;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InstanceTypeConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InstanceTypeConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InstanceTypeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InstanceTypeConfigProperty {
            private final java.lang.String instanceType;
            private final java.lang.String bidPrice;
            private final java.lang.Number bidPriceAsPercentageOfOnDemandPrice;
            private final java.lang.Object configurations;
            private final java.lang.String customAmiId;
            private final java.lang.Object ebsConfiguration;
            private final java.lang.Number weightedCapacity;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.bidPrice = software.amazon.jsii.Kernel.get(this, "bidPrice", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.bidPriceAsPercentageOfOnDemandPrice = software.amazon.jsii.Kernel.get(this, "bidPriceAsPercentageOfOnDemandPrice", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.configurations = software.amazon.jsii.Kernel.get(this, "configurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.customAmiId = software.amazon.jsii.Kernel.get(this, "customAmiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.ebsConfiguration = software.amazon.jsii.Kernel.get(this, "ebsConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.weightedCapacity = software.amazon.jsii.Kernel.get(this, "weightedCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.instanceType = java.util.Objects.requireNonNull(builder.instanceType, "instanceType is required");
                this.bidPrice = builder.bidPrice;
                this.bidPriceAsPercentageOfOnDemandPrice = builder.bidPriceAsPercentageOfOnDemandPrice;
                this.configurations = builder.configurations;
                this.customAmiId = builder.customAmiId;
                this.ebsConfiguration = builder.ebsConfiguration;
                this.weightedCapacity = builder.weightedCapacity;
            }

            @Override
            public final java.lang.String getInstanceType() {
                return this.instanceType;
            }

            @Override
            public final java.lang.String getBidPrice() {
                return this.bidPrice;
            }

            @Override
            public final java.lang.Number getBidPriceAsPercentageOfOnDemandPrice() {
                return this.bidPriceAsPercentageOfOnDemandPrice;
            }

            @Override
            public final java.lang.Object getConfigurations() {
                return this.configurations;
            }

            @Override
            public final java.lang.String getCustomAmiId() {
                return this.customAmiId;
            }

            @Override
            public final java.lang.Object getEbsConfiguration() {
                return this.ebsConfiguration;
            }

            @Override
            public final java.lang.Number getWeightedCapacity() {
                return this.weightedCapacity;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("instanceType", om.valueToTree(this.getInstanceType()));
                if (this.getBidPrice() != null) {
                    data.set("bidPrice", om.valueToTree(this.getBidPrice()));
                }
                if (this.getBidPriceAsPercentageOfOnDemandPrice() != null) {
                    data.set("bidPriceAsPercentageOfOnDemandPrice", om.valueToTree(this.getBidPriceAsPercentageOfOnDemandPrice()));
                }
                if (this.getConfigurations() != null) {
                    data.set("configurations", om.valueToTree(this.getConfigurations()));
                }
                if (this.getCustomAmiId() != null) {
                    data.set("customAmiId", om.valueToTree(this.getCustomAmiId()));
                }
                if (this.getEbsConfiguration() != null) {
                    data.set("ebsConfiguration", om.valueToTree(this.getEbsConfiguration()));
                }
                if (this.getWeightedCapacity() != null) {
                    data.set("weightedCapacity", om.valueToTree(this.getWeightedCapacity()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_emr.CfnCluster.InstanceTypeConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InstanceTypeConfigProperty.Jsii$Proxy that = (InstanceTypeConfigProperty.Jsii$Proxy) o;

                if (!instanceType.equals(that.instanceType)) return false;
                if (this.bidPrice != null ? !this.bidPrice.equals(that.bidPrice) : that.bidPrice != null) return false;
                if (this.bidPriceAsPercentageOfOnDemandPrice != null ? !this.bidPriceAsPercentageOfOnDemandPrice.equals(that.bidPriceAsPercentageOfOnDemandPrice) : that.bidPriceAsPercentageOfOnDemandPrice != null) return false;
                if (this.configurations != null ? !this.configurations.equals(that.configurations) : that.configurations != null) return false;
                if (this.customAmiId != null ? !this.customAmiId.equals(that.customAmiId) : that.customAmiId != null) return false;
                if (this.ebsConfiguration != null ? !this.ebsConfiguration.equals(that.ebsConfiguration) : that.ebsConfiguration != null) return false;
                return this.weightedCapacity != null ? this.weightedCapacity.equals(that.weightedCapacity) : that.weightedCapacity == null;
            }

            @Override
            public final int hashCode() {
                int result = this.instanceType.hashCode();
                result = 31 * result + (this.bidPrice != null ? this.bidPrice.hashCode() : 0);
                result = 31 * result + (this.bidPriceAsPercentageOfOnDemandPrice != null ? this.bidPriceAsPercentageOfOnDemandPrice.hashCode() : 0);
                result = 31 * result + (this.configurations != null ? this.configurations.hashCode() : 0);
                result = 31 * result + (this.customAmiId != null ? this.customAmiId.hashCode() : 0);
                result = 31 * result + (this.ebsConfiguration != null ? this.ebsConfiguration.hashCode() : 0);
                result = 31 * result + (this.weightedCapacity != null ? this.weightedCapacity.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * `JobFlowInstancesConfig` is a property of the `AWS::EMR::Cluster` resource.
     * <p>
     * <code>JobFlowInstancesConfig</code> defines the instance groups or instance fleets that comprise the cluster. <code>JobFlowInstancesConfig</code> must contain either <code>InstanceFleetConfig</code> or <code>InstanceGroupConfig</code> . They cannot be used together.
     * <p>
     * You can now define task instance groups or task instance fleets using the <code>TaskInstanceGroups</code> and <code>TaskInstanceFleets</code> subproperties. Using these subproperties reduces delays in provisioning task nodes compared to specifying task nodes with the <code>InstanceFleetConfig</code> and <code>InstanceGroupConfig</code> resources.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emr.*;
     * ConfigurationProperty configurationProperty_;
     * JobFlowInstancesConfigProperty jobFlowInstancesConfigProperty = JobFlowInstancesConfigProperty.builder()
     *         .additionalMasterSecurityGroups(List.of("additionalMasterSecurityGroups"))
     *         .additionalSlaveSecurityGroups(List.of("additionalSlaveSecurityGroups"))
     *         .coreInstanceFleet(InstanceFleetConfigProperty.builder()
     *                 .instanceTypeConfigs(List.of(InstanceTypeConfigProperty.builder()
     *                         .instanceType("instanceType")
     *                         // the properties below are optional
     *                         .bidPrice("bidPrice")
     *                         .bidPriceAsPercentageOfOnDemandPrice(123)
     *                         .configurations(List.of(ConfigurationProperty.builder()
     *                                 .classification("classification")
     *                                 .configurationProperties(Map.of(
     *                                         "configurationPropertiesKey", "configurationProperties"))
     *                                 .configurations(List.of(configurationProperty_))
     *                                 .build()))
     *                         .customAmiId("customAmiId")
     *                         .ebsConfiguration(EbsConfigurationProperty.builder()
     *                                 .ebsBlockDeviceConfigs(List.of(EbsBlockDeviceConfigProperty.builder()
     *                                         .volumeSpecification(VolumeSpecificationProperty.builder()
     *                                                 .sizeInGb(123)
     *                                                 .volumeType("volumeType")
     *                                                 // the properties below are optional
     *                                                 .iops(123)
     *                                                 .build())
     *                                         // the properties below are optional
     *                                         .volumesPerInstance(123)
     *                                         .build()))
     *                                 .ebsOptimized(false)
     *                                 .build())
     *                         .weightedCapacity(123)
     *                         .build()))
     *                 .launchSpecifications(InstanceFleetProvisioningSpecificationsProperty.builder()
     *                         .onDemandSpecification(OnDemandProvisioningSpecificationProperty.builder()
     *                                 .allocationStrategy("allocationStrategy")
     *                                 .build())
     *                         .spotSpecification(SpotProvisioningSpecificationProperty.builder()
     *                                 .timeoutAction("timeoutAction")
     *                                 .timeoutDurationMinutes(123)
     *                                 // the properties below are optional
     *                                 .allocationStrategy("allocationStrategy")
     *                                 .blockDurationMinutes(123)
     *                                 .build())
     *                         .build())
     *                 .name("name")
     *                 .targetOnDemandCapacity(123)
     *                 .targetSpotCapacity(123)
     *                 .build())
     *         .coreInstanceGroup(InstanceGroupConfigProperty.builder()
     *                 .instanceCount(123)
     *                 .instanceType("instanceType")
     *                 // the properties below are optional
     *                 .autoScalingPolicy(AutoScalingPolicyProperty.builder()
     *                         .constraints(ScalingConstraintsProperty.builder()
     *                                 .maxCapacity(123)
     *                                 .minCapacity(123)
     *                                 .build())
     *                         .rules(List.of(ScalingRuleProperty.builder()
     *                                 .action(ScalingActionProperty.builder()
     *                                         .simpleScalingPolicyConfiguration(SimpleScalingPolicyConfigurationProperty.builder()
     *                                                 .scalingAdjustment(123)
     *                                                 // the properties below are optional
     *                                                 .adjustmentType("adjustmentType")
     *                                                 .coolDown(123)
     *                                                 .build())
     *                                         // the properties below are optional
     *                                         .market("market")
     *                                         .build())
     *                                 .name("name")
     *                                 .trigger(ScalingTriggerProperty.builder()
     *                                         .cloudWatchAlarmDefinition(CloudWatchAlarmDefinitionProperty.builder()
     *                                                 .comparisonOperator("comparisonOperator")
     *                                                 .metricName("metricName")
     *                                                 .period(123)
     *                                                 .threshold(123)
     *                                                 // the properties below are optional
     *                                                 .dimensions(List.of(MetricDimensionProperty.builder()
     *                                                         .key("key")
     *                                                         .value("value")
     *                                                         .build()))
     *                                                 .evaluationPeriods(123)
     *                                                 .namespace("namespace")
     *                                                 .statistic("statistic")
     *                                                 .unit("unit")
     *                                                 .build())
     *                                         .build())
     *                                 // the properties below are optional
     *                                 .description("description")
     *                                 .build()))
     *                         .build())
     *                 .bidPrice("bidPrice")
     *                 .configurations(List.of(ConfigurationProperty.builder()
     *                         .classification("classification")
     *                         .configurationProperties(Map.of(
     *                                 "configurationPropertiesKey", "configurationProperties"))
     *                         .configurations(List.of(configurationProperty_))
     *                         .build()))
     *                 .customAmiId("customAmiId")
     *                 .ebsConfiguration(EbsConfigurationProperty.builder()
     *                         .ebsBlockDeviceConfigs(List.of(EbsBlockDeviceConfigProperty.builder()
     *                                 .volumeSpecification(VolumeSpecificationProperty.builder()
     *                                         .sizeInGb(123)
     *                                         .volumeType("volumeType")
     *                                         // the properties below are optional
     *                                         .iops(123)
     *                                         .build())
     *                                 // the properties below are optional
     *                                 .volumesPerInstance(123)
     *                                 .build()))
     *                         .ebsOptimized(false)
     *                         .build())
     *                 .market("market")
     *                 .name("name")
     *                 .build())
     *         .ec2KeyName("ec2KeyName")
     *         .ec2SubnetId("ec2SubnetId")
     *         .ec2SubnetIds(List.of("ec2SubnetIds"))
     *         .emrManagedMasterSecurityGroup("emrManagedMasterSecurityGroup")
     *         .emrManagedSlaveSecurityGroup("emrManagedSlaveSecurityGroup")
     *         .hadoopVersion("hadoopVersion")
     *         .keepJobFlowAliveWhenNoSteps(false)
     *         .masterInstanceFleet(InstanceFleetConfigProperty.builder()
     *                 .instanceTypeConfigs(List.of(InstanceTypeConfigProperty.builder()
     *                         .instanceType("instanceType")
     *                         // the properties below are optional
     *                         .bidPrice("bidPrice")
     *                         .bidPriceAsPercentageOfOnDemandPrice(123)
     *                         .configurations(List.of(ConfigurationProperty.builder()
     *                                 .classification("classification")
     *                                 .configurationProperties(Map.of(
     *                                         "configurationPropertiesKey", "configurationProperties"))
     *                                 .configurations(List.of(configurationProperty_))
     *                                 .build()))
     *                         .customAmiId("customAmiId")
     *                         .ebsConfiguration(EbsConfigurationProperty.builder()
     *                                 .ebsBlockDeviceConfigs(List.of(EbsBlockDeviceConfigProperty.builder()
     *                                         .volumeSpecification(VolumeSpecificationProperty.builder()
     *                                                 .sizeInGb(123)
     *                                                 .volumeType("volumeType")
     *                                                 // the properties below are optional
     *                                                 .iops(123)
     *                                                 .build())
     *                                         // the properties below are optional
     *                                         .volumesPerInstance(123)
     *                                         .build()))
     *                                 .ebsOptimized(false)
     *                                 .build())
     *                         .weightedCapacity(123)
     *                         .build()))
     *                 .launchSpecifications(InstanceFleetProvisioningSpecificationsProperty.builder()
     *                         .onDemandSpecification(OnDemandProvisioningSpecificationProperty.builder()
     *                                 .allocationStrategy("allocationStrategy")
     *                                 .build())
     *                         .spotSpecification(SpotProvisioningSpecificationProperty.builder()
     *                                 .timeoutAction("timeoutAction")
     *                                 .timeoutDurationMinutes(123)
     *                                 // the properties below are optional
     *                                 .allocationStrategy("allocationStrategy")
     *                                 .blockDurationMinutes(123)
     *                                 .build())
     *                         .build())
     *                 .name("name")
     *                 .targetOnDemandCapacity(123)
     *                 .targetSpotCapacity(123)
     *                 .build())
     *         .masterInstanceGroup(InstanceGroupConfigProperty.builder()
     *                 .instanceCount(123)
     *                 .instanceType("instanceType")
     *                 // the properties below are optional
     *                 .autoScalingPolicy(AutoScalingPolicyProperty.builder()
     *                         .constraints(ScalingConstraintsProperty.builder()
     *                                 .maxCapacity(123)
     *                                 .minCapacity(123)
     *                                 .build())
     *                         .rules(List.of(ScalingRuleProperty.builder()
     *                                 .action(ScalingActionProperty.builder()
     *                                         .simpleScalingPolicyConfiguration(SimpleScalingPolicyConfigurationProperty.builder()
     *                                                 .scalingAdjustment(123)
     *                                                 // the properties below are optional
     *                                                 .adjustmentType("adjustmentType")
     *                                                 .coolDown(123)
     *                                                 .build())
     *                                         // the properties below are optional
     *                                         .market("market")
     *                                         .build())
     *                                 .name("name")
     *                                 .trigger(ScalingTriggerProperty.builder()
     *                                         .cloudWatchAlarmDefinition(CloudWatchAlarmDefinitionProperty.builder()
     *                                                 .comparisonOperator("comparisonOperator")
     *                                                 .metricName("metricName")
     *                                                 .period(123)
     *                                                 .threshold(123)
     *                                                 // the properties below are optional
     *                                                 .dimensions(List.of(MetricDimensionProperty.builder()
     *                                                         .key("key")
     *                                                         .value("value")
     *                                                         .build()))
     *                                                 .evaluationPeriods(123)
     *                                                 .namespace("namespace")
     *                                                 .statistic("statistic")
     *                                                 .unit("unit")
     *                                                 .build())
     *                                         .build())
     *                                 // the properties below are optional
     *                                 .description("description")
     *                                 .build()))
     *                         .build())
     *                 .bidPrice("bidPrice")
     *                 .configurations(List.of(ConfigurationProperty.builder()
     *                         .classification("classification")
     *                         .configurationProperties(Map.of(
     *                                 "configurationPropertiesKey", "configurationProperties"))
     *                         .configurations(List.of(configurationProperty_))
     *                         .build()))
     *                 .customAmiId("customAmiId")
     *                 .ebsConfiguration(EbsConfigurationProperty.builder()
     *                         .ebsBlockDeviceConfigs(List.of(EbsBlockDeviceConfigProperty.builder()
     *                                 .volumeSpecification(VolumeSpecificationProperty.builder()
     *                                         .sizeInGb(123)
     *                                         .volumeType("volumeType")
     *                                         // the properties below are optional
     *                                         .iops(123)
     *                                         .build())
     *                                 // the properties below are optional
     *                                 .volumesPerInstance(123)
     *                                 .build()))
     *                         .ebsOptimized(false)
     *                         .build())
     *                 .market("market")
     *                 .name("name")
     *                 .build())
     *         .placement(PlacementTypeProperty.builder()
     *                 .availabilityZone("availabilityZone")
     *                 .build())
     *         .serviceAccessSecurityGroup("serviceAccessSecurityGroup")
     *         .taskInstanceFleets(List.of(InstanceFleetConfigProperty.builder()
     *                 .instanceTypeConfigs(List.of(InstanceTypeConfigProperty.builder()
     *                         .instanceType("instanceType")
     *                         // the properties below are optional
     *                         .bidPrice("bidPrice")
     *                         .bidPriceAsPercentageOfOnDemandPrice(123)
     *                         .configurations(List.of(ConfigurationProperty.builder()
     *                                 .classification("classification")
     *                                 .configurationProperties(Map.of(
     *                                         "configurationPropertiesKey", "configurationProperties"))
     *                                 .configurations(List.of(configurationProperty_))
     *                                 .build()))
     *                         .customAmiId("customAmiId")
     *                         .ebsConfiguration(EbsConfigurationProperty.builder()
     *                                 .ebsBlockDeviceConfigs(List.of(EbsBlockDeviceConfigProperty.builder()
     *                                         .volumeSpecification(VolumeSpecificationProperty.builder()
     *                                                 .sizeInGb(123)
     *                                                 .volumeType("volumeType")
     *                                                 // the properties below are optional
     *                                                 .iops(123)
     *                                                 .build())
     *                                         // the properties below are optional
     *                                         .volumesPerInstance(123)
     *                                         .build()))
     *                                 .ebsOptimized(false)
     *                                 .build())
     *                         .weightedCapacity(123)
     *                         .build()))
     *                 .launchSpecifications(InstanceFleetProvisioningSpecificationsProperty.builder()
     *                         .onDemandSpecification(OnDemandProvisioningSpecificationProperty.builder()
     *                                 .allocationStrategy("allocationStrategy")
     *                                 .build())
     *                         .spotSpecification(SpotProvisioningSpecificationProperty.builder()
     *                                 .timeoutAction("timeoutAction")
     *                                 .timeoutDurationMinutes(123)
     *                                 // the properties below are optional
     *                                 .allocationStrategy("allocationStrategy")
     *                                 .blockDurationMinutes(123)
     *                                 .build())
     *                         .build())
     *                 .name("name")
     *                 .targetOnDemandCapacity(123)
     *                 .targetSpotCapacity(123)
     *                 .build()))
     *         .taskInstanceGroups(List.of(InstanceGroupConfigProperty.builder()
     *                 .instanceCount(123)
     *                 .instanceType("instanceType")
     *                 // the properties below are optional
     *                 .autoScalingPolicy(AutoScalingPolicyProperty.builder()
     *                         .constraints(ScalingConstraintsProperty.builder()
     *                                 .maxCapacity(123)
     *                                 .minCapacity(123)
     *                                 .build())
     *                         .rules(List.of(ScalingRuleProperty.builder()
     *                                 .action(ScalingActionProperty.builder()
     *                                         .simpleScalingPolicyConfiguration(SimpleScalingPolicyConfigurationProperty.builder()
     *                                                 .scalingAdjustment(123)
     *                                                 // the properties below are optional
     *                                                 .adjustmentType("adjustmentType")
     *                                                 .coolDown(123)
     *                                                 .build())
     *                                         // the properties below are optional
     *                                         .market("market")
     *                                         .build())
     *                                 .name("name")
     *                                 .trigger(ScalingTriggerProperty.builder()
     *                                         .cloudWatchAlarmDefinition(CloudWatchAlarmDefinitionProperty.builder()
     *                                                 .comparisonOperator("comparisonOperator")
     *                                                 .metricName("metricName")
     *                                                 .period(123)
     *                                                 .threshold(123)
     *                                                 // the properties below are optional
     *                                                 .dimensions(List.of(MetricDimensionProperty.builder()
     *                                                         .key("key")
     *                                                         .value("value")
     *                                                         .build()))
     *                                                 .evaluationPeriods(123)
     *                                                 .namespace("namespace")
     *                                                 .statistic("statistic")
     *                                                 .unit("unit")
     *                                                 .build())
     *                                         .build())
     *                                 // the properties below are optional
     *                                 .description("description")
     *                                 .build()))
     *                         .build())
     *                 .bidPrice("bidPrice")
     *                 .configurations(List.of(ConfigurationProperty.builder()
     *                         .classification("classification")
     *                         .configurationProperties(Map.of(
     *                                 "configurationPropertiesKey", "configurationProperties"))
     *                         .configurations(List.of(configurationProperty_))
     *                         .build()))
     *                 .customAmiId("customAmiId")
     *                 .ebsConfiguration(EbsConfigurationProperty.builder()
     *                         .ebsBlockDeviceConfigs(List.of(EbsBlockDeviceConfigProperty.builder()
     *                                 .volumeSpecification(VolumeSpecificationProperty.builder()
     *                                         .sizeInGb(123)
     *                                         .volumeType("volumeType")
     *                                         // the properties below are optional
     *                                         .iops(123)
     *                                         .build())
     *                                 // the properties below are optional
     *                                 .volumesPerInstance(123)
     *                                 .build()))
     *                         .ebsOptimized(false)
     *                         .build())
     *                 .market("market")
     *                 .name("name")
     *                 .build()))
     *         .terminationProtected(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_emr.CfnCluster.JobFlowInstancesConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(JobFlowInstancesConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface JobFlowInstancesConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of additional Amazon EC2 security group IDs for the master node.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAdditionalMasterSecurityGroups() {
            return null;
        }

        /**
         * A list of additional Amazon EC2 security group IDs for the core and task nodes.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAdditionalSlaveSecurityGroups() {
            return null;
        }

        /**
         * Describes the EC2 instances and instance configurations for the core instance fleet when using clusters with the instance fleet configuration.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCoreInstanceFleet() {
            return null;
        }

        /**
         * Describes the EC2 instances and instance configurations for core instance groups when using clusters with the uniform instance group configuration.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCoreInstanceGroup() {
            return null;
        }

        /**
         * The name of the EC2 key pair that can be used to connect to the master node using SSH as the user called "hadoop.".
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEc2KeyName() {
            return null;
        }

        /**
         * Applies to clusters that use the uniform instance group configuration.
         * <p>
         * To launch the cluster in Amazon Virtual Private Cloud (Amazon VPC), set this parameter to the identifier of the Amazon VPC subnet where you want the cluster to launch. If you do not specify this value and your account supports EC2-Classic, the cluster launches in EC2-Classic.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEc2SubnetId() {
            return null;
        }

        /**
         * Applies to clusters that use the instance fleet configuration.
         * <p>
         * When multiple EC2 subnet IDs are specified, Amazon EMR evaluates them and launches instances in the optimal subnet.
         * <p>
         * <blockquote>
         * <p>
         * The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x versions.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getEc2SubnetIds() {
            return null;
        }

        /**
         * The identifier of the Amazon EC2 security group for the master node.
         * <p>
         * If you specify <code>EmrManagedMasterSecurityGroup</code> , you must also specify <code>EmrManagedSlaveSecurityGroup</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEmrManagedMasterSecurityGroup() {
            return null;
        }

        /**
         * The identifier of the Amazon EC2 security group for the core and task nodes.
         * <p>
         * If you specify <code>EmrManagedSlaveSecurityGroup</code> , you must also specify <code>EmrManagedMasterSecurityGroup</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEmrManagedSlaveSecurityGroup() {
            return null;
        }

        /**
         * Applies only to Amazon EMR release versions earlier than 4.0. The Hadoop version for the cluster. Valid inputs are "0.18" (no longer maintained), "0.20" (no longer maintained), "0.20.205" (no longer maintained), "1.0.3", "2.2.0", or "2.4.0". If you do not set this value, the default of 0.18 is used, unless the `AmiVersion` parameter is set in the RunJobFlow call, in which case the default version of Hadoop for that AMI version is used.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHadoopVersion() {
            return null;
        }

        /**
         * Specifies whether the cluster should remain available after completing all steps.
         * <p>
         * Defaults to <code>true</code> . For more information about configuring cluster termination, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-termination.html">Control Cluster Termination</a> in the <em>EMR Management Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getKeepJobFlowAliveWhenNoSteps() {
            return null;
        }

        /**
         * Describes the EC2 instances and instance configurations for the master instance fleet when using clusters with the instance fleet configuration.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMasterInstanceFleet() {
            return null;
        }

        /**
         * Describes the EC2 instances and instance configurations for the master instance group when using clusters with the uniform instance group configuration.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMasterInstanceGroup() {
            return null;
        }

        /**
         * The Availability Zone in which the cluster runs.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPlacement() {
            return null;
        }

        /**
         * The identifier of the Amazon EC2 security group for the Amazon EMR service to access clusters in VPC private subnets.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getServiceAccessSecurityGroup() {
            return null;
        }

        /**
         * Describes the EC2 instances and instance configurations for the task instance fleets when using clusters with the instance fleet configuration.
         * <p>
         * These task instance fleets are added to the cluster as part of the cluster launch. Each task instance fleet must have a unique name specified so that CloudFormation can differentiate between the task instance fleets.
         * <p>
         * <blockquote>
         * <p>
         * You can currently specify only one task instance fleet for a cluster. After creating the cluster, you can only modify the mutable properties of <code>InstanceFleetConfig</code> , which are <code>TargetOnDemandCapacity</code> and <code>TargetSpotCapacity</code> . Modifying any other property results in cluster replacement. &gt; To allow a maximum of 30 Amazon EC2 instance types per fleet, include <code>TaskInstanceFleets</code> when you create your cluster. If you create your cluster without <code>TaskInstanceFleets</code> , Amazon EMR uses its default allocation strategy, which allows for a maximum of five Amazon EC2 instance types.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTaskInstanceFleets() {
            return null;
        }

        /**
         * Describes the EC2 instances and instance configurations for task instance groups when using clusters with the uniform instance group configuration.
         * <p>
         * These task instance groups are added to the cluster as part of the cluster launch. Each task instance group must have a unique name specified so that CloudFormation can differentiate between the task instance groups.
         * <p>
         * <blockquote>
         * <p>
         * After creating the cluster, you can only modify the mutable properties of <code>InstanceGroupConfig</code> , which are <code>AutoScalingPolicy</code> and <code>InstanceCount</code> . Modifying any other property results in cluster replacement.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTaskInstanceGroups() {
            return null;
        }

        /**
         * Specifies whether to lock the cluster to prevent the Amazon EC2 instances from being terminated by API call, user intervention, or in the event of a job-flow error.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTerminationProtected() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link JobFlowInstancesConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link JobFlowInstancesConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<JobFlowInstancesConfigProperty> {
            java.util.List<java.lang.String> additionalMasterSecurityGroups;
            java.util.List<java.lang.String> additionalSlaveSecurityGroups;
            java.lang.Object coreInstanceFleet;
            java.lang.Object coreInstanceGroup;
            java.lang.String ec2KeyName;
            java.lang.String ec2SubnetId;
            java.util.List<java.lang.String> ec2SubnetIds;
            java.lang.String emrManagedMasterSecurityGroup;
            java.lang.String emrManagedSlaveSecurityGroup;
            java.lang.String hadoopVersion;
            java.lang.Object keepJobFlowAliveWhenNoSteps;
            java.lang.Object masterInstanceFleet;
            java.lang.Object masterInstanceGroup;
            java.lang.Object placement;
            java.lang.String serviceAccessSecurityGroup;
            java.lang.Object taskInstanceFleets;
            java.lang.Object taskInstanceGroups;
            java.lang.Object terminationProtected;

            /**
             * Sets the value of {@link JobFlowInstancesConfigProperty#getAdditionalMasterSecurityGroups}
             * @param additionalMasterSecurityGroups A list of additional Amazon EC2 security group IDs for the master node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder additionalMasterSecurityGroups(java.util.List<java.lang.String> additionalMasterSecurityGroups) {
                this.additionalMasterSecurityGroups = additionalMasterSecurityGroups;
                return this;
            }

            /**
             * Sets the value of {@link JobFlowInstancesConfigProperty#getAdditionalSlaveSecurityGroups}
             * @param additionalSlaveSecurityGroups A list of additional Amazon EC2 security group IDs for the core and task nodes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder additionalSlaveSecurityGroups(java.util.List<java.lang.String> additionalSlaveSecurityGroups) {
                this.additionalSlaveSecurityGroups = additionalSlaveSecurityGroups;
                return this;
            }

            /**
             * Sets the value of {@link JobFlowInstancesConfigProperty#getCoreInstanceFleet}
             * @param coreInstanceFleet Describes the EC2 instances and instance configurations for the core instance fleet when using clusters with the instance fleet configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder coreInstanceFleet(software.amazon.awscdk.services.emr.CfnCluster.InstanceFleetConfigProperty coreInstanceFleet) {
                this.coreInstanceFleet = coreInstanceFleet;
                return this;
            }

            /**
             * Sets the value of {@link JobFlowInstancesConfigProperty#getCoreInstanceFleet}
             * @param coreInstanceFleet Describes the EC2 instances and instance configurations for the core instance fleet when using clusters with the instance fleet configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder coreInstanceFleet(software.amazon.awscdk.core.IResolvable coreInstanceFleet) {
                this.coreInstanceFleet = coreInstanceFleet;
                return this;
            }

            /**
             * Sets the value of {@link JobFlowInstancesConfigProperty#getCoreInstanceGroup}
             * @param coreInstanceGroup Describes the EC2 instances and instance configurations for core instance groups when using clusters with the uniform instance group configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder coreInstanceGroup(software.amazon.awscdk.services.emr.CfnCluster.InstanceGroupConfigProperty coreInstanceGroup) {
                this.coreInstanceGroup = coreInstanceGroup;
                return this;
            }

            /**
             * Sets the value of {@link JobFlowInstancesConfigProperty#getCoreInstanceGroup}
             * @param coreInstanceGroup Describes the EC2 instances and instance configurations for core instance groups when using clusters with the uniform instance group configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder coreInstanceGroup(software.amazon.awscdk.core.IResolvable coreInstanceGroup) {
                this.coreInstanceGroup = coreInstanceGroup;
                return this;
            }

            /**
             * Sets the value of {@link JobFlowInstancesConfigProperty#getEc2KeyName}
             * @param ec2KeyName The name of the EC2 key pair that can be used to connect to the master node using SSH as the user called "hadoop.".
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ec2KeyName(java.lang.String ec2KeyName) {
                this.ec2KeyName = ec2KeyName;
                return this;
            }

            /**
             * Sets the value of {@link JobFlowInstancesConfigProperty#getEc2SubnetId}
             * @param ec2SubnetId Applies to clusters that use the uniform instance group configuration.
             *                    To launch the cluster in Amazon Virtual Private Cloud (Amazon VPC), set this parameter to the identifier of the Amazon VPC subnet where you want the cluster to launch. If you do not specify this value and your account supports EC2-Classic, the cluster launches in EC2-Classic.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ec2SubnetId(java.lang.String ec2SubnetId) {
                this.ec2SubnetId = ec2SubnetId;
                return this;
            }

            /**
             * Sets the value of {@link JobFlowInstancesConfigProperty#getEc2SubnetIds}
             * @param ec2SubnetIds Applies to clusters that use the instance fleet configuration.
             *                     When multiple EC2 subnet IDs are specified, Amazon EMR evaluates them and launches instances in the optimal subnet.
             *                     <p>
             *                     <blockquote>
             *                     <p>
             *                     The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x versions.
             *                     <p>
             *                     </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ec2SubnetIds(java.util.List<java.lang.String> ec2SubnetIds) {
                this.ec2SubnetIds = ec2SubnetIds;
                return this;
            }

            /**
             * Sets the value of {@link JobFlowInstancesConfigProperty#getEmrManagedMasterSecurityGroup}
             * @param emrManagedMasterSecurityGroup The identifier of the Amazon EC2 security group for the master node.
             *                                      If you specify <code>EmrManagedMasterSecurityGroup</code> , you must also specify <code>EmrManagedSlaveSecurityGroup</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder emrManagedMasterSecurityGroup(java.lang.String emrManagedMasterSecurityGroup) {
                this.emrManagedMasterSecurityGroup = emrManagedMasterSecurityGroup;
                return this;
            }

            /**
             * Sets the value of {@link JobFlowInstancesConfigProperty#getEmrManagedSlaveSecurityGroup}
             * @param emrManagedSlaveSecurityGroup The identifier of the Amazon EC2 security group for the core and task nodes.
             *                                     If you specify <code>EmrManagedSlaveSecurityGroup</code> , you must also specify <code>EmrManagedMasterSecurityGroup</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder emrManagedSlaveSecurityGroup(java.lang.String emrManagedSlaveSecurityGroup) {
                this.emrManagedSlaveSecurityGroup = emrManagedSlaveSecurityGroup;
                return this;
            }

            /**
             * Sets the value of {@link JobFlowInstancesConfigProperty#getHadoopVersion}
             * @param hadoopVersion Applies only to Amazon EMR release versions earlier than 4.0. The Hadoop version for the cluster. Valid inputs are "0.18" (no longer maintained), "0.20" (no longer maintained), "0.20.205" (no longer maintained), "1.0.3", "2.2.0", or "2.4.0". If you do not set this value, the default of 0.18 is used, unless the `AmiVersion` parameter is set in the RunJobFlow call, in which case the default version of Hadoop for that AMI version is used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hadoopVersion(java.lang.String hadoopVersion) {
                this.hadoopVersion = hadoopVersion;
                return this;
            }

            /**
             * Sets the value of {@link JobFlowInstancesConfigProperty#getKeepJobFlowAliveWhenNoSteps}
             * @param keepJobFlowAliveWhenNoSteps Specifies whether the cluster should remain available after completing all steps.
             *                                    Defaults to <code>true</code> . For more information about configuring cluster termination, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-termination.html">Control Cluster Termination</a> in the <em>EMR Management Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keepJobFlowAliveWhenNoSteps(java.lang.Boolean keepJobFlowAliveWhenNoSteps) {
                this.keepJobFlowAliveWhenNoSteps = keepJobFlowAliveWhenNoSteps;
                return this;
            }

            /**
             * Sets the value of {@link JobFlowInstancesConfigProperty#getKeepJobFlowAliveWhenNoSteps}
             * @param keepJobFlowAliveWhenNoSteps Specifies whether the cluster should remain available after completing all steps.
             *                                    Defaults to <code>true</code> . For more information about configuring cluster termination, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-termination.html">Control Cluster Termination</a> in the <em>EMR Management Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keepJobFlowAliveWhenNoSteps(software.amazon.awscdk.core.IResolvable keepJobFlowAliveWhenNoSteps) {
                this.keepJobFlowAliveWhenNoSteps = keepJobFlowAliveWhenNoSteps;
                return this;
            }

            /**
             * Sets the value of {@link JobFlowInstancesConfigProperty#getMasterInstanceFleet}
             * @param masterInstanceFleet Describes the EC2 instances and instance configurations for the master instance fleet when using clusters with the instance fleet configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder masterInstanceFleet(software.amazon.awscdk.services.emr.CfnCluster.InstanceFleetConfigProperty masterInstanceFleet) {
                this.masterInstanceFleet = masterInstanceFleet;
                return this;
            }

            /**
             * Sets the value of {@link JobFlowInstancesConfigProperty#getMasterInstanceFleet}
             * @param masterInstanceFleet Describes the EC2 instances and instance configurations for the master instance fleet when using clusters with the instance fleet configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder masterInstanceFleet(software.amazon.awscdk.core.IResolvable masterInstanceFleet) {
                this.masterInstanceFleet = masterInstanceFleet;
                return this;
            }

            /**
             * Sets the value of {@link JobFlowInstancesConfigProperty#getMasterInstanceGroup}
             * @param masterInstanceGroup Describes the EC2 instances and instance configurations for the master instance group when using clusters with the uniform instance group configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder masterInstanceGroup(software.amazon.awscdk.services.emr.CfnCluster.InstanceGroupConfigProperty masterInstanceGroup) {
                this.masterInstanceGroup = masterInstanceGroup;
                return this;
            }

            /**
             * Sets the value of {@link JobFlowInstancesConfigProperty#getMasterInstanceGroup}
             * @param masterInstanceGroup Describes the EC2 instances and instance configurations for the master instance group when using clusters with the uniform instance group configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder masterInstanceGroup(software.amazon.awscdk.core.IResolvable masterInstanceGroup) {
                this.masterInstanceGroup = masterInstanceGroup;
                return this;
            }

            /**
             * Sets the value of {@link JobFlowInstancesConfigProperty#getPlacement}
             * @param placement The Availability Zone in which the cluster runs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder placement(software.amazon.awscdk.services.emr.CfnCluster.PlacementTypeProperty placement) {
                this.placement = placement;
                return this;
            }

            /**
             * Sets the value of {@link JobFlowInstancesConfigProperty#getPlacement}
             * @param placement The Availability Zone in which the cluster runs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder placement(software.amazon.awscdk.core.IResolvable placement) {
                this.placement = placement;
                return this;
            }

            /**
             * Sets the value of {@link JobFlowInstancesConfigProperty#getServiceAccessSecurityGroup}
             * @param serviceAccessSecurityGroup The identifier of the Amazon EC2 security group for the Amazon EMR service to access clusters in VPC private subnets.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceAccessSecurityGroup(java.lang.String serviceAccessSecurityGroup) {
                this.serviceAccessSecurityGroup = serviceAccessSecurityGroup;
                return this;
            }

            /**
             * Sets the value of {@link JobFlowInstancesConfigProperty#getTaskInstanceFleets}
             * @param taskInstanceFleets Describes the EC2 instances and instance configurations for the task instance fleets when using clusters with the instance fleet configuration.
             *                           These task instance fleets are added to the cluster as part of the cluster launch. Each task instance fleet must have a unique name specified so that CloudFormation can differentiate between the task instance fleets.
             *                           <p>
             *                           <blockquote>
             *                           <p>
             *                           You can currently specify only one task instance fleet for a cluster. After creating the cluster, you can only modify the mutable properties of <code>InstanceFleetConfig</code> , which are <code>TargetOnDemandCapacity</code> and <code>TargetSpotCapacity</code> . Modifying any other property results in cluster replacement. &gt; To allow a maximum of 30 Amazon EC2 instance types per fleet, include <code>TaskInstanceFleets</code> when you create your cluster. If you create your cluster without <code>TaskInstanceFleets</code> , Amazon EMR uses its default allocation strategy, which allows for a maximum of five Amazon EC2 instance types.
             *                           <p>
             *                           </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder taskInstanceFleets(software.amazon.awscdk.core.IResolvable taskInstanceFleets) {
                this.taskInstanceFleets = taskInstanceFleets;
                return this;
            }

            /**
             * Sets the value of {@link JobFlowInstancesConfigProperty#getTaskInstanceFleets}
             * @param taskInstanceFleets Describes the EC2 instances and instance configurations for the task instance fleets when using clusters with the instance fleet configuration.
             *                           These task instance fleets are added to the cluster as part of the cluster launch. Each task instance fleet must have a unique name specified so that CloudFormation can differentiate between the task instance fleets.
             *                           <p>
             *                           <blockquote>
             *                           <p>
             *                           You can currently specify only one task instance fleet for a cluster. After creating the cluster, you can only modify the mutable properties of <code>InstanceFleetConfig</code> , which are <code>TargetOnDemandCapacity</code> and <code>TargetSpotCapacity</code> . Modifying any other property results in cluster replacement. &gt; To allow a maximum of 30 Amazon EC2 instance types per fleet, include <code>TaskInstanceFleets</code> when you create your cluster. If you create your cluster without <code>TaskInstanceFleets</code> , Amazon EMR uses its default allocation strategy, which allows for a maximum of five Amazon EC2 instance types.
             *                           <p>
             *                           </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder taskInstanceFleets(java.util.List<? extends java.lang.Object> taskInstanceFleets) {
                this.taskInstanceFleets = taskInstanceFleets;
                return this;
            }

            /**
             * Sets the value of {@link JobFlowInstancesConfigProperty#getTaskInstanceGroups}
             * @param taskInstanceGroups Describes the EC2 instances and instance configurations for task instance groups when using clusters with the uniform instance group configuration.
             *                           These task instance groups are added to the cluster as part of the cluster launch. Each task instance group must have a unique name specified so that CloudFormation can differentiate between the task instance groups.
             *                           <p>
             *                           <blockquote>
             *                           <p>
             *                           After creating the cluster, you can only modify the mutable properties of <code>InstanceGroupConfig</code> , which are <code>AutoScalingPolicy</code> and <code>InstanceCount</code> . Modifying any other property results in cluster replacement.
             *                           <p>
             *                           </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder taskInstanceGroups(software.amazon.awscdk.core.IResolvable taskInstanceGroups) {
                this.taskInstanceGroups = taskInstanceGroups;
                return this;
            }

            /**
             * Sets the value of {@link JobFlowInstancesConfigProperty#getTaskInstanceGroups}
             * @param taskInstanceGroups Describes the EC2 instances and instance configurations for task instance groups when using clusters with the uniform instance group configuration.
             *                           These task instance groups are added to the cluster as part of the cluster launch. Each task instance group must have a unique name specified so that CloudFormation can differentiate between the task instance groups.
             *                           <p>
             *                           <blockquote>
             *                           <p>
             *                           After creating the cluster, you can only modify the mutable properties of <code>InstanceGroupConfig</code> , which are <code>AutoScalingPolicy</code> and <code>InstanceCount</code> . Modifying any other property results in cluster replacement.
             *                           <p>
             *                           </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder taskInstanceGroups(java.util.List<? extends java.lang.Object> taskInstanceGroups) {
                this.taskInstanceGroups = taskInstanceGroups;
                return this;
            }

            /**
             * Sets the value of {@link JobFlowInstancesConfigProperty#getTerminationProtected}
             * @param terminationProtected Specifies whether to lock the cluster to prevent the Amazon EC2 instances from being terminated by API call, user intervention, or in the event of a job-flow error.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder terminationProtected(java.lang.Boolean terminationProtected) {
                this.terminationProtected = terminationProtected;
                return this;
            }

            /**
             * Sets the value of {@link JobFlowInstancesConfigProperty#getTerminationProtected}
             * @param terminationProtected Specifies whether to lock the cluster to prevent the Amazon EC2 instances from being terminated by API call, user intervention, or in the event of a job-flow error.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder terminationProtected(software.amazon.awscdk.core.IResolvable terminationProtected) {
                this.terminationProtected = terminationProtected;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link JobFlowInstancesConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public JobFlowInstancesConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link JobFlowInstancesConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements JobFlowInstancesConfigProperty {
            private final java.util.List<java.lang.String> additionalMasterSecurityGroups;
            private final java.util.List<java.lang.String> additionalSlaveSecurityGroups;
            private final java.lang.Object coreInstanceFleet;
            private final java.lang.Object coreInstanceGroup;
            private final java.lang.String ec2KeyName;
            private final java.lang.String ec2SubnetId;
            private final java.util.List<java.lang.String> ec2SubnetIds;
            private final java.lang.String emrManagedMasterSecurityGroup;
            private final java.lang.String emrManagedSlaveSecurityGroup;
            private final java.lang.String hadoopVersion;
            private final java.lang.Object keepJobFlowAliveWhenNoSteps;
            private final java.lang.Object masterInstanceFleet;
            private final java.lang.Object masterInstanceGroup;
            private final java.lang.Object placement;
            private final java.lang.String serviceAccessSecurityGroup;
            private final java.lang.Object taskInstanceFleets;
            private final java.lang.Object taskInstanceGroups;
            private final java.lang.Object terminationProtected;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.additionalMasterSecurityGroups = software.amazon.jsii.Kernel.get(this, "additionalMasterSecurityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.additionalSlaveSecurityGroups = software.amazon.jsii.Kernel.get(this, "additionalSlaveSecurityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.coreInstanceFleet = software.amazon.jsii.Kernel.get(this, "coreInstanceFleet", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.coreInstanceGroup = software.amazon.jsii.Kernel.get(this, "coreInstanceGroup", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ec2KeyName = software.amazon.jsii.Kernel.get(this, "ec2KeyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.ec2SubnetId = software.amazon.jsii.Kernel.get(this, "ec2SubnetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.ec2SubnetIds = software.amazon.jsii.Kernel.get(this, "ec2SubnetIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.emrManagedMasterSecurityGroup = software.amazon.jsii.Kernel.get(this, "emrManagedMasterSecurityGroup", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.emrManagedSlaveSecurityGroup = software.amazon.jsii.Kernel.get(this, "emrManagedSlaveSecurityGroup", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.hadoopVersion = software.amazon.jsii.Kernel.get(this, "hadoopVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.keepJobFlowAliveWhenNoSteps = software.amazon.jsii.Kernel.get(this, "keepJobFlowAliveWhenNoSteps", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.masterInstanceFleet = software.amazon.jsii.Kernel.get(this, "masterInstanceFleet", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.masterInstanceGroup = software.amazon.jsii.Kernel.get(this, "masterInstanceGroup", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.placement = software.amazon.jsii.Kernel.get(this, "placement", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.serviceAccessSecurityGroup = software.amazon.jsii.Kernel.get(this, "serviceAccessSecurityGroup", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.taskInstanceFleets = software.amazon.jsii.Kernel.get(this, "taskInstanceFleets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.taskInstanceGroups = software.amazon.jsii.Kernel.get(this, "taskInstanceGroups", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.terminationProtected = software.amazon.jsii.Kernel.get(this, "terminationProtected", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.additionalMasterSecurityGroups = builder.additionalMasterSecurityGroups;
                this.additionalSlaveSecurityGroups = builder.additionalSlaveSecurityGroups;
                this.coreInstanceFleet = builder.coreInstanceFleet;
                this.coreInstanceGroup = builder.coreInstanceGroup;
                this.ec2KeyName = builder.ec2KeyName;
                this.ec2SubnetId = builder.ec2SubnetId;
                this.ec2SubnetIds = builder.ec2SubnetIds;
                this.emrManagedMasterSecurityGroup = builder.emrManagedMasterSecurityGroup;
                this.emrManagedSlaveSecurityGroup = builder.emrManagedSlaveSecurityGroup;
                this.hadoopVersion = builder.hadoopVersion;
                this.keepJobFlowAliveWhenNoSteps = builder.keepJobFlowAliveWhenNoSteps;
                this.masterInstanceFleet = builder.masterInstanceFleet;
                this.masterInstanceGroup = builder.masterInstanceGroup;
                this.placement = builder.placement;
                this.serviceAccessSecurityGroup = builder.serviceAccessSecurityGroup;
                this.taskInstanceFleets = builder.taskInstanceFleets;
                this.taskInstanceGroups = builder.taskInstanceGroups;
                this.terminationProtected = builder.terminationProtected;
            }

            @Override
            public final java.util.List<java.lang.String> getAdditionalMasterSecurityGroups() {
                return this.additionalMasterSecurityGroups;
            }

            @Override
            public final java.util.List<java.lang.String> getAdditionalSlaveSecurityGroups() {
                return this.additionalSlaveSecurityGroups;
            }

            @Override
            public final java.lang.Object getCoreInstanceFleet() {
                return this.coreInstanceFleet;
            }

            @Override
            public final java.lang.Object getCoreInstanceGroup() {
                return this.coreInstanceGroup;
            }

            @Override
            public final java.lang.String getEc2KeyName() {
                return this.ec2KeyName;
            }

            @Override
            public final java.lang.String getEc2SubnetId() {
                return this.ec2SubnetId;
            }

            @Override
            public final java.util.List<java.lang.String> getEc2SubnetIds() {
                return this.ec2SubnetIds;
            }

            @Override
            public final java.lang.String getEmrManagedMasterSecurityGroup() {
                return this.emrManagedMasterSecurityGroup;
            }

            @Override
            public final java.lang.String getEmrManagedSlaveSecurityGroup() {
                return this.emrManagedSlaveSecurityGroup;
            }

            @Override
            public final java.lang.String getHadoopVersion() {
                return this.hadoopVersion;
            }

            @Override
            public final java.lang.Object getKeepJobFlowAliveWhenNoSteps() {
                return this.keepJobFlowAliveWhenNoSteps;
            }

            @Override
            public final java.lang.Object getMasterInstanceFleet() {
                return this.masterInstanceFleet;
            }

            @Override
            public final java.lang.Object getMasterInstanceGroup() {
                return this.masterInstanceGroup;
            }

            @Override
            public final java.lang.Object getPlacement() {
                return this.placement;
            }

            @Override
            public final java.lang.String getServiceAccessSecurityGroup() {
                return this.serviceAccessSecurityGroup;
            }

            @Override
            public final java.lang.Object getTaskInstanceFleets() {
                return this.taskInstanceFleets;
            }

            @Override
            public final java.lang.Object getTaskInstanceGroups() {
                return this.taskInstanceGroups;
            }

            @Override
            public final java.lang.Object getTerminationProtected() {
                return this.terminationProtected;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAdditionalMasterSecurityGroups() != null) {
                    data.set("additionalMasterSecurityGroups", om.valueToTree(this.getAdditionalMasterSecurityGroups()));
                }
                if (this.getAdditionalSlaveSecurityGroups() != null) {
                    data.set("additionalSlaveSecurityGroups", om.valueToTree(this.getAdditionalSlaveSecurityGroups()));
                }
                if (this.getCoreInstanceFleet() != null) {
                    data.set("coreInstanceFleet", om.valueToTree(this.getCoreInstanceFleet()));
                }
                if (this.getCoreInstanceGroup() != null) {
                    data.set("coreInstanceGroup", om.valueToTree(this.getCoreInstanceGroup()));
                }
                if (this.getEc2KeyName() != null) {
                    data.set("ec2KeyName", om.valueToTree(this.getEc2KeyName()));
                }
                if (this.getEc2SubnetId() != null) {
                    data.set("ec2SubnetId", om.valueToTree(this.getEc2SubnetId()));
                }
                if (this.getEc2SubnetIds() != null) {
                    data.set("ec2SubnetIds", om.valueToTree(this.getEc2SubnetIds()));
                }
                if (this.getEmrManagedMasterSecurityGroup() != null) {
                    data.set("emrManagedMasterSecurityGroup", om.valueToTree(this.getEmrManagedMasterSecurityGroup()));
                }
                if (this.getEmrManagedSlaveSecurityGroup() != null) {
                    data.set("emrManagedSlaveSecurityGroup", om.valueToTree(this.getEmrManagedSlaveSecurityGroup()));
                }
                if (this.getHadoopVersion() != null) {
                    data.set("hadoopVersion", om.valueToTree(this.getHadoopVersion()));
                }
                if (this.getKeepJobFlowAliveWhenNoSteps() != null) {
                    data.set("keepJobFlowAliveWhenNoSteps", om.valueToTree(this.getKeepJobFlowAliveWhenNoSteps()));
                }
                if (this.getMasterInstanceFleet() != null) {
                    data.set("masterInstanceFleet", om.valueToTree(this.getMasterInstanceFleet()));
                }
                if (this.getMasterInstanceGroup() != null) {
                    data.set("masterInstanceGroup", om.valueToTree(this.getMasterInstanceGroup()));
                }
                if (this.getPlacement() != null) {
                    data.set("placement", om.valueToTree(this.getPlacement()));
                }
                if (this.getServiceAccessSecurityGroup() != null) {
                    data.set("serviceAccessSecurityGroup", om.valueToTree(this.getServiceAccessSecurityGroup()));
                }
                if (this.getTaskInstanceFleets() != null) {
                    data.set("taskInstanceFleets", om.valueToTree(this.getTaskInstanceFleets()));
                }
                if (this.getTaskInstanceGroups() != null) {
                    data.set("taskInstanceGroups", om.valueToTree(this.getTaskInstanceGroups()));
                }
                if (this.getTerminationProtected() != null) {
                    data.set("terminationProtected", om.valueToTree(this.getTerminationProtected()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_emr.CfnCluster.JobFlowInstancesConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                JobFlowInstancesConfigProperty.Jsii$Proxy that = (JobFlowInstancesConfigProperty.Jsii$Proxy) o;

                if (this.additionalMasterSecurityGroups != null ? !this.additionalMasterSecurityGroups.equals(that.additionalMasterSecurityGroups) : that.additionalMasterSecurityGroups != null) return false;
                if (this.additionalSlaveSecurityGroups != null ? !this.additionalSlaveSecurityGroups.equals(that.additionalSlaveSecurityGroups) : that.additionalSlaveSecurityGroups != null) return false;
                if (this.coreInstanceFleet != null ? !this.coreInstanceFleet.equals(that.coreInstanceFleet) : that.coreInstanceFleet != null) return false;
                if (this.coreInstanceGroup != null ? !this.coreInstanceGroup.equals(that.coreInstanceGroup) : that.coreInstanceGroup != null) return false;
                if (this.ec2KeyName != null ? !this.ec2KeyName.equals(that.ec2KeyName) : that.ec2KeyName != null) return false;
                if (this.ec2SubnetId != null ? !this.ec2SubnetId.equals(that.ec2SubnetId) : that.ec2SubnetId != null) return false;
                if (this.ec2SubnetIds != null ? !this.ec2SubnetIds.equals(that.ec2SubnetIds) : that.ec2SubnetIds != null) return false;
                if (this.emrManagedMasterSecurityGroup != null ? !this.emrManagedMasterSecurityGroup.equals(that.emrManagedMasterSecurityGroup) : that.emrManagedMasterSecurityGroup != null) return false;
                if (this.emrManagedSlaveSecurityGroup != null ? !this.emrManagedSlaveSecurityGroup.equals(that.emrManagedSlaveSecurityGroup) : that.emrManagedSlaveSecurityGroup != null) return false;
                if (this.hadoopVersion != null ? !this.hadoopVersion.equals(that.hadoopVersion) : that.hadoopVersion != null) return false;
                if (this.keepJobFlowAliveWhenNoSteps != null ? !this.keepJobFlowAliveWhenNoSteps.equals(that.keepJobFlowAliveWhenNoSteps) : that.keepJobFlowAliveWhenNoSteps != null) return false;
                if (this.masterInstanceFleet != null ? !this.masterInstanceFleet.equals(that.masterInstanceFleet) : that.masterInstanceFleet != null) return false;
                if (this.masterInstanceGroup != null ? !this.masterInstanceGroup.equals(that.masterInstanceGroup) : that.masterInstanceGroup != null) return false;
                if (this.placement != null ? !this.placement.equals(that.placement) : that.placement != null) return false;
                if (this.serviceAccessSecurityGroup != null ? !this.serviceAccessSecurityGroup.equals(that.serviceAccessSecurityGroup) : that.serviceAccessSecurityGroup != null) return false;
                if (this.taskInstanceFleets != null ? !this.taskInstanceFleets.equals(that.taskInstanceFleets) : that.taskInstanceFleets != null) return false;
                if (this.taskInstanceGroups != null ? !this.taskInstanceGroups.equals(that.taskInstanceGroups) : that.taskInstanceGroups != null) return false;
                return this.terminationProtected != null ? this.terminationProtected.equals(that.terminationProtected) : that.terminationProtected == null;
            }

            @Override
            public final int hashCode() {
                int result = this.additionalMasterSecurityGroups != null ? this.additionalMasterSecurityGroups.hashCode() : 0;
                result = 31 * result + (this.additionalSlaveSecurityGroups != null ? this.additionalSlaveSecurityGroups.hashCode() : 0);
                result = 31 * result + (this.coreInstanceFleet != null ? this.coreInstanceFleet.hashCode() : 0);
                result = 31 * result + (this.coreInstanceGroup != null ? this.coreInstanceGroup.hashCode() : 0);
                result = 31 * result + (this.ec2KeyName != null ? this.ec2KeyName.hashCode() : 0);
                result = 31 * result + (this.ec2SubnetId != null ? this.ec2SubnetId.hashCode() : 0);
                result = 31 * result + (this.ec2SubnetIds != null ? this.ec2SubnetIds.hashCode() : 0);
                result = 31 * result + (this.emrManagedMasterSecurityGroup != null ? this.emrManagedMasterSecurityGroup.hashCode() : 0);
                result = 31 * result + (this.emrManagedSlaveSecurityGroup != null ? this.emrManagedSlaveSecurityGroup.hashCode() : 0);
                result = 31 * result + (this.hadoopVersion != null ? this.hadoopVersion.hashCode() : 0);
                result = 31 * result + (this.keepJobFlowAliveWhenNoSteps != null ? this.keepJobFlowAliveWhenNoSteps.hashCode() : 0);
                result = 31 * result + (this.masterInstanceFleet != null ? this.masterInstanceFleet.hashCode() : 0);
                result = 31 * result + (this.masterInstanceGroup != null ? this.masterInstanceGroup.hashCode() : 0);
                result = 31 * result + (this.placement != null ? this.placement.hashCode() : 0);
                result = 31 * result + (this.serviceAccessSecurityGroup != null ? this.serviceAccessSecurityGroup.hashCode() : 0);
                result = 31 * result + (this.taskInstanceFleets != null ? this.taskInstanceFleets.hashCode() : 0);
                result = 31 * result + (this.taskInstanceGroups != null ? this.taskInstanceGroups.hashCode() : 0);
                result = 31 * result + (this.terminationProtected != null ? this.terminationProtected.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * `KerberosAttributes` is a property of the `AWS::EMR::Cluster` resource.
     * <p>
     * <code>KerberosAttributes</code> define the cluster-specific Kerberos configuration when Kerberos authentication is enabled using a security configuration. The cluster-specific configuration must be compatible with the security configuration. For more information see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-kerberos.html">Use Kerberos Authentication</a> in the <em>EMR Management Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emr.*;
     * KerberosAttributesProperty kerberosAttributesProperty = KerberosAttributesProperty.builder()
     *         .kdcAdminPassword("kdcAdminPassword")
     *         .realm("realm")
     *         // the properties below are optional
     *         .adDomainJoinPassword("adDomainJoinPassword")
     *         .adDomainJoinUser("adDomainJoinUser")
     *         .crossRealmTrustPrincipalPassword("crossRealmTrustPrincipalPassword")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_emr.CfnCluster.KerberosAttributesProperty")
    @software.amazon.jsii.Jsii.Proxy(KerberosAttributesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KerberosAttributesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The password used within the cluster for the kadmin service on the cluster-dedicated KDC, which maintains Kerberos principals, password policies, and keytabs for the cluster.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKdcAdminPassword();

        /**
         * The name of the Kerberos realm to which all nodes in a cluster belong.
         * <p>
         * For example, <code>EC2.INTERNAL</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRealm();

        /**
         * The Active Directory password for `ADDomainJoinUser` .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAdDomainJoinPassword() {
            return null;
        }

        /**
         * Required only when establishing a cross-realm trust with an Active Directory domain.
         * <p>
         * A user with sufficient privileges to join resources to the domain.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAdDomainJoinUser() {
            return null;
        }

        /**
         * Required only when establishing a cross-realm trust with a KDC in a different realm.
         * <p>
         * The cross-realm principal password, which must be identical across realms.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCrossRealmTrustPrincipalPassword() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link KerberosAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KerberosAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KerberosAttributesProperty> {
            java.lang.String kdcAdminPassword;
            java.lang.String realm;
            java.lang.String adDomainJoinPassword;
            java.lang.String adDomainJoinUser;
            java.lang.String crossRealmTrustPrincipalPassword;

            /**
             * Sets the value of {@link KerberosAttributesProperty#getKdcAdminPassword}
             * @param kdcAdminPassword The password used within the cluster for the kadmin service on the cluster-dedicated KDC, which maintains Kerberos principals, password policies, and keytabs for the cluster. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kdcAdminPassword(java.lang.String kdcAdminPassword) {
                this.kdcAdminPassword = kdcAdminPassword;
                return this;
            }

            /**
             * Sets the value of {@link KerberosAttributesProperty#getRealm}
             * @param realm The name of the Kerberos realm to which all nodes in a cluster belong. This parameter is required.
             *              For example, <code>EC2.INTERNAL</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder realm(java.lang.String realm) {
                this.realm = realm;
                return this;
            }

            /**
             * Sets the value of {@link KerberosAttributesProperty#getAdDomainJoinPassword}
             * @param adDomainJoinPassword The Active Directory password for `ADDomainJoinUser` .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder adDomainJoinPassword(java.lang.String adDomainJoinPassword) {
                this.adDomainJoinPassword = adDomainJoinPassword;
                return this;
            }

            /**
             * Sets the value of {@link KerberosAttributesProperty#getAdDomainJoinUser}
             * @param adDomainJoinUser Required only when establishing a cross-realm trust with an Active Directory domain.
             *                         A user with sufficient privileges to join resources to the domain.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder adDomainJoinUser(java.lang.String adDomainJoinUser) {
                this.adDomainJoinUser = adDomainJoinUser;
                return this;
            }

            /**
             * Sets the value of {@link KerberosAttributesProperty#getCrossRealmTrustPrincipalPassword}
             * @param crossRealmTrustPrincipalPassword Required only when establishing a cross-realm trust with a KDC in a different realm.
             *                                         The cross-realm principal password, which must be identical across realms.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder crossRealmTrustPrincipalPassword(java.lang.String crossRealmTrustPrincipalPassword) {
                this.crossRealmTrustPrincipalPassword = crossRealmTrustPrincipalPassword;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KerberosAttributesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KerberosAttributesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KerberosAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KerberosAttributesProperty {
            private final java.lang.String kdcAdminPassword;
            private final java.lang.String realm;
            private final java.lang.String adDomainJoinPassword;
            private final java.lang.String adDomainJoinUser;
            private final java.lang.String crossRealmTrustPrincipalPassword;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.kdcAdminPassword = software.amazon.jsii.Kernel.get(this, "kdcAdminPassword", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.realm = software.amazon.jsii.Kernel.get(this, "realm", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.adDomainJoinPassword = software.amazon.jsii.Kernel.get(this, "adDomainJoinPassword", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.adDomainJoinUser = software.amazon.jsii.Kernel.get(this, "adDomainJoinUser", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.crossRealmTrustPrincipalPassword = software.amazon.jsii.Kernel.get(this, "crossRealmTrustPrincipalPassword", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.kdcAdminPassword = java.util.Objects.requireNonNull(builder.kdcAdminPassword, "kdcAdminPassword is required");
                this.realm = java.util.Objects.requireNonNull(builder.realm, "realm is required");
                this.adDomainJoinPassword = builder.adDomainJoinPassword;
                this.adDomainJoinUser = builder.adDomainJoinUser;
                this.crossRealmTrustPrincipalPassword = builder.crossRealmTrustPrincipalPassword;
            }

            @Override
            public final java.lang.String getKdcAdminPassword() {
                return this.kdcAdminPassword;
            }

            @Override
            public final java.lang.String getRealm() {
                return this.realm;
            }

            @Override
            public final java.lang.String getAdDomainJoinPassword() {
                return this.adDomainJoinPassword;
            }

            @Override
            public final java.lang.String getAdDomainJoinUser() {
                return this.adDomainJoinUser;
            }

            @Override
            public final java.lang.String getCrossRealmTrustPrincipalPassword() {
                return this.crossRealmTrustPrincipalPassword;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("kdcAdminPassword", om.valueToTree(this.getKdcAdminPassword()));
                data.set("realm", om.valueToTree(this.getRealm()));
                if (this.getAdDomainJoinPassword() != null) {
                    data.set("adDomainJoinPassword", om.valueToTree(this.getAdDomainJoinPassword()));
                }
                if (this.getAdDomainJoinUser() != null) {
                    data.set("adDomainJoinUser", om.valueToTree(this.getAdDomainJoinUser()));
                }
                if (this.getCrossRealmTrustPrincipalPassword() != null) {
                    data.set("crossRealmTrustPrincipalPassword", om.valueToTree(this.getCrossRealmTrustPrincipalPassword()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_emr.CfnCluster.KerberosAttributesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KerberosAttributesProperty.Jsii$Proxy that = (KerberosAttributesProperty.Jsii$Proxy) o;

                if (!kdcAdminPassword.equals(that.kdcAdminPassword)) return false;
                if (!realm.equals(that.realm)) return false;
                if (this.adDomainJoinPassword != null ? !this.adDomainJoinPassword.equals(that.adDomainJoinPassword) : that.adDomainJoinPassword != null) return false;
                if (this.adDomainJoinUser != null ? !this.adDomainJoinUser.equals(that.adDomainJoinUser) : that.adDomainJoinUser != null) return false;
                return this.crossRealmTrustPrincipalPassword != null ? this.crossRealmTrustPrincipalPassword.equals(that.crossRealmTrustPrincipalPassword) : that.crossRealmTrustPrincipalPassword == null;
            }

            @Override
            public final int hashCode() {
                int result = this.kdcAdminPassword.hashCode();
                result = 31 * result + (this.realm.hashCode());
                result = 31 * result + (this.adDomainJoinPassword != null ? this.adDomainJoinPassword.hashCode() : 0);
                result = 31 * result + (this.adDomainJoinUser != null ? this.adDomainJoinUser.hashCode() : 0);
                result = 31 * result + (this.crossRealmTrustPrincipalPassword != null ? this.crossRealmTrustPrincipalPassword.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * `KeyValue` is a subproperty of the `HadoopJarStepConfig` property type.
     * <p>
     * <code>KeyValue</code> is used to pass parameters to a step.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emr.*;
     * KeyValueProperty keyValueProperty = KeyValueProperty.builder()
     *         .key("key")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_emr.CfnCluster.KeyValueProperty")
    @software.amazon.jsii.Jsii.Proxy(KeyValueProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KeyValueProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The unique identifier of a key-value pair.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKey() {
            return null;
        }

        /**
         * The value part of the identified key.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link KeyValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KeyValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KeyValueProperty> {
            java.lang.String key;
            java.lang.String value;

            /**
             * Sets the value of {@link KeyValueProperty#getKey}
             * @param key The unique identifier of a key-value pair.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link KeyValueProperty#getValue}
             * @param value The value part of the identified key.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KeyValueProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KeyValueProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KeyValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KeyValueProperty {
            private final java.lang.String key;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = builder.key;
                this.value = builder.value;
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getKey() != null) {
                    data.set("key", om.valueToTree(this.getKey()));
                }
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_emr.CfnCluster.KeyValueProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KeyValueProperty.Jsii$Proxy that = (KeyValueProperty.Jsii$Proxy) o;

                if (this.key != null ? !this.key.equals(that.key) : that.key != null) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.key != null ? this.key.hashCode() : 0;
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Managed scaling policy for an Amazon EMR cluster.
     * <p>
     * The policy specifies the limits for resources that can be added or terminated from a cluster. The policy only applies to the core and task nodes. The master node cannot be scaled after initial configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emr.*;
     * ManagedScalingPolicyProperty managedScalingPolicyProperty = ManagedScalingPolicyProperty.builder()
     *         .computeLimits(ComputeLimitsProperty.builder()
     *                 .maximumCapacityUnits(123)
     *                 .minimumCapacityUnits(123)
     *                 .unitType("unitType")
     *                 // the properties below are optional
     *                 .maximumCoreCapacityUnits(123)
     *                 .maximumOnDemandCapacityUnits(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_emr.CfnCluster.ManagedScalingPolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(ManagedScalingPolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ManagedScalingPolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The EC2 unit limits for a managed scaling policy.
         * <p>
         * The managed scaling activity of a cluster is not allowed to go above or below these limits. The limit only applies to the core and task nodes. The master node cannot be scaled after initial configuration.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getComputeLimits() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ManagedScalingPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ManagedScalingPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ManagedScalingPolicyProperty> {
            java.lang.Object computeLimits;

            /**
             * Sets the value of {@link ManagedScalingPolicyProperty#getComputeLimits}
             * @param computeLimits The EC2 unit limits for a managed scaling policy.
             *                      The managed scaling activity of a cluster is not allowed to go above or below these limits. The limit only applies to the core and task nodes. The master node cannot be scaled after initial configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder computeLimits(software.amazon.awscdk.services.emr.CfnCluster.ComputeLimitsProperty computeLimits) {
                this.computeLimits = computeLimits;
                return this;
            }

            /**
             * Sets the value of {@link ManagedScalingPolicyProperty#getComputeLimits}
             * @param computeLimits The EC2 unit limits for a managed scaling policy.
             *                      The managed scaling activity of a cluster is not allowed to go above or below these limits. The limit only applies to the core and task nodes. The master node cannot be scaled after initial configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder computeLimits(software.amazon.awscdk.core.IResolvable computeLimits) {
                this.computeLimits = computeLimits;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ManagedScalingPolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ManagedScalingPolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ManagedScalingPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ManagedScalingPolicyProperty {
            private final java.lang.Object computeLimits;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.computeLimits = software.amazon.jsii.Kernel.get(this, "computeLimits", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.computeLimits = builder.computeLimits;
            }

            @Override
            public final java.lang.Object getComputeLimits() {
                return this.computeLimits;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getComputeLimits() != null) {
                    data.set("computeLimits", om.valueToTree(this.getComputeLimits()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_emr.CfnCluster.ManagedScalingPolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ManagedScalingPolicyProperty.Jsii$Proxy that = (ManagedScalingPolicyProperty.Jsii$Proxy) o;

                return this.computeLimits != null ? this.computeLimits.equals(that.computeLimits) : that.computeLimits == null;
            }

            @Override
            public final int hashCode() {
                int result = this.computeLimits != null ? this.computeLimits.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * `MetricDimension` is a subproperty of the `CloudWatchAlarmDefinition` property type.
     * <p>
     * <code>MetricDimension</code> specifies a CloudWatch dimension, which is specified with a <code>Key</code> <code>Value</code> pair. The key is known as a <code>Name</code> in CloudWatch. By default, Amazon EMR uses one dimension whose <code>Key</code> is <code>JobFlowID</code> and <code>Value</code> is a variable representing the cluster ID, which is <code>${emr.clusterId}</code> . This enables the automatic scaling rule for EMR to bootstrap when the cluster ID becomes available during cluster creation.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emr.*;
     * MetricDimensionProperty metricDimensionProperty = MetricDimensionProperty.builder()
     *         .key("key")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_emr.CfnCluster.MetricDimensionProperty")
    @software.amazon.jsii.Jsii.Proxy(MetricDimensionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MetricDimensionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The dimension name.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * The dimension value.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link MetricDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MetricDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MetricDimensionProperty> {
            java.lang.String key;
            java.lang.String value;

            /**
             * Sets the value of {@link MetricDimensionProperty#getKey}
             * @param key The dimension name. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link MetricDimensionProperty#getValue}
             * @param value The dimension value. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MetricDimensionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MetricDimensionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MetricDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MetricDimensionProperty {
            private final java.lang.String key;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("key", om.valueToTree(this.getKey()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_emr.CfnCluster.MetricDimensionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MetricDimensionProperty.Jsii$Proxy that = (MetricDimensionProperty.Jsii$Proxy) o;

                if (!key.equals(that.key)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.key.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * The launch specification for On-Demand Instances in the instance fleet, which determines the allocation strategy.
     * <p>
     * <blockquote>
     * <p>
     * The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x versions. On-Demand Instances allocation strategy is available in Amazon EMR version 5.12.1 and later.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emr.*;
     * OnDemandProvisioningSpecificationProperty onDemandProvisioningSpecificationProperty = OnDemandProvisioningSpecificationProperty.builder()
     *         .allocationStrategy("allocationStrategy")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_emr.CfnCluster.OnDemandProvisioningSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(OnDemandProvisioningSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OnDemandProvisioningSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the strategy to use in launching On-Demand instance fleets.
         * <p>
         * Currently, the only option is <code>lowest-price</code> (the default), which launches the lowest price first.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAllocationStrategy();

        /**
         * @return a {@link Builder} of {@link OnDemandProvisioningSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OnDemandProvisioningSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OnDemandProvisioningSpecificationProperty> {
            java.lang.String allocationStrategy;

            /**
             * Sets the value of {@link OnDemandProvisioningSpecificationProperty#getAllocationStrategy}
             * @param allocationStrategy Specifies the strategy to use in launching On-Demand instance fleets. This parameter is required.
             *                           Currently, the only option is <code>lowest-price</code> (the default), which launches the lowest price first.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allocationStrategy(java.lang.String allocationStrategy) {
                this.allocationStrategy = allocationStrategy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OnDemandProvisioningSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OnDemandProvisioningSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OnDemandProvisioningSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OnDemandProvisioningSpecificationProperty {
            private final java.lang.String allocationStrategy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.allocationStrategy = software.amazon.jsii.Kernel.get(this, "allocationStrategy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.allocationStrategy = java.util.Objects.requireNonNull(builder.allocationStrategy, "allocationStrategy is required");
            }

            @Override
            public final java.lang.String getAllocationStrategy() {
                return this.allocationStrategy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("allocationStrategy", om.valueToTree(this.getAllocationStrategy()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_emr.CfnCluster.OnDemandProvisioningSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OnDemandProvisioningSpecificationProperty.Jsii$Proxy that = (OnDemandProvisioningSpecificationProperty.Jsii$Proxy) o;

                return this.allocationStrategy.equals(that.allocationStrategy);
            }

            @Override
            public final int hashCode() {
                int result = this.allocationStrategy.hashCode();
                return result;
            }
        }
    }
    /**
     * `PlacementType` is a property of the `AWS::EMR::Cluster` resource.
     * <p>
     * <code>PlacementType</code> determines the Amazon EC2 Availability Zone configuration of the cluster (job flow).
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emr.*;
     * PlacementTypeProperty placementTypeProperty = PlacementTypeProperty.builder()
     *         .availabilityZone("availabilityZone")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_emr.CfnCluster.PlacementTypeProperty")
    @software.amazon.jsii.Jsii.Proxy(PlacementTypeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PlacementTypeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon EC2 Availability Zone for the cluster.
         * <p>
         * <code>AvailabilityZone</code> is used for uniform instance groups, while <code>AvailabilityZones</code> (plural) is used for instance fleets.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAvailabilityZone();

        /**
         * @return a {@link Builder} of {@link PlacementTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PlacementTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PlacementTypeProperty> {
            java.lang.String availabilityZone;

            /**
             * Sets the value of {@link PlacementTypeProperty#getAvailabilityZone}
             * @param availabilityZone The Amazon EC2 Availability Zone for the cluster. This parameter is required.
             *                         <code>AvailabilityZone</code> is used for uniform instance groups, while <code>AvailabilityZones</code> (plural) is used for instance fleets.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder availabilityZone(java.lang.String availabilityZone) {
                this.availabilityZone = availabilityZone;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PlacementTypeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PlacementTypeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PlacementTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PlacementTypeProperty {
            private final java.lang.String availabilityZone;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.availabilityZone = software.amazon.jsii.Kernel.get(this, "availabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.availabilityZone = java.util.Objects.requireNonNull(builder.availabilityZone, "availabilityZone is required");
            }

            @Override
            public final java.lang.String getAvailabilityZone() {
                return this.availabilityZone;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_emr.CfnCluster.PlacementTypeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PlacementTypeProperty.Jsii$Proxy that = (PlacementTypeProperty.Jsii$Proxy) o;

                return this.availabilityZone.equals(that.availabilityZone);
            }

            @Override
            public final int hashCode() {
                int result = this.availabilityZone.hashCode();
                return result;
            }
        }
    }
    /**
     * `ScalingAction` is a subproperty of the `ScalingRule` property type.
     * <p>
     * <code>ScalingAction</code> determines the type of adjustment the automatic scaling activity makes when triggered, and the periodicity of the adjustment.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emr.*;
     * ScalingActionProperty scalingActionProperty = ScalingActionProperty.builder()
     *         .simpleScalingPolicyConfiguration(SimpleScalingPolicyConfigurationProperty.builder()
     *                 .scalingAdjustment(123)
     *                 // the properties below are optional
     *                 .adjustmentType("adjustmentType")
     *                 .coolDown(123)
     *                 .build())
     *         // the properties below are optional
     *         .market("market")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_emr.CfnCluster.ScalingActionProperty")
    @software.amazon.jsii.Jsii.Proxy(ScalingActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ScalingActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of adjustment the automatic scaling activity makes when triggered, and the periodicity of the adjustment.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getSimpleScalingPolicyConfiguration();

        /**
         * Not available for instance groups.
         * <p>
         * Instance groups use the market type specified for the group.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMarket() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ScalingActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScalingActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ScalingActionProperty> {
            java.lang.Object simpleScalingPolicyConfiguration;
            java.lang.String market;

            /**
             * Sets the value of {@link ScalingActionProperty#getSimpleScalingPolicyConfiguration}
             * @param simpleScalingPolicyConfiguration The type of adjustment the automatic scaling activity makes when triggered, and the periodicity of the adjustment. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder simpleScalingPolicyConfiguration(software.amazon.awscdk.services.emr.CfnCluster.SimpleScalingPolicyConfigurationProperty simpleScalingPolicyConfiguration) {
                this.simpleScalingPolicyConfiguration = simpleScalingPolicyConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ScalingActionProperty#getSimpleScalingPolicyConfiguration}
             * @param simpleScalingPolicyConfiguration The type of adjustment the automatic scaling activity makes when triggered, and the periodicity of the adjustment. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder simpleScalingPolicyConfiguration(software.amazon.awscdk.core.IResolvable simpleScalingPolicyConfiguration) {
                this.simpleScalingPolicyConfiguration = simpleScalingPolicyConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ScalingActionProperty#getMarket}
             * @param market Not available for instance groups.
             *               Instance groups use the market type specified for the group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder market(java.lang.String market) {
                this.market = market;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScalingActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ScalingActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ScalingActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScalingActionProperty {
            private final java.lang.Object simpleScalingPolicyConfiguration;
            private final java.lang.String market;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.simpleScalingPolicyConfiguration = software.amazon.jsii.Kernel.get(this, "simpleScalingPolicyConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.market = software.amazon.jsii.Kernel.get(this, "market", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.simpleScalingPolicyConfiguration = java.util.Objects.requireNonNull(builder.simpleScalingPolicyConfiguration, "simpleScalingPolicyConfiguration is required");
                this.market = builder.market;
            }

            @Override
            public final java.lang.Object getSimpleScalingPolicyConfiguration() {
                return this.simpleScalingPolicyConfiguration;
            }

            @Override
            public final java.lang.String getMarket() {
                return this.market;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("simpleScalingPolicyConfiguration", om.valueToTree(this.getSimpleScalingPolicyConfiguration()));
                if (this.getMarket() != null) {
                    data.set("market", om.valueToTree(this.getMarket()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_emr.CfnCluster.ScalingActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScalingActionProperty.Jsii$Proxy that = (ScalingActionProperty.Jsii$Proxy) o;

                if (!simpleScalingPolicyConfiguration.equals(that.simpleScalingPolicyConfiguration)) return false;
                return this.market != null ? this.market.equals(that.market) : that.market == null;
            }

            @Override
            public final int hashCode() {
                int result = this.simpleScalingPolicyConfiguration.hashCode();
                result = 31 * result + (this.market != null ? this.market.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * `ScalingConstraints` is a subproperty of the `AutoScalingPolicy` property type.
     * <p>
     * <code>ScalingConstraints</code> defines the upper and lower EC2 instance limits for an automatic scaling policy. Automatic scaling activities triggered by automatic scaling rules will not cause an instance group to grow above or shrink below these limits.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emr.*;
     * ScalingConstraintsProperty scalingConstraintsProperty = ScalingConstraintsProperty.builder()
     *         .maxCapacity(123)
     *         .minCapacity(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_emr.CfnCluster.ScalingConstraintsProperty")
    @software.amazon.jsii.Jsii.Proxy(ScalingConstraintsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ScalingConstraintsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The upper boundary of EC2 instances in an instance group beyond which scaling activities are not allowed to grow.
         * <p>
         * Scale-out activities will not add instances beyond this boundary.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMaxCapacity();

        /**
         * The lower boundary of EC2 instances in an instance group below which scaling activities are not allowed to shrink.
         * <p>
         * Scale-in activities will not terminate instances below this boundary.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMinCapacity();

        /**
         * @return a {@link Builder} of {@link ScalingConstraintsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScalingConstraintsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ScalingConstraintsProperty> {
            java.lang.Number maxCapacity;
            java.lang.Number minCapacity;

            /**
             * Sets the value of {@link ScalingConstraintsProperty#getMaxCapacity}
             * @param maxCapacity The upper boundary of EC2 instances in an instance group beyond which scaling activities are not allowed to grow. This parameter is required.
             *                    Scale-out activities will not add instances beyond this boundary.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxCapacity(java.lang.Number maxCapacity) {
                this.maxCapacity = maxCapacity;
                return this;
            }

            /**
             * Sets the value of {@link ScalingConstraintsProperty#getMinCapacity}
             * @param minCapacity The lower boundary of EC2 instances in an instance group below which scaling activities are not allowed to shrink. This parameter is required.
             *                    Scale-in activities will not terminate instances below this boundary.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minCapacity(java.lang.Number minCapacity) {
                this.minCapacity = minCapacity;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScalingConstraintsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ScalingConstraintsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ScalingConstraintsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScalingConstraintsProperty {
            private final java.lang.Number maxCapacity;
            private final java.lang.Number minCapacity;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxCapacity = software.amazon.jsii.Kernel.get(this, "maxCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.minCapacity = software.amazon.jsii.Kernel.get(this, "minCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxCapacity = java.util.Objects.requireNonNull(builder.maxCapacity, "maxCapacity is required");
                this.minCapacity = java.util.Objects.requireNonNull(builder.minCapacity, "minCapacity is required");
            }

            @Override
            public final java.lang.Number getMaxCapacity() {
                return this.maxCapacity;
            }

            @Override
            public final java.lang.Number getMinCapacity() {
                return this.minCapacity;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("maxCapacity", om.valueToTree(this.getMaxCapacity()));
                data.set("minCapacity", om.valueToTree(this.getMinCapacity()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_emr.CfnCluster.ScalingConstraintsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScalingConstraintsProperty.Jsii$Proxy that = (ScalingConstraintsProperty.Jsii$Proxy) o;

                if (!maxCapacity.equals(that.maxCapacity)) return false;
                return this.minCapacity.equals(that.minCapacity);
            }

            @Override
            public final int hashCode() {
                int result = this.maxCapacity.hashCode();
                result = 31 * result + (this.minCapacity.hashCode());
                return result;
            }
        }
    }
    /**
     * `ScalingRule` is a subproperty of the `AutoScalingPolicy` property type.
     * <p>
     * <code>ScalingRule</code> defines the scale-in or scale-out rules for scaling activity, including the CloudWatch metric alarm that triggers activity, how EC2 instances are added or removed, and the periodicity of adjustments. The automatic scaling policy for an instance group can comprise one or more automatic scaling rules.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emr.*;
     * ScalingRuleProperty scalingRuleProperty = ScalingRuleProperty.builder()
     *         .action(ScalingActionProperty.builder()
     *                 .simpleScalingPolicyConfiguration(SimpleScalingPolicyConfigurationProperty.builder()
     *                         .scalingAdjustment(123)
     *                         // the properties below are optional
     *                         .adjustmentType("adjustmentType")
     *                         .coolDown(123)
     *                         .build())
     *                 // the properties below are optional
     *                 .market("market")
     *                 .build())
     *         .name("name")
     *         .trigger(ScalingTriggerProperty.builder()
     *                 .cloudWatchAlarmDefinition(CloudWatchAlarmDefinitionProperty.builder()
     *                         .comparisonOperator("comparisonOperator")
     *                         .metricName("metricName")
     *                         .period(123)
     *                         .threshold(123)
     *                         // the properties below are optional
     *                         .dimensions(List.of(MetricDimensionProperty.builder()
     *                                 .key("key")
     *                                 .value("value")
     *                                 .build()))
     *                         .evaluationPeriods(123)
     *                         .namespace("namespace")
     *                         .statistic("statistic")
     *                         .unit("unit")
     *                         .build())
     *                 .build())
     *         // the properties below are optional
     *         .description("description")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_emr.CfnCluster.ScalingRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(ScalingRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ScalingRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The conditions that trigger an automatic scaling activity.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getAction();

        /**
         * The name used to identify an automatic scaling rule.
         * <p>
         * Rule names must be unique within a scaling policy.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The CloudWatch alarm definition that determines when automatic scaling activity is triggered.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getTrigger();

        /**
         * A friendly, more verbose description of the automatic scaling rule.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ScalingRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScalingRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ScalingRuleProperty> {
            java.lang.Object action;
            java.lang.String name;
            java.lang.Object trigger;
            java.lang.String description;

            /**
             * Sets the value of {@link ScalingRuleProperty#getAction}
             * @param action The conditions that trigger an automatic scaling activity. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder action(software.amazon.awscdk.services.emr.CfnCluster.ScalingActionProperty action) {
                this.action = action;
                return this;
            }

            /**
             * Sets the value of {@link ScalingRuleProperty#getAction}
             * @param action The conditions that trigger an automatic scaling activity. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder action(software.amazon.awscdk.core.IResolvable action) {
                this.action = action;
                return this;
            }

            /**
             * Sets the value of {@link ScalingRuleProperty#getName}
             * @param name The name used to identify an automatic scaling rule. This parameter is required.
             *             Rule names must be unique within a scaling policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link ScalingRuleProperty#getTrigger}
             * @param trigger The CloudWatch alarm definition that determines when automatic scaling activity is triggered. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder trigger(software.amazon.awscdk.services.emr.CfnCluster.ScalingTriggerProperty trigger) {
                this.trigger = trigger;
                return this;
            }

            /**
             * Sets the value of {@link ScalingRuleProperty#getTrigger}
             * @param trigger The CloudWatch alarm definition that determines when automatic scaling activity is triggered. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder trigger(software.amazon.awscdk.core.IResolvable trigger) {
                this.trigger = trigger;
                return this;
            }

            /**
             * Sets the value of {@link ScalingRuleProperty#getDescription}
             * @param description A friendly, more verbose description of the automatic scaling rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScalingRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ScalingRuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ScalingRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScalingRuleProperty {
            private final java.lang.Object action;
            private final java.lang.String name;
            private final java.lang.Object trigger;
            private final java.lang.String description;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.action = software.amazon.jsii.Kernel.get(this, "action", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.trigger = software.amazon.jsii.Kernel.get(this, "trigger", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.action = java.util.Objects.requireNonNull(builder.action, "action is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.trigger = java.util.Objects.requireNonNull(builder.trigger, "trigger is required");
                this.description = builder.description;
            }

            @Override
            public final java.lang.Object getAction() {
                return this.action;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getTrigger() {
                return this.trigger;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("action", om.valueToTree(this.getAction()));
                data.set("name", om.valueToTree(this.getName()));
                data.set("trigger", om.valueToTree(this.getTrigger()));
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_emr.CfnCluster.ScalingRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScalingRuleProperty.Jsii$Proxy that = (ScalingRuleProperty.Jsii$Proxy) o;

                if (!action.equals(that.action)) return false;
                if (!name.equals(that.name)) return false;
                if (!trigger.equals(that.trigger)) return false;
                return this.description != null ? this.description.equals(that.description) : that.description == null;
            }

            @Override
            public final int hashCode() {
                int result = this.action.hashCode();
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.trigger.hashCode());
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * `ScalingTrigger` is a subproperty of the `ScalingRule` property type.
     * <p>
     * <code>ScalingTrigger</code> determines the conditions that trigger an automatic scaling activity.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emr.*;
     * ScalingTriggerProperty scalingTriggerProperty = ScalingTriggerProperty.builder()
     *         .cloudWatchAlarmDefinition(CloudWatchAlarmDefinitionProperty.builder()
     *                 .comparisonOperator("comparisonOperator")
     *                 .metricName("metricName")
     *                 .period(123)
     *                 .threshold(123)
     *                 // the properties below are optional
     *                 .dimensions(List.of(MetricDimensionProperty.builder()
     *                         .key("key")
     *                         .value("value")
     *                         .build()))
     *                 .evaluationPeriods(123)
     *                 .namespace("namespace")
     *                 .statistic("statistic")
     *                 .unit("unit")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_emr.CfnCluster.ScalingTriggerProperty")
    @software.amazon.jsii.Jsii.Proxy(ScalingTriggerProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ScalingTriggerProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The definition of a CloudWatch metric alarm.
         * <p>
         * When the defined alarm conditions are met along with other trigger parameters, scaling activity begins.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getCloudWatchAlarmDefinition();

        /**
         * @return a {@link Builder} of {@link ScalingTriggerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScalingTriggerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ScalingTriggerProperty> {
            java.lang.Object cloudWatchAlarmDefinition;

            /**
             * Sets the value of {@link ScalingTriggerProperty#getCloudWatchAlarmDefinition}
             * @param cloudWatchAlarmDefinition The definition of a CloudWatch metric alarm. This parameter is required.
             *                                  When the defined alarm conditions are met along with other trigger parameters, scaling activity begins.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchAlarmDefinition(software.amazon.awscdk.services.emr.CfnCluster.CloudWatchAlarmDefinitionProperty cloudWatchAlarmDefinition) {
                this.cloudWatchAlarmDefinition = cloudWatchAlarmDefinition;
                return this;
            }

            /**
             * Sets the value of {@link ScalingTriggerProperty#getCloudWatchAlarmDefinition}
             * @param cloudWatchAlarmDefinition The definition of a CloudWatch metric alarm. This parameter is required.
             *                                  When the defined alarm conditions are met along with other trigger parameters, scaling activity begins.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchAlarmDefinition(software.amazon.awscdk.core.IResolvable cloudWatchAlarmDefinition) {
                this.cloudWatchAlarmDefinition = cloudWatchAlarmDefinition;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScalingTriggerProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ScalingTriggerProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ScalingTriggerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScalingTriggerProperty {
            private final java.lang.Object cloudWatchAlarmDefinition;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cloudWatchAlarmDefinition = software.amazon.jsii.Kernel.get(this, "cloudWatchAlarmDefinition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cloudWatchAlarmDefinition = java.util.Objects.requireNonNull(builder.cloudWatchAlarmDefinition, "cloudWatchAlarmDefinition is required");
            }

            @Override
            public final java.lang.Object getCloudWatchAlarmDefinition() {
                return this.cloudWatchAlarmDefinition;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("cloudWatchAlarmDefinition", om.valueToTree(this.getCloudWatchAlarmDefinition()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_emr.CfnCluster.ScalingTriggerProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScalingTriggerProperty.Jsii$Proxy that = (ScalingTriggerProperty.Jsii$Proxy) o;

                return this.cloudWatchAlarmDefinition.equals(that.cloudWatchAlarmDefinition);
            }

            @Override
            public final int hashCode() {
                int result = this.cloudWatchAlarmDefinition.hashCode();
                return result;
            }
        }
    }
    /**
     * `ScriptBootstrapActionConfig` is a subproperty of the `BootstrapActionConfig` property type.
     * <p>
     * <code>ScriptBootstrapActionConfig</code> specifies the arguments and location of the bootstrap script for EMR to run on all cluster nodes before it installs open-source big data applications on them.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emr.*;
     * ScriptBootstrapActionConfigProperty scriptBootstrapActionConfigProperty = ScriptBootstrapActionConfigProperty.builder()
     *         .path("path")
     *         // the properties below are optional
     *         .args(List.of("args"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_emr.CfnCluster.ScriptBootstrapActionConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ScriptBootstrapActionConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ScriptBootstrapActionConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Location in Amazon S3 of the script to run during a bootstrap action.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPath();

        /**
         * A list of command line arguments to pass to the bootstrap action script.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getArgs() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ScriptBootstrapActionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScriptBootstrapActionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ScriptBootstrapActionConfigProperty> {
            java.lang.String path;
            java.util.List<java.lang.String> args;

            /**
             * Sets the value of {@link ScriptBootstrapActionConfigProperty#getPath}
             * @param path Location in Amazon S3 of the script to run during a bootstrap action. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder path(java.lang.String path) {
                this.path = path;
                return this;
            }

            /**
             * Sets the value of {@link ScriptBootstrapActionConfigProperty#getArgs}
             * @param args A list of command line arguments to pass to the bootstrap action script.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder args(java.util.List<java.lang.String> args) {
                this.args = args;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScriptBootstrapActionConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ScriptBootstrapActionConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ScriptBootstrapActionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScriptBootstrapActionConfigProperty {
            private final java.lang.String path;
            private final java.util.List<java.lang.String> args;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.path = software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.args = software.amazon.jsii.Kernel.get(this, "args", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.path = java.util.Objects.requireNonNull(builder.path, "path is required");
                this.args = builder.args;
            }

            @Override
            public final java.lang.String getPath() {
                return this.path;
            }

            @Override
            public final java.util.List<java.lang.String> getArgs() {
                return this.args;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("path", om.valueToTree(this.getPath()));
                if (this.getArgs() != null) {
                    data.set("args", om.valueToTree(this.getArgs()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_emr.CfnCluster.ScriptBootstrapActionConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScriptBootstrapActionConfigProperty.Jsii$Proxy that = (ScriptBootstrapActionConfigProperty.Jsii$Proxy) o;

                if (!path.equals(that.path)) return false;
                return this.args != null ? this.args.equals(that.args) : that.args == null;
            }

            @Override
            public final int hashCode() {
                int result = this.path.hashCode();
                result = 31 * result + (this.args != null ? this.args.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * `SimpleScalingPolicyConfiguration` is a subproperty of the `ScalingAction` property type.
     * <p>
     * <code>SimpleScalingPolicyConfiguration</code> determines how an automatic scaling action adds or removes instances, the cooldown period, and the number of EC2 instances that are added each time the CloudWatch metric alarm condition is satisfied.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emr.*;
     * SimpleScalingPolicyConfigurationProperty simpleScalingPolicyConfigurationProperty = SimpleScalingPolicyConfigurationProperty.builder()
     *         .scalingAdjustment(123)
     *         // the properties below are optional
     *         .adjustmentType("adjustmentType")
     *         .coolDown(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_emr.CfnCluster.SimpleScalingPolicyConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(SimpleScalingPolicyConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SimpleScalingPolicyConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The amount by which to scale in or scale out, based on the specified `AdjustmentType` .
         * <p>
         * A positive value adds to the instance group's EC2 instance count while a negative number removes instances. If <code>AdjustmentType</code> is set to <code>EXACT_CAPACITY</code> , the number should only be a positive integer. If <code>AdjustmentType</code> is set to <code>PERCENT_CHANGE_IN_CAPACITY</code> , the value should express the percentage as an integer. For example, -20 indicates a decrease in 20% increments of cluster capacity.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getScalingAdjustment();

        /**
         * The way in which EC2 instances are added (if `ScalingAdjustment` is a positive number) or terminated (if `ScalingAdjustment` is a negative number) each time the scaling activity is triggered.
         * <p>
         * <code>CHANGE_IN_CAPACITY</code> is the default. <code>CHANGE_IN_CAPACITY</code> indicates that the EC2 instance count increments or decrements by <code>ScalingAdjustment</code> , which should be expressed as an integer. <code>PERCENT_CHANGE_IN_CAPACITY</code> indicates the instance count increments or decrements by the percentage specified by <code>ScalingAdjustment</code> , which should be expressed as an integer. For example, 20 indicates an increase in 20% increments of cluster capacity. <code>EXACT_CAPACITY</code> indicates the scaling activity results in an instance group with the number of EC2 instances specified by <code>ScalingAdjustment</code> , which should be expressed as a positive integer.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAdjustmentType() {
            return null;
        }

        /**
         * The amount of time, in seconds, after a scaling activity completes before any further trigger-related scaling activities can start.
         * <p>
         * The default value is 0.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getCoolDown() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SimpleScalingPolicyConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SimpleScalingPolicyConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SimpleScalingPolicyConfigurationProperty> {
            java.lang.Number scalingAdjustment;
            java.lang.String adjustmentType;
            java.lang.Number coolDown;

            /**
             * Sets the value of {@link SimpleScalingPolicyConfigurationProperty#getScalingAdjustment}
             * @param scalingAdjustment The amount by which to scale in or scale out, based on the specified `AdjustmentType` . This parameter is required.
             *                          A positive value adds to the instance group's EC2 instance count while a negative number removes instances. If <code>AdjustmentType</code> is set to <code>EXACT_CAPACITY</code> , the number should only be a positive integer. If <code>AdjustmentType</code> is set to <code>PERCENT_CHANGE_IN_CAPACITY</code> , the value should express the percentage as an integer. For example, -20 indicates a decrease in 20% increments of cluster capacity.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scalingAdjustment(java.lang.Number scalingAdjustment) {
                this.scalingAdjustment = scalingAdjustment;
                return this;
            }

            /**
             * Sets the value of {@link SimpleScalingPolicyConfigurationProperty#getAdjustmentType}
             * @param adjustmentType The way in which EC2 instances are added (if `ScalingAdjustment` is a positive number) or terminated (if `ScalingAdjustment` is a negative number) each time the scaling activity is triggered.
             *                       <code>CHANGE_IN_CAPACITY</code> is the default. <code>CHANGE_IN_CAPACITY</code> indicates that the EC2 instance count increments or decrements by <code>ScalingAdjustment</code> , which should be expressed as an integer. <code>PERCENT_CHANGE_IN_CAPACITY</code> indicates the instance count increments or decrements by the percentage specified by <code>ScalingAdjustment</code> , which should be expressed as an integer. For example, 20 indicates an increase in 20% increments of cluster capacity. <code>EXACT_CAPACITY</code> indicates the scaling activity results in an instance group with the number of EC2 instances specified by <code>ScalingAdjustment</code> , which should be expressed as a positive integer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder adjustmentType(java.lang.String adjustmentType) {
                this.adjustmentType = adjustmentType;
                return this;
            }

            /**
             * Sets the value of {@link SimpleScalingPolicyConfigurationProperty#getCoolDown}
             * @param coolDown The amount of time, in seconds, after a scaling activity completes before any further trigger-related scaling activities can start.
             *                 The default value is 0.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder coolDown(java.lang.Number coolDown) {
                this.coolDown = coolDown;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SimpleScalingPolicyConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SimpleScalingPolicyConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SimpleScalingPolicyConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SimpleScalingPolicyConfigurationProperty {
            private final java.lang.Number scalingAdjustment;
            private final java.lang.String adjustmentType;
            private final java.lang.Number coolDown;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.scalingAdjustment = software.amazon.jsii.Kernel.get(this, "scalingAdjustment", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.adjustmentType = software.amazon.jsii.Kernel.get(this, "adjustmentType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.coolDown = software.amazon.jsii.Kernel.get(this, "coolDown", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.scalingAdjustment = java.util.Objects.requireNonNull(builder.scalingAdjustment, "scalingAdjustment is required");
                this.adjustmentType = builder.adjustmentType;
                this.coolDown = builder.coolDown;
            }

            @Override
            public final java.lang.Number getScalingAdjustment() {
                return this.scalingAdjustment;
            }

            @Override
            public final java.lang.String getAdjustmentType() {
                return this.adjustmentType;
            }

            @Override
            public final java.lang.Number getCoolDown() {
                return this.coolDown;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("scalingAdjustment", om.valueToTree(this.getScalingAdjustment()));
                if (this.getAdjustmentType() != null) {
                    data.set("adjustmentType", om.valueToTree(this.getAdjustmentType()));
                }
                if (this.getCoolDown() != null) {
                    data.set("coolDown", om.valueToTree(this.getCoolDown()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_emr.CfnCluster.SimpleScalingPolicyConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SimpleScalingPolicyConfigurationProperty.Jsii$Proxy that = (SimpleScalingPolicyConfigurationProperty.Jsii$Proxy) o;

                if (!scalingAdjustment.equals(that.scalingAdjustment)) return false;
                if (this.adjustmentType != null ? !this.adjustmentType.equals(that.adjustmentType) : that.adjustmentType != null) return false;
                return this.coolDown != null ? this.coolDown.equals(that.coolDown) : that.coolDown == null;
            }

            @Override
            public final int hashCode() {
                int result = this.scalingAdjustment.hashCode();
                result = 31 * result + (this.adjustmentType != null ? this.adjustmentType.hashCode() : 0);
                result = 31 * result + (this.coolDown != null ? this.coolDown.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * `SpotProvisioningSpecification` is a subproperty of the `InstanceFleetProvisioningSpecifications` property type.
     * <p>
     * <code>SpotProvisioningSpecification</code> determines the launch specification for Spot instances in the instance fleet, which includes the defined duration and provisioning timeout behavior.
     * <p>
     * <blockquote>
     * <p>
     * The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x versions.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emr.*;
     * SpotProvisioningSpecificationProperty spotProvisioningSpecificationProperty = SpotProvisioningSpecificationProperty.builder()
     *         .timeoutAction("timeoutAction")
     *         .timeoutDurationMinutes(123)
     *         // the properties below are optional
     *         .allocationStrategy("allocationStrategy")
     *         .blockDurationMinutes(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_emr.CfnCluster.SpotProvisioningSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(SpotProvisioningSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SpotProvisioningSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The action to take when `TargetSpotCapacity` has not been fulfilled when the `TimeoutDurationMinutes` has expired;
         * <p>
         * that is, when all Spot Instances could not be provisioned within the Spot provisioning timeout. Valid values are <code>TERMINATE_CLUSTER</code> and <code>SWITCH_TO_ON_DEMAND</code> . SWITCH_TO_ON_DEMAND specifies that if no Spot Instances are available, On-Demand Instances should be provisioned to fulfill any remaining Spot capacity.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTimeoutAction();

        /**
         * The spot provisioning timeout period in minutes.
         * <p>
         * If Spot Instances are not provisioned within this time period, the <code>TimeOutAction</code> is taken. Minimum value is 5 and maximum value is 1440. The timeout applies only during initial provisioning, when the cluster is first created.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getTimeoutDurationMinutes();

        /**
         * Specifies the strategy to use in launching Spot Instance fleets.
         * <p>
         * Currently, the only option is capacity-optimized (the default), which launches instances from Spot Instance pools with optimal capacity for the number of instances that are launching.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAllocationStrategy() {
            return null;
        }

        /**
         * The defined duration for Spot Instances (also known as Spot blocks) in minutes.
         * <p>
         * When specified, the Spot Instance does not terminate before the defined duration expires, and defined duration pricing for Spot Instances applies. Valid values are 60, 120, 180, 240, 300, or 360. The duration period starts as soon as a Spot Instance receives its instance ID. At the end of the duration, Amazon EC2 marks the Spot Instance for termination and provides a Spot Instance termination notice, which gives the instance a two-minute warning before it terminates.
         * <p>
         * <blockquote>
         * <p>
         * Spot Instances with a defined duration (also known as Spot blocks) are no longer available to new customers from July 1, 2021. For customers who have previously used the feature, we will continue to support Spot Instances with a defined duration until December 31, 2022.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getBlockDurationMinutes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SpotProvisioningSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SpotProvisioningSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SpotProvisioningSpecificationProperty> {
            java.lang.String timeoutAction;
            java.lang.Number timeoutDurationMinutes;
            java.lang.String allocationStrategy;
            java.lang.Number blockDurationMinutes;

            /**
             * Sets the value of {@link SpotProvisioningSpecificationProperty#getTimeoutAction}
             * @param timeoutAction The action to take when `TargetSpotCapacity` has not been fulfilled when the `TimeoutDurationMinutes` has expired;. This parameter is required.
             *                      that is, when all Spot Instances could not be provisioned within the Spot provisioning timeout. Valid values are <code>TERMINATE_CLUSTER</code> and <code>SWITCH_TO_ON_DEMAND</code> . SWITCH_TO_ON_DEMAND specifies that if no Spot Instances are available, On-Demand Instances should be provisioned to fulfill any remaining Spot capacity.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeoutAction(java.lang.String timeoutAction) {
                this.timeoutAction = timeoutAction;
                return this;
            }

            /**
             * Sets the value of {@link SpotProvisioningSpecificationProperty#getTimeoutDurationMinutes}
             * @param timeoutDurationMinutes The spot provisioning timeout period in minutes. This parameter is required.
             *                               If Spot Instances are not provisioned within this time period, the <code>TimeOutAction</code> is taken. Minimum value is 5 and maximum value is 1440. The timeout applies only during initial provisioning, when the cluster is first created.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeoutDurationMinutes(java.lang.Number timeoutDurationMinutes) {
                this.timeoutDurationMinutes = timeoutDurationMinutes;
                return this;
            }

            /**
             * Sets the value of {@link SpotProvisioningSpecificationProperty#getAllocationStrategy}
             * @param allocationStrategy Specifies the strategy to use in launching Spot Instance fleets.
             *                           Currently, the only option is capacity-optimized (the default), which launches instances from Spot Instance pools with optimal capacity for the number of instances that are launching.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allocationStrategy(java.lang.String allocationStrategy) {
                this.allocationStrategy = allocationStrategy;
                return this;
            }

            /**
             * Sets the value of {@link SpotProvisioningSpecificationProperty#getBlockDurationMinutes}
             * @param blockDurationMinutes The defined duration for Spot Instances (also known as Spot blocks) in minutes.
             *                             When specified, the Spot Instance does not terminate before the defined duration expires, and defined duration pricing for Spot Instances applies. Valid values are 60, 120, 180, 240, 300, or 360. The duration period starts as soon as a Spot Instance receives its instance ID. At the end of the duration, Amazon EC2 marks the Spot Instance for termination and provides a Spot Instance termination notice, which gives the instance a two-minute warning before it terminates.
             *                             <p>
             *                             <blockquote>
             *                             <p>
             *                             Spot Instances with a defined duration (also known as Spot blocks) are no longer available to new customers from July 1, 2021. For customers who have previously used the feature, we will continue to support Spot Instances with a defined duration until December 31, 2022.
             *                             <p>
             *                             </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blockDurationMinutes(java.lang.Number blockDurationMinutes) {
                this.blockDurationMinutes = blockDurationMinutes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SpotProvisioningSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SpotProvisioningSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SpotProvisioningSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SpotProvisioningSpecificationProperty {
            private final java.lang.String timeoutAction;
            private final java.lang.Number timeoutDurationMinutes;
            private final java.lang.String allocationStrategy;
            private final java.lang.Number blockDurationMinutes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.timeoutAction = software.amazon.jsii.Kernel.get(this, "timeoutAction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.timeoutDurationMinutes = software.amazon.jsii.Kernel.get(this, "timeoutDurationMinutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.allocationStrategy = software.amazon.jsii.Kernel.get(this, "allocationStrategy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.blockDurationMinutes = software.amazon.jsii.Kernel.get(this, "blockDurationMinutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.timeoutAction = java.util.Objects.requireNonNull(builder.timeoutAction, "timeoutAction is required");
                this.timeoutDurationMinutes = java.util.Objects.requireNonNull(builder.timeoutDurationMinutes, "timeoutDurationMinutes is required");
                this.allocationStrategy = builder.allocationStrategy;
                this.blockDurationMinutes = builder.blockDurationMinutes;
            }

            @Override
            public final java.lang.String getTimeoutAction() {
                return this.timeoutAction;
            }

            @Override
            public final java.lang.Number getTimeoutDurationMinutes() {
                return this.timeoutDurationMinutes;
            }

            @Override
            public final java.lang.String getAllocationStrategy() {
                return this.allocationStrategy;
            }

            @Override
            public final java.lang.Number getBlockDurationMinutes() {
                return this.blockDurationMinutes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("timeoutAction", om.valueToTree(this.getTimeoutAction()));
                data.set("timeoutDurationMinutes", om.valueToTree(this.getTimeoutDurationMinutes()));
                if (this.getAllocationStrategy() != null) {
                    data.set("allocationStrategy", om.valueToTree(this.getAllocationStrategy()));
                }
                if (this.getBlockDurationMinutes() != null) {
                    data.set("blockDurationMinutes", om.valueToTree(this.getBlockDurationMinutes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_emr.CfnCluster.SpotProvisioningSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SpotProvisioningSpecificationProperty.Jsii$Proxy that = (SpotProvisioningSpecificationProperty.Jsii$Proxy) o;

                if (!timeoutAction.equals(that.timeoutAction)) return false;
                if (!timeoutDurationMinutes.equals(that.timeoutDurationMinutes)) return false;
                if (this.allocationStrategy != null ? !this.allocationStrategy.equals(that.allocationStrategy) : that.allocationStrategy != null) return false;
                return this.blockDurationMinutes != null ? this.blockDurationMinutes.equals(that.blockDurationMinutes) : that.blockDurationMinutes == null;
            }

            @Override
            public final int hashCode() {
                int result = this.timeoutAction.hashCode();
                result = 31 * result + (this.timeoutDurationMinutes.hashCode());
                result = 31 * result + (this.allocationStrategy != null ? this.allocationStrategy.hashCode() : 0);
                result = 31 * result + (this.blockDurationMinutes != null ? this.blockDurationMinutes.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * `StepConfig` is a property of the `AWS::EMR::Cluster` resource.
     * <p>
     * The <code>StepConfig</code> property type specifies a cluster (job flow) step, which runs only on the master node. Steps are used to submit data processing jobs to the cluster.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emr.*;
     * StepConfigProperty stepConfigProperty = StepConfigProperty.builder()
     *         .hadoopJarStep(HadoopJarStepConfigProperty.builder()
     *                 .jar("jar")
     *                 // the properties below are optional
     *                 .args(List.of("args"))
     *                 .mainClass("mainClass")
     *                 .stepProperties(List.of(KeyValueProperty.builder()
     *                         .key("key")
     *                         .value("value")
     *                         .build()))
     *                 .build())
     *         .name("name")
     *         // the properties below are optional
     *         .actionOnFailure("actionOnFailure")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_emr.CfnCluster.StepConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(StepConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StepConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The JAR file used for the step.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getHadoopJarStep();

        /**
         * The name of the step.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The action to take when the cluster step fails.
         * <p>
         * Possible values are <code>CANCEL_AND_WAIT</code> and <code>CONTINUE</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getActionOnFailure() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StepConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StepConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StepConfigProperty> {
            java.lang.Object hadoopJarStep;
            java.lang.String name;
            java.lang.String actionOnFailure;

            /**
             * Sets the value of {@link StepConfigProperty#getHadoopJarStep}
             * @param hadoopJarStep The JAR file used for the step. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hadoopJarStep(software.amazon.awscdk.services.emr.CfnCluster.HadoopJarStepConfigProperty hadoopJarStep) {
                this.hadoopJarStep = hadoopJarStep;
                return this;
            }

            /**
             * Sets the value of {@link StepConfigProperty#getHadoopJarStep}
             * @param hadoopJarStep The JAR file used for the step. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hadoopJarStep(software.amazon.awscdk.core.IResolvable hadoopJarStep) {
                this.hadoopJarStep = hadoopJarStep;
                return this;
            }

            /**
             * Sets the value of {@link StepConfigProperty#getName}
             * @param name The name of the step. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link StepConfigProperty#getActionOnFailure}
             * @param actionOnFailure The action to take when the cluster step fails.
             *                        Possible values are <code>CANCEL_AND_WAIT</code> and <code>CONTINUE</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actionOnFailure(java.lang.String actionOnFailure) {
                this.actionOnFailure = actionOnFailure;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StepConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StepConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StepConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StepConfigProperty {
            private final java.lang.Object hadoopJarStep;
            private final java.lang.String name;
            private final java.lang.String actionOnFailure;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.hadoopJarStep = software.amazon.jsii.Kernel.get(this, "hadoopJarStep", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.actionOnFailure = software.amazon.jsii.Kernel.get(this, "actionOnFailure", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.hadoopJarStep = java.util.Objects.requireNonNull(builder.hadoopJarStep, "hadoopJarStep is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.actionOnFailure = builder.actionOnFailure;
            }

            @Override
            public final java.lang.Object getHadoopJarStep() {
                return this.hadoopJarStep;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getActionOnFailure() {
                return this.actionOnFailure;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("hadoopJarStep", om.valueToTree(this.getHadoopJarStep()));
                data.set("name", om.valueToTree(this.getName()));
                if (this.getActionOnFailure() != null) {
                    data.set("actionOnFailure", om.valueToTree(this.getActionOnFailure()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_emr.CfnCluster.StepConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StepConfigProperty.Jsii$Proxy that = (StepConfigProperty.Jsii$Proxy) o;

                if (!hadoopJarStep.equals(that.hadoopJarStep)) return false;
                if (!name.equals(that.name)) return false;
                return this.actionOnFailure != null ? this.actionOnFailure.equals(that.actionOnFailure) : that.actionOnFailure == null;
            }

            @Override
            public final int hashCode() {
                int result = this.hadoopJarStep.hashCode();
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.actionOnFailure != null ? this.actionOnFailure.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * `VolumeSpecification` is a subproperty of the `EbsBlockDeviceConfig` property type.
     * <p>
     * <code>VolumeSecification</code> determines the volume type, IOPS, and size (GiB) for EBS volumes attached to EC2 instances.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emr.*;
     * VolumeSpecificationProperty volumeSpecificationProperty = VolumeSpecificationProperty.builder()
     *         .sizeInGb(123)
     *         .volumeType("volumeType")
     *         // the properties below are optional
     *         .iops(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_emr.CfnCluster.VolumeSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(VolumeSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VolumeSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The volume size, in gibibytes (GiB).
         * <p>
         * This can be a number from 1 - 1024. If the volume type is EBS-optimized, the minimum value is 10.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getSizeInGb();

        /**
         * The volume type.
         * <p>
         * Volume types supported are gp3, gp2, io1, st1, sc1, and standard.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getVolumeType();

        /**
         * The number of I/O operations per second (IOPS) that the volume supports.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getIops() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VolumeSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VolumeSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VolumeSpecificationProperty> {
            java.lang.Number sizeInGb;
            java.lang.String volumeType;
            java.lang.Number iops;

            /**
             * Sets the value of {@link VolumeSpecificationProperty#getSizeInGb}
             * @param sizeInGb The volume size, in gibibytes (GiB). This parameter is required.
             *                 This can be a number from 1 - 1024. If the volume type is EBS-optimized, the minimum value is 10.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sizeInGb(java.lang.Number sizeInGb) {
                this.sizeInGb = sizeInGb;
                return this;
            }

            /**
             * Sets the value of {@link VolumeSpecificationProperty#getVolumeType}
             * @param volumeType The volume type. This parameter is required.
             *                   Volume types supported are gp3, gp2, io1, st1, sc1, and standard.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumeType(java.lang.String volumeType) {
                this.volumeType = volumeType;
                return this;
            }

            /**
             * Sets the value of {@link VolumeSpecificationProperty#getIops}
             * @param iops The number of I/O operations per second (IOPS) that the volume supports.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iops(java.lang.Number iops) {
                this.iops = iops;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VolumeSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VolumeSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VolumeSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VolumeSpecificationProperty {
            private final java.lang.Number sizeInGb;
            private final java.lang.String volumeType;
            private final java.lang.Number iops;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.sizeInGb = software.amazon.jsii.Kernel.get(this, "sizeInGb", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.volumeType = software.amazon.jsii.Kernel.get(this, "volumeType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.iops = software.amazon.jsii.Kernel.get(this, "iops", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.sizeInGb = java.util.Objects.requireNonNull(builder.sizeInGb, "sizeInGb is required");
                this.volumeType = java.util.Objects.requireNonNull(builder.volumeType, "volumeType is required");
                this.iops = builder.iops;
            }

            @Override
            public final java.lang.Number getSizeInGb() {
                return this.sizeInGb;
            }

            @Override
            public final java.lang.String getVolumeType() {
                return this.volumeType;
            }

            @Override
            public final java.lang.Number getIops() {
                return this.iops;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("sizeInGb", om.valueToTree(this.getSizeInGb()));
                data.set("volumeType", om.valueToTree(this.getVolumeType()));
                if (this.getIops() != null) {
                    data.set("iops", om.valueToTree(this.getIops()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_emr.CfnCluster.VolumeSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VolumeSpecificationProperty.Jsii$Proxy that = (VolumeSpecificationProperty.Jsii$Proxy) o;

                if (!sizeInGb.equals(that.sizeInGb)) return false;
                if (!volumeType.equals(that.volumeType)) return false;
                return this.iops != null ? this.iops.equals(that.iops) : that.iops == null;
            }

            @Override
            public final int hashCode() {
                int result = this.sizeInGb.hashCode();
                result = 31 * result + (this.volumeType.hashCode());
                result = 31 * result + (this.iops != null ? this.iops.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.emr.CfnCluster}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.emr.CfnCluster> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.emr.CfnClusterProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.emr.CfnClusterProps.Builder();
        }

        /**
         * A specification of the number and type of Amazon EC2 instances.
         * <p>
         * @return {@code this}
         * @param instances A specification of the number and type of Amazon EC2 instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instances(final software.amazon.awscdk.services.emr.CfnCluster.JobFlowInstancesConfigProperty instances) {
            this.props.instances(instances);
            return this;
        }
        /**
         * A specification of the number and type of Amazon EC2 instances.
         * <p>
         * @return {@code this}
         * @param instances A specification of the number and type of Amazon EC2 instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instances(final software.amazon.awscdk.core.IResolvable instances) {
            this.props.instances(instances);
            return this;
        }

        /**
         * Also called instance profile and EC2 role.
         * <p>
         * An IAM role for an EMR cluster. The EC2 instances of the cluster assume this role. The default role is <code>EMR_EC2_DefaultRole</code> . In order to use the default role, you must have already created it using the CLI or console.
         * <p>
         * @return {@code this}
         * @param jobFlowRole Also called instance profile and EC2 role. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobFlowRole(final java.lang.String jobFlowRole) {
            this.props.jobFlowRole(jobFlowRole);
            return this;
        }

        /**
         * The name of the cluster.
         * <p>
         * @return {@code this}
         * @param name The name of the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The IAM role that Amazon EMR assumes in order to access AWS resources on your behalf.
         * <p>
         * @return {@code this}
         * @param serviceRole The IAM role that Amazon EMR assumes in order to access AWS resources on your behalf. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceRole(final java.lang.String serviceRole) {
            this.props.serviceRole(serviceRole);
            return this;
        }

        /**
         * A JSON string for selecting additional features.
         * <p>
         * @return {@code this}
         * @param additionalInfo A JSON string for selecting additional features. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder additionalInfo(final java.lang.Object additionalInfo) {
            this.props.additionalInfo(additionalInfo);
            return this;
        }

        /**
         * The applications to install on this cluster, for example, Spark, Flink, Oozie, Zeppelin, and so on.
         * <p>
         * @return {@code this}
         * @param applications The applications to install on this cluster, for example, Spark, Flink, Oozie, Zeppelin, and so on. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applications(final software.amazon.awscdk.core.IResolvable applications) {
            this.props.applications(applications);
            return this;
        }
        /**
         * The applications to install on this cluster, for example, Spark, Flink, Oozie, Zeppelin, and so on.
         * <p>
         * @return {@code this}
         * @param applications The applications to install on this cluster, for example, Spark, Flink, Oozie, Zeppelin, and so on. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applications(final java.util.List<? extends java.lang.Object> applications) {
            this.props.applications(applications);
            return this;
        }

        /**
         * An IAM role for automatic scaling policies.
         * <p>
         * The default role is <code>EMR_AutoScaling_DefaultRole</code> . The IAM role provides permissions that the automatic scaling feature requires to launch and terminate EC2 instances in an instance group.
         * <p>
         * @return {@code this}
         * @param autoScalingRole An IAM role for automatic scaling policies. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoScalingRole(final java.lang.String autoScalingRole) {
            this.props.autoScalingRole(autoScalingRole);
            return this;
        }

        /**
         * `AWS::EMR::Cluster.AutoTerminationPolicy`.
         * <p>
         * @return {@code this}
         * @param autoTerminationPolicy `AWS::EMR::Cluster.AutoTerminationPolicy`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoTerminationPolicy(final software.amazon.awscdk.services.emr.CfnCluster.AutoTerminationPolicyProperty autoTerminationPolicy) {
            this.props.autoTerminationPolicy(autoTerminationPolicy);
            return this;
        }
        /**
         * `AWS::EMR::Cluster.AutoTerminationPolicy`.
         * <p>
         * @return {@code this}
         * @param autoTerminationPolicy `AWS::EMR::Cluster.AutoTerminationPolicy`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoTerminationPolicy(final software.amazon.awscdk.core.IResolvable autoTerminationPolicy) {
            this.props.autoTerminationPolicy(autoTerminationPolicy);
            return this;
        }

        /**
         * A list of bootstrap actions to run before Hadoop starts on the cluster nodes.
         * <p>
         * @return {@code this}
         * @param bootstrapActions A list of bootstrap actions to run before Hadoop starts on the cluster nodes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bootstrapActions(final software.amazon.awscdk.core.IResolvable bootstrapActions) {
            this.props.bootstrapActions(bootstrapActions);
            return this;
        }
        /**
         * A list of bootstrap actions to run before Hadoop starts on the cluster nodes.
         * <p>
         * @return {@code this}
         * @param bootstrapActions A list of bootstrap actions to run before Hadoop starts on the cluster nodes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bootstrapActions(final java.util.List<? extends java.lang.Object> bootstrapActions) {
            this.props.bootstrapActions(bootstrapActions);
            return this;
        }

        /**
         * Applies only to Amazon EMR releases 4.x and later. The list of Configurations supplied to the EMR cluster.
         * <p>
         * @return {@code this}
         * @param configurations Applies only to Amazon EMR releases 4.x and later. The list of Configurations supplied to the EMR cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configurations(final software.amazon.awscdk.core.IResolvable configurations) {
            this.props.configurations(configurations);
            return this;
        }
        /**
         * Applies only to Amazon EMR releases 4.x and later. The list of Configurations supplied to the EMR cluster.
         * <p>
         * @return {@code this}
         * @param configurations Applies only to Amazon EMR releases 4.x and later. The list of Configurations supplied to the EMR cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configurations(final java.util.List<? extends java.lang.Object> configurations) {
            this.props.configurations(configurations);
            return this;
        }

        /**
         * Available only in Amazon EMR version 5.7.0 and later. The ID of a custom Amazon EBS-backed Linux AMI if the cluster uses a custom AMI.
         * <p>
         * @return {@code this}
         * @param customAmiId Available only in Amazon EMR version 5.7.0 and later. The ID of a custom Amazon EBS-backed Linux AMI if the cluster uses a custom AMI. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customAmiId(final java.lang.String customAmiId) {
            this.props.customAmiId(customAmiId);
            return this;
        }

        /**
         * The size, in GiB, of the Amazon EBS root device volume of the Linux AMI that is used for each EC2 instance.
         * <p>
         * Available in Amazon EMR version 4.x and later.
         * <p>
         * @return {@code this}
         * @param ebsRootVolumeSize The size, in GiB, of the Amazon EBS root device volume of the Linux AMI that is used for each EC2 instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ebsRootVolumeSize(final java.lang.Number ebsRootVolumeSize) {
            this.props.ebsRootVolumeSize(ebsRootVolumeSize);
            return this;
        }

        /**
         * Attributes for Kerberos configuration when Kerberos authentication is enabled using a security configuration.
         * <p>
         * For more information see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-kerberos.html">Use Kerberos Authentication</a> in the <em>Amazon EMR Management Guide</em> .
         * <p>
         * @return {@code this}
         * @param kerberosAttributes Attributes for Kerberos configuration when Kerberos authentication is enabled using a security configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kerberosAttributes(final software.amazon.awscdk.services.emr.CfnCluster.KerberosAttributesProperty kerberosAttributes) {
            this.props.kerberosAttributes(kerberosAttributes);
            return this;
        }
        /**
         * Attributes for Kerberos configuration when Kerberos authentication is enabled using a security configuration.
         * <p>
         * For more information see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-kerberos.html">Use Kerberos Authentication</a> in the <em>Amazon EMR Management Guide</em> .
         * <p>
         * @return {@code this}
         * @param kerberosAttributes Attributes for Kerberos configuration when Kerberos authentication is enabled using a security configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kerberosAttributes(final software.amazon.awscdk.core.IResolvable kerberosAttributes) {
            this.props.kerberosAttributes(kerberosAttributes);
            return this;
        }

        /**
         * The AWS KMS key used for encrypting log files.
         * <p>
         * This attribute is only available with EMR version 5.30.0 and later, excluding EMR 6.0.0.
         * <p>
         * @return {@code this}
         * @param logEncryptionKmsKeyId The AWS KMS key used for encrypting log files. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logEncryptionKmsKeyId(final java.lang.String logEncryptionKmsKeyId) {
            this.props.logEncryptionKmsKeyId(logEncryptionKmsKeyId);
            return this;
        }

        /**
         * The path to the Amazon S3 location where logs for this cluster are stored.
         * <p>
         * @return {@code this}
         * @param logUri The path to the Amazon S3 location where logs for this cluster are stored. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logUri(final java.lang.String logUri) {
            this.props.logUri(logUri);
            return this;
        }

        /**
         * Creates or updates a managed scaling policy for an Amazon EMR cluster.
         * <p>
         * The managed scaling policy defines the limits for resources, such as EC2 instances that can be added or terminated from a cluster. The policy only applies to the core and task nodes. The master node cannot be scaled after initial configuration.
         * <p>
         * @return {@code this}
         * @param managedScalingPolicy Creates or updates a managed scaling policy for an Amazon EMR cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder managedScalingPolicy(final software.amazon.awscdk.services.emr.CfnCluster.ManagedScalingPolicyProperty managedScalingPolicy) {
            this.props.managedScalingPolicy(managedScalingPolicy);
            return this;
        }
        /**
         * Creates or updates a managed scaling policy for an Amazon EMR cluster.
         * <p>
         * The managed scaling policy defines the limits for resources, such as EC2 instances that can be added or terminated from a cluster. The policy only applies to the core and task nodes. The master node cannot be scaled after initial configuration.
         * <p>
         * @return {@code this}
         * @param managedScalingPolicy Creates or updates a managed scaling policy for an Amazon EMR cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder managedScalingPolicy(final software.amazon.awscdk.core.IResolvable managedScalingPolicy) {
            this.props.managedScalingPolicy(managedScalingPolicy);
            return this;
        }

        /**
         * The Amazon Linux release specified in a cluster launch RunJobFlow request.
         * <p>
         * If no Amazon Linux release was specified, the default Amazon Linux release is shown in the response.
         * <p>
         * @return {@code this}
         * @param osReleaseLabel The Amazon Linux release specified in a cluster launch RunJobFlow request. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder osReleaseLabel(final java.lang.String osReleaseLabel) {
            this.props.osReleaseLabel(osReleaseLabel);
            return this;
        }

        /**
         * The Amazon EMR release label, which determines the version of open-source application packages installed on the cluster.
         * <p>
         * Release labels are in the form <code>emr-x.x.x</code> , where x.x.x is an Amazon EMR release version such as <code>emr-5.14.0</code> . For more information about Amazon EMR release versions and included application versions and features, see <a href="https://docs.aws.amazon.com/emr/latest/ReleaseGuide/"></a> . The release label applies only to Amazon EMR releases version 4.0 and later. Earlier versions use <code>AmiVersion</code> .
         * <p>
         * @return {@code this}
         * @param releaseLabel The Amazon EMR release label, which determines the version of open-source application packages installed on the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder releaseLabel(final java.lang.String releaseLabel) {
            this.props.releaseLabel(releaseLabel);
            return this;
        }

        /**
         * The way that individual Amazon EC2 instances terminate when an automatic scale-in activity occurs or an instance group is resized.
         * <p>
         * <code>TERMINATE_AT_INSTANCE_HOUR</code> indicates that Amazon EMR terminates nodes at the instance-hour boundary, regardless of when the request to terminate the instance was submitted. This option is only available with Amazon EMR 5.1.0 and later and is the default for clusters created using that version. <code>TERMINATE_AT_TASK_COMPLETION</code> indicates that Amazon EMR adds nodes to a deny list and drains tasks from nodes before terminating the Amazon EC2 instances, regardless of the instance-hour boundary. With either behavior, Amazon EMR removes the least active nodes first and blocks instance termination if it could lead to HDFS corruption. <code>TERMINATE_AT_TASK_COMPLETION</code> is available only in Amazon EMR version 4.1.0 and later, and is the default for versions of Amazon EMR earlier than 5.1.0.
         * <p>
         * @return {@code this}
         * @param scaleDownBehavior The way that individual Amazon EC2 instances terminate when an automatic scale-in activity occurs or an instance group is resized. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scaleDownBehavior(final java.lang.String scaleDownBehavior) {
            this.props.scaleDownBehavior(scaleDownBehavior);
            return this;
        }

        /**
         * The name of the security configuration applied to the cluster.
         * <p>
         * @return {@code this}
         * @param securityConfiguration The name of the security configuration applied to the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityConfiguration(final java.lang.String securityConfiguration) {
            this.props.securityConfiguration(securityConfiguration);
            return this;
        }

        /**
         * Specifies the number of steps that can be executed concurrently.
         * <p>
         * The default value is <code>1</code> . The maximum value is <code>256</code> .
         * <p>
         * @return {@code this}
         * @param stepConcurrencyLevel Specifies the number of steps that can be executed concurrently. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stepConcurrencyLevel(final java.lang.Number stepConcurrencyLevel) {
            this.props.stepConcurrencyLevel(stepConcurrencyLevel);
            return this;
        }

        /**
         * A list of steps to run.
         * <p>
         * @return {@code this}
         * @param steps A list of steps to run. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder steps(final software.amazon.awscdk.core.IResolvable steps) {
            this.props.steps(steps);
            return this;
        }
        /**
         * A list of steps to run.
         * <p>
         * @return {@code this}
         * @param steps A list of steps to run. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder steps(final java.util.List<? extends java.lang.Object> steps) {
            this.props.steps(steps);
            return this;
        }

        /**
         * A list of tags associated with a cluster.
         * <p>
         * @return {@code this}
         * @param tags A list of tags associated with a cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * Indicates whether the cluster is visible to all IAM users of the AWS account associated with the cluster.
         * <p>
         * If this value is set to <code>true</code> , all IAM users of that AWS account can view and manage the cluster if they have the proper policy permissions set. If this value is <code>false</code> , only the IAM user that created the cluster can view and manage it. This value can be changed using the SetVisibleToAllUsers action.
         * <p>
         * <blockquote>
         * <p>
         * When you create clusters directly through the EMR console or API, this value is set to <code>true</code> by default. However, for <code>AWS::EMR::Cluster</code> resources in CloudFormation, the default is <code>false</code> .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param visibleToAllUsers Indicates whether the cluster is visible to all IAM users of the AWS account associated with the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder visibleToAllUsers(final java.lang.Boolean visibleToAllUsers) {
            this.props.visibleToAllUsers(visibleToAllUsers);
            return this;
        }
        /**
         * Indicates whether the cluster is visible to all IAM users of the AWS account associated with the cluster.
         * <p>
         * If this value is set to <code>true</code> , all IAM users of that AWS account can view and manage the cluster if they have the proper policy permissions set. If this value is <code>false</code> , only the IAM user that created the cluster can view and manage it. This value can be changed using the SetVisibleToAllUsers action.
         * <p>
         * <blockquote>
         * <p>
         * When you create clusters directly through the EMR console or API, this value is set to <code>true</code> by default. However, for <code>AWS::EMR::Cluster</code> resources in CloudFormation, the default is <code>false</code> .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param visibleToAllUsers Indicates whether the cluster is visible to all IAM users of the AWS account associated with the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder visibleToAllUsers(final software.amazon.awscdk.core.IResolvable visibleToAllUsers) {
            this.props.visibleToAllUsers(visibleToAllUsers);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.emr.CfnCluster}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.emr.CfnCluster build() {
            return new software.amazon.awscdk.services.emr.CfnCluster(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
