package software.amazon.awscdk.services.emrserverless;

/**
 * A CloudFormation `AWS::EMRServerless::Application`.
 * <p>
 * The <code>AWS::EMRServerless::Application</code> resource specifies an EMR Serverless application. An application uses open source analytics frameworks to run jobs that process data. To create an application, you must specify the release version for the open source framework version you want to use and the type of application you want, such as Apache Spark or Apache Hive. After you create an application, you can submit data processing jobs or interactive requests to it.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.emrserverless.*;
 * CfnApplication cfnApplication = CfnApplication.Builder.create(this, "MyCfnApplication")
 *         .releaseLabel("releaseLabel")
 *         .type("type")
 *         // the properties below are optional
 *         .architecture("architecture")
 *         .autoStartConfiguration(AutoStartConfigurationProperty.builder()
 *                 .enabled(false)
 *                 .build())
 *         .autoStopConfiguration(AutoStopConfigurationProperty.builder()
 *                 .enabled(false)
 *                 .idleTimeoutMinutes(123)
 *                 .build())
 *         .initialCapacity(List.of(InitialCapacityConfigKeyValuePairProperty.builder()
 *                 .key("key")
 *                 .value(InitialCapacityConfigProperty.builder()
 *                         .workerConfiguration(WorkerConfigurationProperty.builder()
 *                                 .cpu("cpu")
 *                                 .memory("memory")
 *                                 // the properties below are optional
 *                                 .disk("disk")
 *                                 .build())
 *                         .workerCount(123)
 *                         .build())
 *                 .build()))
 *         .maximumCapacity(MaximumAllowedResourcesProperty.builder()
 *                 .cpu("cpu")
 *                 .memory("memory")
 *                 // the properties below are optional
 *                 .disk("disk")
 *                 .build())
 *         .name("name")
 *         .networkConfiguration(NetworkConfigurationProperty.builder()
 *                 .securityGroupIds(List.of("securityGroupIds"))
 *                 .subnetIds(List.of("subnetIds"))
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:01.725Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_emrserverless.CfnApplication")
public class CfnApplication extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnApplication(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnApplication(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.emrserverless.CfnApplication.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::EMRServerless::Application`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnApplication(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.emrserverless.CfnApplicationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ID of the application, such as `ab4rp1abcs8xz47n3x0example` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrApplicationId() {
        return software.amazon.jsii.Kernel.get(this, "attrApplicationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the project.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The tags assigned to the application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * The EMR release version associated with the application.
     * <p>
     * <em>Minimum</em> : 1
     * <p>
     * <em>Maximum</em> : 64
     * <p>
     * <em>Pattern</em> : <code>^[A-Za-z0-9._/-]+$</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getReleaseLabel() {
        return software.amazon.jsii.Kernel.get(this, "releaseLabel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The EMR release version associated with the application.
     * <p>
     * <em>Minimum</em> : 1
     * <p>
     * <em>Maximum</em> : 64
     * <p>
     * <em>Pattern</em> : <code>^[A-Za-z0-9._/-]+$</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReleaseLabel(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "releaseLabel", java.util.Objects.requireNonNull(value, "releaseLabel is required"));
    }

    /**
     * The type of application, such as Spark or Hive.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getType() {
        return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of application, such as Spark or Hive.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "type", java.util.Objects.requireNonNull(value, "type is required"));
    }

    /**
     * The CPU architecture type of the application.
     * <p>
     * Allowed values: <code>X86_64</code> or <code>ARM64</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getArchitecture() {
        return software.amazon.jsii.Kernel.get(this, "architecture", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The CPU architecture type of the application.
     * <p>
     * Allowed values: <code>X86_64</code> or <code>ARM64</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setArchitecture(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "architecture", value);
    }

    /**
     * The configuration for an application to automatically start on job submission.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAutoStartConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "autoStartConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration for an application to automatically start on job submission.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoStartConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.emrserverless.CfnApplication.AutoStartConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "autoStartConfiguration", value);
    }

    /**
     * The configuration for an application to automatically start on job submission.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoStartConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "autoStartConfiguration", value);
    }

    /**
     * The configuration for an application to automatically stop after a certain amount of time being idle.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAutoStopConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "autoStopConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration for an application to automatically stop after a certain amount of time being idle.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoStopConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.emrserverless.CfnApplication.AutoStopConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "autoStopConfiguration", value);
    }

    /**
     * The configuration for an application to automatically stop after a certain amount of time being idle.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoStopConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "autoStopConfiguration", value);
    }

    /**
     * The initial capacity of the application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getInitialCapacity() {
        return software.amazon.jsii.Kernel.get(this, "initialCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The initial capacity of the application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInitialCapacity(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "initialCapacity", value);
    }

    /**
     * The initial capacity of the application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInitialCapacity(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.emrserverless.CfnApplication.InitialCapacityConfigKeyValuePairProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.core.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.emrserverless.CfnApplication.InitialCapacityConfigKeyValuePairProperty, software.amazon.awscdk.core.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "initialCapacity", value);
    }

    /**
     * The maximum capacity of the application.
     * <p>
     * This is cumulative across all workers at any given point in time during the lifespan of the application is created. No new resources will be created once any one of the defined limits is hit.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMaximumCapacity() {
        return software.amazon.jsii.Kernel.get(this, "maximumCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The maximum capacity of the application.
     * <p>
     * This is cumulative across all workers at any given point in time during the lifespan of the application is created. No new resources will be created once any one of the defined limits is hit.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMaximumCapacity(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.emrserverless.CfnApplication.MaximumAllowedResourcesProperty value) {
        software.amazon.jsii.Kernel.set(this, "maximumCapacity", value);
    }

    /**
     * The maximum capacity of the application.
     * <p>
     * This is cumulative across all workers at any given point in time during the lifespan of the application is created. No new resources will be created once any one of the defined limits is hit.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMaximumCapacity(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "maximumCapacity", value);
    }

    /**
     * The name of the application.
     * <p>
     * <em>Minimum</em> : 1
     * <p>
     * <em>Maximum</em> : 64
     * <p>
     * <em>Pattern</em> : <code>^[A-Za-z0-9._\\/#-]+$</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the application.
     * <p>
     * <em>Minimum</em> : 1
     * <p>
     * <em>Maximum</em> : 64
     * <p>
     * <em>Pattern</em> : <code>^[A-Za-z0-9._\\/#-]+$</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * The network configuration for customer VPC connectivity for the application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getNetworkConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "networkConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The network configuration for customer VPC connectivity for the application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNetworkConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.emrserverless.CfnApplication.NetworkConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "networkConfiguration", value);
    }

    /**
     * The network configuration for customer VPC connectivity for the application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNetworkConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "networkConfiguration", value);
    }
    /**
     * The conﬁguration for an application to automatically start on job submission.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emrserverless.*;
     * AutoStartConfigurationProperty autoStartConfigurationProperty = AutoStartConfigurationProperty.builder()
     *         .enabled(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_emrserverless.CfnApplication.AutoStartConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(AutoStartConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AutoStartConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Enables the application to automatically start on job submission.
         * <p>
         * Defaults to true.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AutoStartConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AutoStartConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AutoStartConfigurationProperty> {
            java.lang.Object enabled;

            /**
             * Sets the value of {@link AutoStartConfigurationProperty#getEnabled}
             * @param enabled Enables the application to automatically start on job submission.
             *                Defaults to true.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link AutoStartConfigurationProperty#getEnabled}
             * @param enabled Enables the application to automatically start on job submission.
             *                Defaults to true.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.core.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AutoStartConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AutoStartConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AutoStartConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AutoStartConfigurationProperty {
            private final java.lang.Object enabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = builder.enabled;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_emrserverless.CfnApplication.AutoStartConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AutoStartConfigurationProperty.Jsii$Proxy that = (AutoStartConfigurationProperty.Jsii$Proxy) o;

                return this.enabled != null ? this.enabled.equals(that.enabled) : that.enabled == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled != null ? this.enabled.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The conﬁguration for an application to automatically stop after a certain amount of time being idle.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emrserverless.*;
     * AutoStopConfigurationProperty autoStopConfigurationProperty = AutoStopConfigurationProperty.builder()
     *         .enabled(false)
     *         .idleTimeoutMinutes(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_emrserverless.CfnApplication.AutoStopConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(AutoStopConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AutoStopConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Enables the application to automatically stop after a certain amount of time being idle.
         * <p>
         * Defaults to true.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * The amount of idle time in minutes after which your application will automatically stop. Defaults to 15 minutes.
         * <p>
         * <em>Minimum</em> : 1
         * <p>
         * <em>Maximum</em> : 10080
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getIdleTimeoutMinutes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AutoStopConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AutoStopConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AutoStopConfigurationProperty> {
            java.lang.Object enabled;
            java.lang.Number idleTimeoutMinutes;

            /**
             * Sets the value of {@link AutoStopConfigurationProperty#getEnabled}
             * @param enabled Enables the application to automatically stop after a certain amount of time being idle.
             *                Defaults to true.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link AutoStopConfigurationProperty#getEnabled}
             * @param enabled Enables the application to automatically stop after a certain amount of time being idle.
             *                Defaults to true.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.core.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link AutoStopConfigurationProperty#getIdleTimeoutMinutes}
             * @param idleTimeoutMinutes The amount of idle time in minutes after which your application will automatically stop. Defaults to 15 minutes.
             *                           <em>Minimum</em> : 1
             *                           <p>
             *                           <em>Maximum</em> : 10080
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder idleTimeoutMinutes(java.lang.Number idleTimeoutMinutes) {
                this.idleTimeoutMinutes = idleTimeoutMinutes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AutoStopConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AutoStopConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AutoStopConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AutoStopConfigurationProperty {
            private final java.lang.Object enabled;
            private final java.lang.Number idleTimeoutMinutes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.idleTimeoutMinutes = software.amazon.jsii.Kernel.get(this, "idleTimeoutMinutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = builder.enabled;
                this.idleTimeoutMinutes = builder.idleTimeoutMinutes;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.Number getIdleTimeoutMinutes() {
                return this.idleTimeoutMinutes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }
                if (this.getIdleTimeoutMinutes() != null) {
                    data.set("idleTimeoutMinutes", om.valueToTree(this.getIdleTimeoutMinutes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_emrserverless.CfnApplication.AutoStopConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AutoStopConfigurationProperty.Jsii$Proxy that = (AutoStopConfigurationProperty.Jsii$Proxy) o;

                if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
                return this.idleTimeoutMinutes != null ? this.idleTimeoutMinutes.equals(that.idleTimeoutMinutes) : that.idleTimeoutMinutes == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled != null ? this.enabled.hashCode() : 0;
                result = 31 * result + (this.idleTimeoutMinutes != null ? this.idleTimeoutMinutes.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The initial capacity configuration per worker.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emrserverless.*;
     * InitialCapacityConfigKeyValuePairProperty initialCapacityConfigKeyValuePairProperty = InitialCapacityConfigKeyValuePairProperty.builder()
     *         .key("key")
     *         .value(InitialCapacityConfigProperty.builder()
     *                 .workerConfiguration(WorkerConfigurationProperty.builder()
     *                         .cpu("cpu")
     *                         .memory("memory")
     *                         // the properties below are optional
     *                         .disk("disk")
     *                         .build())
     *                 .workerCount(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_emrserverless.CfnApplication.InitialCapacityConfigKeyValuePairProperty")
    @software.amazon.jsii.Jsii.Proxy(InitialCapacityConfigKeyValuePairProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InitialCapacityConfigKeyValuePairProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The worker type for an analytics framework.
         * <p>
         * For Spark applications, the key can either be set to <code>Driver</code> or <code>Executor</code> . For Hive applications, it can be set to <code>HiveDriver</code> or <code>TezTask</code> .
         * <p>
         * <em>Minimum</em> : 1
         * <p>
         * <em>Maximum</em> : 50
         * <p>
         * <em>Pattern</em> : <code>^[a-zA-Z]+[-_]*[a-zA-Z]+$</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * The value for the initial capacity configuration per worker.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getValue();

        /**
         * @return a {@link Builder} of {@link InitialCapacityConfigKeyValuePairProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InitialCapacityConfigKeyValuePairProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InitialCapacityConfigKeyValuePairProperty> {
            java.lang.String key;
            java.lang.Object value;

            /**
             * Sets the value of {@link InitialCapacityConfigKeyValuePairProperty#getKey}
             * @param key The worker type for an analytics framework. This parameter is required.
             *            For Spark applications, the key can either be set to <code>Driver</code> or <code>Executor</code> . For Hive applications, it can be set to <code>HiveDriver</code> or <code>TezTask</code> .
             *            <p>
             *            <em>Minimum</em> : 1
             *            <p>
             *            <em>Maximum</em> : 50
             *            <p>
             *            <em>Pattern</em> : <code>^[a-zA-Z]+[-_]*[a-zA-Z]+$</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link InitialCapacityConfigKeyValuePairProperty#getValue}
             * @param value The value for the initial capacity configuration per worker. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(software.amazon.awscdk.services.emrserverless.CfnApplication.InitialCapacityConfigProperty value) {
                this.value = value;
                return this;
            }

            /**
             * Sets the value of {@link InitialCapacityConfigKeyValuePairProperty#getValue}
             * @param value The value for the initial capacity configuration per worker. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(software.amazon.awscdk.core.IResolvable value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InitialCapacityConfigKeyValuePairProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InitialCapacityConfigKeyValuePairProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InitialCapacityConfigKeyValuePairProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InitialCapacityConfigKeyValuePairProperty {
            private final java.lang.String key;
            private final java.lang.Object value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.Object getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("key", om.valueToTree(this.getKey()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_emrserverless.CfnApplication.InitialCapacityConfigKeyValuePairProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InitialCapacityConfigKeyValuePairProperty.Jsii$Proxy that = (InitialCapacityConfigKeyValuePairProperty.Jsii$Proxy) o;

                if (!key.equals(that.key)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.key.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * The initial capacity configuration per worker.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emrserverless.*;
     * InitialCapacityConfigProperty initialCapacityConfigProperty = InitialCapacityConfigProperty.builder()
     *         .workerConfiguration(WorkerConfigurationProperty.builder()
     *                 .cpu("cpu")
     *                 .memory("memory")
     *                 // the properties below are optional
     *                 .disk("disk")
     *                 .build())
     *         .workerCount(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_emrserverless.CfnApplication.InitialCapacityConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(InitialCapacityConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InitialCapacityConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The resource configuration of the initial capacity configuration.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getWorkerConfiguration();

        /**
         * The number of workers in the initial capacity configuration.
         * <p>
         * <em>Minimum</em> : 1
         * <p>
         * <em>Maximum</em> : 1000000
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getWorkerCount();

        /**
         * @return a {@link Builder} of {@link InitialCapacityConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InitialCapacityConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InitialCapacityConfigProperty> {
            java.lang.Object workerConfiguration;
            java.lang.Number workerCount;

            /**
             * Sets the value of {@link InitialCapacityConfigProperty#getWorkerConfiguration}
             * @param workerConfiguration The resource configuration of the initial capacity configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder workerConfiguration(software.amazon.awscdk.services.emrserverless.CfnApplication.WorkerConfigurationProperty workerConfiguration) {
                this.workerConfiguration = workerConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link InitialCapacityConfigProperty#getWorkerConfiguration}
             * @param workerConfiguration The resource configuration of the initial capacity configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder workerConfiguration(software.amazon.awscdk.core.IResolvable workerConfiguration) {
                this.workerConfiguration = workerConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link InitialCapacityConfigProperty#getWorkerCount}
             * @param workerCount The number of workers in the initial capacity configuration. This parameter is required.
             *                    <em>Minimum</em> : 1
             *                    <p>
             *                    <em>Maximum</em> : 1000000
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder workerCount(java.lang.Number workerCount) {
                this.workerCount = workerCount;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InitialCapacityConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InitialCapacityConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InitialCapacityConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InitialCapacityConfigProperty {
            private final java.lang.Object workerConfiguration;
            private final java.lang.Number workerCount;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.workerConfiguration = software.amazon.jsii.Kernel.get(this, "workerConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.workerCount = software.amazon.jsii.Kernel.get(this, "workerCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.workerConfiguration = java.util.Objects.requireNonNull(builder.workerConfiguration, "workerConfiguration is required");
                this.workerCount = java.util.Objects.requireNonNull(builder.workerCount, "workerCount is required");
            }

            @Override
            public final java.lang.Object getWorkerConfiguration() {
                return this.workerConfiguration;
            }

            @Override
            public final java.lang.Number getWorkerCount() {
                return this.workerCount;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("workerConfiguration", om.valueToTree(this.getWorkerConfiguration()));
                data.set("workerCount", om.valueToTree(this.getWorkerCount()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_emrserverless.CfnApplication.InitialCapacityConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InitialCapacityConfigProperty.Jsii$Proxy that = (InitialCapacityConfigProperty.Jsii$Proxy) o;

                if (!workerConfiguration.equals(that.workerConfiguration)) return false;
                return this.workerCount.equals(that.workerCount);
            }

            @Override
            public final int hashCode() {
                int result = this.workerConfiguration.hashCode();
                result = 31 * result + (this.workerCount.hashCode());
                return result;
            }
        }
    }
    /**
     * The maximum allowed cumulative resources for an application.
     * <p>
     * No new resources will be created once the limit is hit.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emrserverless.*;
     * MaximumAllowedResourcesProperty maximumAllowedResourcesProperty = MaximumAllowedResourcesProperty.builder()
     *         .cpu("cpu")
     *         .memory("memory")
     *         // the properties below are optional
     *         .disk("disk")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_emrserverless.CfnApplication.MaximumAllowedResourcesProperty")
    @software.amazon.jsii.Jsii.Proxy(MaximumAllowedResourcesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MaximumAllowedResourcesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum allowed CPU for an application.
         * <p>
         * <em>Minimum</em> : 1
         * <p>
         * <em>Maximum</em> : 15
         * <p>
         * <em>Pattern</em> : <code>^[1-9][0-9]*(\\s)?(vCPU|vcpu|VCPU)?$</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCpu();

        /**
         * The maximum allowed resources for an application.
         * <p>
         * <em>Minimum</em> : 1
         * <p>
         * <em>Maximum</em> : 15
         * <p>
         * <em>Pattern</em> : <code>^[1-9][0-9]*(\\s)?(GB|gb|gB|Gb)?$</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMemory();

        /**
         * The maximum allowed disk for an application.
         * <p>
         * <em>Minimum</em> : 1
         * <p>
         * <em>Maximum</em> : 15
         * <p>
         * <em>Pattern</em> : <code>^[1-9][0-9]*(\\s)?(GB|gb|gB|Gb)$"</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDisk() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MaximumAllowedResourcesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MaximumAllowedResourcesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MaximumAllowedResourcesProperty> {
            java.lang.String cpu;
            java.lang.String memory;
            java.lang.String disk;

            /**
             * Sets the value of {@link MaximumAllowedResourcesProperty#getCpu}
             * @param cpu The maximum allowed CPU for an application. This parameter is required.
             *            <em>Minimum</em> : 1
             *            <p>
             *            <em>Maximum</em> : 15
             *            <p>
             *            <em>Pattern</em> : <code>^[1-9][0-9]*(\\s)?(vCPU|vcpu|VCPU)?$</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cpu(java.lang.String cpu) {
                this.cpu = cpu;
                return this;
            }

            /**
             * Sets the value of {@link MaximumAllowedResourcesProperty#getMemory}
             * @param memory The maximum allowed resources for an application. This parameter is required.
             *               <em>Minimum</em> : 1
             *               <p>
             *               <em>Maximum</em> : 15
             *               <p>
             *               <em>Pattern</em> : <code>^[1-9][0-9]*(\\s)?(GB|gb|gB|Gb)?$</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder memory(java.lang.String memory) {
                this.memory = memory;
                return this;
            }

            /**
             * Sets the value of {@link MaximumAllowedResourcesProperty#getDisk}
             * @param disk The maximum allowed disk for an application.
             *             <em>Minimum</em> : 1
             *             <p>
             *             <em>Maximum</em> : 15
             *             <p>
             *             <em>Pattern</em> : <code>^[1-9][0-9]*(\\s)?(GB|gb|gB|Gb)$"</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder disk(java.lang.String disk) {
                this.disk = disk;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MaximumAllowedResourcesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MaximumAllowedResourcesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MaximumAllowedResourcesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MaximumAllowedResourcesProperty {
            private final java.lang.String cpu;
            private final java.lang.String memory;
            private final java.lang.String disk;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cpu = software.amazon.jsii.Kernel.get(this, "cpu", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.memory = software.amazon.jsii.Kernel.get(this, "memory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.disk = software.amazon.jsii.Kernel.get(this, "disk", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cpu = java.util.Objects.requireNonNull(builder.cpu, "cpu is required");
                this.memory = java.util.Objects.requireNonNull(builder.memory, "memory is required");
                this.disk = builder.disk;
            }

            @Override
            public final java.lang.String getCpu() {
                return this.cpu;
            }

            @Override
            public final java.lang.String getMemory() {
                return this.memory;
            }

            @Override
            public final java.lang.String getDisk() {
                return this.disk;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("cpu", om.valueToTree(this.getCpu()));
                data.set("memory", om.valueToTree(this.getMemory()));
                if (this.getDisk() != null) {
                    data.set("disk", om.valueToTree(this.getDisk()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_emrserverless.CfnApplication.MaximumAllowedResourcesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MaximumAllowedResourcesProperty.Jsii$Proxy that = (MaximumAllowedResourcesProperty.Jsii$Proxy) o;

                if (!cpu.equals(that.cpu)) return false;
                if (!memory.equals(that.memory)) return false;
                return this.disk != null ? this.disk.equals(that.disk) : that.disk == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cpu.hashCode();
                result = 31 * result + (this.memory.hashCode());
                result = 31 * result + (this.disk != null ? this.disk.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The network configuration for customer VPC connectivity.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emrserverless.*;
     * NetworkConfigurationProperty networkConfigurationProperty = NetworkConfigurationProperty.builder()
     *         .securityGroupIds(List.of("securityGroupIds"))
     *         .subnetIds(List.of("subnetIds"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_emrserverless.CfnApplication.NetworkConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(NetworkConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NetworkConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The array of security group Ids for customer VPC connectivity.
         * <p>
         * <em>Minimum</em> : 1
         * <p>
         * <em>Maximum</em> : 32
         * <p>
         * <em>Pattern</em> : <code>^[-0-9a-zA-Z]+</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroupIds() {
            return null;
        }

        /**
         * The array of subnet Ids for customer VPC connectivity.
         * <p>
         * <em>Minimum</em> : 1
         * <p>
         * <em>Maximum</em> : 32
         * <p>
         * <em>Pattern</em> : <code>^[-0-9a-zA-Z]+</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSubnetIds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NetworkConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NetworkConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NetworkConfigurationProperty> {
            java.util.List<java.lang.String> securityGroupIds;
            java.util.List<java.lang.String> subnetIds;

            /**
             * Sets the value of {@link NetworkConfigurationProperty#getSecurityGroupIds}
             * @param securityGroupIds The array of security group Ids for customer VPC connectivity.
             *                         <em>Minimum</em> : 1
             *                         <p>
             *                         <em>Maximum</em> : 32
             *                         <p>
             *                         <em>Pattern</em> : <code>^[-0-9a-zA-Z]+</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroupIds(java.util.List<java.lang.String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            /**
             * Sets the value of {@link NetworkConfigurationProperty#getSubnetIds}
             * @param subnetIds The array of subnet Ids for customer VPC connectivity.
             *                  <em>Minimum</em> : 1
             *                  <p>
             *                  <em>Maximum</em> : 32
             *                  <p>
             *                  <em>Pattern</em> : <code>^[-0-9a-zA-Z]+</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subnetIds(java.util.List<java.lang.String> subnetIds) {
                this.subnetIds = subnetIds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NetworkConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NetworkConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NetworkConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NetworkConfigurationProperty {
            private final java.util.List<java.lang.String> securityGroupIds;
            private final java.util.List<java.lang.String> subnetIds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.securityGroupIds = software.amazon.jsii.Kernel.get(this, "securityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.subnetIds = software.amazon.jsii.Kernel.get(this, "subnetIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.securityGroupIds = builder.securityGroupIds;
                this.subnetIds = builder.subnetIds;
            }

            @Override
            public final java.util.List<java.lang.String> getSecurityGroupIds() {
                return this.securityGroupIds;
            }

            @Override
            public final java.util.List<java.lang.String> getSubnetIds() {
                return this.subnetIds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSecurityGroupIds() != null) {
                    data.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
                }
                if (this.getSubnetIds() != null) {
                    data.set("subnetIds", om.valueToTree(this.getSubnetIds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_emrserverless.CfnApplication.NetworkConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NetworkConfigurationProperty.Jsii$Proxy that = (NetworkConfigurationProperty.Jsii$Proxy) o;

                if (this.securityGroupIds != null ? !this.securityGroupIds.equals(that.securityGroupIds) : that.securityGroupIds != null) return false;
                return this.subnetIds != null ? this.subnetIds.equals(that.subnetIds) : that.subnetIds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.securityGroupIds != null ? this.securityGroupIds.hashCode() : 0;
                result = 31 * result + (this.subnetIds != null ? this.subnetIds.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The resource configuration of the initial capacity configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emrserverless.*;
     * WorkerConfigurationProperty workerConfigurationProperty = WorkerConfigurationProperty.builder()
     *         .cpu("cpu")
     *         .memory("memory")
     *         // the properties below are optional
     *         .disk("disk")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_emrserverless.CfnApplication.WorkerConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(WorkerConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface WorkerConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * *Minimum* : 1.
         * <p>
         * <em>Maximum</em> : 15
         * <p>
         * <em>Pattern</em> : <code>^[1-9][0-9]*(\\s)?(vCPU|vcpu|VCPU)?$</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCpu();

        /**
         * *Minimum* : 1.
         * <p>
         * <em>Maximum</em> : 15
         * <p>
         * <em>Pattern</em> : <code>^[1-9][0-9]*(\\s)?(GB|gb|gB|Gb)?$</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMemory();

        /**
         * *Minimum* : 1.
         * <p>
         * <em>Maximum</em> : 15
         * <p>
         * <em>Pattern</em> : <code>^[1-9][0-9]*(\\s)?(GB|gb|gB|Gb)$"</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDisk() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link WorkerConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link WorkerConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<WorkerConfigurationProperty> {
            java.lang.String cpu;
            java.lang.String memory;
            java.lang.String disk;

            /**
             * Sets the value of {@link WorkerConfigurationProperty#getCpu}
             * @param cpu *Minimum* : 1. This parameter is required.
             *            <em>Maximum</em> : 15
             *            <p>
             *            <em>Pattern</em> : <code>^[1-9][0-9]*(\\s)?(vCPU|vcpu|VCPU)?$</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cpu(java.lang.String cpu) {
                this.cpu = cpu;
                return this;
            }

            /**
             * Sets the value of {@link WorkerConfigurationProperty#getMemory}
             * @param memory *Minimum* : 1. This parameter is required.
             *               <em>Maximum</em> : 15
             *               <p>
             *               <em>Pattern</em> : <code>^[1-9][0-9]*(\\s)?(GB|gb|gB|Gb)?$</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder memory(java.lang.String memory) {
                this.memory = memory;
                return this;
            }

            /**
             * Sets the value of {@link WorkerConfigurationProperty#getDisk}
             * @param disk *Minimum* : 1.
             *             <em>Maximum</em> : 15
             *             <p>
             *             <em>Pattern</em> : <code>^[1-9][0-9]*(\\s)?(GB|gb|gB|Gb)$"</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder disk(java.lang.String disk) {
                this.disk = disk;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link WorkerConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public WorkerConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link WorkerConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WorkerConfigurationProperty {
            private final java.lang.String cpu;
            private final java.lang.String memory;
            private final java.lang.String disk;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cpu = software.amazon.jsii.Kernel.get(this, "cpu", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.memory = software.amazon.jsii.Kernel.get(this, "memory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.disk = software.amazon.jsii.Kernel.get(this, "disk", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cpu = java.util.Objects.requireNonNull(builder.cpu, "cpu is required");
                this.memory = java.util.Objects.requireNonNull(builder.memory, "memory is required");
                this.disk = builder.disk;
            }

            @Override
            public final java.lang.String getCpu() {
                return this.cpu;
            }

            @Override
            public final java.lang.String getMemory() {
                return this.memory;
            }

            @Override
            public final java.lang.String getDisk() {
                return this.disk;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("cpu", om.valueToTree(this.getCpu()));
                data.set("memory", om.valueToTree(this.getMemory()));
                if (this.getDisk() != null) {
                    data.set("disk", om.valueToTree(this.getDisk()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_emrserverless.CfnApplication.WorkerConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                WorkerConfigurationProperty.Jsii$Proxy that = (WorkerConfigurationProperty.Jsii$Proxy) o;

                if (!cpu.equals(that.cpu)) return false;
                if (!memory.equals(that.memory)) return false;
                return this.disk != null ? this.disk.equals(that.disk) : that.disk == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cpu.hashCode();
                result = 31 * result + (this.memory.hashCode());
                result = 31 * result + (this.disk != null ? this.disk.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.emrserverless.CfnApplication}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.emrserverless.CfnApplication> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.emrserverless.CfnApplicationProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.emrserverless.CfnApplicationProps.Builder();
        }

        /**
         * The EMR release version associated with the application.
         * <p>
         * <em>Minimum</em> : 1
         * <p>
         * <em>Maximum</em> : 64
         * <p>
         * <em>Pattern</em> : <code>^[A-Za-z0-9._/-]+$</code>
         * <p>
         * @return {@code this}
         * @param releaseLabel The EMR release version associated with the application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder releaseLabel(final java.lang.String releaseLabel) {
            this.props.releaseLabel(releaseLabel);
            return this;
        }

        /**
         * The type of application, such as Spark or Hive.
         * <p>
         * @return {@code this}
         * @param type The type of application, such as Spark or Hive. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(final java.lang.String type) {
            this.props.type(type);
            return this;
        }

        /**
         * The CPU architecture type of the application.
         * <p>
         * Allowed values: <code>X86_64</code> or <code>ARM64</code>
         * <p>
         * @return {@code this}
         * @param architecture The CPU architecture type of the application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder architecture(final java.lang.String architecture) {
            this.props.architecture(architecture);
            return this;
        }

        /**
         * The configuration for an application to automatically start on job submission.
         * <p>
         * @return {@code this}
         * @param autoStartConfiguration The configuration for an application to automatically start on job submission. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoStartConfiguration(final software.amazon.awscdk.services.emrserverless.CfnApplication.AutoStartConfigurationProperty autoStartConfiguration) {
            this.props.autoStartConfiguration(autoStartConfiguration);
            return this;
        }
        /**
         * The configuration for an application to automatically start on job submission.
         * <p>
         * @return {@code this}
         * @param autoStartConfiguration The configuration for an application to automatically start on job submission. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoStartConfiguration(final software.amazon.awscdk.core.IResolvable autoStartConfiguration) {
            this.props.autoStartConfiguration(autoStartConfiguration);
            return this;
        }

        /**
         * The configuration for an application to automatically stop after a certain amount of time being idle.
         * <p>
         * @return {@code this}
         * @param autoStopConfiguration The configuration for an application to automatically stop after a certain amount of time being idle. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoStopConfiguration(final software.amazon.awscdk.services.emrserverless.CfnApplication.AutoStopConfigurationProperty autoStopConfiguration) {
            this.props.autoStopConfiguration(autoStopConfiguration);
            return this;
        }
        /**
         * The configuration for an application to automatically stop after a certain amount of time being idle.
         * <p>
         * @return {@code this}
         * @param autoStopConfiguration The configuration for an application to automatically stop after a certain amount of time being idle. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoStopConfiguration(final software.amazon.awscdk.core.IResolvable autoStopConfiguration) {
            this.props.autoStopConfiguration(autoStopConfiguration);
            return this;
        }

        /**
         * The initial capacity of the application.
         * <p>
         * @return {@code this}
         * @param initialCapacity The initial capacity of the application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder initialCapacity(final software.amazon.awscdk.core.IResolvable initialCapacity) {
            this.props.initialCapacity(initialCapacity);
            return this;
        }
        /**
         * The initial capacity of the application.
         * <p>
         * @return {@code this}
         * @param initialCapacity The initial capacity of the application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder initialCapacity(final java.util.List<? extends java.lang.Object> initialCapacity) {
            this.props.initialCapacity(initialCapacity);
            return this;
        }

        /**
         * The maximum capacity of the application.
         * <p>
         * This is cumulative across all workers at any given point in time during the lifespan of the application is created. No new resources will be created once any one of the defined limits is hit.
         * <p>
         * @return {@code this}
         * @param maximumCapacity The maximum capacity of the application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maximumCapacity(final software.amazon.awscdk.services.emrserverless.CfnApplication.MaximumAllowedResourcesProperty maximumCapacity) {
            this.props.maximumCapacity(maximumCapacity);
            return this;
        }
        /**
         * The maximum capacity of the application.
         * <p>
         * This is cumulative across all workers at any given point in time during the lifespan of the application is created. No new resources will be created once any one of the defined limits is hit.
         * <p>
         * @return {@code this}
         * @param maximumCapacity The maximum capacity of the application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maximumCapacity(final software.amazon.awscdk.core.IResolvable maximumCapacity) {
            this.props.maximumCapacity(maximumCapacity);
            return this;
        }

        /**
         * The name of the application.
         * <p>
         * <em>Minimum</em> : 1
         * <p>
         * <em>Maximum</em> : 64
         * <p>
         * <em>Pattern</em> : <code>^[A-Za-z0-9._\\/#-]+$</code>
         * <p>
         * @return {@code this}
         * @param name The name of the application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The network configuration for customer VPC connectivity for the application.
         * <p>
         * @return {@code this}
         * @param networkConfiguration The network configuration for customer VPC connectivity for the application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkConfiguration(final software.amazon.awscdk.services.emrserverless.CfnApplication.NetworkConfigurationProperty networkConfiguration) {
            this.props.networkConfiguration(networkConfiguration);
            return this;
        }
        /**
         * The network configuration for customer VPC connectivity for the application.
         * <p>
         * @return {@code this}
         * @param networkConfiguration The network configuration for customer VPC connectivity for the application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkConfiguration(final software.amazon.awscdk.core.IResolvable networkConfiguration) {
            this.props.networkConfiguration(networkConfiguration);
            return this;
        }

        /**
         * The tags assigned to the application.
         * <p>
         * @return {@code this}
         * @param tags The tags assigned to the application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.emrserverless.CfnApplication}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.emrserverless.CfnApplication build() {
            return new software.amazon.awscdk.services.emrserverless.CfnApplication(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
