package software.amazon.awscdk.services.events;

/**
 * (experimental) Define an EventBridge Connection.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Connection connection = Connection.Builder.create(this, "Connection")
 *         .authorization(Authorization.apiKey("x-api-key", SecretValue.secretsManager("ApiSecretName")))
 *         .description("Connection with API Key x-api-key")
 *         .build();
 * ApiDestination destination = ApiDestination.Builder.create(this, "Destination")
 *         .connection(connection)
 *         .endpoint("https://example.com")
 *         .description("Calling example.com with API key x-api-key")
 *         .build();
 * Rule rule = Rule.Builder.create(this, "Rule")
 *         .schedule(Schedule.rate(Duration.minutes(1)))
 *         .targets(List.of(new ApiDestination(destination)))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:01.861Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_events.Connection")
public class Connection extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.events.IConnection {

    protected Connection(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Connection(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public Connection(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.ConnectionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Import an existing connection resource.
     * <p>
     * @param scope Parent construct. This parameter is required.
     * @param id Construct ID. This parameter is required.
     * @param attrs Imported connection properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.IConnection fromConnectionAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.ConnectionAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.events.Connection.class, "fromConnectionAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.IConnection.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * (experimental) Import an existing connection resource.
     * <p>
     * @param scope Parent construct. This parameter is required.
     * @param id Construct ID. This parameter is required.
     * @param connectionArn ARN of imported connection. This parameter is required.
     * @param connectionSecretArn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.IConnection fromEventBusArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String connectionArn, final @org.jetbrains.annotations.NotNull java.lang.String connectionSecretArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.events.Connection.class, "fromEventBusArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.IConnection.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(connectionArn, "connectionArn is required"), java.util.Objects.requireNonNull(connectionSecretArn, "connectionSecretArn is required") });
    }

    /**
     * (experimental) The ARN of the connection created.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getConnectionArn() {
        return software.amazon.jsii.Kernel.get(this, "connectionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The Name for the connection.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getConnectionName() {
        return software.amazon.jsii.Kernel.get(this, "connectionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The ARN for the secret created for the connection.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getConnectionSecretArn() {
        return software.amazon.jsii.Kernel.get(this, "connectionSecretArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.events.Connection}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.events.Connection> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.events.ConnectionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.events.ConnectionProps.Builder();
        }

        /**
         * (experimental) The authorization type for the connection.
         * <p>
         * @return {@code this}
         * @param authorization The authorization type for the connection. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder authorization(final software.amazon.awscdk.services.events.Authorization authorization) {
            this.props.authorization(authorization);
            return this;
        }

        /**
         * (experimental) Additional string parameters to add to the invocation bodies.
         * <p>
         * Default: - No additional parameters
         * <p>
         * @return {@code this}
         * @param bodyParameters Additional string parameters to add to the invocation bodies. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder bodyParameters(final java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.events.HttpParameter> bodyParameters) {
            this.props.bodyParameters(bodyParameters);
            return this;
        }

        /**
         * (experimental) The name of the connection.
         * <p>
         * Default: - A name is automatically generated
         * <p>
         * @return {@code this}
         * @param connectionName The name of the connection. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder connectionName(final java.lang.String connectionName) {
            this.props.connectionName(connectionName);
            return this;
        }

        /**
         * (experimental) The name of the connection.
         * <p>
         * Default: - none
         * <p>
         * @return {@code this}
         * @param description The name of the connection. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * (experimental) Additional string parameters to add to the invocation headers.
         * <p>
         * Default: - No additional parameters
         * <p>
         * @return {@code this}
         * @param headerParameters Additional string parameters to add to the invocation headers. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder headerParameters(final java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.events.HttpParameter> headerParameters) {
            this.props.headerParameters(headerParameters);
            return this;
        }

        /**
         * (experimental) Additional string parameters to add to the invocation query strings.
         * <p>
         * Default: - No additional parameters
         * <p>
         * @return {@code this}
         * @param queryStringParameters Additional string parameters to add to the invocation query strings. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder queryStringParameters(final java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.events.HttpParameter> queryStringParameters) {
            this.props.queryStringParameters(queryStringParameters);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.events.Connection}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.events.Connection build() {
            return new software.amazon.awscdk.services.events.Connection(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
