package software.amazon.awscdk.services.events.targets;

/**
 * (experimental) Use an API Destination rule target.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Connection connection = Connection.Builder.create(this, "Connection")
 *         .authorization(Authorization.apiKey("x-api-key", SecretValue.secretsManager("ApiSecretName")))
 *         .description("Connection with API Key x-api-key")
 *         .build();
 * ApiDestination destination = ApiDestination.Builder.create(this, "Destination")
 *         .connection(connection)
 *         .endpoint("https://example.com")
 *         .description("Calling example.com with API key x-api-key")
 *         .build();
 * Rule rule = Rule.Builder.create(this, "Rule")
 *         .schedule(Schedule.rate(Duration.minutes(1)))
 *         .targets(List.of(new ApiDestination(destination)))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:01.909Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_events_targets.ApiDestination")
public class ApiDestination extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.events.IRuleTarget {

    protected ApiDestination(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ApiDestination(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param apiDestination This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public ApiDestination(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.IApiDestination apiDestination, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.targets.ApiDestinationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(apiDestination, "apiDestination is required"), props });
    }

    /**
     * @param apiDestination This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public ApiDestination(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.IApiDestination apiDestination) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(apiDestination, "apiDestination is required") });
    }

    /**
     * (experimental) Returns a RuleTarget that can be used to trigger API destinations from an EventBridge event.
     * <p>
     * @param _rule This parameter is required.
     * @param _id
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.RuleTargetConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.IRule _rule, final @org.jetbrains.annotations.Nullable java.lang.String _id) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.RuleTargetConfig.class), new Object[] { java.util.Objects.requireNonNull(_rule, "_rule is required"), _id });
    }

    /**
     * (experimental) Returns a RuleTarget that can be used to trigger API destinations from an EventBridge event.
     * <p>
     * @param _rule This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.RuleTargetConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.IRule _rule) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.RuleTargetConfig.class), new Object[] { java.util.Objects.requireNonNull(_rule, "_rule is required") });
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.events.targets.ApiDestination}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.events.targets.ApiDestination> {
        /**
         * @return a new instance of {@link Builder}.
         * @param apiDestination This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.amazon.awscdk.services.events.IApiDestination apiDestination) {
            return new Builder(apiDestination);
        }

        private final software.amazon.awscdk.services.events.IApiDestination apiDestination;
        private software.amazon.awscdk.services.events.targets.ApiDestinationProps.Builder props;

        private Builder(final software.amazon.awscdk.services.events.IApiDestination apiDestination) {
            this.apiDestination = apiDestination;
        }

        /**
         * (experimental) The SQS queue to be used as deadLetterQueue. Check out the [considerations for using a dead-letter queue](https://docs.aws.amazon.com/eventbridge/latest/userguide/rule-dlq.html#dlq-considerations).
         * <p>
         * The events not successfully delivered are automatically retried for a specified period of time,
         * depending on the retry policy of the target.
         * If an event is not delivered before all retry attempts are exhausted, it will be sent to the dead letter queue.
         * <p>
         * Default: - no dead-letter queue
         * <p>
         * @return {@code this}
         * @param deadLetterQueue The SQS queue to be used as deadLetterQueue. Check out the [considerations for using a dead-letter queue](https://docs.aws.amazon.com/eventbridge/latest/userguide/rule-dlq.html#dlq-considerations). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder deadLetterQueue(final software.amazon.awscdk.services.sqs.IQueue deadLetterQueue) {
            this.props().deadLetterQueue(deadLetterQueue);
            return this;
        }

        /**
         * (experimental) The maximum age of a request that Lambda sends to a function for processing.
         * <p>
         * Minimum value of 60.
         * Maximum value of 86400.
         * <p>
         * Default: Duration.hours(24)
         * <p>
         * @return {@code this}
         * @param maxEventAge The maximum age of a request that Lambda sends to a function for processing. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder maxEventAge(final software.amazon.awscdk.core.Duration maxEventAge) {
            this.props().maxEventAge(maxEventAge);
            return this;
        }

        /**
         * (experimental) The maximum number of times to retry when the function returns an error.
         * <p>
         * Minimum value of 0.
         * Maximum value of 185.
         * <p>
         * Default: 185
         * <p>
         * @return {@code this}
         * @param retryAttempts The maximum number of times to retry when the function returns an error. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder retryAttempts(final java.lang.Number retryAttempts) {
            this.props().retryAttempts(retryAttempts);
            return this;
        }

        /**
         * (experimental) The event to send.
         * <p>
         * Default: - the entire EventBridge event
         * <p>
         * @return {@code this}
         * @param event The event to send. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder event(final software.amazon.awscdk.services.events.RuleTargetInput event) {
            this.props().event(event);
            return this;
        }

        /**
         * (experimental) The role to assume before invoking the target.
         * <p>
         * Default: - a new role will be created
         * <p>
         * @return {@code this}
         * @param eventRole The role to assume before invoking the target. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder eventRole(final software.amazon.awscdk.services.iam.IRole eventRole) {
            this.props().eventRole(eventRole);
            return this;
        }

        /**
         * (experimental) Additional headers sent to the API Destination.
         * <p>
         * These are merged with headers specified on the Connection, with
         * the headers on the Connection taking precedence.
         * <p>
         * You can only specify secret values on the Connection.
         * <p>
         * Default: - none
         * <p>
         * @return {@code this}
         * @param headerParameters Additional headers sent to the API Destination. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder headerParameters(final java.util.Map<java.lang.String, java.lang.String> headerParameters) {
            this.props().headerParameters(headerParameters);
            return this;
        }

        /**
         * (experimental) Path parameters to insert in place of path wildcards (`*`).
         * <p>
         * If the API destination has a wilcard in the path, these path parts
         * will be inserted in that place.
         * <p>
         * Default: - none
         * <p>
         * @return {@code this}
         * @param pathParameterValues Path parameters to insert in place of path wildcards (`*`). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder pathParameterValues(final java.util.List<java.lang.String> pathParameterValues) {
            this.props().pathParameterValues(pathParameterValues);
            return this;
        }

        /**
         * (experimental) Additional query string parameters sent to the API Destination.
         * <p>
         * These are merged with headers specified on the Connection, with
         * the headers on the Connection taking precedence.
         * <p>
         * You can only specify secret values on the Connection.
         * <p>
         * Default: - none
         * <p>
         * @return {@code this}
         * @param queryStringParameters Additional query string parameters sent to the API Destination. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder queryStringParameters(final java.util.Map<java.lang.String, java.lang.String> queryStringParameters) {
            this.props().queryStringParameters(queryStringParameters);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.events.targets.ApiDestination}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.events.targets.ApiDestination build() {
            return new software.amazon.awscdk.services.events.targets.ApiDestination(
                this.apiDestination,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.events.targets.ApiDestinationProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.events.targets.ApiDestinationProps.Builder();
            }
            return this.props;
        }
    }
}
