package software.amazon.awscdk.services.fsx;

/**
 * (experimental) Properties for the FSx file system.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.services.ec2.*;
 * import software.amazon.awscdk.services.fsx.*;
 * import software.amazon.awscdk.services.kms.*;
 * Key key;
 * SecurityGroup securityGroup;
 * Vpc vpc;
 * FileSystemProps fileSystemProps = FileSystemProps.builder()
 *         .storageCapacityGiB(123)
 *         .vpc(vpc)
 *         // the properties below are optional
 *         .backupId("backupId")
 *         .kmsKey(key)
 *         .removalPolicy(RemovalPolicy.DESTROY)
 *         .securityGroup(securityGroup)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:02.238Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_fsx.FileSystemProps")
@software.amazon.jsii.Jsii.Proxy(FileSystemProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface FileSystemProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The storage capacity of the file system being created.
     * <p>
     * For Windows file systems, valid values are 32 GiB to 65,536 GiB.
     * For SCRATCH_1 deployment types, valid values are 1,200, 2,400, 3,600, then continuing in increments of 3,600 GiB.
     * For SCRATCH_2 and PERSISTENT_1 types, valid values are 1,200, 2,400, then continuing in increments of 2,400 GiB.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.Number getStorageCapacityGiB();

    /**
     * (experimental) The VPC to launch the file system in.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IVpc getVpc();

    /**
     * (experimental) The ID of the backup.
     * <p>
     * Specifies the backup to use if you're creating a file system from an existing backup.
     * <p>
     * Default: - no backup will be used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getBackupId() {
        return null;
    }

    /**
     * (experimental) The KMS key used for encryption to protect your data at rest.
     * <p>
     * Default: - the aws/fsx default KMS key for the AWS account being deployed into.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getKmsKey() {
        return null;
    }

    /**
     * (experimental) Policy to apply when the file system is removed from the stack.
     * <p>
     * Default: RemovalPolicy.RETAIN
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.RemovalPolicy getRemovalPolicy() {
        return null;
    }

    /**
     * (experimental) Security Group to assign to this file system.
     * <p>
     * Default: - creates new security group which allows all outbound traffic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link FileSystemProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FileSystemProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<FileSystemProps> {
        java.lang.Number storageCapacityGiB;
        software.amazon.awscdk.services.ec2.IVpc vpc;
        java.lang.String backupId;
        software.amazon.awscdk.services.kms.IKey kmsKey;
        software.amazon.awscdk.core.RemovalPolicy removalPolicy;
        software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup;

        /**
         * Sets the value of {@link FileSystemProps#getStorageCapacityGiB}
         * @param storageCapacityGiB The storage capacity of the file system being created. This parameter is required.
         *                           For Windows file systems, valid values are 32 GiB to 65,536 GiB.
         *                           For SCRATCH_1 deployment types, valid values are 1,200, 2,400, 3,600, then continuing in increments of 3,600 GiB.
         *                           For SCRATCH_2 and PERSISTENT_1 types, valid values are 1,200, 2,400, then continuing in increments of 2,400 GiB.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder storageCapacityGiB(java.lang.Number storageCapacityGiB) {
            this.storageCapacityGiB = storageCapacityGiB;
            return this;
        }

        /**
         * Sets the value of {@link FileSystemProps#getVpc}
         * @param vpc The VPC to launch the file system in. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Sets the value of {@link FileSystemProps#getBackupId}
         * @param backupId The ID of the backup.
         *                 Specifies the backup to use if you're creating a file system from an existing backup.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder backupId(java.lang.String backupId) {
            this.backupId = backupId;
            return this;
        }

        /**
         * Sets the value of {@link FileSystemProps#getKmsKey}
         * @param kmsKey The KMS key used for encryption to protect your data at rest.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder kmsKey(software.amazon.awscdk.services.kms.IKey kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        /**
         * Sets the value of {@link FileSystemProps#getRemovalPolicy}
         * @param removalPolicy Policy to apply when the file system is removed from the stack.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder removalPolicy(software.amazon.awscdk.core.RemovalPolicy removalPolicy) {
            this.removalPolicy = removalPolicy;
            return this;
        }

        /**
         * Sets the value of {@link FileSystemProps#getSecurityGroup}
         * @param securityGroup Security Group to assign to this file system.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder securityGroup(software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
            this.securityGroup = securityGroup;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FileSystemProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public FileSystemProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link FileSystemProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FileSystemProps {
        private final java.lang.Number storageCapacityGiB;
        private final software.amazon.awscdk.services.ec2.IVpc vpc;
        private final java.lang.String backupId;
        private final software.amazon.awscdk.services.kms.IKey kmsKey;
        private final software.amazon.awscdk.core.RemovalPolicy removalPolicy;
        private final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.storageCapacityGiB = software.amazon.jsii.Kernel.get(this, "storageCapacityGiB", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.vpc = software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
            this.backupId = software.amazon.jsii.Kernel.get(this, "backupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.kmsKey = software.amazon.jsii.Kernel.get(this, "kmsKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
            this.removalPolicy = software.amazon.jsii.Kernel.get(this, "removalPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.RemovalPolicy.class));
            this.securityGroup = software.amazon.jsii.Kernel.get(this, "securityGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.storageCapacityGiB = java.util.Objects.requireNonNull(builder.storageCapacityGiB, "storageCapacityGiB is required");
            this.vpc = java.util.Objects.requireNonNull(builder.vpc, "vpc is required");
            this.backupId = builder.backupId;
            this.kmsKey = builder.kmsKey;
            this.removalPolicy = builder.removalPolicy;
            this.securityGroup = builder.securityGroup;
        }

        @Override
        public final java.lang.Number getStorageCapacityGiB() {
            return this.storageCapacityGiB;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        public final java.lang.String getBackupId() {
            return this.backupId;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getKmsKey() {
            return this.kmsKey;
        }

        @Override
        public final software.amazon.awscdk.core.RemovalPolicy getRemovalPolicy() {
            return this.removalPolicy;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup() {
            return this.securityGroup;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("storageCapacityGiB", om.valueToTree(this.getStorageCapacityGiB()));
            data.set("vpc", om.valueToTree(this.getVpc()));
            if (this.getBackupId() != null) {
                data.set("backupId", om.valueToTree(this.getBackupId()));
            }
            if (this.getKmsKey() != null) {
                data.set("kmsKey", om.valueToTree(this.getKmsKey()));
            }
            if (this.getRemovalPolicy() != null) {
                data.set("removalPolicy", om.valueToTree(this.getRemovalPolicy()));
            }
            if (this.getSecurityGroup() != null) {
                data.set("securityGroup", om.valueToTree(this.getSecurityGroup()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_fsx.FileSystemProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FileSystemProps.Jsii$Proxy that = (FileSystemProps.Jsii$Proxy) o;

            if (!storageCapacityGiB.equals(that.storageCapacityGiB)) return false;
            if (!vpc.equals(that.vpc)) return false;
            if (this.backupId != null ? !this.backupId.equals(that.backupId) : that.backupId != null) return false;
            if (this.kmsKey != null ? !this.kmsKey.equals(that.kmsKey) : that.kmsKey != null) return false;
            if (this.removalPolicy != null ? !this.removalPolicy.equals(that.removalPolicy) : that.removalPolicy != null) return false;
            return this.securityGroup != null ? this.securityGroup.equals(that.securityGroup) : that.securityGroup == null;
        }

        @Override
        public final int hashCode() {
            int result = this.storageCapacityGiB.hashCode();
            result = 31 * result + (this.vpc.hashCode());
            result = 31 * result + (this.backupId != null ? this.backupId.hashCode() : 0);
            result = 31 * result + (this.kmsKey != null ? this.kmsKey.hashCode() : 0);
            result = 31 * result + (this.removalPolicy != null ? this.removalPolicy.hashCode() : 0);
            result = 31 * result + (this.securityGroup != null ? this.securityGroup.hashCode() : 0);
            return result;
        }
    }
}
