package software.amazon.awscdk.services.fsx;

/**
 * (experimental) The different kinds of file system deployments used by Lustre.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * LustreFileSystem fileSystem = LustreFileSystem.Builder.create(this, "FsxLustreFileSystem")
 *         .lustreConfiguration(LustreConfiguration.builder().deploymentType(LustreDeploymentType.SCRATCH_2).build())
 *         .storageCapacityGiB(1200)
 *         .vpc(vpc)
 *         .vpcSubnet(vpc.getPrivateSubnets()[0])
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:02.241Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_fsx.LustreDeploymentType")
public enum LustreDeploymentType {
    /**
     * (experimental) Original type for shorter term data processing.
     * <p>
     * Data is not replicated and does not persist on server fail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    SCRATCH_1,
    /**
     * (experimental) Newer type for shorter term data processing.
     * <p>
     * Data is not replicated and does not persist on server fail.
     * Provides better support for spiky workloads.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    SCRATCH_2,
    /**
     * (experimental) Long term storage.
     * <p>
     * Data is replicated and file servers are replaced if they fail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    PERSISTENT_1,
    /**
     * (experimental) Newer type of long term storage with higher throughput tiers.
     * <p>
     * Data is replicated and file servers are replaced if they fail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    PERSISTENT_2,
}
