package software.amazon.awscdk.services.glue;

/**
 * A CloudFormation `AWS::Glue::Crawler`.
 * <p>
 * The <code>AWS::Glue::Crawler</code> resource specifies an AWS Glue crawler. For more information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/add-crawler.html">Cataloging Tables with a Crawler</a> and <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-crawling.html#aws-glue-api-crawler-crawling-Crawler">Crawler Structure</a> in the <em>AWS Glue Developer Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.glue.*;
 * Object tags;
 * CfnCrawler cfnCrawler = CfnCrawler.Builder.create(this, "MyCfnCrawler")
 *         .role("role")
 *         .targets(TargetsProperty.builder()
 *                 .catalogTargets(List.of(CatalogTargetProperty.builder()
 *                         .databaseName("databaseName")
 *                         .tables(List.of("tables"))
 *                         .build()))
 *                 .dynamoDbTargets(List.of(DynamoDBTargetProperty.builder()
 *                         .path("path")
 *                         .build()))
 *                 .jdbcTargets(List.of(JdbcTargetProperty.builder()
 *                         .connectionName("connectionName")
 *                         .exclusions(List.of("exclusions"))
 *                         .path("path")
 *                         .build()))
 *                 .mongoDbTargets(List.of(MongoDBTargetProperty.builder()
 *                         .connectionName("connectionName")
 *                         .path("path")
 *                         .build()))
 *                 .s3Targets(List.of(S3TargetProperty.builder()
 *                         .connectionName("connectionName")
 *                         .dlqEventQueueArn("dlqEventQueueArn")
 *                         .eventQueueArn("eventQueueArn")
 *                         .exclusions(List.of("exclusions"))
 *                         .path("path")
 *                         .sampleSize(123)
 *                         .build()))
 *                 .build())
 *         // the properties below are optional
 *         .classifiers(List.of("classifiers"))
 *         .configuration("configuration")
 *         .crawlerSecurityConfiguration("crawlerSecurityConfiguration")
 *         .databaseName("databaseName")
 *         .description("description")
 *         .name("name")
 *         .recrawlPolicy(RecrawlPolicyProperty.builder()
 *                 .recrawlBehavior("recrawlBehavior")
 *                 .build())
 *         .schedule(ScheduleProperty.builder()
 *                 .scheduleExpression("scheduleExpression")
 *                 .build())
 *         .schemaChangePolicy(SchemaChangePolicyProperty.builder()
 *                 .deleteBehavior("deleteBehavior")
 *                 .updateBehavior("updateBehavior")
 *                 .build())
 *         .tablePrefix("tablePrefix")
 *         .tags(tags)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:02.433Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_glue.CfnCrawler")
public class CfnCrawler extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnCrawler(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCrawler(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.glue.CfnCrawler.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::Glue::Crawler`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnCrawler(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.CfnCrawlerProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The tags to use with this crawler.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * The Amazon Resource Name (ARN) of an IAM role that's used to access customer resources, such as Amazon Simple Storage Service (Amazon S3) data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRole() {
        return software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of an IAM role that's used to access customer resources, such as Amazon Simple Storage Service (Amazon S3) data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRole(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "role", java.util.Objects.requireNonNull(value, "role is required"));
    }

    /**
     * A collection of targets to crawl.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getTargets() {
        return software.amazon.jsii.Kernel.get(this, "targets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A collection of targets to crawl.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTargets(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.CfnCrawler.TargetsProperty value) {
        software.amazon.jsii.Kernel.set(this, "targets", java.util.Objects.requireNonNull(value, "targets is required"));
    }

    /**
     * A collection of targets to crawl.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTargets(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "targets", java.util.Objects.requireNonNull(value, "targets is required"));
    }

    /**
     * A list of UTF-8 strings that specify the names of custom classifiers that are associated with the crawler.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getClassifiers() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "classifiers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A list of UTF-8 strings that specify the names of custom classifiers that are associated with the crawler.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setClassifiers(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "classifiers", value);
    }

    /**
     * Crawler configuration information.
     * <p>
     * This versioned JSON string allows users to specify aspects of a crawler's behavior. For more information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/crawler-configuration.html">Configuring a Crawler</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "configuration", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Crawler configuration information.
     * <p>
     * This versioned JSON string allows users to specify aspects of a crawler's behavior. For more information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/crawler-configuration.html">Configuring a Crawler</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfiguration(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "configuration", value);
    }

    /**
     * The name of the `SecurityConfiguration` structure to be used by this crawler.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCrawlerSecurityConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "crawlerSecurityConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the `SecurityConfiguration` structure to be used by this crawler.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCrawlerSecurityConfiguration(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "crawlerSecurityConfiguration", value);
    }

    /**
     * The name of the database in which the crawler's output is stored.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDatabaseName() {
        return software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the database in which the crawler's output is stored.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDatabaseName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "databaseName", value);
    }

    /**
     * A description of the crawler.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A description of the crawler.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * The name of the crawler.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the crawler.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * A policy that specifies whether to crawl the entire dataset again, or to crawl only folders that were added since the last crawler run.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRecrawlPolicy() {
        return software.amazon.jsii.Kernel.get(this, "recrawlPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A policy that specifies whether to crawl the entire dataset again, or to crawl only folders that were added since the last crawler run.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRecrawlPolicy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.glue.CfnCrawler.RecrawlPolicyProperty value) {
        software.amazon.jsii.Kernel.set(this, "recrawlPolicy", value);
    }

    /**
     * A policy that specifies whether to crawl the entire dataset again, or to crawl only folders that were added since the last crawler run.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRecrawlPolicy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "recrawlPolicy", value);
    }

    /**
     * For scheduled crawlers, the schedule when the crawler runs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSchedule() {
        return software.amazon.jsii.Kernel.get(this, "schedule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * For scheduled crawlers, the schedule when the crawler runs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSchedule(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.glue.CfnCrawler.ScheduleProperty value) {
        software.amazon.jsii.Kernel.set(this, "schedule", value);
    }

    /**
     * For scheduled crawlers, the schedule when the crawler runs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSchedule(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "schedule", value);
    }

    /**
     * The policy that specifies update and delete behaviors for the crawler.
     * <p>
     * The policy tells the crawler what to do in the event that it detects a change in a table that already exists in the customer's database at the time of the crawl. The <code>SchemaChangePolicy</code> does not affect whether or how new tables and partitions are added. New tables and partitions are always created regardless of the <code>SchemaChangePolicy</code> on a crawler.
     * <p>
     * The SchemaChangePolicy consists of two components, <code>UpdateBehavior</code> and <code>DeleteBehavior</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSchemaChangePolicy() {
        return software.amazon.jsii.Kernel.get(this, "schemaChangePolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The policy that specifies update and delete behaviors for the crawler.
     * <p>
     * The policy tells the crawler what to do in the event that it detects a change in a table that already exists in the customer's database at the time of the crawl. The <code>SchemaChangePolicy</code> does not affect whether or how new tables and partitions are added. New tables and partitions are always created regardless of the <code>SchemaChangePolicy</code> on a crawler.
     * <p>
     * The SchemaChangePolicy consists of two components, <code>UpdateBehavior</code> and <code>DeleteBehavior</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSchemaChangePolicy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.glue.CfnCrawler.SchemaChangePolicyProperty value) {
        software.amazon.jsii.Kernel.set(this, "schemaChangePolicy", value);
    }

    /**
     * The policy that specifies update and delete behaviors for the crawler.
     * <p>
     * The policy tells the crawler what to do in the event that it detects a change in a table that already exists in the customer's database at the time of the crawl. The <code>SchemaChangePolicy</code> does not affect whether or how new tables and partitions are added. New tables and partitions are always created regardless of the <code>SchemaChangePolicy</code> on a crawler.
     * <p>
     * The SchemaChangePolicy consists of two components, <code>UpdateBehavior</code> and <code>DeleteBehavior</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSchemaChangePolicy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "schemaChangePolicy", value);
    }

    /**
     * The prefix added to the names of tables that are created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTablePrefix() {
        return software.amazon.jsii.Kernel.get(this, "tablePrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The prefix added to the names of tables that are created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTablePrefix(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "tablePrefix", value);
    }
    /**
     * Specifies an AWS Glue Data Catalog target.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.glue.*;
     * CatalogTargetProperty catalogTargetProperty = CatalogTargetProperty.builder()
     *         .databaseName("databaseName")
     *         .tables(List.of("tables"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_glue.CfnCrawler.CatalogTargetProperty")
    @software.amazon.jsii.Jsii.Proxy(CatalogTargetProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CatalogTargetProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the database to be synchronized.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDatabaseName() {
            return null;
        }

        /**
         * A list of the tables to be synchronized.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getTables() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CatalogTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CatalogTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CatalogTargetProperty> {
            java.lang.String databaseName;
            java.util.List<java.lang.String> tables;

            /**
             * Sets the value of {@link CatalogTargetProperty#getDatabaseName}
             * @param databaseName The name of the database to be synchronized.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseName(java.lang.String databaseName) {
                this.databaseName = databaseName;
                return this;
            }

            /**
             * Sets the value of {@link CatalogTargetProperty#getTables}
             * @param tables A list of the tables to be synchronized.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tables(java.util.List<java.lang.String> tables) {
                this.tables = tables;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CatalogTargetProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CatalogTargetProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CatalogTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CatalogTargetProperty {
            private final java.lang.String databaseName;
            private final java.util.List<java.lang.String> tables;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.databaseName = software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tables = software.amazon.jsii.Kernel.get(this, "tables", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.databaseName = builder.databaseName;
                this.tables = builder.tables;
            }

            @Override
            public final java.lang.String getDatabaseName() {
                return this.databaseName;
            }

            @Override
            public final java.util.List<java.lang.String> getTables() {
                return this.tables;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDatabaseName() != null) {
                    data.set("databaseName", om.valueToTree(this.getDatabaseName()));
                }
                if (this.getTables() != null) {
                    data.set("tables", om.valueToTree(this.getTables()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_glue.CfnCrawler.CatalogTargetProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CatalogTargetProperty.Jsii$Proxy that = (CatalogTargetProperty.Jsii$Proxy) o;

                if (this.databaseName != null ? !this.databaseName.equals(that.databaseName) : that.databaseName != null) return false;
                return this.tables != null ? this.tables.equals(that.tables) : that.tables == null;
            }

            @Override
            public final int hashCode() {
                int result = this.databaseName != null ? this.databaseName.hashCode() : 0;
                result = 31 * result + (this.tables != null ? this.tables.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies an Amazon DynamoDB table to crawl.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.glue.*;
     * DynamoDBTargetProperty dynamoDBTargetProperty = DynamoDBTargetProperty.builder()
     *         .path("path")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_glue.CfnCrawler.DynamoDBTargetProperty")
    @software.amazon.jsii.Jsii.Proxy(DynamoDBTargetProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DynamoDBTargetProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the DynamoDB table to crawl.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPath() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DynamoDBTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DynamoDBTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DynamoDBTargetProperty> {
            java.lang.String path;

            /**
             * Sets the value of {@link DynamoDBTargetProperty#getPath}
             * @param path The name of the DynamoDB table to crawl.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder path(java.lang.String path) {
                this.path = path;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DynamoDBTargetProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DynamoDBTargetProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DynamoDBTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DynamoDBTargetProperty {
            private final java.lang.String path;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.path = software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.path = builder.path;
            }

            @Override
            public final java.lang.String getPath() {
                return this.path;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPath() != null) {
                    data.set("path", om.valueToTree(this.getPath()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_glue.CfnCrawler.DynamoDBTargetProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DynamoDBTargetProperty.Jsii$Proxy that = (DynamoDBTargetProperty.Jsii$Proxy) o;

                return this.path != null ? this.path.equals(that.path) : that.path == null;
            }

            @Override
            public final int hashCode() {
                int result = this.path != null ? this.path.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Specifies a JDBC data store to crawl.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.glue.*;
     * JdbcTargetProperty jdbcTargetProperty = JdbcTargetProperty.builder()
     *         .connectionName("connectionName")
     *         .exclusions(List.of("exclusions"))
     *         .path("path")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_glue.CfnCrawler.JdbcTargetProperty")
    @software.amazon.jsii.Jsii.Proxy(JdbcTargetProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface JdbcTargetProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the connection to use to connect to the JDBC target.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getConnectionName() {
            return null;
        }

        /**
         * A list of glob patterns used to exclude from the crawl.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/add-crawler.html">Catalog Tables with a Crawler</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExclusions() {
            return null;
        }

        /**
         * The path of the JDBC target.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPath() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link JdbcTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link JdbcTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<JdbcTargetProperty> {
            java.lang.String connectionName;
            java.util.List<java.lang.String> exclusions;
            java.lang.String path;

            /**
             * Sets the value of {@link JdbcTargetProperty#getConnectionName}
             * @param connectionName The name of the connection to use to connect to the JDBC target.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectionName(java.lang.String connectionName) {
                this.connectionName = connectionName;
                return this;
            }

            /**
             * Sets the value of {@link JdbcTargetProperty#getExclusions}
             * @param exclusions A list of glob patterns used to exclude from the crawl.
             *                   For more information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/add-crawler.html">Catalog Tables with a Crawler</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exclusions(java.util.List<java.lang.String> exclusions) {
                this.exclusions = exclusions;
                return this;
            }

            /**
             * Sets the value of {@link JdbcTargetProperty#getPath}
             * @param path The path of the JDBC target.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder path(java.lang.String path) {
                this.path = path;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link JdbcTargetProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public JdbcTargetProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link JdbcTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements JdbcTargetProperty {
            private final java.lang.String connectionName;
            private final java.util.List<java.lang.String> exclusions;
            private final java.lang.String path;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.connectionName = software.amazon.jsii.Kernel.get(this, "connectionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.exclusions = software.amazon.jsii.Kernel.get(this, "exclusions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.path = software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.connectionName = builder.connectionName;
                this.exclusions = builder.exclusions;
                this.path = builder.path;
            }

            @Override
            public final java.lang.String getConnectionName() {
                return this.connectionName;
            }

            @Override
            public final java.util.List<java.lang.String> getExclusions() {
                return this.exclusions;
            }

            @Override
            public final java.lang.String getPath() {
                return this.path;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getConnectionName() != null) {
                    data.set("connectionName", om.valueToTree(this.getConnectionName()));
                }
                if (this.getExclusions() != null) {
                    data.set("exclusions", om.valueToTree(this.getExclusions()));
                }
                if (this.getPath() != null) {
                    data.set("path", om.valueToTree(this.getPath()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_glue.CfnCrawler.JdbcTargetProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                JdbcTargetProperty.Jsii$Proxy that = (JdbcTargetProperty.Jsii$Proxy) o;

                if (this.connectionName != null ? !this.connectionName.equals(that.connectionName) : that.connectionName != null) return false;
                if (this.exclusions != null ? !this.exclusions.equals(that.exclusions) : that.exclusions != null) return false;
                return this.path != null ? this.path.equals(that.path) : that.path == null;
            }

            @Override
            public final int hashCode() {
                int result = this.connectionName != null ? this.connectionName.hashCode() : 0;
                result = 31 * result + (this.exclusions != null ? this.exclusions.hashCode() : 0);
                result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies an Amazon DocumentDB or MongoDB data store to crawl.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.glue.*;
     * MongoDBTargetProperty mongoDBTargetProperty = MongoDBTargetProperty.builder()
     *         .connectionName("connectionName")
     *         .path("path")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_glue.CfnCrawler.MongoDBTargetProperty")
    @software.amazon.jsii.Jsii.Proxy(MongoDBTargetProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MongoDBTargetProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the connection to use to connect to the Amazon DocumentDB or MongoDB target.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getConnectionName() {
            return null;
        }

        /**
         * The path of the Amazon DocumentDB or MongoDB target (database/collection).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPath() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MongoDBTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MongoDBTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MongoDBTargetProperty> {
            java.lang.String connectionName;
            java.lang.String path;

            /**
             * Sets the value of {@link MongoDBTargetProperty#getConnectionName}
             * @param connectionName The name of the connection to use to connect to the Amazon DocumentDB or MongoDB target.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectionName(java.lang.String connectionName) {
                this.connectionName = connectionName;
                return this;
            }

            /**
             * Sets the value of {@link MongoDBTargetProperty#getPath}
             * @param path The path of the Amazon DocumentDB or MongoDB target (database/collection).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder path(java.lang.String path) {
                this.path = path;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MongoDBTargetProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MongoDBTargetProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MongoDBTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MongoDBTargetProperty {
            private final java.lang.String connectionName;
            private final java.lang.String path;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.connectionName = software.amazon.jsii.Kernel.get(this, "connectionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.path = software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.connectionName = builder.connectionName;
                this.path = builder.path;
            }

            @Override
            public final java.lang.String getConnectionName() {
                return this.connectionName;
            }

            @Override
            public final java.lang.String getPath() {
                return this.path;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getConnectionName() != null) {
                    data.set("connectionName", om.valueToTree(this.getConnectionName()));
                }
                if (this.getPath() != null) {
                    data.set("path", om.valueToTree(this.getPath()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_glue.CfnCrawler.MongoDBTargetProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MongoDBTargetProperty.Jsii$Proxy that = (MongoDBTargetProperty.Jsii$Proxy) o;

                if (this.connectionName != null ? !this.connectionName.equals(that.connectionName) : that.connectionName != null) return false;
                return this.path != null ? this.path.equals(that.path) : that.path == null;
            }

            @Override
            public final int hashCode() {
                int result = this.connectionName != null ? this.connectionName.hashCode() : 0;
                result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * When crawling an Amazon S3 data source after the first crawl is complete, specifies whether to crawl the entire dataset again or to crawl only folders that were added since the last crawler run.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/incremental-crawls.html">Incremental Crawls in AWS Glue</a> in the developer guide.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.glue.*;
     * RecrawlPolicyProperty recrawlPolicyProperty = RecrawlPolicyProperty.builder()
     *         .recrawlBehavior("recrawlBehavior")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_glue.CfnCrawler.RecrawlPolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(RecrawlPolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RecrawlPolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether to crawl the entire dataset again or to crawl only folders that were added since the last crawler run.
         * <p>
         * A value of <code>CRAWL_EVERYTHING</code> specifies crawling the entire dataset again.
         * <p>
         * A value of <code>CRAWL_NEW_FOLDERS_ONLY</code> specifies crawling only folders that were added since the last crawler run.
         * <p>
         * A value of <code>CRAWL_EVENT_MODE</code> specifies crawling only the changes identified by Amazon S3 events.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRecrawlBehavior() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RecrawlPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RecrawlPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RecrawlPolicyProperty> {
            java.lang.String recrawlBehavior;

            /**
             * Sets the value of {@link RecrawlPolicyProperty#getRecrawlBehavior}
             * @param recrawlBehavior Specifies whether to crawl the entire dataset again or to crawl only folders that were added since the last crawler run.
             *                        A value of <code>CRAWL_EVERYTHING</code> specifies crawling the entire dataset again.
             *                        <p>
             *                        A value of <code>CRAWL_NEW_FOLDERS_ONLY</code> specifies crawling only folders that were added since the last crawler run.
             *                        <p>
             *                        A value of <code>CRAWL_EVENT_MODE</code> specifies crawling only the changes identified by Amazon S3 events.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recrawlBehavior(java.lang.String recrawlBehavior) {
                this.recrawlBehavior = recrawlBehavior;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RecrawlPolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RecrawlPolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RecrawlPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RecrawlPolicyProperty {
            private final java.lang.String recrawlBehavior;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.recrawlBehavior = software.amazon.jsii.Kernel.get(this, "recrawlBehavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.recrawlBehavior = builder.recrawlBehavior;
            }

            @Override
            public final java.lang.String getRecrawlBehavior() {
                return this.recrawlBehavior;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getRecrawlBehavior() != null) {
                    data.set("recrawlBehavior", om.valueToTree(this.getRecrawlBehavior()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_glue.CfnCrawler.RecrawlPolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RecrawlPolicyProperty.Jsii$Proxy that = (RecrawlPolicyProperty.Jsii$Proxy) o;

                return this.recrawlBehavior != null ? this.recrawlBehavior.equals(that.recrawlBehavior) : that.recrawlBehavior == null;
            }

            @Override
            public final int hashCode() {
                int result = this.recrawlBehavior != null ? this.recrawlBehavior.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Specifies a data store in Amazon Simple Storage Service (Amazon S3).
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.glue.*;
     * S3TargetProperty s3TargetProperty = S3TargetProperty.builder()
     *         .connectionName("connectionName")
     *         .dlqEventQueueArn("dlqEventQueueArn")
     *         .eventQueueArn("eventQueueArn")
     *         .exclusions(List.of("exclusions"))
     *         .path("path")
     *         .sampleSize(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_glue.CfnCrawler.S3TargetProperty")
    @software.amazon.jsii.Jsii.Proxy(S3TargetProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3TargetProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of a connection which allows a job or crawler to access data in Amazon S3 within an Amazon Virtual Private Cloud environment (Amazon VPC).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getConnectionName() {
            return null;
        }

        /**
         * A valid Amazon dead-letter SQS ARN.
         * <p>
         * For example, <code>arn:aws:sqs:region:account:deadLetterQueue</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDlqEventQueueArn() {
            return null;
        }

        /**
         * A valid Amazon SQS ARN.
         * <p>
         * For example, <code>arn:aws:sqs:region:account:sqs</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEventQueueArn() {
            return null;
        }

        /**
         * A list of glob patterns used to exclude from the crawl.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/add-crawler.html">Catalog Tables with a Crawler</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExclusions() {
            return null;
        }

        /**
         * The path to the Amazon S3 target.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPath() {
            return null;
        }

        /**
         * Sets the number of files in each leaf folder to be crawled when crawling sample files in a dataset.
         * <p>
         * If not set, all the files are crawled. A valid value is an integer between 1 and 249.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSampleSize() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3TargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3TargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3TargetProperty> {
            java.lang.String connectionName;
            java.lang.String dlqEventQueueArn;
            java.lang.String eventQueueArn;
            java.util.List<java.lang.String> exclusions;
            java.lang.String path;
            java.lang.Number sampleSize;

            /**
             * Sets the value of {@link S3TargetProperty#getConnectionName}
             * @param connectionName The name of a connection which allows a job or crawler to access data in Amazon S3 within an Amazon Virtual Private Cloud environment (Amazon VPC).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectionName(java.lang.String connectionName) {
                this.connectionName = connectionName;
                return this;
            }

            /**
             * Sets the value of {@link S3TargetProperty#getDlqEventQueueArn}
             * @param dlqEventQueueArn A valid Amazon dead-letter SQS ARN.
             *                         For example, <code>arn:aws:sqs:region:account:deadLetterQueue</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dlqEventQueueArn(java.lang.String dlqEventQueueArn) {
                this.dlqEventQueueArn = dlqEventQueueArn;
                return this;
            }

            /**
             * Sets the value of {@link S3TargetProperty#getEventQueueArn}
             * @param eventQueueArn A valid Amazon SQS ARN.
             *                      For example, <code>arn:aws:sqs:region:account:sqs</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventQueueArn(java.lang.String eventQueueArn) {
                this.eventQueueArn = eventQueueArn;
                return this;
            }

            /**
             * Sets the value of {@link S3TargetProperty#getExclusions}
             * @param exclusions A list of glob patterns used to exclude from the crawl.
             *                   For more information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/add-crawler.html">Catalog Tables with a Crawler</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exclusions(java.util.List<java.lang.String> exclusions) {
                this.exclusions = exclusions;
                return this;
            }

            /**
             * Sets the value of {@link S3TargetProperty#getPath}
             * @param path The path to the Amazon S3 target.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder path(java.lang.String path) {
                this.path = path;
                return this;
            }

            /**
             * Sets the value of {@link S3TargetProperty#getSampleSize}
             * @param sampleSize Sets the number of files in each leaf folder to be crawled when crawling sample files in a dataset.
             *                   If not set, all the files are crawled. A valid value is an integer between 1 and 249.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sampleSize(java.lang.Number sampleSize) {
                this.sampleSize = sampleSize;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3TargetProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3TargetProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3TargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3TargetProperty {
            private final java.lang.String connectionName;
            private final java.lang.String dlqEventQueueArn;
            private final java.lang.String eventQueueArn;
            private final java.util.List<java.lang.String> exclusions;
            private final java.lang.String path;
            private final java.lang.Number sampleSize;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.connectionName = software.amazon.jsii.Kernel.get(this, "connectionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dlqEventQueueArn = software.amazon.jsii.Kernel.get(this, "dlqEventQueueArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.eventQueueArn = software.amazon.jsii.Kernel.get(this, "eventQueueArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.exclusions = software.amazon.jsii.Kernel.get(this, "exclusions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.path = software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sampleSize = software.amazon.jsii.Kernel.get(this, "sampleSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.connectionName = builder.connectionName;
                this.dlqEventQueueArn = builder.dlqEventQueueArn;
                this.eventQueueArn = builder.eventQueueArn;
                this.exclusions = builder.exclusions;
                this.path = builder.path;
                this.sampleSize = builder.sampleSize;
            }

            @Override
            public final java.lang.String getConnectionName() {
                return this.connectionName;
            }

            @Override
            public final java.lang.String getDlqEventQueueArn() {
                return this.dlqEventQueueArn;
            }

            @Override
            public final java.lang.String getEventQueueArn() {
                return this.eventQueueArn;
            }

            @Override
            public final java.util.List<java.lang.String> getExclusions() {
                return this.exclusions;
            }

            @Override
            public final java.lang.String getPath() {
                return this.path;
            }

            @Override
            public final java.lang.Number getSampleSize() {
                return this.sampleSize;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getConnectionName() != null) {
                    data.set("connectionName", om.valueToTree(this.getConnectionName()));
                }
                if (this.getDlqEventQueueArn() != null) {
                    data.set("dlqEventQueueArn", om.valueToTree(this.getDlqEventQueueArn()));
                }
                if (this.getEventQueueArn() != null) {
                    data.set("eventQueueArn", om.valueToTree(this.getEventQueueArn()));
                }
                if (this.getExclusions() != null) {
                    data.set("exclusions", om.valueToTree(this.getExclusions()));
                }
                if (this.getPath() != null) {
                    data.set("path", om.valueToTree(this.getPath()));
                }
                if (this.getSampleSize() != null) {
                    data.set("sampleSize", om.valueToTree(this.getSampleSize()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_glue.CfnCrawler.S3TargetProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3TargetProperty.Jsii$Proxy that = (S3TargetProperty.Jsii$Proxy) o;

                if (this.connectionName != null ? !this.connectionName.equals(that.connectionName) : that.connectionName != null) return false;
                if (this.dlqEventQueueArn != null ? !this.dlqEventQueueArn.equals(that.dlqEventQueueArn) : that.dlqEventQueueArn != null) return false;
                if (this.eventQueueArn != null ? !this.eventQueueArn.equals(that.eventQueueArn) : that.eventQueueArn != null) return false;
                if (this.exclusions != null ? !this.exclusions.equals(that.exclusions) : that.exclusions != null) return false;
                if (this.path != null ? !this.path.equals(that.path) : that.path != null) return false;
                return this.sampleSize != null ? this.sampleSize.equals(that.sampleSize) : that.sampleSize == null;
            }

            @Override
            public final int hashCode() {
                int result = this.connectionName != null ? this.connectionName.hashCode() : 0;
                result = 31 * result + (this.dlqEventQueueArn != null ? this.dlqEventQueueArn.hashCode() : 0);
                result = 31 * result + (this.eventQueueArn != null ? this.eventQueueArn.hashCode() : 0);
                result = 31 * result + (this.exclusions != null ? this.exclusions.hashCode() : 0);
                result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
                result = 31 * result + (this.sampleSize != null ? this.sampleSize.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A scheduling object using a `cron` statement to schedule an event.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.glue.*;
     * ScheduleProperty scheduleProperty = ScheduleProperty.builder()
     *         .scheduleExpression("scheduleExpression")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_glue.CfnCrawler.ScheduleProperty")
    @software.amazon.jsii.Jsii.Proxy(ScheduleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ScheduleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A `cron` expression used to specify the schedule.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html">Time-Based Schedules for Jobs and Crawlers</a> . For example, to run something every day at 12:15 UTC, specify <code>cron(15 12 * * ? *)</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getScheduleExpression() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ScheduleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScheduleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ScheduleProperty> {
            java.lang.String scheduleExpression;

            /**
             * Sets the value of {@link ScheduleProperty#getScheduleExpression}
             * @param scheduleExpression A `cron` expression used to specify the schedule.
             *                           For more information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html">Time-Based Schedules for Jobs and Crawlers</a> . For example, to run something every day at 12:15 UTC, specify <code>cron(15 12 * * ? *)</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scheduleExpression(java.lang.String scheduleExpression) {
                this.scheduleExpression = scheduleExpression;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScheduleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ScheduleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ScheduleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScheduleProperty {
            private final java.lang.String scheduleExpression;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.scheduleExpression = software.amazon.jsii.Kernel.get(this, "scheduleExpression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.scheduleExpression = builder.scheduleExpression;
            }

            @Override
            public final java.lang.String getScheduleExpression() {
                return this.scheduleExpression;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getScheduleExpression() != null) {
                    data.set("scheduleExpression", om.valueToTree(this.getScheduleExpression()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_glue.CfnCrawler.ScheduleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScheduleProperty.Jsii$Proxy that = (ScheduleProperty.Jsii$Proxy) o;

                return this.scheduleExpression != null ? this.scheduleExpression.equals(that.scheduleExpression) : that.scheduleExpression == null;
            }

            @Override
            public final int hashCode() {
                int result = this.scheduleExpression != null ? this.scheduleExpression.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The policy that specifies update and delete behaviors for the crawler.
     * <p>
     * The policy tells the crawler what to do in the event that it detects a change in a table that already exists in the customer's database at the time of the crawl. The <code>SchemaChangePolicy</code> does not affect whether or how new tables and partitions are added. New tables and partitions are always created regardless of the <code>SchemaChangePolicy</code> on a crawler.
     * <p>
     * The SchemaChangePolicy consists of two components, <code>UpdateBehavior</code> and <code>DeleteBehavior</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.glue.*;
     * SchemaChangePolicyProperty schemaChangePolicyProperty = SchemaChangePolicyProperty.builder()
     *         .deleteBehavior("deleteBehavior")
     *         .updateBehavior("updateBehavior")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_glue.CfnCrawler.SchemaChangePolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(SchemaChangePolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SchemaChangePolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The deletion behavior when the crawler finds a deleted object.
         * <p>
         * A value of <code>LOG</code> specifies that if a table or partition is found to no longer exist, do not delete it, only log that it was found to no longer exist.
         * <p>
         * A value of <code>DELETE_FROM_DATABASE</code> specifies that if a table or partition is found to have been removed, delete it from the database.
         * <p>
         * A value of <code>DEPRECATE_IN_DATABASE</code> specifies that if a table has been found to no longer exist, to add a property to the table that says "DEPRECATED" and includes a timestamp with the time of deprecation.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDeleteBehavior() {
            return null;
        }

        /**
         * The update behavior when the crawler finds a changed schema.
         * <p>
         * A value of <code>LOG</code> specifies that if a table or a partition already exists, and a change is detected, do not update it, only log that a change was detected. Add new tables and new partitions (including on existing tables).
         * <p>
         * A value of <code>UPDATE_IN_DATABASE</code> specifies that if a table or partition already exists, and a change is detected, update it. Add new tables and partitions.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUpdateBehavior() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SchemaChangePolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SchemaChangePolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SchemaChangePolicyProperty> {
            java.lang.String deleteBehavior;
            java.lang.String updateBehavior;

            /**
             * Sets the value of {@link SchemaChangePolicyProperty#getDeleteBehavior}
             * @param deleteBehavior The deletion behavior when the crawler finds a deleted object.
             *                       A value of <code>LOG</code> specifies that if a table or partition is found to no longer exist, do not delete it, only log that it was found to no longer exist.
             *                       <p>
             *                       A value of <code>DELETE_FROM_DATABASE</code> specifies that if a table or partition is found to have been removed, delete it from the database.
             *                       <p>
             *                       A value of <code>DEPRECATE_IN_DATABASE</code> specifies that if a table has been found to no longer exist, to add a property to the table that says "DEPRECATED" and includes a timestamp with the time of deprecation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deleteBehavior(java.lang.String deleteBehavior) {
                this.deleteBehavior = deleteBehavior;
                return this;
            }

            /**
             * Sets the value of {@link SchemaChangePolicyProperty#getUpdateBehavior}
             * @param updateBehavior The update behavior when the crawler finds a changed schema.
             *                       A value of <code>LOG</code> specifies that if a table or a partition already exists, and a change is detected, do not update it, only log that a change was detected. Add new tables and new partitions (including on existing tables).
             *                       <p>
             *                       A value of <code>UPDATE_IN_DATABASE</code> specifies that if a table or partition already exists, and a change is detected, update it. Add new tables and partitions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder updateBehavior(java.lang.String updateBehavior) {
                this.updateBehavior = updateBehavior;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SchemaChangePolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SchemaChangePolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SchemaChangePolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SchemaChangePolicyProperty {
            private final java.lang.String deleteBehavior;
            private final java.lang.String updateBehavior;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.deleteBehavior = software.amazon.jsii.Kernel.get(this, "deleteBehavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.updateBehavior = software.amazon.jsii.Kernel.get(this, "updateBehavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.deleteBehavior = builder.deleteBehavior;
                this.updateBehavior = builder.updateBehavior;
            }

            @Override
            public final java.lang.String getDeleteBehavior() {
                return this.deleteBehavior;
            }

            @Override
            public final java.lang.String getUpdateBehavior() {
                return this.updateBehavior;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDeleteBehavior() != null) {
                    data.set("deleteBehavior", om.valueToTree(this.getDeleteBehavior()));
                }
                if (this.getUpdateBehavior() != null) {
                    data.set("updateBehavior", om.valueToTree(this.getUpdateBehavior()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_glue.CfnCrawler.SchemaChangePolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SchemaChangePolicyProperty.Jsii$Proxy that = (SchemaChangePolicyProperty.Jsii$Proxy) o;

                if (this.deleteBehavior != null ? !this.deleteBehavior.equals(that.deleteBehavior) : that.deleteBehavior != null) return false;
                return this.updateBehavior != null ? this.updateBehavior.equals(that.updateBehavior) : that.updateBehavior == null;
            }

            @Override
            public final int hashCode() {
                int result = this.deleteBehavior != null ? this.deleteBehavior.hashCode() : 0;
                result = 31 * result + (this.updateBehavior != null ? this.updateBehavior.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies data stores to crawl.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.glue.*;
     * TargetsProperty targetsProperty = TargetsProperty.builder()
     *         .catalogTargets(List.of(CatalogTargetProperty.builder()
     *                 .databaseName("databaseName")
     *                 .tables(List.of("tables"))
     *                 .build()))
     *         .dynamoDbTargets(List.of(DynamoDBTargetProperty.builder()
     *                 .path("path")
     *                 .build()))
     *         .jdbcTargets(List.of(JdbcTargetProperty.builder()
     *                 .connectionName("connectionName")
     *                 .exclusions(List.of("exclusions"))
     *                 .path("path")
     *                 .build()))
     *         .mongoDbTargets(List.of(MongoDBTargetProperty.builder()
     *                 .connectionName("connectionName")
     *                 .path("path")
     *                 .build()))
     *         .s3Targets(List.of(S3TargetProperty.builder()
     *                 .connectionName("connectionName")
     *                 .dlqEventQueueArn("dlqEventQueueArn")
     *                 .eventQueueArn("eventQueueArn")
     *                 .exclusions(List.of("exclusions"))
     *                 .path("path")
     *                 .sampleSize(123)
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_glue.CfnCrawler.TargetsProperty")
    @software.amazon.jsii.Jsii.Proxy(TargetsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TargetsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies AWS Glue Data Catalog targets.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCatalogTargets() {
            return null;
        }

        /**
         * Specifies Amazon DynamoDB targets.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDynamoDbTargets() {
            return null;
        }

        /**
         * Specifies JDBC targets.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getJdbcTargets() {
            return null;
        }

        /**
         * A list of Mongo DB targets.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMongoDbTargets() {
            return null;
        }

        /**
         * Specifies Amazon Simple Storage Service (Amazon S3) targets.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3Targets() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TargetsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TargetsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TargetsProperty> {
            java.lang.Object catalogTargets;
            java.lang.Object dynamoDbTargets;
            java.lang.Object jdbcTargets;
            java.lang.Object mongoDbTargets;
            java.lang.Object s3Targets;

            /**
             * Sets the value of {@link TargetsProperty#getCatalogTargets}
             * @param catalogTargets Specifies AWS Glue Data Catalog targets.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder catalogTargets(software.amazon.awscdk.core.IResolvable catalogTargets) {
                this.catalogTargets = catalogTargets;
                return this;
            }

            /**
             * Sets the value of {@link TargetsProperty#getCatalogTargets}
             * @param catalogTargets Specifies AWS Glue Data Catalog targets.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder catalogTargets(java.util.List<? extends java.lang.Object> catalogTargets) {
                this.catalogTargets = catalogTargets;
                return this;
            }

            /**
             * Sets the value of {@link TargetsProperty#getDynamoDbTargets}
             * @param dynamoDbTargets Specifies Amazon DynamoDB targets.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dynamoDbTargets(software.amazon.awscdk.core.IResolvable dynamoDbTargets) {
                this.dynamoDbTargets = dynamoDbTargets;
                return this;
            }

            /**
             * Sets the value of {@link TargetsProperty#getDynamoDbTargets}
             * @param dynamoDbTargets Specifies Amazon DynamoDB targets.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dynamoDbTargets(java.util.List<? extends java.lang.Object> dynamoDbTargets) {
                this.dynamoDbTargets = dynamoDbTargets;
                return this;
            }

            /**
             * Sets the value of {@link TargetsProperty#getJdbcTargets}
             * @param jdbcTargets Specifies JDBC targets.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jdbcTargets(software.amazon.awscdk.core.IResolvable jdbcTargets) {
                this.jdbcTargets = jdbcTargets;
                return this;
            }

            /**
             * Sets the value of {@link TargetsProperty#getJdbcTargets}
             * @param jdbcTargets Specifies JDBC targets.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jdbcTargets(java.util.List<? extends java.lang.Object> jdbcTargets) {
                this.jdbcTargets = jdbcTargets;
                return this;
            }

            /**
             * Sets the value of {@link TargetsProperty#getMongoDbTargets}
             * @param mongoDbTargets A list of Mongo DB targets.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mongoDbTargets(software.amazon.awscdk.core.IResolvable mongoDbTargets) {
                this.mongoDbTargets = mongoDbTargets;
                return this;
            }

            /**
             * Sets the value of {@link TargetsProperty#getMongoDbTargets}
             * @param mongoDbTargets A list of Mongo DB targets.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mongoDbTargets(java.util.List<? extends java.lang.Object> mongoDbTargets) {
                this.mongoDbTargets = mongoDbTargets;
                return this;
            }

            /**
             * Sets the value of {@link TargetsProperty#getS3Targets}
             * @param s3Targets Specifies Amazon Simple Storage Service (Amazon S3) targets.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Targets(software.amazon.awscdk.core.IResolvable s3Targets) {
                this.s3Targets = s3Targets;
                return this;
            }

            /**
             * Sets the value of {@link TargetsProperty#getS3Targets}
             * @param s3Targets Specifies Amazon Simple Storage Service (Amazon S3) targets.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Targets(java.util.List<? extends java.lang.Object> s3Targets) {
                this.s3Targets = s3Targets;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TargetsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TargetsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TargetsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TargetsProperty {
            private final java.lang.Object catalogTargets;
            private final java.lang.Object dynamoDbTargets;
            private final java.lang.Object jdbcTargets;
            private final java.lang.Object mongoDbTargets;
            private final java.lang.Object s3Targets;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.catalogTargets = software.amazon.jsii.Kernel.get(this, "catalogTargets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dynamoDbTargets = software.amazon.jsii.Kernel.get(this, "dynamoDbTargets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.jdbcTargets = software.amazon.jsii.Kernel.get(this, "jdbcTargets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.mongoDbTargets = software.amazon.jsii.Kernel.get(this, "mongoDbTargets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.s3Targets = software.amazon.jsii.Kernel.get(this, "s3Targets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.catalogTargets = builder.catalogTargets;
                this.dynamoDbTargets = builder.dynamoDbTargets;
                this.jdbcTargets = builder.jdbcTargets;
                this.mongoDbTargets = builder.mongoDbTargets;
                this.s3Targets = builder.s3Targets;
            }

            @Override
            public final java.lang.Object getCatalogTargets() {
                return this.catalogTargets;
            }

            @Override
            public final java.lang.Object getDynamoDbTargets() {
                return this.dynamoDbTargets;
            }

            @Override
            public final java.lang.Object getJdbcTargets() {
                return this.jdbcTargets;
            }

            @Override
            public final java.lang.Object getMongoDbTargets() {
                return this.mongoDbTargets;
            }

            @Override
            public final java.lang.Object getS3Targets() {
                return this.s3Targets;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCatalogTargets() != null) {
                    data.set("catalogTargets", om.valueToTree(this.getCatalogTargets()));
                }
                if (this.getDynamoDbTargets() != null) {
                    data.set("dynamoDbTargets", om.valueToTree(this.getDynamoDbTargets()));
                }
                if (this.getJdbcTargets() != null) {
                    data.set("jdbcTargets", om.valueToTree(this.getJdbcTargets()));
                }
                if (this.getMongoDbTargets() != null) {
                    data.set("mongoDbTargets", om.valueToTree(this.getMongoDbTargets()));
                }
                if (this.getS3Targets() != null) {
                    data.set("s3Targets", om.valueToTree(this.getS3Targets()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_glue.CfnCrawler.TargetsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TargetsProperty.Jsii$Proxy that = (TargetsProperty.Jsii$Proxy) o;

                if (this.catalogTargets != null ? !this.catalogTargets.equals(that.catalogTargets) : that.catalogTargets != null) return false;
                if (this.dynamoDbTargets != null ? !this.dynamoDbTargets.equals(that.dynamoDbTargets) : that.dynamoDbTargets != null) return false;
                if (this.jdbcTargets != null ? !this.jdbcTargets.equals(that.jdbcTargets) : that.jdbcTargets != null) return false;
                if (this.mongoDbTargets != null ? !this.mongoDbTargets.equals(that.mongoDbTargets) : that.mongoDbTargets != null) return false;
                return this.s3Targets != null ? this.s3Targets.equals(that.s3Targets) : that.s3Targets == null;
            }

            @Override
            public final int hashCode() {
                int result = this.catalogTargets != null ? this.catalogTargets.hashCode() : 0;
                result = 31 * result + (this.dynamoDbTargets != null ? this.dynamoDbTargets.hashCode() : 0);
                result = 31 * result + (this.jdbcTargets != null ? this.jdbcTargets.hashCode() : 0);
                result = 31 * result + (this.mongoDbTargets != null ? this.mongoDbTargets.hashCode() : 0);
                result = 31 * result + (this.s3Targets != null ? this.s3Targets.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.glue.CfnCrawler}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.glue.CfnCrawler> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.glue.CfnCrawlerProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.glue.CfnCrawlerProps.Builder();
        }

        /**
         * The Amazon Resource Name (ARN) of an IAM role that's used to access customer resources, such as Amazon Simple Storage Service (Amazon S3) data.
         * <p>
         * @return {@code this}
         * @param role The Amazon Resource Name (ARN) of an IAM role that's used to access customer resources, such as Amazon Simple Storage Service (Amazon S3) data. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(final java.lang.String role) {
            this.props.role(role);
            return this;
        }

        /**
         * A collection of targets to crawl.
         * <p>
         * @return {@code this}
         * @param targets A collection of targets to crawl. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targets(final software.amazon.awscdk.services.glue.CfnCrawler.TargetsProperty targets) {
            this.props.targets(targets);
            return this;
        }
        /**
         * A collection of targets to crawl.
         * <p>
         * @return {@code this}
         * @param targets A collection of targets to crawl. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targets(final software.amazon.awscdk.core.IResolvable targets) {
            this.props.targets(targets);
            return this;
        }

        /**
         * A list of UTF-8 strings that specify the names of custom classifiers that are associated with the crawler.
         * <p>
         * @return {@code this}
         * @param classifiers A list of UTF-8 strings that specify the names of custom classifiers that are associated with the crawler. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder classifiers(final java.util.List<java.lang.String> classifiers) {
            this.props.classifiers(classifiers);
            return this;
        }

        /**
         * Crawler configuration information.
         * <p>
         * This versioned JSON string allows users to specify aspects of a crawler's behavior. For more information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/crawler-configuration.html">Configuring a Crawler</a> .
         * <p>
         * @return {@code this}
         * @param configuration Crawler configuration information. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(final java.lang.String configuration) {
            this.props.configuration(configuration);
            return this;
        }

        /**
         * The name of the `SecurityConfiguration` structure to be used by this crawler.
         * <p>
         * @return {@code this}
         * @param crawlerSecurityConfiguration The name of the `SecurityConfiguration` structure to be used by this crawler. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder crawlerSecurityConfiguration(final java.lang.String crawlerSecurityConfiguration) {
            this.props.crawlerSecurityConfiguration(crawlerSecurityConfiguration);
            return this;
        }

        /**
         * The name of the database in which the crawler's output is stored.
         * <p>
         * @return {@code this}
         * @param databaseName The name of the database in which the crawler's output is stored. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder databaseName(final java.lang.String databaseName) {
            this.props.databaseName(databaseName);
            return this;
        }

        /**
         * A description of the crawler.
         * <p>
         * @return {@code this}
         * @param description A description of the crawler. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The name of the crawler.
         * <p>
         * @return {@code this}
         * @param name The name of the crawler. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * A policy that specifies whether to crawl the entire dataset again, or to crawl only folders that were added since the last crawler run.
         * <p>
         * @return {@code this}
         * @param recrawlPolicy A policy that specifies whether to crawl the entire dataset again, or to crawl only folders that were added since the last crawler run. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recrawlPolicy(final software.amazon.awscdk.services.glue.CfnCrawler.RecrawlPolicyProperty recrawlPolicy) {
            this.props.recrawlPolicy(recrawlPolicy);
            return this;
        }
        /**
         * A policy that specifies whether to crawl the entire dataset again, or to crawl only folders that were added since the last crawler run.
         * <p>
         * @return {@code this}
         * @param recrawlPolicy A policy that specifies whether to crawl the entire dataset again, or to crawl only folders that were added since the last crawler run. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recrawlPolicy(final software.amazon.awscdk.core.IResolvable recrawlPolicy) {
            this.props.recrawlPolicy(recrawlPolicy);
            return this;
        }

        /**
         * For scheduled crawlers, the schedule when the crawler runs.
         * <p>
         * @return {@code this}
         * @param schedule For scheduled crawlers, the schedule when the crawler runs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedule(final software.amazon.awscdk.services.glue.CfnCrawler.ScheduleProperty schedule) {
            this.props.schedule(schedule);
            return this;
        }
        /**
         * For scheduled crawlers, the schedule when the crawler runs.
         * <p>
         * @return {@code this}
         * @param schedule For scheduled crawlers, the schedule when the crawler runs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedule(final software.amazon.awscdk.core.IResolvable schedule) {
            this.props.schedule(schedule);
            return this;
        }

        /**
         * The policy that specifies update and delete behaviors for the crawler.
         * <p>
         * The policy tells the crawler what to do in the event that it detects a change in a table that already exists in the customer's database at the time of the crawl. The <code>SchemaChangePolicy</code> does not affect whether or how new tables and partitions are added. New tables and partitions are always created regardless of the <code>SchemaChangePolicy</code> on a crawler.
         * <p>
         * The SchemaChangePolicy consists of two components, <code>UpdateBehavior</code> and <code>DeleteBehavior</code> .
         * <p>
         * @return {@code this}
         * @param schemaChangePolicy The policy that specifies update and delete behaviors for the crawler. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schemaChangePolicy(final software.amazon.awscdk.services.glue.CfnCrawler.SchemaChangePolicyProperty schemaChangePolicy) {
            this.props.schemaChangePolicy(schemaChangePolicy);
            return this;
        }
        /**
         * The policy that specifies update and delete behaviors for the crawler.
         * <p>
         * The policy tells the crawler what to do in the event that it detects a change in a table that already exists in the customer's database at the time of the crawl. The <code>SchemaChangePolicy</code> does not affect whether or how new tables and partitions are added. New tables and partitions are always created regardless of the <code>SchemaChangePolicy</code> on a crawler.
         * <p>
         * The SchemaChangePolicy consists of two components, <code>UpdateBehavior</code> and <code>DeleteBehavior</code> .
         * <p>
         * @return {@code this}
         * @param schemaChangePolicy The policy that specifies update and delete behaviors for the crawler. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schemaChangePolicy(final software.amazon.awscdk.core.IResolvable schemaChangePolicy) {
            this.props.schemaChangePolicy(schemaChangePolicy);
            return this;
        }

        /**
         * The prefix added to the names of tables that are created.
         * <p>
         * @return {@code this}
         * @param tablePrefix The prefix added to the names of tables that are created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tablePrefix(final java.lang.String tablePrefix) {
            this.props.tablePrefix(tablePrefix);
            return this;
        }

        /**
         * The tags to use with this crawler.
         * <p>
         * @return {@code this}
         * @param tags The tags to use with this crawler. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.lang.Object tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.glue.CfnCrawler}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.glue.CfnCrawler build() {
            return new software.amazon.awscdk.services.glue.CfnCrawler(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
