package software.amazon.awscdk.services.glue;

/**
 * (experimental) Properties for enabling Continuous Logging for Glue Jobs.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.glue.*;
 * import software.amazon.awscdk.services.logs.*;
 * LogGroup logGroup;
 * ContinuousLoggingProps continuousLoggingProps = ContinuousLoggingProps.builder()
 *         .enabled(false)
 *         // the properties below are optional
 *         .conversionPattern("conversionPattern")
 *         .logGroup(logGroup)
 *         .logStreamPrefix("logStreamPrefix")
 *         .quiet(false)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html">https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:02.593Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_glue.ContinuousLoggingProps")
@software.amazon.jsii.Jsii.Proxy(ContinuousLoggingProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface ContinuousLoggingProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) Enable continouous logging.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.Boolean getEnabled();

    /**
     * (experimental) Apply the provided conversion pattern.
     * <p>
     * This is a Log4j Conversion Pattern to customize driver and executor logs.
     * <p>
     * Default: `%d{yy/MM/dd HH:mm:ss} %p %c{1}: %m%n`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getConversionPattern() {
        return null;
    }

    /**
     * (experimental) Specify a custom CloudWatch log group name.
     * <p>
     * Default: - a log group is created with name `/aws-glue/jobs/logs-v2/`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.ILogGroup getLogGroup() {
        return null;
    }

    /**
     * (experimental) Specify a custom CloudWatch log stream prefix.
     * <p>
     * Default: - the job run ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getLogStreamPrefix() {
        return null;
    }

    /**
     * (experimental) Filter out non-useful Apache Spark driver/executor and Apache Hadoop YARN heartbeat log messages.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getQuiet() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ContinuousLoggingProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ContinuousLoggingProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<ContinuousLoggingProps> {
        java.lang.Boolean enabled;
        java.lang.String conversionPattern;
        software.amazon.awscdk.services.logs.ILogGroup logGroup;
        java.lang.String logStreamPrefix;
        java.lang.Boolean quiet;

        /**
         * Sets the value of {@link ContinuousLoggingProps#getEnabled}
         * @param enabled Enable continouous logging. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder enabled(java.lang.Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * Sets the value of {@link ContinuousLoggingProps#getConversionPattern}
         * @param conversionPattern Apply the provided conversion pattern.
         *                          This is a Log4j Conversion Pattern to customize driver and executor logs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder conversionPattern(java.lang.String conversionPattern) {
            this.conversionPattern = conversionPattern;
            return this;
        }

        /**
         * Sets the value of {@link ContinuousLoggingProps#getLogGroup}
         * @param logGroup Specify a custom CloudWatch log group name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder logGroup(software.amazon.awscdk.services.logs.ILogGroup logGroup) {
            this.logGroup = logGroup;
            return this;
        }

        /**
         * Sets the value of {@link ContinuousLoggingProps#getLogStreamPrefix}
         * @param logStreamPrefix Specify a custom CloudWatch log stream prefix.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder logStreamPrefix(java.lang.String logStreamPrefix) {
            this.logStreamPrefix = logStreamPrefix;
            return this;
        }

        /**
         * Sets the value of {@link ContinuousLoggingProps#getQuiet}
         * @param quiet Filter out non-useful Apache Spark driver/executor and Apache Hadoop YARN heartbeat log messages.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder quiet(java.lang.Boolean quiet) {
            this.quiet = quiet;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ContinuousLoggingProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public ContinuousLoggingProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ContinuousLoggingProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ContinuousLoggingProps {
        private final java.lang.Boolean enabled;
        private final java.lang.String conversionPattern;
        private final software.amazon.awscdk.services.logs.ILogGroup logGroup;
        private final java.lang.String logStreamPrefix;
        private final java.lang.Boolean quiet;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.conversionPattern = software.amazon.jsii.Kernel.get(this, "conversionPattern", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.logGroup = software.amazon.jsii.Kernel.get(this, "logGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.ILogGroup.class));
            this.logStreamPrefix = software.amazon.jsii.Kernel.get(this, "logStreamPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.quiet = software.amazon.jsii.Kernel.get(this, "quiet", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.enabled = java.util.Objects.requireNonNull(builder.enabled, "enabled is required");
            this.conversionPattern = builder.conversionPattern;
            this.logGroup = builder.logGroup;
            this.logStreamPrefix = builder.logStreamPrefix;
            this.quiet = builder.quiet;
        }

        @Override
        public final java.lang.Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final java.lang.String getConversionPattern() {
            return this.conversionPattern;
        }

        @Override
        public final software.amazon.awscdk.services.logs.ILogGroup getLogGroup() {
            return this.logGroup;
        }

        @Override
        public final java.lang.String getLogStreamPrefix() {
            return this.logStreamPrefix;
        }

        @Override
        public final java.lang.Boolean getQuiet() {
            return this.quiet;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("enabled", om.valueToTree(this.getEnabled()));
            if (this.getConversionPattern() != null) {
                data.set("conversionPattern", om.valueToTree(this.getConversionPattern()));
            }
            if (this.getLogGroup() != null) {
                data.set("logGroup", om.valueToTree(this.getLogGroup()));
            }
            if (this.getLogStreamPrefix() != null) {
                data.set("logStreamPrefix", om.valueToTree(this.getLogStreamPrefix()));
            }
            if (this.getQuiet() != null) {
                data.set("quiet", om.valueToTree(this.getQuiet()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_glue.ContinuousLoggingProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ContinuousLoggingProps.Jsii$Proxy that = (ContinuousLoggingProps.Jsii$Proxy) o;

            if (!enabled.equals(that.enabled)) return false;
            if (this.conversionPattern != null ? !this.conversionPattern.equals(that.conversionPattern) : that.conversionPattern != null) return false;
            if (this.logGroup != null ? !this.logGroup.equals(that.logGroup) : that.logGroup != null) return false;
            if (this.logStreamPrefix != null ? !this.logStreamPrefix.equals(that.logStreamPrefix) : that.logStreamPrefix != null) return false;
            return this.quiet != null ? this.quiet.equals(that.quiet) : that.quiet == null;
        }

        @Override
        public final int hashCode() {
            int result = this.enabled.hashCode();
            result = 31 * result + (this.conversionPattern != null ? this.conversionPattern.hashCode() : 0);
            result = 31 * result + (this.logGroup != null ? this.logGroup.hashCode() : 0);
            result = 31 * result + (this.logStreamPrefix != null ? this.logStreamPrefix.hashCode() : 0);
            result = 31 * result + (this.quiet != null ? this.quiet.hashCode() : 0);
            return result;
        }
    }
}
