package software.amazon.awscdk.services.glue;

/**
 * (experimental) Encryption mode for Job Bookmarks.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * SecurityConfiguration.Builder.create(this, "MySecurityConfiguration")
 *         .securityConfigurationName("name")
 *         .cloudWatchEncryption(CloudWatchEncryption.builder()
 *                 .mode(CloudWatchEncryptionMode.KMS)
 *                 .build())
 *         .jobBookmarksEncryption(JobBookmarksEncryption.builder()
 *                 .mode(JobBookmarksEncryptionMode.CLIENT_SIDE_KMS)
 *                 .build())
 *         .s3Encryption(S3Encryption.builder()
 *                 .mode(S3EncryptionMode.KMS)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/glue/latest/webapi/API_JobBookmarksEncryption.html#Glue-Type-JobBookmarksEncryption-JobBookmarksEncryptionMode">https://docs.aws.amazon.com/glue/latest/webapi/API_JobBookmarksEncryption.html#Glue-Type-JobBookmarksEncryption-JobBookmarksEncryptionMode</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:02.607Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_glue.JobBookmarksEncryptionMode")
public enum JobBookmarksEncryptionMode {
    /**
     * (experimental) Client-side encryption (CSE) with an AWS KMS key managed by the account owner.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingClientSideEncryption.html">https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingClientSideEncryption.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    CLIENT_SIDE_KMS,
}
