package software.amazon.awscdk.services.grafana;

/**
 * Properties for defining a `CfnWorkspace`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.grafana.*;
 * CfnWorkspaceProps cfnWorkspaceProps = CfnWorkspaceProps.builder()
 *         .accountAccessType("accountAccessType")
 *         .authenticationProviders(List.of("authenticationProviders"))
 *         .clientToken("clientToken")
 *         .dataSources(List.of("dataSources"))
 *         .description("description")
 *         .name("name")
 *         .notificationDestinations(List.of("notificationDestinations"))
 *         .organizationalUnits(List.of("organizationalUnits"))
 *         .organizationRoleName("organizationRoleName")
 *         .permissionType("permissionType")
 *         .roleArn("roleArn")
 *         .samlConfiguration(SamlConfigurationProperty.builder()
 *                 .idpMetadata(IdpMetadataProperty.builder()
 *                         .url("url")
 *                         .xml("xml")
 *                         .build())
 *                 // the properties below are optional
 *                 .allowedOrganizations(List.of("allowedOrganizations"))
 *                 .assertionAttributes(AssertionAttributesProperty.builder()
 *                         .email("email")
 *                         .groups("groups")
 *                         .login("login")
 *                         .name("name")
 *                         .org("org")
 *                         .role("role")
 *                         .build())
 *                 .loginValidityDuration(123)
 *                 .roleValues(RoleValuesProperty.builder()
 *                         .admin(List.of("admin"))
 *                         .editor(List.of("editor"))
 *                         .build())
 *                 .build())
 *         .stackSetName("stackSetName")
 *         .vpcConfiguration(VpcConfigurationProperty.builder()
 *                 .securityGroupIds(List.of("securityGroupIds"))
 *                 .subnetIds(List.of("subnetIds"))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:02.662Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_grafana.CfnWorkspaceProps")
@software.amazon.jsii.Jsii.Proxy(CfnWorkspaceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnWorkspaceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specifies whether the workspace can access AWS resources in this AWS account only, or whether it can also access AWS resources in other accounts in the same organization.
     * <p>
     * If this is <code>ORGANIZATION</code> , the <code>workspaceOrganizationalUnits</code> parameter specifies which organizational units the workspace can access.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAccountAccessType() {
        return null;
    }

    /**
     * Specifies whether this workspace uses SAML 2.0, AWS IAM Identity Center (successor to AWS Single Sign-On) , or both to authenticate users for using the Grafana console within a workspace. For more information, see [User authentication in Amazon Managed Grafana](https://docs.aws.amazon.com/grafana/latest/userguide/authentication-in-AMG.html) .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAuthenticationProviders() {
        return null;
    }

    /**
     * A unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getClientToken() {
        return null;
    }

    /**
     * Specifies the AWS data sources that have been configured to have IAM roles and permissions created to allow Amazon Managed Grafana to read data from these sources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDataSources() {
        return null;
    }

    /**
     * The user-defined description of the workspace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The name of the workspace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * The AWS notification channels that Amazon Managed Grafana can automatically create IAM roles and permissions for, to allow Amazon Managed Grafana to use these channels.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getNotificationDestinations() {
        return null;
    }

    /**
     * Specifies the organizational units that this workspace is allowed to use data sources from, if this workspace is in an account that is part of an organization.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getOrganizationalUnits() {
        return null;
    }

    /**
     * The name of the IAM role that is used to access resources through Organizations .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getOrganizationRoleName() {
        return null;
    }

    /**
     * If this is `Service Managed` , Amazon Managed Grafana automatically creates the IAM roles and provisions the permissions that the workspace needs to use AWS data sources and notification channels.
     * <p>
     * If this is <code>CUSTOMER_MANAGED</code> , you manage those roles and permissions yourself. If you are creating this workspace in a member account of an organization and that account is not a delegated administrator account, and you want the workspace to access data sources in other AWS accounts in the organization, you must choose <code>CUSTOMER_MANAGED</code> .
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/grafana/latest/userguide/AMG-manage-permissions.html">Amazon Managed Grafana permissions and policies for AWS data sources and notification channels</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPermissionType() {
        return null;
    }

    /**
     * The IAM role that grants permissions to the AWS resources that the workspace will view data from.
     * <p>
     * This role must already exist.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRoleArn() {
        return null;
    }

    /**
     * If the workspace uses SAML, use this structure to map SAML assertion attributes to workspace user information and define which groups in the assertion attribute are to have the `Admin` and `Editor` roles in the workspace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSamlConfiguration() {
        return null;
    }

    /**
     * The name of the AWS CloudFormation stack set that is used to generate IAM roles to be used for this workspace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStackSetName() {
        return null;
    }

    /**
     * The configuration for connecting to data sources in a private VPC ( Amazon Virtual Private Cloud ).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getVpcConfiguration() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnWorkspaceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnWorkspaceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnWorkspaceProps> {
        java.lang.String accountAccessType;
        java.util.List<java.lang.String> authenticationProviders;
        java.lang.String clientToken;
        java.util.List<java.lang.String> dataSources;
        java.lang.String description;
        java.lang.String name;
        java.util.List<java.lang.String> notificationDestinations;
        java.util.List<java.lang.String> organizationalUnits;
        java.lang.String organizationRoleName;
        java.lang.String permissionType;
        java.lang.String roleArn;
        java.lang.Object samlConfiguration;
        java.lang.String stackSetName;
        java.lang.Object vpcConfiguration;

        /**
         * Sets the value of {@link CfnWorkspaceProps#getAccountAccessType}
         * @param accountAccessType Specifies whether the workspace can access AWS resources in this AWS account only, or whether it can also access AWS resources in other accounts in the same organization.
         *                          If this is <code>ORGANIZATION</code> , the <code>workspaceOrganizationalUnits</code> parameter specifies which organizational units the workspace can access.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accountAccessType(java.lang.String accountAccessType) {
            this.accountAccessType = accountAccessType;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkspaceProps#getAuthenticationProviders}
         * @param authenticationProviders Specifies whether this workspace uses SAML 2.0, AWS IAM Identity Center (successor to AWS Single Sign-On) , or both to authenticate users for using the Grafana console within a workspace. For more information, see [User authentication in Amazon Managed Grafana](https://docs.aws.amazon.com/grafana/latest/userguide/authentication-in-AMG.html) .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authenticationProviders(java.util.List<java.lang.String> authenticationProviders) {
            this.authenticationProviders = authenticationProviders;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkspaceProps#getClientToken}
         * @param clientToken A unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientToken(java.lang.String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkspaceProps#getDataSources}
         * @param dataSources Specifies the AWS data sources that have been configured to have IAM roles and permissions created to allow Amazon Managed Grafana to read data from these sources.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataSources(java.util.List<java.lang.String> dataSources) {
            this.dataSources = dataSources;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkspaceProps#getDescription}
         * @param description The user-defined description of the workspace.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkspaceProps#getName}
         * @param name The name of the workspace.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkspaceProps#getNotificationDestinations}
         * @param notificationDestinations The AWS notification channels that Amazon Managed Grafana can automatically create IAM roles and permissions for, to allow Amazon Managed Grafana to use these channels.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationDestinations(java.util.List<java.lang.String> notificationDestinations) {
            this.notificationDestinations = notificationDestinations;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkspaceProps#getOrganizationalUnits}
         * @param organizationalUnits Specifies the organizational units that this workspace is allowed to use data sources from, if this workspace is in an account that is part of an organization.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder organizationalUnits(java.util.List<java.lang.String> organizationalUnits) {
            this.organizationalUnits = organizationalUnits;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkspaceProps#getOrganizationRoleName}
         * @param organizationRoleName The name of the IAM role that is used to access resources through Organizations .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder organizationRoleName(java.lang.String organizationRoleName) {
            this.organizationRoleName = organizationRoleName;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkspaceProps#getPermissionType}
         * @param permissionType If this is `Service Managed` , Amazon Managed Grafana automatically creates the IAM roles and provisions the permissions that the workspace needs to use AWS data sources and notification channels.
         *                       If this is <code>CUSTOMER_MANAGED</code> , you manage those roles and permissions yourself. If you are creating this workspace in a member account of an organization and that account is not a delegated administrator account, and you want the workspace to access data sources in other AWS accounts in the organization, you must choose <code>CUSTOMER_MANAGED</code> .
         *                       <p>
         *                       For more information, see <a href="https://docs.aws.amazon.com/grafana/latest/userguide/AMG-manage-permissions.html">Amazon Managed Grafana permissions and policies for AWS data sources and notification channels</a>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder permissionType(java.lang.String permissionType) {
            this.permissionType = permissionType;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkspaceProps#getRoleArn}
         * @param roleArn The IAM role that grants permissions to the AWS resources that the workspace will view data from.
         *                This role must already exist.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(java.lang.String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkspaceProps#getSamlConfiguration}
         * @param samlConfiguration If the workspace uses SAML, use this structure to map SAML assertion attributes to workspace user information and define which groups in the assertion attribute are to have the `Admin` and `Editor` roles in the workspace.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder samlConfiguration(software.amazon.awscdk.services.grafana.CfnWorkspace.SamlConfigurationProperty samlConfiguration) {
            this.samlConfiguration = samlConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkspaceProps#getSamlConfiguration}
         * @param samlConfiguration If the workspace uses SAML, use this structure to map SAML assertion attributes to workspace user information and define which groups in the assertion attribute are to have the `Admin` and `Editor` roles in the workspace.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder samlConfiguration(software.amazon.awscdk.core.IResolvable samlConfiguration) {
            this.samlConfiguration = samlConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkspaceProps#getStackSetName}
         * @param stackSetName The name of the AWS CloudFormation stack set that is used to generate IAM roles to be used for this workspace.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stackSetName(java.lang.String stackSetName) {
            this.stackSetName = stackSetName;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkspaceProps#getVpcConfiguration}
         * @param vpcConfiguration The configuration for connecting to data sources in a private VPC ( Amazon Virtual Private Cloud ).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcConfiguration(software.amazon.awscdk.services.grafana.CfnWorkspace.VpcConfigurationProperty vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkspaceProps#getVpcConfiguration}
         * @param vpcConfiguration The configuration for connecting to data sources in a private VPC ( Amazon Virtual Private Cloud ).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcConfiguration(software.amazon.awscdk.core.IResolvable vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnWorkspaceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnWorkspaceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnWorkspaceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnWorkspaceProps {
        private final java.lang.String accountAccessType;
        private final java.util.List<java.lang.String> authenticationProviders;
        private final java.lang.String clientToken;
        private final java.util.List<java.lang.String> dataSources;
        private final java.lang.String description;
        private final java.lang.String name;
        private final java.util.List<java.lang.String> notificationDestinations;
        private final java.util.List<java.lang.String> organizationalUnits;
        private final java.lang.String organizationRoleName;
        private final java.lang.String permissionType;
        private final java.lang.String roleArn;
        private final java.lang.Object samlConfiguration;
        private final java.lang.String stackSetName;
        private final java.lang.Object vpcConfiguration;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.accountAccessType = software.amazon.jsii.Kernel.get(this, "accountAccessType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.authenticationProviders = software.amazon.jsii.Kernel.get(this, "authenticationProviders", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.clientToken = software.amazon.jsii.Kernel.get(this, "clientToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dataSources = software.amazon.jsii.Kernel.get(this, "dataSources", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.notificationDestinations = software.amazon.jsii.Kernel.get(this, "notificationDestinations", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.organizationalUnits = software.amazon.jsii.Kernel.get(this, "organizationalUnits", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.organizationRoleName = software.amazon.jsii.Kernel.get(this, "organizationRoleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.permissionType = software.amazon.jsii.Kernel.get(this, "permissionType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.samlConfiguration = software.amazon.jsii.Kernel.get(this, "samlConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.stackSetName = software.amazon.jsii.Kernel.get(this, "stackSetName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.vpcConfiguration = software.amazon.jsii.Kernel.get(this, "vpcConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.accountAccessType = builder.accountAccessType;
            this.authenticationProviders = builder.authenticationProviders;
            this.clientToken = builder.clientToken;
            this.dataSources = builder.dataSources;
            this.description = builder.description;
            this.name = builder.name;
            this.notificationDestinations = builder.notificationDestinations;
            this.organizationalUnits = builder.organizationalUnits;
            this.organizationRoleName = builder.organizationRoleName;
            this.permissionType = builder.permissionType;
            this.roleArn = builder.roleArn;
            this.samlConfiguration = builder.samlConfiguration;
            this.stackSetName = builder.stackSetName;
            this.vpcConfiguration = builder.vpcConfiguration;
        }

        @Override
        public final java.lang.String getAccountAccessType() {
            return this.accountAccessType;
        }

        @Override
        public final java.util.List<java.lang.String> getAuthenticationProviders() {
            return this.authenticationProviders;
        }

        @Override
        public final java.lang.String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final java.util.List<java.lang.String> getDataSources() {
            return this.dataSources;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.util.List<java.lang.String> getNotificationDestinations() {
            return this.notificationDestinations;
        }

        @Override
        public final java.util.List<java.lang.String> getOrganizationalUnits() {
            return this.organizationalUnits;
        }

        @Override
        public final java.lang.String getOrganizationRoleName() {
            return this.organizationRoleName;
        }

        @Override
        public final java.lang.String getPermissionType() {
            return this.permissionType;
        }

        @Override
        public final java.lang.String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final java.lang.Object getSamlConfiguration() {
            return this.samlConfiguration;
        }

        @Override
        public final java.lang.String getStackSetName() {
            return this.stackSetName;
        }

        @Override
        public final java.lang.Object getVpcConfiguration() {
            return this.vpcConfiguration;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAccountAccessType() != null) {
                data.set("accountAccessType", om.valueToTree(this.getAccountAccessType()));
            }
            if (this.getAuthenticationProviders() != null) {
                data.set("authenticationProviders", om.valueToTree(this.getAuthenticationProviders()));
            }
            if (this.getClientToken() != null) {
                data.set("clientToken", om.valueToTree(this.getClientToken()));
            }
            if (this.getDataSources() != null) {
                data.set("dataSources", om.valueToTree(this.getDataSources()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getNotificationDestinations() != null) {
                data.set("notificationDestinations", om.valueToTree(this.getNotificationDestinations()));
            }
            if (this.getOrganizationalUnits() != null) {
                data.set("organizationalUnits", om.valueToTree(this.getOrganizationalUnits()));
            }
            if (this.getOrganizationRoleName() != null) {
                data.set("organizationRoleName", om.valueToTree(this.getOrganizationRoleName()));
            }
            if (this.getPermissionType() != null) {
                data.set("permissionType", om.valueToTree(this.getPermissionType()));
            }
            if (this.getRoleArn() != null) {
                data.set("roleArn", om.valueToTree(this.getRoleArn()));
            }
            if (this.getSamlConfiguration() != null) {
                data.set("samlConfiguration", om.valueToTree(this.getSamlConfiguration()));
            }
            if (this.getStackSetName() != null) {
                data.set("stackSetName", om.valueToTree(this.getStackSetName()));
            }
            if (this.getVpcConfiguration() != null) {
                data.set("vpcConfiguration", om.valueToTree(this.getVpcConfiguration()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_grafana.CfnWorkspaceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnWorkspaceProps.Jsii$Proxy that = (CfnWorkspaceProps.Jsii$Proxy) o;

            if (this.accountAccessType != null ? !this.accountAccessType.equals(that.accountAccessType) : that.accountAccessType != null) return false;
            if (this.authenticationProviders != null ? !this.authenticationProviders.equals(that.authenticationProviders) : that.authenticationProviders != null) return false;
            if (this.clientToken != null ? !this.clientToken.equals(that.clientToken) : that.clientToken != null) return false;
            if (this.dataSources != null ? !this.dataSources.equals(that.dataSources) : that.dataSources != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.notificationDestinations != null ? !this.notificationDestinations.equals(that.notificationDestinations) : that.notificationDestinations != null) return false;
            if (this.organizationalUnits != null ? !this.organizationalUnits.equals(that.organizationalUnits) : that.organizationalUnits != null) return false;
            if (this.organizationRoleName != null ? !this.organizationRoleName.equals(that.organizationRoleName) : that.organizationRoleName != null) return false;
            if (this.permissionType != null ? !this.permissionType.equals(that.permissionType) : that.permissionType != null) return false;
            if (this.roleArn != null ? !this.roleArn.equals(that.roleArn) : that.roleArn != null) return false;
            if (this.samlConfiguration != null ? !this.samlConfiguration.equals(that.samlConfiguration) : that.samlConfiguration != null) return false;
            if (this.stackSetName != null ? !this.stackSetName.equals(that.stackSetName) : that.stackSetName != null) return false;
            return this.vpcConfiguration != null ? this.vpcConfiguration.equals(that.vpcConfiguration) : that.vpcConfiguration == null;
        }

        @Override
        public final int hashCode() {
            int result = this.accountAccessType != null ? this.accountAccessType.hashCode() : 0;
            result = 31 * result + (this.authenticationProviders != null ? this.authenticationProviders.hashCode() : 0);
            result = 31 * result + (this.clientToken != null ? this.clientToken.hashCode() : 0);
            result = 31 * result + (this.dataSources != null ? this.dataSources.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.notificationDestinations != null ? this.notificationDestinations.hashCode() : 0);
            result = 31 * result + (this.organizationalUnits != null ? this.organizationalUnits.hashCode() : 0);
            result = 31 * result + (this.organizationRoleName != null ? this.organizationRoleName.hashCode() : 0);
            result = 31 * result + (this.permissionType != null ? this.permissionType.hashCode() : 0);
            result = 31 * result + (this.roleArn != null ? this.roleArn.hashCode() : 0);
            result = 31 * result + (this.samlConfiguration != null ? this.samlConfiguration.hashCode() : 0);
            result = 31 * result + (this.stackSetName != null ? this.stackSetName.hashCode() : 0);
            result = 31 * result + (this.vpcConfiguration != null ? this.vpcConfiguration.hashCode() : 0);
            return result;
        }
    }
}
