package software.amazon.awscdk.services.iam;

/**
 * (experimental) The Effect element of an IAM policy.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Resource books;
 * User iamUser;
 * Method getBooks = books.addMethod("GET", new HttpIntegration("http://amazon.com"), MethodOptions.builder()
 *         .authorizationType(AuthorizationType.IAM)
 *         .build());
 * iamUser.attachInlinePolicy(Policy.Builder.create(this, "AllowBooks")
 *         .statements(List.of(
 *             PolicyStatement.Builder.create()
 *                     .actions(List.of("execute-api:Invoke"))
 *                     .effect(Effect.ALLOW)
 *                     .resources(List.of(getBooks.getMethodArn()))
 *                     .build()))
 *         .build());
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_effect.html">https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_effect.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:03.087Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_iam.Effect")
public enum Effect {
    /**
     * (experimental) Allows access to a resource in an IAM policy statement.
     * <p>
     * By default, access to resources are denied.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    ALLOW,
    /**
     * (experimental) Explicitly deny access to a resource.
     * <p>
     * By default, all requests are denied implicitly.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html">https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    DENY,
}
