package software.amazon.awscdk.services.iam;

/**
 * (experimental) Options allowing customizing the behavior of {@link Role.fromRoleArn}.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * IRole role = Role.fromRoleArn(this, "Role", "arn:aws:iam::123456789012:role/MyExistingRole", FromRoleArnOptions.builder()
 *         // Set 'mutable' to 'false' to use the role as-is and prevent adding new
 *         // policies to it. The default is 'true', which means the role may be
 *         // modified as part of the deployment.
 *         .mutable(false)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:03.089Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_iam.FromRoleArnOptions")
@software.amazon.jsii.Jsii.Proxy(FromRoleArnOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface FromRoleArnOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) For immutable roles: add grants to resources instead of dropping them.
     * <p>
     * If this is <code>false</code> or not specified, grant permissions added to this role are ignored.
     * It is your own responsibility to make sure the role has the required permissions.
     * <p>
     * If this is <code>true</code>, any grant permissions will be added to the resource instead.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAddGrantsToResources() {
        return null;
    }

    /**
     * (experimental) Whether the imported role can be modified by attaching policy resources to it.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getMutable() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link FromRoleArnOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FromRoleArnOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<FromRoleArnOptions> {
        java.lang.Boolean addGrantsToResources;
        java.lang.Boolean mutable;

        /**
         * Sets the value of {@link FromRoleArnOptions#getAddGrantsToResources}
         * @param addGrantsToResources For immutable roles: add grants to resources instead of dropping them.
         *                             If this is <code>false</code> or not specified, grant permissions added to this role are ignored.
         *                             It is your own responsibility to make sure the role has the required permissions.
         *                             <p>
         *                             If this is <code>true</code>, any grant permissions will be added to the resource instead.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder addGrantsToResources(java.lang.Boolean addGrantsToResources) {
            this.addGrantsToResources = addGrantsToResources;
            return this;
        }

        /**
         * Sets the value of {@link FromRoleArnOptions#getMutable}
         * @param mutable Whether the imported role can be modified by attaching policy resources to it.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder mutable(java.lang.Boolean mutable) {
            this.mutable = mutable;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FromRoleArnOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public FromRoleArnOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link FromRoleArnOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FromRoleArnOptions {
        private final java.lang.Boolean addGrantsToResources;
        private final java.lang.Boolean mutable;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.addGrantsToResources = software.amazon.jsii.Kernel.get(this, "addGrantsToResources", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.mutable = software.amazon.jsii.Kernel.get(this, "mutable", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.addGrantsToResources = builder.addGrantsToResources;
            this.mutable = builder.mutable;
        }

        @Override
        public final java.lang.Boolean getAddGrantsToResources() {
            return this.addGrantsToResources;
        }

        @Override
        public final java.lang.Boolean getMutable() {
            return this.mutable;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAddGrantsToResources() != null) {
                data.set("addGrantsToResources", om.valueToTree(this.getAddGrantsToResources()));
            }
            if (this.getMutable() != null) {
                data.set("mutable", om.valueToTree(this.getMutable()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_iam.FromRoleArnOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FromRoleArnOptions.Jsii$Proxy that = (FromRoleArnOptions.Jsii$Proxy) o;

            if (this.addGrantsToResources != null ? !this.addGrantsToResources.equals(that.addGrantsToResources) : that.addGrantsToResources != null) return false;
            return this.mutable != null ? this.mutable.equals(that.mutable) : that.mutable == null;
        }

        @Override
        public final int hashCode() {
            int result = this.addGrantsToResources != null ? this.addGrantsToResources.hashCode() : 0;
            result = 31 * result + (this.mutable != null ? this.mutable.hashCode() : 0);
            return result;
        }
    }
}
