package software.amazon.awscdk.services.iot;

/**
 * Properties for defining a `CfnCertificate`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iot.*;
 * CfnCertificateProps cfnCertificateProps = CfnCertificateProps.builder()
 *         .status("status")
 *         // the properties below are optional
 *         .caCertificatePem("caCertificatePem")
 *         .certificateMode("certificateMode")
 *         .certificatePem("certificatePem")
 *         .certificateSigningRequest("certificateSigningRequest")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:03.321Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_iot.CfnCertificateProps")
@software.amazon.jsii.Jsii.Proxy(CfnCertificateProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnCertificateProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The status of the certificate.
     * <p>
     * Valid values are ACTIVE, INACTIVE, REVOKED, PENDING_TRANSFER, and PENDING_ACTIVATION.
     * <p>
     * The status value REGISTER_INACTIVE is deprecated and should not be used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStatus();

    /**
     * The CA certificate used to sign the device certificate being registered, not available when CertificateMode is SNI_ONLY.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCaCertificatePem() {
        return null;
    }

    /**
     * Specifies which mode of certificate registration to use with this resource.
     * <p>
     * Valid options are DEFAULT with CaCertificatePem and CertificatePem, SNI_ONLY with CertificatePem, and Default with CertificateSigningRequest.
     * <p>
     * <code>DEFAULT</code> : A certificate in <code>DEFAULT</code> mode is either generated by AWS IoT Core or registered with an issuer certificate authority (CA). Devices with certificates in <code>DEFAULT</code> mode aren't required to send the Server Name Indication (SNI) extension when connecting to AWS IoT Core . However, to use features such as custom domains and VPC endpoints, we recommend that you use the SNI extension when connecting to AWS IoT Core .
     * <p>
     * <code>SNI_ONLY</code> : A certificate in <code>SNI_ONLY</code> mode is registered without an issuer CA. Devices with certificates in <code>SNI_ONLY</code> mode must send the SNI extension when connecting to AWS IoT Core .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCertificateMode() {
        return null;
    }

    /**
     * The certificate data in PEM format.
     * <p>
     * Requires SNI_ONLY for the certificate mode or the accompanying CACertificatePem for registration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCertificatePem() {
        return null;
    }

    /**
     * The certificate signing request (CSR).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCertificateSigningRequest() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnCertificateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnCertificateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnCertificateProps> {
        java.lang.String status;
        java.lang.String caCertificatePem;
        java.lang.String certificateMode;
        java.lang.String certificatePem;
        java.lang.String certificateSigningRequest;

        /**
         * Sets the value of {@link CfnCertificateProps#getStatus}
         * @param status The status of the certificate. This parameter is required.
         *               Valid values are ACTIVE, INACTIVE, REVOKED, PENDING_TRANSFER, and PENDING_ACTIVATION.
         *               <p>
         *               The status value REGISTER_INACTIVE is deprecated and should not be used.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder status(java.lang.String status) {
            this.status = status;
            return this;
        }

        /**
         * Sets the value of {@link CfnCertificateProps#getCaCertificatePem}
         * @param caCertificatePem The CA certificate used to sign the device certificate being registered, not available when CertificateMode is SNI_ONLY.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder caCertificatePem(java.lang.String caCertificatePem) {
            this.caCertificatePem = caCertificatePem;
            return this;
        }

        /**
         * Sets the value of {@link CfnCertificateProps#getCertificateMode}
         * @param certificateMode Specifies which mode of certificate registration to use with this resource.
         *                        Valid options are DEFAULT with CaCertificatePem and CertificatePem, SNI_ONLY with CertificatePem, and Default with CertificateSigningRequest.
         *                        <p>
         *                        <code>DEFAULT</code> : A certificate in <code>DEFAULT</code> mode is either generated by AWS IoT Core or registered with an issuer certificate authority (CA). Devices with certificates in <code>DEFAULT</code> mode aren't required to send the Server Name Indication (SNI) extension when connecting to AWS IoT Core . However, to use features such as custom domains and VPC endpoints, we recommend that you use the SNI extension when connecting to AWS IoT Core .
         *                        <p>
         *                        <code>SNI_ONLY</code> : A certificate in <code>SNI_ONLY</code> mode is registered without an issuer CA. Devices with certificates in <code>SNI_ONLY</code> mode must send the SNI extension when connecting to AWS IoT Core .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificateMode(java.lang.String certificateMode) {
            this.certificateMode = certificateMode;
            return this;
        }

        /**
         * Sets the value of {@link CfnCertificateProps#getCertificatePem}
         * @param certificatePem The certificate data in PEM format.
         *                       Requires SNI_ONLY for the certificate mode or the accompanying CACertificatePem for registration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificatePem(java.lang.String certificatePem) {
            this.certificatePem = certificatePem;
            return this;
        }

        /**
         * Sets the value of {@link CfnCertificateProps#getCertificateSigningRequest}
         * @param certificateSigningRequest The certificate signing request (CSR).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificateSigningRequest(java.lang.String certificateSigningRequest) {
            this.certificateSigningRequest = certificateSigningRequest;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnCertificateProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnCertificateProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnCertificateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnCertificateProps {
        private final java.lang.String status;
        private final java.lang.String caCertificatePem;
        private final java.lang.String certificateMode;
        private final java.lang.String certificatePem;
        private final java.lang.String certificateSigningRequest;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.caCertificatePem = software.amazon.jsii.Kernel.get(this, "caCertificatePem", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.certificateMode = software.amazon.jsii.Kernel.get(this, "certificateMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.certificatePem = software.amazon.jsii.Kernel.get(this, "certificatePem", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.certificateSigningRequest = software.amazon.jsii.Kernel.get(this, "certificateSigningRequest", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.status = java.util.Objects.requireNonNull(builder.status, "status is required");
            this.caCertificatePem = builder.caCertificatePem;
            this.certificateMode = builder.certificateMode;
            this.certificatePem = builder.certificatePem;
            this.certificateSigningRequest = builder.certificateSigningRequest;
        }

        @Override
        public final java.lang.String getStatus() {
            return this.status;
        }

        @Override
        public final java.lang.String getCaCertificatePem() {
            return this.caCertificatePem;
        }

        @Override
        public final java.lang.String getCertificateMode() {
            return this.certificateMode;
        }

        @Override
        public final java.lang.String getCertificatePem() {
            return this.certificatePem;
        }

        @Override
        public final java.lang.String getCertificateSigningRequest() {
            return this.certificateSigningRequest;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("status", om.valueToTree(this.getStatus()));
            if (this.getCaCertificatePem() != null) {
                data.set("caCertificatePem", om.valueToTree(this.getCaCertificatePem()));
            }
            if (this.getCertificateMode() != null) {
                data.set("certificateMode", om.valueToTree(this.getCertificateMode()));
            }
            if (this.getCertificatePem() != null) {
                data.set("certificatePem", om.valueToTree(this.getCertificatePem()));
            }
            if (this.getCertificateSigningRequest() != null) {
                data.set("certificateSigningRequest", om.valueToTree(this.getCertificateSigningRequest()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_iot.CfnCertificateProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnCertificateProps.Jsii$Proxy that = (CfnCertificateProps.Jsii$Proxy) o;

            if (!status.equals(that.status)) return false;
            if (this.caCertificatePem != null ? !this.caCertificatePem.equals(that.caCertificatePem) : that.caCertificatePem != null) return false;
            if (this.certificateMode != null ? !this.certificateMode.equals(that.certificateMode) : that.certificateMode != null) return false;
            if (this.certificatePem != null ? !this.certificatePem.equals(that.certificatePem) : that.certificatePem != null) return false;
            return this.certificateSigningRequest != null ? this.certificateSigningRequest.equals(that.certificateSigningRequest) : that.certificateSigningRequest == null;
        }

        @Override
        public final int hashCode() {
            int result = this.status.hashCode();
            result = 31 * result + (this.caCertificatePem != null ? this.caCertificatePem.hashCode() : 0);
            result = 31 * result + (this.certificateMode != null ? this.certificateMode.hashCode() : 0);
            result = 31 * result + (this.certificatePem != null ? this.certificatePem.hashCode() : 0);
            result = 31 * result + (this.certificateSigningRequest != null ? this.certificateSigningRequest.hashCode() : 0);
            return result;
        }
    }
}
