package software.amazon.awscdk.services.iot;

/**
 * Properties for defining a `CfnDomainConfiguration`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iot.*;
 * CfnDomainConfigurationProps cfnDomainConfigurationProps = CfnDomainConfigurationProps.builder()
 *         .authorizerConfig(AuthorizerConfigProperty.builder()
 *                 .allowAuthorizerOverride(false)
 *                 .defaultAuthorizerName("defaultAuthorizerName")
 *                 .build())
 *         .domainConfigurationName("domainConfigurationName")
 *         .domainConfigurationStatus("domainConfigurationStatus")
 *         .domainName("domainName")
 *         .serverCertificateArns(List.of("serverCertificateArns"))
 *         .serviceType("serviceType")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .validationCertificateArn("validationCertificateArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:03.349Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_iot.CfnDomainConfigurationProps")
@software.amazon.jsii.Jsii.Proxy(CfnDomainConfigurationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDomainConfigurationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * An object that specifies the authorization service for a domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAuthorizerConfig() {
        return null;
    }

    /**
     * The name of the domain configuration.
     * <p>
     * This value must be unique to a region.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDomainConfigurationName() {
        return null;
    }

    /**
     * The status to which the domain configuration should be updated.
     * <p>
     * Valid values: <code>ENABLED</code> | <code>DISABLED</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDomainConfigurationStatus() {
        return null;
    }

    /**
     * The name of the domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDomainName() {
        return null;
    }

    /**
     * The ARNs of the certificates that AWS IoT passes to the device during the TLS handshake.
     * <p>
     * Currently you can specify only one certificate ARN. This value is not required for AWS -managed domains.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getServerCertificateArns() {
        return null;
    }

    /**
     * The type of service delivered by the endpoint.
     * <p>
     * <blockquote>
     * <p>
     * AWS IoT Core currently supports only the <code>DATA</code> service type.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getServiceType() {
        return null;
    }

    /**
     * Metadata which can be used to manage the domain configuration.
     * <p>
     * <blockquote>
     * <p>
     * For URI Request parameters use format: ...key1=value1&amp;key2=value2...
     * <p>
     * For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."
     * <p>
     * For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
        return null;
    }

    /**
     * The certificate used to validate the server certificate and prove domain name ownership.
     * <p>
     * This certificate must be signed by a public certificate authority. This value is not required for AWS -managed domains.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getValidationCertificateArn() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDomainConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDomainConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDomainConfigurationProps> {
        java.lang.Object authorizerConfig;
        java.lang.String domainConfigurationName;
        java.lang.String domainConfigurationStatus;
        java.lang.String domainName;
        java.util.List<java.lang.String> serverCertificateArns;
        java.lang.String serviceType;
        java.util.List<software.amazon.awscdk.core.CfnTag> tags;
        java.lang.String validationCertificateArn;

        /**
         * Sets the value of {@link CfnDomainConfigurationProps#getAuthorizerConfig}
         * @param authorizerConfig An object that specifies the authorization service for a domain.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizerConfig(software.amazon.awscdk.services.iot.CfnDomainConfiguration.AuthorizerConfigProperty authorizerConfig) {
            this.authorizerConfig = authorizerConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainConfigurationProps#getAuthorizerConfig}
         * @param authorizerConfig An object that specifies the authorization service for a domain.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizerConfig(software.amazon.awscdk.core.IResolvable authorizerConfig) {
            this.authorizerConfig = authorizerConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainConfigurationProps#getDomainConfigurationName}
         * @param domainConfigurationName The name of the domain configuration.
         *                                This value must be unique to a region.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainConfigurationName(java.lang.String domainConfigurationName) {
            this.domainConfigurationName = domainConfigurationName;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainConfigurationProps#getDomainConfigurationStatus}
         * @param domainConfigurationStatus The status to which the domain configuration should be updated.
         *                                  Valid values: <code>ENABLED</code> | <code>DISABLED</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainConfigurationStatus(java.lang.String domainConfigurationStatus) {
            this.domainConfigurationStatus = domainConfigurationStatus;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainConfigurationProps#getDomainName}
         * @param domainName The name of the domain.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(java.lang.String domainName) {
            this.domainName = domainName;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainConfigurationProps#getServerCertificateArns}
         * @param serverCertificateArns The ARNs of the certificates that AWS IoT passes to the device during the TLS handshake.
         *                              Currently you can specify only one certificate ARN. This value is not required for AWS -managed domains.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverCertificateArns(java.util.List<java.lang.String> serverCertificateArns) {
            this.serverCertificateArns = serverCertificateArns;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainConfigurationProps#getServiceType}
         * @param serviceType The type of service delivered by the endpoint.
         *                    <blockquote>
         *                    <p>
         *                    AWS IoT Core currently supports only the <code>DATA</code> service type.
         *                    <p>
         *                    </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceType(java.lang.String serviceType) {
            this.serviceType = serviceType;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainConfigurationProps#getTags}
         * @param tags Metadata which can be used to manage the domain configuration.
         *             <blockquote>
         *             <p>
         *             For URI Request parameters use format: ...key1=value1&amp;key2=value2...
         *             <p>
         *             For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."
         *             <p>
         *             For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."
         *             <p>
         *             </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainConfigurationProps#getValidationCertificateArn}
         * @param validationCertificateArn The certificate used to validate the server certificate and prove domain name ownership.
         *                                 This certificate must be signed by a public certificate authority. This value is not required for AWS -managed domains.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validationCertificateArn(java.lang.String validationCertificateArn) {
            this.validationCertificateArn = validationCertificateArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDomainConfigurationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDomainConfigurationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDomainConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDomainConfigurationProps {
        private final java.lang.Object authorizerConfig;
        private final java.lang.String domainConfigurationName;
        private final java.lang.String domainConfigurationStatus;
        private final java.lang.String domainName;
        private final java.util.List<java.lang.String> serverCertificateArns;
        private final java.lang.String serviceType;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;
        private final java.lang.String validationCertificateArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.authorizerConfig = software.amazon.jsii.Kernel.get(this, "authorizerConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.domainConfigurationName = software.amazon.jsii.Kernel.get(this, "domainConfigurationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.domainConfigurationStatus = software.amazon.jsii.Kernel.get(this, "domainConfigurationStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.domainName = software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.serverCertificateArns = software.amazon.jsii.Kernel.get(this, "serverCertificateArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.serviceType = software.amazon.jsii.Kernel.get(this, "serviceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
            this.validationCertificateArn = software.amazon.jsii.Kernel.get(this, "validationCertificateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.authorizerConfig = builder.authorizerConfig;
            this.domainConfigurationName = builder.domainConfigurationName;
            this.domainConfigurationStatus = builder.domainConfigurationStatus;
            this.domainName = builder.domainName;
            this.serverCertificateArns = builder.serverCertificateArns;
            this.serviceType = builder.serviceType;
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)builder.tags;
            this.validationCertificateArn = builder.validationCertificateArn;
        }

        @Override
        public final java.lang.Object getAuthorizerConfig() {
            return this.authorizerConfig;
        }

        @Override
        public final java.lang.String getDomainConfigurationName() {
            return this.domainConfigurationName;
        }

        @Override
        public final java.lang.String getDomainConfigurationStatus() {
            return this.domainConfigurationStatus;
        }

        @Override
        public final java.lang.String getDomainName() {
            return this.domainName;
        }

        @Override
        public final java.util.List<java.lang.String> getServerCertificateArns() {
            return this.serverCertificateArns;
        }

        @Override
        public final java.lang.String getServiceType() {
            return this.serviceType;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getValidationCertificateArn() {
            return this.validationCertificateArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAuthorizerConfig() != null) {
                data.set("authorizerConfig", om.valueToTree(this.getAuthorizerConfig()));
            }
            if (this.getDomainConfigurationName() != null) {
                data.set("domainConfigurationName", om.valueToTree(this.getDomainConfigurationName()));
            }
            if (this.getDomainConfigurationStatus() != null) {
                data.set("domainConfigurationStatus", om.valueToTree(this.getDomainConfigurationStatus()));
            }
            if (this.getDomainName() != null) {
                data.set("domainName", om.valueToTree(this.getDomainName()));
            }
            if (this.getServerCertificateArns() != null) {
                data.set("serverCertificateArns", om.valueToTree(this.getServerCertificateArns()));
            }
            if (this.getServiceType() != null) {
                data.set("serviceType", om.valueToTree(this.getServiceType()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getValidationCertificateArn() != null) {
                data.set("validationCertificateArn", om.valueToTree(this.getValidationCertificateArn()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_iot.CfnDomainConfigurationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDomainConfigurationProps.Jsii$Proxy that = (CfnDomainConfigurationProps.Jsii$Proxy) o;

            if (this.authorizerConfig != null ? !this.authorizerConfig.equals(that.authorizerConfig) : that.authorizerConfig != null) return false;
            if (this.domainConfigurationName != null ? !this.domainConfigurationName.equals(that.domainConfigurationName) : that.domainConfigurationName != null) return false;
            if (this.domainConfigurationStatus != null ? !this.domainConfigurationStatus.equals(that.domainConfigurationStatus) : that.domainConfigurationStatus != null) return false;
            if (this.domainName != null ? !this.domainName.equals(that.domainName) : that.domainName != null) return false;
            if (this.serverCertificateArns != null ? !this.serverCertificateArns.equals(that.serverCertificateArns) : that.serverCertificateArns != null) return false;
            if (this.serviceType != null ? !this.serviceType.equals(that.serviceType) : that.serviceType != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.validationCertificateArn != null ? this.validationCertificateArn.equals(that.validationCertificateArn) : that.validationCertificateArn == null;
        }

        @Override
        public final int hashCode() {
            int result = this.authorizerConfig != null ? this.authorizerConfig.hashCode() : 0;
            result = 31 * result + (this.domainConfigurationName != null ? this.domainConfigurationName.hashCode() : 0);
            result = 31 * result + (this.domainConfigurationStatus != null ? this.domainConfigurationStatus.hashCode() : 0);
            result = 31 * result + (this.domainName != null ? this.domainName.hashCode() : 0);
            result = 31 * result + (this.serverCertificateArns != null ? this.serverCertificateArns.hashCode() : 0);
            result = 31 * result + (this.serviceType != null ? this.serviceType.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.validationCertificateArn != null ? this.validationCertificateArn.hashCode() : 0);
            return result;
        }
    }
}
