package software.amazon.awscdk.services.iot;

/**
 * Properties for defining a `CfnMitigationAction`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iot.*;
 * CfnMitigationActionProps cfnMitigationActionProps = CfnMitigationActionProps.builder()
 *         .actionParams(ActionParamsProperty.builder()
 *                 .addThingsToThingGroupParams(AddThingsToThingGroupParamsProperty.builder()
 *                         .thingGroupNames(List.of("thingGroupNames"))
 *                         // the properties below are optional
 *                         .overrideDynamicGroups(false)
 *                         .build())
 *                 .enableIoTLoggingParams(EnableIoTLoggingParamsProperty.builder()
 *                         .logLevel("logLevel")
 *                         .roleArnForLogging("roleArnForLogging")
 *                         .build())
 *                 .publishFindingToSnsParams(PublishFindingToSnsParamsProperty.builder()
 *                         .topicArn("topicArn")
 *                         .build())
 *                 .replaceDefaultPolicyVersionParams(ReplaceDefaultPolicyVersionParamsProperty.builder()
 *                         .templateName("templateName")
 *                         .build())
 *                 .updateCaCertificateParams(UpdateCACertificateParamsProperty.builder()
 *                         .action("action")
 *                         .build())
 *                 .updateDeviceCertificateParams(UpdateDeviceCertificateParamsProperty.builder()
 *                         .action("action")
 *                         .build())
 *                 .build())
 *         .roleArn("roleArn")
 *         // the properties below are optional
 *         .actionName("actionName")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:03.378Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_iot.CfnMitigationActionProps")
@software.amazon.jsii.Jsii.Proxy(CfnMitigationActionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnMitigationActionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The set of parameters for this mitigation action.
     * <p>
     * The parameters vary, depending on the kind of action you apply.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getActionParams();

    /**
     * The IAM role ARN used to apply this mitigation action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

    /**
     * The friendly name of the mitigation action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getActionName() {
        return null;
    }

    /**
     * Metadata that can be used to manage the mitigation action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnMitigationActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnMitigationActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnMitigationActionProps> {
        java.lang.Object actionParams;
        java.lang.String roleArn;
        java.lang.String actionName;
        java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Sets the value of {@link CfnMitigationActionProps#getActionParams}
         * @param actionParams The set of parameters for this mitigation action. This parameter is required.
         *                     The parameters vary, depending on the kind of action you apply.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionParams(software.amazon.awscdk.services.iot.CfnMitigationAction.ActionParamsProperty actionParams) {
            this.actionParams = actionParams;
            return this;
        }

        /**
         * Sets the value of {@link CfnMitigationActionProps#getActionParams}
         * @param actionParams The set of parameters for this mitigation action. This parameter is required.
         *                     The parameters vary, depending on the kind of action you apply.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionParams(software.amazon.awscdk.core.IResolvable actionParams) {
            this.actionParams = actionParams;
            return this;
        }

        /**
         * Sets the value of {@link CfnMitigationActionProps#getRoleArn}
         * @param roleArn The IAM role ARN used to apply this mitigation action. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(java.lang.String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnMitigationActionProps#getActionName}
         * @param actionName The friendly name of the mitigation action.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionName(java.lang.String actionName) {
            this.actionName = actionName;
            return this;
        }

        /**
         * Sets the value of {@link CfnMitigationActionProps#getTags}
         * @param tags Metadata that can be used to manage the mitigation action.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnMitigationActionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnMitigationActionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnMitigationActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnMitigationActionProps {
        private final java.lang.Object actionParams;
        private final java.lang.String roleArn;
        private final java.lang.String actionName;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.actionParams = software.amazon.jsii.Kernel.get(this, "actionParams", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.actionName = software.amazon.jsii.Kernel.get(this, "actionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.actionParams = java.util.Objects.requireNonNull(builder.actionParams, "actionParams is required");
            this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
            this.actionName = builder.actionName;
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getActionParams() {
            return this.actionParams;
        }

        @Override
        public final java.lang.String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final java.lang.String getActionName() {
            return this.actionName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("actionParams", om.valueToTree(this.getActionParams()));
            data.set("roleArn", om.valueToTree(this.getRoleArn()));
            if (this.getActionName() != null) {
                data.set("actionName", om.valueToTree(this.getActionName()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_iot.CfnMitigationActionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnMitigationActionProps.Jsii$Proxy that = (CfnMitigationActionProps.Jsii$Proxy) o;

            if (!actionParams.equals(that.actionParams)) return false;
            if (!roleArn.equals(that.roleArn)) return false;
            if (this.actionName != null ? !this.actionName.equals(that.actionName) : that.actionName != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.actionParams.hashCode();
            result = 31 * result + (this.roleArn.hashCode());
            result = 31 * result + (this.actionName != null ? this.actionName.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
