package software.amazon.awscdk.services.iot.actions;

/**
 * (experimental) Configuration properties of an action for CloudWatch metric.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * TopicRule topicRule = TopicRule.Builder.create(this, "TopicRule")
 *         .sql(IotSql.fromStringAsVer20160323("SELECT topic(2) as device_id, namespace, unit, value, timestamp FROM 'device/+/data'"))
 *         .actions(List.of(
 *             CloudWatchPutMetricAction.Builder.create()
 *                     .metricName("${topic(2)}")
 *                     .metricNamespace("${namespace}")
 *                     .metricUnit("${unit}")
 *                     .metricValue("${value}")
 *                     .metricTimestamp("${timestamp}")
 *                     .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:03.559Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_iot_actions.CloudWatchPutMetricActionProps")
@software.amazon.jsii.Jsii.Proxy(CloudWatchPutMetricActionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface CloudWatchPutMetricActionProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.iot.actions.CommonActionProps {

    /**
     * (experimental) The CloudWatch metric name.
     * <p>
     * Supports substitution templates.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-substitution-templates.html">https://docs.aws.amazon.com/iot/latest/developerguide/iot-substitution-templates.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getMetricName();

    /**
     * (experimental) The CloudWatch metric namespace name.
     * <p>
     * Supports substitution templates.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-substitution-templates.html">https://docs.aws.amazon.com/iot/latest/developerguide/iot-substitution-templates.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getMetricNamespace();

    /**
     * (experimental) The metric unit supported by CloudWatch.
     * <p>
     * Supports substitution templates.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-substitution-templates.html">https://docs.aws.amazon.com/iot/latest/developerguide/iot-substitution-templates.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getMetricUnit();

    /**
     * (experimental) A string that contains the CloudWatch metric value.
     * <p>
     * Supports substitution templates.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-substitution-templates.html">https://docs.aws.amazon.com/iot/latest/developerguide/iot-substitution-templates.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getMetricValue();

    /**
     * (experimental) A string that contains the timestamp, expressed in seconds in Unix epoch time.
     * <p>
     * Supports substitution templates.
     * <p>
     * Default: - none -- Defaults to the current Unix epoch time.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-substitution-templates.html">https://docs.aws.amazon.com/iot/latest/developerguide/iot-substitution-templates.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getMetricTimestamp() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CloudWatchPutMetricActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CloudWatchPutMetricActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<CloudWatchPutMetricActionProps> {
        java.lang.String metricName;
        java.lang.String metricNamespace;
        java.lang.String metricUnit;
        java.lang.String metricValue;
        java.lang.String metricTimestamp;
        software.amazon.awscdk.services.iam.IRole role;

        /**
         * Sets the value of {@link CloudWatchPutMetricActionProps#getMetricName}
         * @param metricName The CloudWatch metric name. This parameter is required.
         *                   Supports substitution templates.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder metricName(java.lang.String metricName) {
            this.metricName = metricName;
            return this;
        }

        /**
         * Sets the value of {@link CloudWatchPutMetricActionProps#getMetricNamespace}
         * @param metricNamespace The CloudWatch metric namespace name. This parameter is required.
         *                        Supports substitution templates.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder metricNamespace(java.lang.String metricNamespace) {
            this.metricNamespace = metricNamespace;
            return this;
        }

        /**
         * Sets the value of {@link CloudWatchPutMetricActionProps#getMetricUnit}
         * @param metricUnit The metric unit supported by CloudWatch. This parameter is required.
         *                   Supports substitution templates.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder metricUnit(java.lang.String metricUnit) {
            this.metricUnit = metricUnit;
            return this;
        }

        /**
         * Sets the value of {@link CloudWatchPutMetricActionProps#getMetricValue}
         * @param metricValue A string that contains the CloudWatch metric value. This parameter is required.
         *                    Supports substitution templates.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder metricValue(java.lang.String metricValue) {
            this.metricValue = metricValue;
            return this;
        }

        /**
         * Sets the value of {@link CloudWatchPutMetricActionProps#getMetricTimestamp}
         * @param metricTimestamp A string that contains the timestamp, expressed in seconds in Unix epoch time.
         *                        Supports substitution templates.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder metricTimestamp(java.lang.String metricTimestamp) {
            this.metricTimestamp = metricTimestamp;
            return this;
        }

        /**
         * Sets the value of {@link CloudWatchPutMetricActionProps#getRole}
         * @param role The IAM role that allows access to AWS service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CloudWatchPutMetricActionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public CloudWatchPutMetricActionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CloudWatchPutMetricActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CloudWatchPutMetricActionProps {
        private final java.lang.String metricName;
        private final java.lang.String metricNamespace;
        private final java.lang.String metricUnit;
        private final java.lang.String metricValue;
        private final java.lang.String metricTimestamp;
        private final software.amazon.awscdk.services.iam.IRole role;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.metricName = software.amazon.jsii.Kernel.get(this, "metricName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.metricNamespace = software.amazon.jsii.Kernel.get(this, "metricNamespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.metricUnit = software.amazon.jsii.Kernel.get(this, "metricUnit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.metricValue = software.amazon.jsii.Kernel.get(this, "metricValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.metricTimestamp = software.amazon.jsii.Kernel.get(this, "metricTimestamp", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.metricName = java.util.Objects.requireNonNull(builder.metricName, "metricName is required");
            this.metricNamespace = java.util.Objects.requireNonNull(builder.metricNamespace, "metricNamespace is required");
            this.metricUnit = java.util.Objects.requireNonNull(builder.metricUnit, "metricUnit is required");
            this.metricValue = java.util.Objects.requireNonNull(builder.metricValue, "metricValue is required");
            this.metricTimestamp = builder.metricTimestamp;
            this.role = builder.role;
        }

        @Override
        public final java.lang.String getMetricName() {
            return this.metricName;
        }

        @Override
        public final java.lang.String getMetricNamespace() {
            return this.metricNamespace;
        }

        @Override
        public final java.lang.String getMetricUnit() {
            return this.metricUnit;
        }

        @Override
        public final java.lang.String getMetricValue() {
            return this.metricValue;
        }

        @Override
        public final java.lang.String getMetricTimestamp() {
            return this.metricTimestamp;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("metricName", om.valueToTree(this.getMetricName()));
            data.set("metricNamespace", om.valueToTree(this.getMetricNamespace()));
            data.set("metricUnit", om.valueToTree(this.getMetricUnit()));
            data.set("metricValue", om.valueToTree(this.getMetricValue()));
            if (this.getMetricTimestamp() != null) {
                data.set("metricTimestamp", om.valueToTree(this.getMetricTimestamp()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_iot_actions.CloudWatchPutMetricActionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CloudWatchPutMetricActionProps.Jsii$Proxy that = (CloudWatchPutMetricActionProps.Jsii$Proxy) o;

            if (!metricName.equals(that.metricName)) return false;
            if (!metricNamespace.equals(that.metricNamespace)) return false;
            if (!metricUnit.equals(that.metricUnit)) return false;
            if (!metricValue.equals(that.metricValue)) return false;
            if (this.metricTimestamp != null ? !this.metricTimestamp.equals(that.metricTimestamp) : that.metricTimestamp != null) return false;
            return this.role != null ? this.role.equals(that.role) : that.role == null;
        }

        @Override
        public final int hashCode() {
            int result = this.metricName.hashCode();
            result = 31 * result + (this.metricNamespace.hashCode());
            result = 31 * result + (this.metricUnit.hashCode());
            result = 31 * result + (this.metricValue.hashCode());
            result = 31 * result + (this.metricTimestamp != null ? this.metricTimestamp.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            return result;
        }
    }
}
